#!/Perl
# showsm01.pl
# AIM: To show my Start Menu in different ways ...
use strict;
use warnings;
require "logfile.pl" or die "ERROR: Unable to locate ligfile.pl ... $! ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $sm_path = 'C:\Documents and Settings\All Users\Start Menu\Programs';
my @sm_dirs = ();
my @sm_lnks = ();
my @sm_files = ();
my $file = '';
my $ff = '';
my $sm_dcnt = 0;
my $sm_lcnt = 0;
my $sm_ocnt = 0;
# debug output
my $dbg1 = 0;
process_dir($sm_path, 0);


close_log($outfile,1);
exit(0);

######################
sub process_dir {
	my ($path, $lev) = @_;
	opendir( DIR, $path) || mydie( "ERROR: Can NOT open $path ... aborting ...\n" );
	my @files = readdir(DIR);
	closedir DIR;
	prt ("Found ".scalar @files." items in the directory ...\n") if ($dbg1);
	foreach $file (@files) {
		if (!(($file eq '.')||($file eq '..'))) {
			$ff = $path . "\\" . $file;
			if ( -f $ff) {
				prt( "$file <FILE>\n" ) if ($dbg1);
				if (is_lnk_file($file)) {
					push(@sm_lnks, [ $file, $path, $lev ]);
				} else {
					push(@sm_files, [ $file, $path, $lev ]);
				}
			} else {
				prt( "$file <DIR>\n" ) if ($dbg1);
				push(@sm_dirs, [ $file, $path, $lev ]);
				my $nd = $path . "\\" . $file;
				process_dir($nd, ($lev+1));
			}
		}
	}
	if ($lev == 0) {
		$sm_dcnt = scalar @sm_dirs;
		$sm_lcnt = scalar @sm_lnks;
		$sm_ocnt = scalar @sm_files;
		prt( "Got $sm_dcnt folders, $sm_lcnt LNK files, and $sm_ocnt others ...\n" );
	}
}

sub is_lnk_file {
	my ($f) = shift;
	my $ri = rindex($f,'.');
	if ($ri > 0) {
		my $ext = substr($f, ($ri+1));
		if ($ext =~ /^lnk$/i) {
			return 1;
		}
	}
	return 0;
}
# eof
