#!/perl -w
# NAME: sln2dsw.pl
# AIM: Read a MSVC7/8/9/?? solution, and vcproj files, and create
# or maybe update an (depreciated, as too hard)
# equivalent DSW/DSP files ...
# 19/05/2008 - Add 'Static Library' DSP header ... still missing 'Dynamic Library'
# 22/04/2008 - Extract DEPENDENCIES from solution file, and add to DSW output
# 17/12/2007 - geoff mclane - http://geoffair.net/mperl
# 14/02/2008 - attempt to get RELATIVE folders correct, both in DSW (and DSP)
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'relative.pl' or die "Unable to load relative.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
###prt( "$0 ... Hello, World ...\n" );
my $inpsln = '';
my $dswfile = '';
my $dspfile = '';

# Options
my $killfilt = 1;	# kill the filter name and type on </Filter>
my $chk4dups = 0;	# do a DUPLICATE check
my $tryharder = 0;	# needs more work to put this ON
my $keeporder = 1;	# if a PREVIOUS DSW file, then try to retain the ORDER in it

#my @proj_files = ();
my $pcnt = 0;
##                  [0]   [1]   [2]       [3]       [4] [5]  [6]        [7]
##                  relnm full  group      filter   cmp done project    grp
##	push(@v8_srcs, [$src, $ff, $filtname, $filttype, 0,  0,  $projname, shr] );
use constant {
    V8_SRC => 0,
    V8_FUL => 1,
    V8_GRP => 2,
    V8_FIL => 3,
    V8_CMP => 4,
    V8_DON => 5,
    V8_PRJ => 6,
    V8_SHR => 7
};
my @v8_srcs = ();	# source found in VCPROJ files
my %v8_link = ();	# compiler definitions, by configuration
my %v8_depend = ();	# linker addtional dependencies, by configuration
my %v8_apptyp = ();	# application TYPE, per project name
# maybe _WINDOWS => 'Application'
# ie # TARGTYPE "Win32 (x86) Application" 0x0101 in a DSP file
# but then Alu.vcproj only has -
# PreprocessorDefinitions="NDEBUG;WIN32;AL_BUILD_LIBRARY"
my %v8_defines = ( '_CONSOLE' => 'Console Application',
 '_USRDLL' => 'Dynamic-Link Library',
 '_LIB' => 'Static Library' );
my @special_typing = qw( libpng zlib visualc6 );	# make these STATIC LIBRARIES
my $typelse = 'Application';

my $TYP_OPEN = 1;
my $TYP_CLOSE = 2;
my $TYP_OPENCLOSE = 3;
my $TYP_VERSION = 4;

my $v8_cfgexp = '<Configuration\\s+.*Name=\\"(\\S+)\\"\\s';
my $v8_toolexp = '<Tool\\s+.?\\s*Name=\\"(\\S+)\\"\\s';
my $v8_prepexp = '\\s+PreprocessorDefinitions=\\"(\\S+)\\"';

use constant {
    GRP_UNK => 0,
    GRP_SRC => 1,
    GRP_HDR => 2,    # also include extensionless files, maybe ...
    GRP_RCS => 3,
    GRP_SPL => 4    # special items
};
my $def_src_g = "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat;for;f90";
my $def_hdr_g = "h;hpp;hxx;hm;inl;fi;fd";
my $def_rcs_g = "ico;cur;bmp;dlg;rc2;rct;bin;cnt;rtf;gif;jpg;jpeg;jpe";
my $def_spl_g = "txt;vc5;h-msvc8;asm";

my $def_src_nm = "Source Files";    # Begin Group "Source Files"
my $def_hdr_nm = "Header Files";	# Begin Group "Header Files"
my $def_rcs_nm = "Resource Files";	# Begin Group "Resource Files"
my $def_spl_nm = "Special Files";
my $def_unknown = "Unknown";

my @dsp_base_defs_rel = qw( WIN32 NDEBUG _WINDOWS _MBCS );
my @dsp_base_defs_dbg = qw( WIN32 _DEBUG _WINDOWS _MBCS );
my @dsp_base_libs_rel = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );
my @dsp_base_libs_dbg = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );

# default items for Application (windows and console)
my $def_runtime_rel = '/MT';
my $def_runtime_dbg = '/MTd';
my $def_defines_dbg = '/D "_CRT_SECURE_NO_WARNINGS"';
my $def_defines_rel = '/D "_CRT_SECURE_NO_WARNINGS"';
my $def_libs_rel = 'comctl32.lib Msimg32.lib Winmm.lib';
my $def_libs_dbg = 'comctl32.lib Msimg32.lib Winmm.lib';

my $dsp_runtime_rel = '';
my $dsp_runtime_dbg = '';
my $dsp_defines_dbg = '';
my $dsp_defines_rel = '';
my $dsp_libs_rel = '';
my $dsp_libs_dbg = '';

my @dsw_file = ();	# contents of the DSW file, if ONE EXISTS
my @dsp_files = (); # [relfile, fullpath, and project NAME]
my @v6_srcs = ();  # relnm full group filter
my %v6_defs = ();
my %v6_conf = ();
my @extra_projects = ();

my %sln_projects = ();	# projects FOUND in SLN file - key=name, data=vcproj file
my %sln_projpath = ();	# and the RELATIVE path of the project, IF ANY ...
my %sln_projids  = ();	# special ID used in SLN file
my %sln_depends  = ();	# dependencies
my $vcproj_cnt = 0;		# count of VCPROJ files processed

my %dsw_projects = ();	# project WRITTEN to DSP files - key=name, data=DSP file
my %dsw_projpath = ();	# and relaive PATH, if ANY
my @dsp_written = ();	# list of DSP files written
my $compres = 0;	# compare result - if non-zero, DSP written and DSW needs modification/creation

# debug only
my $dbg1 = 1;	# use following default input
my $basepath = 'C:\FG\tempfg';
my $defin = $basepath.'\fgfs\fgfs.sln';
my $altsrcfind = 'C:\FG\19';
#my $defin = 'C:\Projects\tar120\Win32\tar.sln';
#my $defin = 'C:\Projects\grep\build\greputils.sln';
#my $defin = 'C:\FG\19\fgfs\fgfs.sln';
#my $defin = 'C:\GTools\tools\bglview2\bglview2.sln';
#my $defin = 'C:\Projects\gshhs\gshhs\gshhs.sln';
#my $defin = "C:\\FG\\FGCOMXML\\xmlrpc-c\\Windows\\xmlrpc.sln";
#my $defin = "C:\\GTools\\tools\\testmem\\testmem.sln";
#my $defin = "C:\\GTools\\tools\\testap3\\testap3.sln";
#my $defin = "C:\\GTools\\tools\\mirror\\mirror.sln";
#my $defin = "C:\\FG\\12\\fgfs\\fgfs.sln";
my $dbg_src1 = 0;
my $dbg_src2 = 0;
my $dbg_src3 = 0;
my $dbg_src4 = 0;
my $dbg_src5 = 0;	# show lines NOT in tumble - very noisy
my $dbg_src6 = 0;	# show v8 configuration found
my $dbg_src7 = 0;	# show SOME ITEMS OF <Tool Name="????" ...
my $dbg_src8 = 0;	# show compiler tool and definitions added $v8_depend{$conf} = $1;
my $dbg_src9 = 0;	# show each TAG, and TYPE
my $dbg_srcv = 0;	# show XML version line
my $dbg_srcc = 0;	# show CLOSE tags
my $dbg_src10 = 0;	# show BEGIN and END Configurations
my $dbg_src11 = 0;	# show project name, and vcproj version ...
my $dbg_src12a = 0;	# show linker tool array and hash
my $dbg_src12 = 0;	# show linker tool and additional added $v8_link{$conf} = $1;
my $dbg_src13 = 0;	# show space split array
my $dbg_src14 = 0;	# show Name="VCCLCompilerTool" ... Is compiler tool ...[$fline] ...
my $dbg_src15 = 0;	# big display of VCCLCompilerTool ...
my $dbg_src16 = 0;	# show EACH XML source - "SRC: [$ffnr] (ok|MISSING [$src][$ff])\n"

my $dbg_sl1 = 0;	# show projects found in SOLUTION (SLN) file - "Got PROJECT name=$projname, file=$projff
my $dbg_s12 = 0;	# show "Proj $projname, dependant on $arr[0] ...
my $dbg_s13 = 0;	# show "proj $projname, depends on $nmdeps ...

my $dbg_dsp = 0;
my $dbg_ds1 = 0;
my $dbg_ds2 = 0;
my $dbg_ds3 = 0;	# show OTHER file, exclu .xml
my $dbg_ds4 = 0;	# show CPP and LINK config items - %v6_conf
my $dbg_ds5 = 0;	# show Defined items - %v6_defs
my $dbg_ds6 = 0;	# show !IF, !ELSEIF switching
my $dbg_ds7 = 0;	# show %v6_conf listing
my $dbg_ds8 = 0;	# show VC6 Filter and Group Name
my $dbg_ds9 = 0;	# show EACH VC6 source pushed
my $big_dbg = 0;	# show EACH COMPARE, and results

my $dbg_dsw1 = 0;	# show EACH DSW line
my $dbg_dsw2 = 0;	# show projects as found in DSW file

my $verbose = 1;	# show Creating $dsw_name 
my $tmpdsw = 'tempdsp2.dsw';

my $dbg10 = 1;	# output a 'temp' DSP file ...
my $dbg11 = 0;	# show vc8 source files
my $dbg12 = 0;	# massive output for is_same_DOS_file()

my @warnings = ();	# output any WARNINGS at the END
my $sln_path = '';	# this is DIRECTORY of SOLUTION
my $act_vcproj = '';	# active VCPROJ file

### commence process ###
parse_args( @ARGV );

if ( -f $inpsln) {
	my $fil = $inpsln;
	my ($name,$dir,$suffix) = fileparse($fil);
	$dswfile = $dir . basename($name,  ".".get_suffix($name));
	$dswfile .= ".dsw";
	prt( "Processing [$fil] file ...\n" );
	process_SLN( $fil );
	$pcnt = scalar keys(%sln_projects);
	prt( "Got $pcnt vcproj files to process ...\n" );
	process_DSW( $dswfile );
	if ($pcnt) {
		my $key = '';
		foreach $key (keys %sln_projects) {
		#for (my $i = 0; $i < $pcnt; $i++) {
		#	my $fil = $proj_files[$i];
		#	($name,$dir,$suffix) = fileparse($fil);
			$fil = $sln_projects{$key};
			my $rp  = $sln_projpath{$key};
			$rp =~ s/\\$//;	# remove any TRAILING '\' char
			my $tmpdsp = "temp.$key.dsp";
			if (length($rp)) {
				$rp =~ s/\\/#/g;
				$tmpdsp = "temp.$rp.$key.dsp";
			}
			($name,$dir,$suffix) = fileparse($fil, qr/\.[^.]*/ );
			$dspfile = $dir .$name.".dsp";
			clear_proj_files();
			$vcproj_cnt++;
			prt( "\n$vcproj_cnt: Processing:[$fil] VCPROJ file ... \n" );
			$act_vcproj = $fil;
			get_xml_sources( $fil );	# load the VCPROJ file
			process_DSP( $key, $dspfile );	# and any EXISTING DSP file
			my $compcnt = compare_proj_with_dsp( $key, $rp ); # also WRITES new DSP file
			$compres += $compcnt;
			generate_DSP( $key, $tmpdsp ); # out TEMP, ALWAYS instead of if ($compcnt); # output a DSP file
		}
		write_DSW_file( $name, $tmpdsw ); # ALWAYS OUT temp file - not only if ($compres); 
	}
} else {
	prtw( "ERROR: Can NOT locate $inpsln file ...\n" );
}

show_warnings();
close_log($outfile,1);
exit(0);


######################
# DEAL WITH DSW OUTPUT

sub add_proj_begin {
	my ($fh, $prj, $fil) = @_;
	print $fh <<EOF;
###############################################################################

Project: "$prj"=".\\$fil" - Package Owner=<4>

Package=<5>
{{{
}}}

Package=<4>
{{{
EOF
}

sub add_proj_depends {
	my ($fh, $prj) = @_;
	my ($pdeps, @arr, $dpn);
	if (defined $sln_depends{$prj}) {
		$pdeps = $sln_depends{$prj};
		if (length($pdeps)) {
			@arr = split( /\|/, $pdeps );
			foreach $dpn (@arr) {
				print $fh "    Begin Project Dependency\n";
				print $fh "    Project_Dep_Name $dpn\n";
				print $fh "    End Project Dependency\n";
			}
		}
	} else {
		prtw( "WARNING: Project $prj NOT defined in sln_depends!!!\n" );
	}
}

sub add_proj_end {
	my ($fh) = shift;
	print $fh <<EOF;
}}}

EOF
}

sub in_list {
	my ($itm, @lst) = @_;
	foreach my $ti (@lst) {
		if ($itm eq $ti) {
			return 1;
		}
	}
	return 0;
}

# output a TEMP DSW file
# if $keeporder, and there is a previous DSW, then try to output in SAME order
sub write_DSW_file {
	my ($key,$dfile) = @_;
	my ($msg, $prj, $DSW);
	my ($pdeps, @arr, $dpn, $i);
	my ($fil, $rp);
	my @prjlist = sort keys(%dsw_projects);
	my $prjcnt = scalar @prjlist;
	my $dspcnt = scalar @dsp_files;	# list collected from previous DSW, if any
	my @donelist = ();
	if (open $DSW, ">$dfile") {
		$msg = get_dsw_head();
		print $DSW $msg;
		if ($keeporder && $dspcnt) {
			prt( "Output in ORDER of previous DSW file ...\n" );
			for ($i = 0; $i < $dspcnt; $i++) {
				#                   0      1    2
				# push(@dsp_files, [$pfil, $ff, $pnm]); # [file, fullpath, and project NAME]
				$prj = $dsp_files[$i][2];
				if (defined $dsw_projects{$prj}) {
					$fil = $dsw_projects{$prj};
					$rp  = $dsw_projpath{$prj};
					$fil = $rp."\\".$fil if (length($rp));
					add_proj_begin( $DSW, $prj, $fil );
					# add any DEPENDENCIES NOW
					add_proj_depends( $DSW, $prj );
					add_proj_end( $DSW );
					push(@donelist, $prj);
				} else {
					prt( "Warning: $prj now discarded ...\n" );
				}
			}
		} elsif ($keeporder) {
			prt( "No ORDER possible, since no previous DSW file ...\n" );
		}
		# $dsw_projects{$key} = "$key.dsp";
		#foreach $prj (sort keys(%dsw_projects)) {
		# foreach $prj (@prjlist)
		for ($i = 0; $i < $prjcnt; $i++) {
			$prj = $prjlist[$i];
			if (!in_list($prj, @donelist)) {
				$fil = $dsw_projects{$prj};
				$rp  = $dsw_projpath{$prj};
				$fil = $rp."\\".$fil if (length($rp));
				add_proj_begin( $DSW, $prj, $fil );
				# add any DEPENDENCIES NOW
				add_proj_depends( $DSW, $prj );
				add_proj_end( $DSW );
			}
		}

		$msg = get_dsw_tail();
		print $DSW $msg;
		close $DSW;
		# diagnostic OUTPUT
		prt( "\nWritten [$dfile] file ...\n" );
		prt( "For DSP list :-\n" );
		foreach $msg (@dsp_written) {
			prt( "$msg\n" );
		}
	} else {
		prtw("ERROR: Unable to WRITE $dfile ...\n" );
	}	
}

sub write_DSW_file_OLD {
	my ($key,$dfile) = @_;
	my ($msg, $prj);
	my ($pdeps, @arr, $dpn);
	if (open DSW, ">$dfile") {
		$msg = get_dsw_head();
		print DSW $msg;
		# $dsw_projects{$key} = "$key.dsp";
		foreach $prj (sort keys(%dsw_projects)) {
			my $fil = $dsw_projects{$prj};
			my $rp  = $dsw_projpath{$prj};
			$fil = $rp."\\".$fil if (length($rp));
			print DSW <<EOF;
###############################################################################

Project: "$prj"=".\\$fil" - Package Owner=<4>

Package=<5>
{{{
}}}

Package=<4>
{{{
EOF

			# add any DEPENDENCIES NOW
			if (defined $sln_depends{$prj}) {
				$pdeps = $sln_depends{$prj};
				if (length($pdeps)) {
					@arr = split( /\|/, $pdeps );
					foreach $dpn (@arr) {
						print DSW "    Begin Project Dependency\n";
						print DSW "    Project_Dep_Name $dpn\n";
						print DSW "    End Project Dependency\n";
					}
				}
			} else {
				prtw( "WARNING: Project $prj NOT defined in sln_depends!!!\n" );
			}

			print DSW <<EOF;
}}}

EOF
		}

		$msg = get_dsw_tail();
		print DSW $msg;
		close DSW;
		# diagnostic OUTPUT
		prt( "\nWritten [$dfile] file ...\n" );
		prt( "For DSP list :-\n" );
		foreach $msg (@dsp_written) {
			prt( "$msg\n" );
		}
	} else {
		prtw("ERROR: Unable to WRITE $dfile ...\n" );
	}	
}

sub clear_proj_files {

	@v8_srcs = ();	# start with NONE
	%v8_link = ();	# compiler definitions, by configuration
	%v8_depend = ();	# linker addtional dependencies, by configuration
	@v6_srcs = ();  # relnm full group filter
	%v6_defs = ();
	%v6_conf = ();

	# establish DEFAULT items for DSP generation
	# these can be altered by the XML decode
	$dsp_runtime_rel = $def_runtime_rel;
	$dsp_runtime_dbg = $def_runtime_dbg;
	$dsp_defines_dbg = $def_defines_dbg;
	$dsp_defines_rel = $def_defines_rel;
	$dsp_libs_rel = $def_libs_rel;
	$dsp_libs_dbg = $def_libs_dbg;

}

sub compare_proj_with_dsp {
	my ($key, $rp) = @_;	# key is PROJECT name, and any relative path
	my ($i1, $i2, $fnd, $matched);
	##	push(@cv8_srcs, [$src, $ff, $filtname, $filttype, $flag, $projname] );
	my ($src1, $ff1, $fnm1, $typ1, $flg1);
	my ($src2, $ff2, $fnm2, $typ2, $flg2);
	my ($nm1, $pth1, $suf1);
	my ($nm2, $pth2, $suf2);
	my ($added, $subed);
	my ($miss1, $miss2, $msg);
	my ($dup1, $dup2);
    my ($tmpsrc);
	# compare @v8_srcs, with @v6_srcs
	my $v8_tot = scalar @v8_srcs;
	my $v6_tot = scalar @v6_srcs;
	prt( "\nCompare of sources " );
	prt( "MSVC 8 total = $v8_tot, with " ); 
	prt( "MSVC 6 total = $v6_tot\n" );
	$fnd = 0;
	$matched = 0;
	# clear the compare flag
	for ($i1 = 0; $i1 < $v8_tot; $i1++) {
		$v8_srcs[$i1][4] = 0;
	}
	# clear compare flags
	for ($i2 = 0; $i2 < $v6_tot; $i2++) {
		$v6_srcs[$i2][4] = 0;
	}
	if ($chk4dups) {
		prt( "Check $v8_tot VC8 for DUPLICATES ...\n" );
		$dup1 = 0;
		for ($i1 = 0; $i1 < $v8_tot; $i1++) {
			if( $v8_srcs[$i1][4] ) {
				next;
			}
			$ff1  = $v8_srcs[$i1][1];
			for ($i2 = 0; $i2 < $v8_tot; $i2++) {
				if ($i1 != $i2) {
					if( $v8_srcs[$i2][4] ) {
						next;
					}
					$ff2  = $v8_srcs[$i2][1];
					if (is_same_DOS_file($ff1,$ff2)) {
						$v8_srcs[$i2][4] = -1;	# MARK IT DUPLICATE
						prt( "Found VC8 duplicate [$ff2]\n" );
						$dup1++;
					}
				}	
			}
		}
		prt( "Found $dup1 of $v8_tot VC8 DUPLICATES ...\n" );
		prt( "Check $v6_tot VC6 for DUPLICATES ...\n" );
		$dup2 = 0;
		for ($i2 = 0; $i2 < $v6_tot; $i2++) {
			if ($v6_srcs[$i2][4]) {
				next;
			}
			$ff1  = $v6_srcs[$i2][1];
			for ($i1 = 0; $i1 < $v6_tot; $i1++) {
				if ($i1 != $i2) {
					if ($v6_srcs[$i1][4]) {
						next;
					}
					$ff2  = $v6_srcs[$i1][1];
					if (is_same_DOS_file($ff1,$ff2)) {
						$v6_srcs[$i1][4] = -1;	# MARK IT DUPLICATE
						prt( "Found VC6 duplicate [$ff2]\n" );
						$dup2++;
					}
				}
			}
		}
		prt( "Found $dup2 of $v6_tot VC6 DUPLICATES ...\n" );
	}
	for ($i1 = 0; $i1 < $v8_tot; $i1++) {
		$src1 = $v8_srcs[$i1][0];
		$ff1  = $v8_srcs[$i1][1];
		$fnm1 = $v8_srcs[$i1][2];
		$typ1 = $v8_srcs[$i1][3];
		$flg1 = $v8_srcs[$i1][4];
		if ($chk4dups && $flg1) {
			next;
		}
		($nm1,$pth1,$suf1) = fileparse( $src1 );
		$msg = "$i1 $nm1 ($ff1) - "; 
		$fnd = 0;
		for ($i2 = 0; $i2 < $v6_tot; $i2++) {
			$src2 = $v6_srcs[$i2][0];
			$ff2  = $v6_srcs[$i2][1];
			$fnm2 = $v6_srcs[$i2][2];
			$typ2 = $v6_srcs[$i2][3];
			$flg2 = $v6_srcs[$i2][4];
			if ($chk4dups && $flg2) {
				next;
			}
			($nm2,$pth2,$suf2) = fileparse( $src2 );
			if (is_same_DOS_file($ff1,$ff2)) {
				$v6_srcs[$i2][4] = ($i1 + 1);	# put offset + 1 to VC8
				$v8_srcs[$i1][4] = ($i2 + 1);	# put offset + 1 to VC6
				$fnd = 1;
				last;
			}
		}
		if ($fnd) {
			$msg .= "ok";
			$matched++;
		} else {
			$msg .= "NO MATCH";
		}
		prt( "$msg\n" ) if ($big_dbg);
	}
	$added = $v8_tot - $matched;
	$subed = $v6_tot - $matched;
	$miss1 = 0;
	$miss2 = 0;
	for ($i1 = 0; $i1 < $v8_tot; $i1++) {
		if ($v8_srcs[$i1][4] == 0) {
			$miss1++;
		}
	}
	for ($i2 = 0; $i2 < $v6_tot; $i2++) {
		if ($v6_srcs[$i2][4] == 0) {
			$miss2++;
		}
	}
	prt( "Matched $matched of $v8_tot, with $matched of $v6_tot ...\n" );
	if (($added == 0) && ($subed == 0)) {
		prt( "DSP appears EQUIVALENT to VCPROJ file - no DSP modification done.\n" );
	} else {
		if ($v6_tot > 0) {
			prt( "DSP needs to be MODIFIED ... add = $added, subed = $subed\n" );
		} else {
			prt( "DSP will be CREATED ... with $added sources ...\n" );
		}
	}

	if ($miss1) {
		prt( "There are $miss1 files in VCPROJ, NOT in DSP\n" );
		for ($i1 = 0; $i1 < $v8_tot; $i1++) {
			if ($v8_srcs[$i1][4] == 0) {
				$src1 = $v8_srcs[$i1][0];
				$ff1  = $v8_srcs[$i1][1];
				$msg = "$src1 ($ff1) ";
				if (-f $ff1) {
					$msg .= "ok";
				} else {
                    if (length($altsrcfind) && length($basepath) && (length($basepath) < length($ff1))) {
                        $tmpsrc = $altsrcfind . substr($ff1, length($basepath));
                        if (-f $tmpsrc) {
        					$msg .= "ok (on alt src)";
                        } else {
        					$msg .= "NOT FOUND, even on alt src";
                        }
                    } else {
    					$msg .= "NOT FOUND";
                    }
				}
				prt( "$msg\n" );
			}
		}
	}
	if ($miss2) {
		prt( "There are $miss2 files in DSP, NOT in VCPROJ\n" );
		for ($i2 = 0; $i2 < $v6_tot; $i2++) {
			if ($v6_srcs[$i2][4] == 0) {
				$src2 = $v6_srcs[$i2][0];
				$ff2  = $v6_srcs[$i2][1];
				$msg = "$src2 ($ff2) ";
				if (-f $ff2) {
					$msg .= "ok";
				} else {
					$msg .= "NOT FOUND";
				}
				prt( "$msg\n" );
			}
		}
	}
	prt("\n");
	# whether modified, or new, keep the DSW entry
	$dsw_projects{$key} = "$key.dsp";
	$dsw_projpath{$key} = $rp;
	return ($added + $subed);	# return CHANGE counter
}

sub is_same_DOS_file {
	my ($f1, $f2) = @_;
	prt( "Comparing [$f1] with [$f2] " ) if ($dbg12);
	my $len = length($f1);
	if ($len != length($f2)) {
		prt( "Len $len != ".length($f2)."\n" ) if ($dbg12);
		return 0;	# not the SAME
	}
	$f1 =~ s/\//\\/g;
	$f2 =~ s/\//\\/g;
	my $lcf1 = lc($f1);
	my $lcf2 = lc($f2);
	my $i = 0;
	while ($i < $len) {
		if (substr($lcf1,$i,1) ne substr($lcf2,$i,1)) {
			prt( "Diff at $i\n" ) if ($dbg12);
			return 0;
		}
		$i++;
	}
	prt( "SAME\n\n" ) if ($dbg12);
	return 1;
}

sub process_DSW {
	my ($fil) = shift;
	my ($pnm, $pfil, $ff, $line, $lncnt);
	my ($msg);
	prt( "\nProcess DSW file $fil ... " );
	if ( -f $fil ) {
		prt( "already exists ...\n" );
		my ($name,$dir,$suffix) = fileparse($fil);
		# Project: "mirror"=.\mirror.dsp - Package Owner=<4>
		open IF, "<$fil" or mydie( "ERROR: Unable to open FILE! ... $! ...\n" );
		@dsw_file = <IF>;	# slurp it in, and keep it
		close IF;	# close file
		$lncnt = scalar @dsw_file;
		prt( "Processing $lncnt lines from file ...\n" );
		foreach $line (@dsw_file) {
			prt( $line ) if ($dbg_dsw1);
			##if ($line =~ /Project:\s+\"(\w+)\"=([\.\w\\]+)+\s*/) {
			if ($line =~ /^Project:\s+"(\w+)"="*([\w\.\\]+)"*\s+/) {
				$pnm = $1;
				$pfil = $2;
				$ff = $dir.$pfil;
				$msg = "Project: name=$pnm, file=$pfil ff=$ff ...";
				if ( -f $ff) {
					$msg .= "ok";
					push(@dsp_files, [$pfil, $ff, $pnm]); # [file, fullpath, and project NAME]
					prt( "$msg\n" ) if ($dbg_dsw2);
				} else {
					$msg .= "FAILED! CHECK ME!!";
					prt( "$msg\n" );
				}
			}
		}
		if (@dsp_files) {
			prt( "Got ".scalar @dsp_files." projects from $fil ...\n" );
		} else {
			prtw( "Warning: No projects found in $fil!!!\n" );
		}
	} else {
		prt( "*** DOES NOT EXIST ***\n" );
	}
}

sub process_DSP {
	my ($proj, $fil) = @_;
	my ($line, $prjname, $grpname, $filter, $ff, $src, $chr, $tmp, $conf, $ffnr);
	my ($itm1, $itm2, $key, $targtype);
	my $scnt = 0;
	my @dsp_lines = ();
	prt( "\nProcess DSP file $fil ... " );
	if ( -f $fil ) {
		prt( "already exists ...\n" );
		my ($name,$dir,$suffix) = fileparse($fil);
		if ( open IF, "<$fil" ) {
			@dsp_lines = <IF>;
			close IF;
			prt( "Got ".scalar @dsp_lines." lines to process ...\n" );
			my $ins = 0;
			foreach $line (@dsp_lines) {
				$line = trim_all($line);
				$chr = substr($line, 0, 1);	# get FIRST char of LINE
				if( $chr eq '#' ) {
					# line begins with SHARP
					if ($line =~ /\s+Microsoft Developer Studio Project File - Name=\"([\.\w\s]+)+/) {
						$prjname = $1;
						prt( "Project NAME = $prjname ...\n" ) if ($dbg_dsp);
					} elsif ($line =~ /\s+Microsoft Developer Studio Generated Build File, Format Version ([\d\.]+)/) {
						prt( "MSVC Version $1 ...\n" ) if ($dbg_dsp);
					} elsif ($line =~ /\s*TARGTYPE\s+\"(.+)\"\s+/) { # Win32 (x86) Console Application" 0x0103
						$targtype = $1;
						prt( "TARGTYPE: $targtype, name=$prjname ($proj)\n" );
					} elsif ($line =~ /Begin Group \"([\s\w]+)+/ ) {
						$grpname = $1;
						prt( "Begin group ... $grpname\n" ) if ($dbg_dsp);
					} elsif ($line =~ /PROP\s+Default_Filter\s+\"([\w;]+)+\"/ ) {
						$filter = $1;
						prt( "Begin Filter group $grpname, filter $filter\n" ) if ($dbg_ds8);
					} elsif ($line =~ /Begin Source File/) {
						$ins = 1;
						prt( "Begin source ... $ins ...\n" ) if ($dbg_dsp);
					} elsif ($line =~ /End Source File/) {
						$ins = 0;
						prt( "End source ... $ins ...\n" ) if ($dbg_dsp);
					} elsif ( $line =~ /ADD BASE CPP (.+)/ )  {
						# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /c
						$key = 'CPP '.$conf;
						prt( "ADD BASE $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					} elsif ( $line =~ /ADD CPP (.+)/ )  {
						# ADD CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /FD /c
						$key = 'CPP '.$conf;
						prt( "ADD $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					} elsif ( $line =~ /ADD BASE LINK32 (.+)/ )  {
						# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
						$key = 'LINK '.$conf;
						prt( "ADD BASE $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					} elsif ( $line =~ /ADD LINK32 (.+)/ )  {
						$key = 'LINK '.$conf;
						# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
						prt( "ADD $key [$1]\n" ) if ($dbg_ds4);
						$v6_conf{$key} = $1;
					}
				} elsif ( $chr eq '!' ) {
					if ($line =~ /^!IF\s+(.+)/i ) {
						prt( "Entering IF $1 ...\n" ) if ($dbg_ds6);
						if ($line =~ /!IF\s+(.+) == (.+)/i) {
							$itm1 = $1;
							$itm2 = $2;
							$itm1 =~ s/\"//g;
							$itm2 =~ s/\"//g;
							prt( "Got [$itm1] [$itm2]...\n" ) if ($dbg_ds6);
							if ($itm1 =~ /^\$\((.+)\)/ ) {
								if (defined $v6_defs{$1}) {
									if ($v6_defs{$1} eq $itm2) {
										$tmp = "TRUE";
									} else {
										$tmp = "FALSE";
									}
									if( $1 eq 'CFG' ) {
										$conf = $itm2;
									}
									prt( "and [$1] defined as \"$v6_defs{$1}\" ... $tmp $conf\n" ) if ($dbg_ds6);
								} else {
									prt( "NOT DEFINED [$1] ...\n" );
								}
							}
						} else {
							prt( "FAILED IF == [$line]\n" );
						}
					} elsif ( $line =~ /^!ELSE\s+/i ) {
						prt( "Entering ELSE ...\n" ) if ($dbg_ds6);
					} elsif ( $line =~ /^!ELSEIF\s+(.+)/i ) {
						prt( "Entering ELSEIF $1 ...\n" ) if ($dbg_ds6);
						if ($line =~ /!ELSEIF\s+(.+) == (.+)/i) {
							$itm1 = $1;
							$itm2 = $2;
							$itm1 =~ s/\"//g;
							$itm2 =~ s/\"//g;
							prt( "Got [$itm1] [$itm2]...\n" ) if ($dbg_ds6);
							if ($itm1 =~ /^\$\((.+)\)/ ) {
								if (defined $v6_defs{$1}) {
									if ($v6_defs{$1} eq $itm2) {
										$tmp = "TRUE";
									} else {
										$tmp = "FALSE";
									}
									if( $1 eq 'CFG' ) {
										$conf = $itm2;
									}
									prt( "and [$1] defined as \"$v6_defs{$1}\" ... $tmp $conf\n" ) if ($dbg_ds6);
								} else {
									prt( "NOT DEFINED [$1] ...\n" );
								}
							}
						} else {
							prt( "FAILED ELSEIF == [$line]\n" );
						}
					} elsif ( $line =~ /^!ENDIF\s*/i ) {
						prt( "Out ENDIF ...\n" ) if ($dbg_ds6);
					}
				} else {
					if ($line =~ /SOURCE=([\.\\\w-]+)+/ ) {
						$src = $1;
						$ff = $dir.$src;
						$ffnr = fix_rel_path($ff);
						if ($ins) {
							prt( "SOURCE = $src ($ff)... $ins \n" ) if ($dbg_dsp);
						} else {
							prt( "source = $src ($ff) OUTSIDE 'in source' ... $ins\n" );
						}
						if (is_c_source($src)) {
							prt("SOURCE=[$src]\n") if ($dbg_ds1);
						} elsif (is_h_source($src)) {
							prt("HEADER=[$src]\n") if ($dbg_ds2);
						} elsif (is_h_special($src)) {
							prt("HEADER=[$src]\n") if ($dbg_ds2);
						} else {
							prt("OTHER=[$src] ($line)\n") if ($dbg_ds3);
						}
						#                0     1      2          3          4  5  6
						#push(@v6_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname] );
						push(@v6_srcs, [$src, $ffnr, $grpname, $filter, 0, 0, $proj] );
						$scnt++;
						prt( "$scnt v6_srcs: $src, $ffnr, $grpname, $filter, 0, 0, $proj\n" ) if ($dbg_ds9);
					} elsif ( $line =~ /(.*)=(.*)/ ) {
						$itm1 = $1;
						$itm2 = $2;
						$v6_defs{$itm1} = $itm2;
						prt( "Defined [$itm1] = [$itm2] ...\n" ) if ($dbg_ds5);
					}
				}
			}
			prt( "End DSP - got $scnt source files ...\n" );
			if ($dbg_ds7) {
				foreach $key (keys %v6_conf) {
					prt( "Config $key = [$v6_conf{$key}]\n" );
				}
			}
		} else {
			prtw( "ERROR: FAILED TO OPEN $fil FILE!\n" );
		}
	} else {
		prt( "*** DOES NOT EXIST ***\n" );
	}
}

#################################################
##### VCPROJ XML PARSING #####
#################################################
sub get_xml_tag {
	my ($lin) = shift;
	my $len = length($lin);
	my $tag = '';
	my $pch = '';
	for (my $t = 0; $t < $len; $t++) {
		my $ch = substr($lin,$t,1);
		if ($ch eq '<') {
			prtw( "WARNING: Second TAG in line! ($lin)\n" ) if (length($tag));
			$tag = '';
			$t++;
			for ( ; $t < $len; $t++) {
				$ch = substr($lin,$t,1);
				if ($ch =~ /\s/) {
					# end of tag
					$t++;
					for ( ; $t < $len; $t++) {
						$ch = substr($lin,$t,1);
						if ($ch eq '>') {
							$tag .= $pch if ($pch eq '/');
							prtw( "WARNING: Premature CLOSE! ($lin)(1)\n" ) if (($t +1) < $len);
							last;	# end of TAG
						}
						$pch = $ch;	# keep last
					}
					last;
				} elsif ($ch eq '>') {
					prtw( "WARNING: Premature CLOSE! ($lin)(2)\n" ) if (($t +1) < $len);
					last;
				}
				$tag .= $ch;
			}
		}
	}
	return $tag;
}

sub tag_typ_2_stg {
	my ($typ) = shift;
	if ($typ == $TYP_OPEN) {
		return "OPEN";
	} elsif ($typ == $TYP_CLOSE) {
		return "CLOSE";
	} elsif ($typ == $TYP_OPENCLOSE) {
		return "OPENCLOSE";
	} elsif ($typ == $TYP_VERSION) {
		return "VERSION";
	}
	return "UNKNOWN";
}

sub get_tag_typ {
	my ($xt) = shift;
	my $typ = $TYP_OPEN;
	if ($xt =~ /^\//) {
		$typ = $TYP_CLOSE;
	} elsif ($xt =~ /\/$/) {
		$typ = $TYP_OPENCLOSE;
	} elsif ($xt eq '?xml') {
		$typ = $TYP_VERSION;
	}
	###prt( "For [$xt] returning [$typ] ...\n" );
	return $typ;
}

# get application type
# one of Console Application, Application, static library, dynamic library
sub get_app_type {
	my ($defs) = shift;
	my ($def, $key);
	my @arr = split(';',$defs);
	foreach $def (@arr) {
		foreach $key (keys %v8_defines) {
			if ($def eq $key) {
				return $v8_defines{$key};
			}
		}
	}
	# ok, nothing found - TRY HARDER
	foreach $def (@arr) {
		if ($def =~ /BUILD_LIBRARY/) {
			return $v8_defines{'_LIB'};
		} elsif ($def =~ /STATIC/) {
			return $v8_defines{'_LIB'};
		}
	}
	# UGH - still NOT FOUND - provide overrides for
	foreach $def (@special_typing) {
		if ($act_vcproj =~ /$def/) {
			return $v8_defines{'_LIB'};
		}
	}
	prtw( "Warning: String [$defs] does not give clue to TYPE!!!\n$act_vcproj - return def $typelse ??? CHECK ME\n" );
	return $typelse;
}

# split_space - space_split - like split(/\s/,$txt), but honour double inverted commas
sub space_split {
	my ($txt) = shift;
	my $len = length($txt);
	my ($k, $ch, $tag, $incomm);
	my @arr = ();
	$tag = '';
	$incomm = 0;
	for ($k = 0; $k < $len; $k++) {
		$ch = substr($txt,$k,1);
		if ($incomm) {
			$incomm = 0 if ($ch eq '"');
			$tag .= $ch;
		} elsif ($ch =~ /\s/) {
			push(@arr, $tag) if (length($tag));
			$tag = '';
		} else {
			$tag .= $ch;
			$incomm = 1 if ($ch eq '"');
		}
	}
	push(@arr, $tag) if (length($tag));
	if ($dbg_src13) {
		prt( "space_split (".scalar @arr.") of [$txt]\n" );
		foreach $tag (@arr) {
			prt( " $tag\n" );
		}
	}
	return @arr;
}

sub array_2_hash_on_equals {
	my (@inarr) = @_;
	my %hash = ();
	my ($itm, @arr, $key, $val, $al, $a);
	foreach $itm (@inarr) {
		@arr = split('=',$itm);
		$al = scalar @arr;
		$key = $arr[0];
		$val = '';
		for ($a = 1; $a < $al; $a++) {
			$val .= '=' if length($val);
			$val .= $arr[$a];
		}
		if (defined $hash{$key}) {
			prt( "WARNING: Duplicate KEY: $key ...\n" );
			$hash{$key} .= "@".$val;
		} else {
			$hash{$key} = $val;
		}
	}
	return %hash;
}

# @arr = split_conf( $dsp_defines_dbg );
sub split_conf {
	my ($cc) = shift;
	my $ln = length($cc);
	my @ar = ();
	my $itm = '';
	for (my $p = 0; $p < $ln; $p++) {
		my $ch = substr($cc,$p,1);
		if ($ch eq '"') {
			$p++;
			$itm = '';
			for (; $p < $ln; $p++) {
				$ch = substr($cc,$p,1);
				if ($ch eq '"') {
					last;
				}
				$itm .= $ch;
			}
			push(@ar,$itm) if length($itm);
		}
	}
	return @ar;
}

sub is_in_skip_conf_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_rel) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_conf_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_dbg) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}

sub is_in_skip_lib_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_rel) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_lib_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_dbg) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}

sub set_runtime_dbg { $dsp_runtime_dbg = shift; }
sub set_runtime_rel { $dsp_runtime_rel = shift; }

sub get_group_type {
    my ($src) = shift;
    my ($n,$d,$s) = fileparse($src, qr/\.[^.]*/ );
    my (@arr, $ext, $ex);
    $ex = substr($s,1) if ($s =~ /^\./);
    $ex = lc($ex);
    if (length($ex) == 0) {
        return GRP_HDR; # default to header is NO EXT
    }

    @arr = split(';', $def_src_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_SRC;
        }
    }

    @arr = split(';', $def_hdr_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_HDR;
        }
    }

    @arr = split(';', $def_rcs_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_RCS;
        }
    }

    @arr = split(';', $def_spl_g);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_SPL;
        }
    }

    prt( "CHECK EXTENSION: What group [$src], with ext [$s] or [$ex] ...\n" );
    return GRP_UNK; # not found, so UNKNOWN
}

sub get_def_group_name {
    my ($grp) = shift;
    if ($grp == GRP_SRC) {
        return $def_src_nm;
    }
    if ($grp == GRP_HDR) {
        return $def_hdr_nm;
    }
    if ($grp == GRP_RCS) {
        return $def_rcs_nm;
    }
    if ($grp == GRP_SPL) {
        return $def_spl_nm;
    }
    return $def_unknown." Group";
}

sub get_def_group_filter {
    my ($grp) = shift;
    if ($grp == GRP_SRC) {
        return $def_src_g;
    }
    if ($grp == GRP_HDR) {
        return $def_hdr_g;
    }
    if ($grp == GRP_RCS) {
        return $def_rcs_g;
    }
    if ($grp == GRP_SPL) {
        return $def_spl_g;
    }
    return $def_unknown." Filter";
}

# get_xml_source
# process the XML project file (*.vcproj) and
# extract the SOURCE file list,
# but do lots MORE than that ...
sub get_xml_sources {
	my ($in) = shift;
	##my $in_fd = file_dirname($in);
	my ($name,$in_fd,$suffix) = fileparse($in);
	my ($src, $ff, $pline);
	my $stf = '<File\\s+RelativePath=\\"([\\.\\\\\\w-]+)+\\"+(.)+';
	#my $filt = '^<Filter\\s+Name=\\"([\\w\\s]+)\\"\\s+Filter=\\"([\\w;]+)\\"';
	my @lines = ();
	my $line = '';
	my $filtname = '';
	my $filttype = '';
	my $conf = '';
	my $tname = '';
	my $version = '';
	my $projname = '';
	my $srccount = 0;
	my @xmltags = ();
	my $xmltag = '';
	my $tagtyp = 0;
	my $lnnum = 0;
	my $bgn = 0;
	my $end = 0;
	my $ll = 0;
	my $ch = '';
	my $bgnend = '';
	my $inconfigs = 0;
	my $ppdefs = '';
	my $apptype = '';
	my $adddeps = '';
	my @attribs = ();
	my %atthash = ();
	my $ctype = 0;
	my $def = '';
	my ($func, $itm, $ffnr, $shr, $tmpsrc);
	prt( "Loading [$in] file in directory [$in_fd] ...\n" );
	open FH, "<$in" or mydie( "ERROR: Can not open [$in] ... aborting ...\n" );
	@lines = <FH>; # slurp the whole file
	close( FH );
	my $fline = '';
	prt( "Processing ".scalar @lines." lines in $in ...\n" );
	my $hadver = 0;
	foreach $line (@lines) {
		$lnnum++;
		$line = trim_all($line);
		$ll = length($line);
		if ($ll) {
			if (length($fline)) {
				$fline .= ' '.$line;
			} else {
				$ch = substr($line,0,1);
				$fline .= $line;
				if ($ch eq '<') {
					$bgn = $lnnum;
				}
			}
		} else {
			next;
		}
		if ($fline =~ />/) {
			$bgnend = "$bgn-$lnnum";
			$bgn = -1;
			$xmltag = get_xml_tag($fline);
			$tagtyp = get_tag_typ($xmltag);
			prt( "$bgnend: $xmltag ".tag_typ_2_stg($tagtyp). " ($tagtyp)\n" ) if ($dbg_src9);
			if ($fline =~ /<VisualStudioProject\s+/) {
				if ($fline =~ /.+Version="(\d+\.{1}\d+)+".+/ ) {
					$version = $1;
				}
				if ($fline =~ /.+Name="(\w+)".+/) {
					$projname = $1;
				}
				##prt( "$fline\n" );
				prt( "Project=$projname, v=$version\n" ) if ($dbg_src11);
			} elsif ($fline =~ /$stf/) {
				# <File RelativePath="src\FDM\SP\ACMS.cxx" >
				$src = $1;
				$ff = $in_fd . $src;
				$ffnr = fix_rel_path($ff);
				$itm = "MISSING";
				if (-f $ffnr) {
					$itm = "ok";
					prt( "SRC: [$ffnr] $itm\n" ) if ($dbg_src16);
				} else {
                    if (length($altsrcfind) && length($basepath) && (length($basepath) < length($ffnr))) {
                        $tmpsrc = $altsrcfind . substr($ffnr, length($basepath));
                        if (-f $tmpsrc) {
        					$itm = "ok";
		        			prt( "SRC: [$ffnr] $itm\n" ) if ($dbg_src16);
                        } else {
        					$itm .= " [$src][$ff] CHECKME TOO [$tmpsrc]!";
	        				prt( "SRC: [$ffnr] $itm\n" );	# always SHOW MISSING if ($dbg_src16);
                        }
                    } else {
    					$itm .= " [$src][$ff] CHECKME!";
	    				prt( "SRC: [$ffnr] $itm\n" );	# always SHOW MISSING if ($dbg_src16);
                    }
				}
				if (is_c_source($src)) {
					prt("SOURCE=[$src]\n") if ($dbg_src1);
					#push(@csrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} elsif (is_h_source($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
					#push(@hsrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} elsif (is_h_special($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
					#push(@hsrc_array, [$src, $ff, $filtname, $filttype, 0] );
				} else {
					prt("OTHER=[$src]\n") if ($dbg_src3);
					#push(@osrc_array, [$src, $ff, $filtname, $filttype, 0] );
				}
				$srccount++;
                $shr = get_group_type($src);
				#                0    1      2          3          4  5  6          7
				push(@v8_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname, $shr] );
				prt( "$srccount v8_srcs: $src, $ffnr, $filtname, $filttype, 0, 0, $projname);\n" ) if ($dbg11);

			} elsif ($fline =~ /<Filter\s+(.*)/) {
				# <Filter Name="Source Files" Filter="cpp;c;cxx;rc;def;r;odl;idl;hpj;bat">
				$filtname = ''; # = NO FILTER NAME, like Source Files
				$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				if ($fline =~ /\s+Name=\"([\w\s]+)\"[\s>]+/) {
					$filtname = $1; # = Source Files
				}
				if ($fline =~ /\s+Filter=\"([\w;,]+)\"[\s>]+/) {
					$filttype = $1; # = cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
				prt("FILTNAME=[$filtname] [$filttype]\n") if ($dbg_src4);
			} elsif ($fline =~ /$v8_cfgexp/ ) {
				##if ($fline =~ /<Configuration\s+.*Name=\"(\S+)\"\s/ ) {
				$conf = $1;
				prt( "Got configuration $conf\n" ) if ($dbg_src6);
			} elsif ($fline =~ /<Tool\s+(.*)$/ ) {
				#} elsif ($fline =~ /$v8_toolexp/ ) {
				$pline = $1;
				#prt( "Got Tool $pline\n" ) if ($dbg_src7);
				if ($pline =~ /\s*Name=\"*(\w+)\"*/) {
					$tname = $1;
					prt( "Got Tool name $tname ($pline)\n" ) if ($dbg_src7);
					if ($tname eq 'VCCLCompilerTool') {
						# <Tool
						# Name="VCCLCompilerTool"
						# Optimization="0"
						# AdditionalIncludeDirectories="../lib,../lib/curl_transport,...
						# PreprocessorDefinitions="_DEBUG;WIN32;_LIB;ABYSS_WIN32;CURL_STATICLIB" 
						# MinimalRebuild="true" 
						# BasicRuntimeChecks="3" 
						# RuntimeLibrary="1" 
						# PrecompiledHeaderFile=".\Debug\xmlrpccpp/xmlrpccpp.pch" 
						# AssemblerListingLocation=".\Debug\xmlrpccpp/" 
						# ObjectFile=".\Debug\xmlrpccpp/" 
						# ProgramDataBaseFileName=".\Debug\xmlrpccpp/" 
						# WarningLevel="3" 
						# SuppressStartupBanner="true" 
						# DebugInformationFormat="4" />]
						$ctype = 0;
						$def = '<UNKNOWN>';
						if ($conf =~ /^Debug\|/) {
							$ctype = 1;
							$def = $dsp_runtime_dbg;
							$func = \&set_runtime_dbg;
						} elsif ($conf =~ /^Release\|/) {
							$ctype = 2;
							$def = $dsp_runtime_rel;
							$func = \&set_runtime_rel;
						}
						prt( "Is compiler tool ...[$fline] ... $conf ($ctype)\n" ) if ($dbg_src14);
						@attribs = space_split($fline);
						%atthash = array_2_hash_on_equals(@attribs);
						if ($dbg_src15) {
							prt( "\nShowing ALL \%atthash keys and values ... [$conf]($ctype)\n" );
							foreach $ppdefs (keys %atthash) {
								prt( "dbg_src15: [$ppdefs] = [$atthash{$ppdefs}] ...\n" );
								if ($ppdefs =~ /RuntimeLibrary/i) {
									prt( "RUNTIME [$ppdefs] = [$atthash{$ppdefs}] ...\n" );
								}
							}
						}

						if ( defined $atthash{'PreprocessorDefinitions'} ) {
							$ppdefs = strip_quotes(trim_all($atthash{'PreprocessorDefinitions'}));
							if ($inconfigs) {
								$apptype = get_app_type($ppdefs);
								prt( "Setting DEFS: $conf [$ppdefs] $apptype ($ctype)\n" ) if ($dbg_src8);
								$v8_link{$conf} = $ppdefs;
								if (defined $v8_apptyp{$projname}) {
									if ($v8_apptyp{$projname} ne $apptype) {
										prtw( "WARNING: ALREADY HAVE $projname with ".$v8_apptyp{$projname}." which is NOT $apptype!!!\n" );
									}
								} else {
									$v8_apptyp{$projname} = $apptype;
								}
							} elsif (length($ppdefs)) {
								prt( "Got DEFS: $conf [$1] OUTSIDE Configurations!\n" ) if ($dbg_src10);
							}
						}
						if ( defined $atthash{'RuntimeLibrary'} ) {
							$ppdefs = strip_quotes(trim_all($atthash{'RuntimeLibrary'}));
							$itm = get_runtime_stg($ppdefs);
							if (($ctype == 1)||($ctype == 2)) {
								if ($itm eq $def) {
									prt( "Got RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm (= $def)\n" );
								} else {
									$func->($itm);
									prt( "Set RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm (was $def)\n" );
								}
							} else {
								prt( "CHECKME:  RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm ($def)\n" );
							}
						}
						prt( "Done atthash for $conf ...\n" )  if ($dbg_src15);
					} elsif ($tname eq 'VCLinkerTool') {
						# <Tool
						# Name="VCLinkerTool"
						# AdditionalDependencies="comctl32.lib Msimg32.lib Winmm.lib"
						# LinkIncremental="1"
						# GenerateDebugInformation="true"
						# SubSystem="2"
						# OptimizeReferences="2"
						# EnableCOMDATFolding="2"
						# TargetMachine="1"
						# />
						prt( "Is linker tool ...[$fline]\n" ) if ($dbg_src7);
						@attribs = space_split($fline);
						%atthash = array_2_hash_on_equals(@attribs);
						if ($dbg_src12a) {	# DEBUG ONLY
							prt( "Split of attribs [$fline] ...\n" );
							foreach $adddeps (@attribs) {
								prt( " $adddeps\n" );
							}
							prt( "Show of HASH ...\n" );
							foreach $adddeps (keys %atthash) {
								prt( " $adddeps = ".$atthash{$adddeps}."\n" );
							}
						}
						if (defined $atthash{'AdditionalDependencies'} ) {
							$adddeps = strip_quotes(trim_all($atthash{'AdditionalDependencies'}));
							prt( "Setting ADDS: $conf [$adddeps]\n" ) if ($dbg_src12);
							$v8_depend{$conf} = $adddeps;
						}
					}
				} else {
					prtw( "WARNING: FAILED Name [$fline]\n" );
				}
			} elsif ($fline =~ /<\/Filter>/) {
				if ($killfilt) {
					$filtname = ''; # = NO FILTER NAME, like Source Files
					$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
			} elsif ($fline =~ /<Platforms/) {
				# 8-8: LINE=[<Platforms>]
			} elsif ($fline =~ /<Platform/) {
				# 9-11: LINE=[<Platform Name="Win32" />]
			} elsif ($fline =~ /<ToolFiles/) {
				# 13-13: LINE=[<ToolFiles>]
			} elsif ($fline =~ /<Configurations/) {
				# 15-15: LINE=[<Configurations>]
				$inconfigs = 1;
				prt( "Enter Configurations ... ($fline)\n" ) if ($dbg_src10);
			} elsif ($fline =~ /<References/) {
				# 167-167: LINE=[<References>]
			} elsif ($fline =~ /<Files/) {
				# 169-169: LINE=[<Files>]
			} elsif ($fline =~ /<FileConfiguration/) {
				# 177-179: LINE=[<FileConfiguration Name="Debug|Win32" >]
			} elsif ($fline =~ /<Globals/) {
				# 591-591: LINE=[<Globals>]
			} else {
				if ($tagtyp == $TYP_VERSION) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcv);
				} elsif ($tagtyp == $TYP_CLOSE) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcc);
				} else {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_src5);
				}
			}
			if ($tagtyp == $TYP_OPEN) {
				push(@xmltags,$xmltag);
			} elsif ($tagtyp == $TYP_CLOSE) {
				if (@xmltags) {
					my $tmptag = pop @xmltags;
					$xmltag = substr($xmltag,1);
					if ($tmptag ne $xmltag) {
						prtw( "WARNING: Closing TAG [$xmltag] not last [$tmptag]! $bgnend\n" );
					}
					if ($xmltag eq 'Configurations') {
						$inconfigs = 0;
						prt( "Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
					}
				} else {
					prtw( "WARNING: CLOSE TAG NOT OPEN! [$fline]\n" );
				}
			}
			$fline = '';
		}
	}

	###prt( "Project: $projname, as $apptype\n" ); # eg 'Project: gshhs, as Console Application'
	my (@att2, @disc, @arr);
	foreach $conf (keys %v8_depend) {
		$ctype = 0;
		if ($conf =~ /^Debug\|/) {
			$ctype = 1;
			$func = \&is_in_skip_lib_dbg;
		} elsif ($conf =~ /^Release\|/) {
			$ctype = 2;
			$func = \&is_in_skip_lib_rel;
		} else {
			$func = \&is_in_skip_lib_rel;
		}
		$ppdefs = $v8_depend{$conf};
		@attribs = split(/ /,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}
		prt( "\nLINK:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" );
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" );
		if ($ctype == 1) {	# ($conf =~ /^Debug\|/)
			$def = $dsp_libs_dbg;
			@arr = split(/ /,$dsp_libs_dbg);
			@disc = ();
			prt( "Debug VERSION ... $conf ... [ @arr ]\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_dbg .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_dbg) ...\n");
			prt( "To      $dsp_libs_dbg, discarding [ @disc ], as already there ...\n" );
		} elsif ($ctype == 2) {	# $conf =~ /^Release\|/)
			$def = $dsp_libs_rel;
			@arr = split(/ /, $dsp_libs_rel );
			prt( "Release VERSION ... $conf ... @arr\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_rel .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_rel) ...\n" );
			prt( "To      $dsp_libs_rel, discarding [ @disc ], as already there ...\n" );
		} else {
			prt( "CHECKME: VERSION NOT DEBUG OR RELEASE??? ... $conf ...\n" );
		}
	}

	foreach $conf (keys %v8_link) {
		$ctype = 0;
		if ($conf =~ /^Debug\|/) {
			$ctype = 1;
			$func = \&is_in_skip_conf_dbg;
		} elsif ($conf =~ /^Release\|/) {
			$ctype = 2;
			$func = \&is_in_skip_conf_rel;
		} else {
			$func = \&is_in_skip_conf_rel;
		}
		$ppdefs = $v8_link{$conf};
		@attribs = split(/;/,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}
		@arr = ();
		prt( "\nDEFS:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" );
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" );
		if ($ctype == 1) {	# ($conf =~ /^Debug\|/)
			$def = $dsp_defines_dbg;
			@arr = split_conf( $dsp_defines_dbg );
			@disc = ();
			prt( "Debug VERSION ... $conf ... @arr\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_dbg .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_dbg) ...\n" );
			prt( "To      $dsp_defines_dbg, discarding [ @disc ], as already there ...\n" );
		} elsif ($ctype == 2) {	# $conf =~ /^Release\|/)
			$def = $dsp_defines_rel;
			@arr = split_conf( $dsp_defines_rel );
			prt( "Release VERSION ... $conf ... @arr\n" );
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_rel .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_rel) ...\n");
			prt( "To      $dsp_defines_rel, discarding [ @disc ], as already there ...\n" );
		} else {
			prt( "\nCHECKME: VERSION NOT DEBUG NOR RELEASE??? ... $conf ...\n\n" );
		}

	}

	my $new_srcs = scalar @v8_srcs;
	prt( "Project: $projname, as $apptype\n" ); # eg 'Project: gshhs, as Console Application'
	prt( "Got new $new_srcs C/C++ files, header files, and others \n" );
}
#################################################


sub is_vcproj {
	my $fil = shift;
	if ($fil =~ /\.vcproj$/i) {
		return 1;
	}
	return 0;
}

sub strip_quotes {
	my ($ln) = shift;
	if ($ln =~ /^".*"$/) {
		$ln = substr($ln,1,length($ln)-2);
	}
	return $ln;
}

sub resolve_depends {
	my ($projname, $projdeps, @arr, $cnt);
	my ($depid, $pn, $projid);
	my ($nmdeps, $fnd);
	foreach $projname (keys %sln_projects) {
		$projdeps = $sln_depends{$projname};
		if (length($projdeps)) {
			# there is LENGTH, convert giant CID to simple project names
			@arr = split( /\|/, $projdeps );	# split em up
			$cnt = scalar @arr;	# get count of split
			#prt( "Proj $projname, depends on $cnt = $projdeps ...\n" );
			$nmdeps = '';	# build simple NAME set
			foreach $depid (@arr) {
				foreach $pn (keys %sln_projids) {
					if ($pn ne $projname) {
						$projid = $sln_projids{$pn};
						if ($depid eq $projid) {
							$nmdeps .= '|' if (length($nmdeps));
							$nmdeps .= $pn;
							last;
						}
					}
				}
			}
			@arr = split( /\|/, $nmdeps );
			prt( "proj $projname, depends on $nmdeps ...\n" ) if ($dbg_s13);
			if ($cnt != scalar @arr) {	# YEEK - Does NOT match - OH WELL
				prtw( "WARNING: Failed to get SAME count $cnt - got ".scalar @arr."!\n" );
			}
			$sln_depends{$projname} = $nmdeps;
		}
	}
}

# Read and store contents of SOLUTION (.sln) file
# 22/04/2008 - Extract DEPENDENCIES from solution file, and add to DSW output
sub process_SLN {
	my ($fil) = shift;
	my ($cnt, $line, $vers, @arr, $mver, $par, $ff, $itmnum);
	my ($projname, $projfile, $projff, $gotproj, $relpath);
	my ($tnm,$tpth);
	my ($inproj, $tline, $projid, $inpdeps, $projdeps);
	open IF, "<$fil" or mydie( "ERROR: Unable to open $fil ... $! ...\n" );
	my @lines = <IF>;
	close IF;
	$cnt = scalar @lines;
	my ($name,$sln_path) = fileparse($fil);
	prt( "\nProcessing $cnt lines ... n=[$name] p=[$sln_path] ...\n" );
	$projname = '';
	$projfile = '';
	$projff = '';
	$gotproj = 0;
	$inproj = 0;
	$inpdeps = 0;
	foreach $line (@lines) {
		$tline = trim_all($line);
		if ($line =~ /.+Format\s+Version\s+(\d+\.\d+)$/i) {
			$vers = $1;	# get n.nn version
			@arr = split(/\./,$vers);
			$mver = $arr[0];
			prt( "Is MSVC Version $mver ...\n" );
		} elsif ($line =~ /^Project\s*\(/) {
			# seek like 
			#Project("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}") = "abyss", "abyss.vcproj", "{8B384B8A-2B72-4DC4-8DF1-E3EF32F18850}"
			###prt( "Got project [$line] ...\n" );
			$inproj = 1;
			@arr = split( '=', $line );
			$cnt = scalar @arr;
			if ($cnt == 2) {
				$par = $arr[1];
				@arr = split(',', $par);
				$cnt = scalar @arr;
				if ($cnt == 3) {
					$projname = strip_quotes(trim_all($arr[0]));
					$projfile = strip_quotes(trim_all($arr[1]));
					$projid   = strip_quotes(trim_all($arr[2]));
					$projff = fix_rel_path($sln_path.$projfile);
					if ((length($projname)) && (is_vcproj($projfile)) && (-f $projff)) {
						$gotproj = 1;
						($tnm,$tpth) = fileparse($projff);
						$relpath = get_rel_dos_path($tpth, $sln_path);
						prt( "Got PROJECT name=$projname, file=$projff, rel=[$relpath].\n" ) if ($dbg_sl1);
						###push(@proj_files, $projff);
						if (defined $sln_projects{$projname}) {
							mydie( "A PROBLEM: Already GOT this project name $projname!!!\n" );
						} else {
							$sln_projects{$projname} = $projff;
							$sln_projpath{$projname} = $relpath; # can be BLANK, or say 'BvMath/'
							$sln_projids{$projname}  = $projid;
							$sln_depends{$projname}  = '';	# start dependencies, if any
						}
					} else {
						prt( "WARNING: " );
						if (!length($projname)) {
							prt( "Failed to get a project name!" );
						} elsif ( !is_vcproj($projfile) ) {
							prt( "Name [$projfile] NOT a VCPROJ name!" );
						} else {
							prt( "Unable to locate file [$projff]!" );
						}
						prt( " Line is (trimmed)\n$tline\n" );
					}
				} else {
					prtw( "Warning: Part 2 of Project line did NOT split into 3 on comma!???\n" );
				}
			} else {
				prtw( "Warning: Project line did NOT split in 2 on equal sign!???\n" );
			}

			# to switch on $tryharder requires additional work on parsing this line
			# =====================================================================
			if (!$gotproj && $tryharder) {
				@arr = split( /\"/, $line );
				$itmnum = 0;
				foreach $par (@arr) {
					$itmnum++;
					###prt( "$itmnum [$par]\n" );
					if (is_vcproj($par)) {
						$ff = $sln_path.$par;
						prt( "Got PROJECT file [$par] " );
						if ( -f $ff) {
							prt( "ok" );
							###push(@proj_files, $ff);
							my ($nm,$pt,$ex) = fileparse( $ff, qr/\.[^.]*/ );
							$projname = $nm;
							if (defined $sln_projects{$projname}) {
								mydie( "A PROBLEM: Already GOT this project name $projname!!!\n" );
							} else {
								($tnm,$tpth) = fileparse($ff);
								$relpath = get_rel_dos_path($tpth, $sln_path);
								$sln_projects{$projname} = $ff;
								$sln_projpath{$projname} = $relpath; # can be BLANK, or say 'BvMath/'
								# WARNING: TO BE DONE !!!
								$sln_projids{$projname}  = $projid;
								$sln_depends{$projname}  = '';	# start dependencies, if any
							}
						} else {
							prt( "FAILED" );
						}
						prt("\n");
					}
				}
			}
			# =====================================================================
		} elsif ($inproj) {
			# in the Project section - look for END of section, and DEPENDENCIES
			# ProjectSection(ProjectDependencies)
			if ($tline eq 'EndProject') {
			###if ($line =~ /^EndProject\s*/)
				$inproj = 0;
			} else {
				if ($inpdeps) {
					if ($tline eq 'EndProjectSection' ) {
						$inpdeps = 0;
					} else {
						# collect dependencies
						@arr = split( '=', $line );
						$cnt = scalar @arr;
						if ($cnt == 2) {
							$arr[0] = trim_all($arr[0]);
							$arr[1] = trim_all($arr[1]);
							if ($arr[0] eq $arr[1]) {
								$projdeps = $sln_depends{$projname};	# extract dependencies, if any
								$projdeps .= '|' if (length($projdeps));
								$projdeps .= $arr[0];
								prt( "Proj $projname, dependant on $arr[0] ...\n" ) if ($dbg_s12);
								##prt( "Proj $projname, dependant on $projdeps ...\n" );
								$sln_depends{$projname} = $projdeps;
							} else {
								prtw( "Warning: Found different IDS '$arr[0]' NE '$arr[1]'!!! \n" );
							}
						} else {
							prtw( "Warning: Project DEPENDENCY line did NOT split in 2 on equal sign!???\n" );
							prtw( "line=$line" );
						}
					}
				} elsif ($line =~ /ProjectSection\s*\(\s*ProjectDependencies\s*\)/) {
					$inpdeps = 1;
				}
			}
		}
	}
	###prt( "Done $fil ... got ".scalar @proj_files." project files ...\n" );
	prt( "Done $fil ... got ".scalar keys(%sln_projects)." project files ...\n" );
	# resolve dependencies, if possible - warn if NOT ...
	resolve_depends();
}

### utitlity subs
sub is_c_source {
	my $f = shift;
	if ( ($f =~ /\.c$/i) || ($f =~ /\.cpp$/i) || ($f =~ /\.cxx$/i) ) {
		return 1;
	}
	##if (!is_h_source($f)) {
	##	prt( "Item [$f] IS NOT C/C++ SOURCE!\n" );
	##}
	return 0;
}

sub is_h_special {
	my $f = shift;
	if (($f =~ /osg/i)||($f =~ /OpenThreads/i)||($f =~ /Producer/i)) {
		return 1;
	}
	return 0;
}

sub is_h_source {
	my $f = shift;
	if ( ($f =~ /\.h$/i) || ($f =~ /\.hpp$/i) || ($f =~ /\.hxx$/i) ) {
		return 1;
	}
	##if (!is_c_source($f)) {
	##	prt( "Item [$f] IS NOT C/C++ SOURCE!\n" );
	##}
	return 0;
}

sub get_suffix {
	my ($f) = shift;
	my @arr = split(/\./,$f);
	return $arr[-1];
}

sub is_rc_file {
    my ($f) = shift;
    my $s = get_suffix($f);
    if (lc($s) eq 'rc') {
        return 1;
    } elsif ($s =~ /^rc/i) {
        return 2;
    }
    return 0;
}

sub parse_args {
	my (@av) = @_;
	while (@av) {
		my $arg = shift @av;
		if ( length($inpsln) ) {
			prtw( "ERROR: Already have input file $inpsln ...\n" );
			mydie( "Only input is a single file ...\n" );
		}
		$inpsln = $arg;
	}
	if ( !length($inpsln) ) {
		if ($dbg1) {
			$inpsln = $defin;
		} else {
			prtw( "ERROR: Solution file not found!\n" );
			mydie( "Useage: solution_file ...\n" );
		}
	}
}

#########################################################
### file generation
sub generate_dsw {
    #my $name = shift;
    my ($name, $path) = @_;
    my $dsw_name = $path.$name . '.dsw';
    if ( !open(DSW, ">$dsw_name") ) {
		prtw( "ERROR: Can't create $dsw_name: $!\n" );
		return 0;
	}

    prt( "\nCreating $dsw_name\n" ) if $verbose;

    print DSW <<"EOF";
Microsoft Developer Studio Workspace File, Format Version 6.00
# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!

###############################################################################\r

EOF

    print DSW 'Project: ', "\"$name\"=\".\\", $name, ".dsp\" - Package Owner=<4>\n";
    print DSW <<"EOF";

Package=<5>
{{{
}}}

Package=<4>
{{{
}}}

EOF

    foreach my $p (@extra_projects) {
	print DSW "###############################################################################\n\n";
	my ($dsp,$nm) = split ',', $p;
	print "Project $nm=$dsp\n" if $verbose;
	print DSW "Project: \"$nm\"=\"$dsp\" - Package Owner=<4>\n\n";
	print DSW <<"EOF";
Package=<5>
{{{
}}}

Package=<4>
{{{
}}}

EOF
    }

    print DSW <<"EOF";
###############################################################################\r

Global:

Package=<5>
{{{
}}}

Package=<3>
{{{
}}}

###############################################################################\r

EOF
    close(DSW);
}


# # Begin Group "Source Files"
# 
# # PROP Default_Filter "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat"
# # Begin Source File
# 
# SOURCE=.\mirror.cpp
# # End Source File
# ...
# # End Group
sub is_in_array {
	my ($itm, @arr) = @_;
	my $max = scalar @arr;
	for (my $k = 0; $k < $max; $k++) {
		if ($arr[$k] eq $itm) {
			return 1;
		}
	}
	return 0;
}

sub is_in_array_nc {
	my ($itm, @arr) = @_;
	foreach my $val (@arr) {
		if ($val =~ /$itm/i) {
			return 1;
		}
	}
	return 0;
}


sub out_src {
	my ($sc,$of) = @_;
	print $of "# Begin Source File\n";
	print $of "\n";
	print $of "SOURCE=$sc\n";
	print $of "# End Source File\n";
}

sub generate_DSP {
	my ($key, $of) = @_;
	my ($DSP, $cnt, $i, $src, $fnm, $ftyp, $rpt, $apt, $dmsg);
	my ($got_src, $got_hdr, $got_rc, $src_cnt, $non_cnt, $shr);
    my ($def_grp);
	my @fltnms = ();
	$got_src = 0;
	$got_hdr = 0;
	$got_rc = 0;
	$src_cnt = 0;
	$non_cnt = 0;
	prt( "Generating DPS file $of, for $key ...\n" );
	if (open $DSP, ">$of") {
		# during the VCPROJ XML parse
		# $apptype = get_app_type($ppdefs);
		# $v8_link{$conf} = $ppdefs;
		# $v8_apptyp{$projname} = $apptype;
		# this should DECIDE which DSP HEADER to get ...
		# it can be ONE OF
		# 'Console Application', 'Dynamic-Link Library', 'Static Library', or 'Application'
		$apt = 'Application';
		$dmsg = "DSP app type = ";
		my $msg = get_dsp_head_app();	# get a DEFAULT windows 'Application'
		if (defined $v8_apptyp{$key}) {
			$apt = $v8_apptyp{$key};
			$dmsg .= $apt;
			if ($apt eq 'Application') {
				$dmsg .= " - using default windows app header ... ($apt)";
			} elsif ($apt eq 'Console Application') {
				$msg = get_dsp_head_console();
				$dmsg .= " - switch to CONSOLE header ... ($apt)";
			} elsif ($apt eq 'Static Library') {
				$msg = get_dsp_head_slib();
				$dmsg .= " - switch to STATIC LIBRARY header ... ($apt)";
			} else {
				$dmsg .= " *WARNING* project TYPE not yet CASED! ($apt)";
			}
		} else {
			prtw( "WARNING: $key NOT defined in v8_apptyp!\n");
			$dmsg .= " *WARNING* $key NOT defined in v8_apptyp!";
		}
		push(@dsp_written, "DPS file $of, for $key, type $apt");
		prt( "$dmsg\n" );
		$dmsg = "s/-NEW_RT_REL-/[$dsp_runtime_rel],\ns/-NEW_RT_DBG-/[$dsp_runtime_dbg]";
		prt( "$dmsg\n" );
		$dmsg = "s/-NEW_DEFS_REL-/[$dsp_defines_rel],\ns/-NEW_DEFS_DBG-/[$dsp_defines_dbg]";
		prt( "$dmsg\n" );
		$dmsg = "s/-NEW_LIBS_DBG-/[$dsp_libs_dbg],\ns/-NEW_LIBS_REL-/[$dsp_libs_rel]";
		prt( "$dmsg\n" );
		# perform SUBSTITUTIONS
		$msg =~ s/-NEW_PROJECT_NAME-/$key/gm;
		$msg =~ s/-NEW_RT_REL-/$dsp_runtime_rel/gm;
		$msg =~ s/-NEW_RT_DBG-/$dsp_runtime_dbg/gm;
		$msg =~ s/-NEW_DEFS_REL-/$dsp_defines_rel/gm;
		$msg =~ s/-NEW_DEFS_DBG-/$dsp_defines_dbg/gm;
		$msg =~ s/-NEW_LIBS_DBG-/$dsp_libs_dbg/gm;
		$msg =~ s/-NEW_LIBS_REL-/$dsp_libs_rel/gm;
		print $DSP $msg;
		#                 0     1    2          3          4  5  6
		# push(@v8_srcs, [$src, $ff, $filtname, $filttype, 0, 0, $projname, 7] );
		$cnt = scalar @v8_srcs;
		# three 'known' groups
		# Begin Group "Source Files"
		# PROP Default_Filter "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat;for;f90"
		# Begin Source File
		# End Source File
		# End Group
		# Begin Group "Header Files"
		# PROP Default_Filter "h;hpp;hxx;hm;inl;fi;fd"
		# End Group
		# Begin Group "Resource Files"
		# PROP Default_Filter "ico;cur;bmp;dlg;rc2;rct;bin;cnt;rtf;gif;jpg;jpeg;jpe"
		# End Group
		for ($i = 0; $i < $cnt; $i++) {
			$src = $v8_srcs[$i][0];         # source file
			$fnm = $v8_srcs[$i][V8_GRP];    # [2] # GROUP NAME 'Source Files', etc ...
			$ftyp = $v8_srcs[$i][3];        # group filter, if any
            $shr = $v8_srcs[$i][V8_SHR];    # [7] get GROUP by extension
            $def_grp = get_def_group_name($shr);
            if ($def_grp =~ /^$def_unknown/) {
                prt( "CHECK UNKNOWN: $shr for $src WHAT IS THIS???\n" );
            } else {
                if (length($fnm) ) {
                    if ($fnm ne $def_grp) {
                        if (!is_rc_file($src)) {
                            prt( "CHECK CHANGE: Change from '$fnm' to '$def_grp' for $src ... [$ftyp] \n" );
                        }
                        $v8_srcs[$i][V8_GRP] = $def_grp;
                    }
                } else {
                    $v8_srcs[$i][V8_GRP] = $def_grp;
                }
            }
			$v8_srcs[$i][5] = 0;	    # clear the DONE FLAG
		}
		$rpt = 1;	# set to BEGIN LOOP
		while ($rpt) {
			$rpt = 0;	# assume NO MORE
			for ($i = 0; $i < $cnt; $i++) {
				if ($v8_srcs[$i][5] == 0) {
					$src = $v8_srcs[$i][0];
					$fnm = $v8_srcs[$i][V8_GRP];	# [2] GROUP NAME 'Source Files', etc ...
					$ftyp = $v8_srcs[$i][3];
					if ( length($fnm) && !is_in_array($fnm,@fltnms) ) {
						if ($fnm =~ /Source/i) {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_src);
							$got_src = 1;
						} elsif ($fnm =~ /Header/i) {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_hdr);
							$got_hdr = 1;
						} elsif ($fnm =~ /Resource/i) {
							prt( "Outing GROUP $fnm ...\n" ) if (!$got_rc);
							$got_rc = 1;
						}
						push(@fltnms,$fnm);	# add it to the DONE GROUP
						$v8_srcs[$i][5] = 1; # SET AS DONE
						print $DSP '# Begin Group "'.$fnm."\"\n";
						print $DSP "\n";
						if (length$ftyp) {
							print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
						}

						out_src($src,$DSP);
						$src_cnt++;
						$i++;	# move to NEXT
						for (; $i < $cnt; $i++) {
							$src = $v8_srcs[$i][0];
							if ($v8_srcs[$i][5] == 0) {
								if ($fnm eq $v8_srcs[$i][2]) {
									out_src($src,$DSP);
									$src_cnt++;
									$v8_srcs[$i][5] = 1; # SET AS DONE
								}
							}
						}
						print $DSP "# End Group\n";
						$rpt = 1;	# try for some more
					}
				}
			}
		}

		# add any GROUPS not already DONE
		if (!$got_src) {
			$fnm = "Source Files";
			$ftyp = $def_src_g; # = "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat;for;f90"
			prt( "Outing GROUP $fnm ... BLANK\n" );
			print $DSP '# Begin Group "'.$fnm."\"\n";
			print $DSP "\n";
			print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
			print $DSP "# End Group\n";
		}
		if (!$got_hdr) {
			$fnm = "Header Files";
			$ftyp = $def_hdr_g; # = "h;hpp;hxx;hm;inl;fi;fd"
			prt( "Outing GROUP $fnm ... BLANK\n" );
			print $DSP '# Begin Group "'.$fnm."\"\n";
			print $DSP "\n";
			print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
			print $DSP "# End Group\n";
		}
		if (!$got_rc) {
			$fnm = "Resource Files";
			prt( "Outing GROUP $fnm ... BLANK\n" );
			$ftyp = $def_rcs_g; # = "ico;cur;bmp;dlg;rc2;rct;bin;cnt;rtf;gif;jpg;jpeg;jpe"
			print $DSP '# Begin Group "'.$fnm."\"\n";
			print $DSP "\n";
			print $DSP '# PROP Default_Filter "'.$ftyp."\"\n";
			print $DSP "# End Group\n";
		}
		###################################
		# any NOT in a GROUP
		for ($i = 0; $i < $cnt; $i++) {
			if ($v8_srcs[$i][5] == 0) {
				$non_cnt++
			}
		}
		prt( "Outing any NOT IN GROUP $non_cnt ...\n" ) if ($non_cnt);
		for ($i = 0; $i < $cnt; $i++) {
			if ($v8_srcs[$i][5] == 0) {
				$src = $v8_srcs[$i][0];
				out_src($src,$DSP);
				$src_cnt++;
			}
		}

		$msg = get_dsp_tail();
		print $DSP $msg;
		close $DSP;
		prt( "Written [$of] DSP file ... with $src_cnt sources ...\n" );
	} else {
		prtw( "WARNING: Failed to create [$of] ... $! ...\n" );
	}
}

sub fix_rel_path {
	my ($path) = shift;
	$path = path_u2d($path);	# ENSURE DOS PATH SEPARATOR (in relative.pl)
	my @a = split(/\\/, $path);
	my $npath = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				prtw( "WARNING: Got relative .. without previous!!! path=$path\n" );
			}
		} else {
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}

# Windows Console Application
# ===========================
sub get_dsp_head_console {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Console Application" 0x0103

CFG=-NEW_PROJECT_NAME- - Win32 Release
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Console Application")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Console Application")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir ".\\Release"
# PROP BASE Intermediate_Dir ".\\Release"
# PROP BASE Target_Dir "."
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir "Release\\-NEW_PROJECT_NAME-"
# PROP Intermediate_Dir "Release\\-NEW_PROJECT_NAME-"
# PROP Ignore_Export_Lib 0
# PROP Target_Dir "."
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /YX /c
# ADD CPP /nologo -NEW_RT_REL- /W3 /GX /O2 /I ".." /D "WIN32" /D "NDEBUG" /D "_CONSOLE" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:console /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /subsystem:console /machine:I386

!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir ".\\Debug"
# PROP BASE Intermediate_Dir ".\\Debug"
# PROP BASE Target_Dir "."
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir "Debug\\-NEW_PROJECT_NAME-"
# PROP Intermediate_Dir "Debug\\-NEW_PROJECT_NAME-"
# PROP Ignore_Export_Lib 0
# PROP Target_Dir "."
# ADD BASE CPP /nologo /W3 /Gm /GX /Zi /Od /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /YX /c
# ADD CPP /nologo -NEW_RT_REL- /W3 /Gm /GX /ZI /Od /I ".." /D "WIN32" /D "_DEBUG" /D "_CONSOLE" -NEW_DEFS_DBG- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:console /debug /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /subsystem:console /debug /machine:I386

!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Application
# ===========================
sub get_dsp_head_app {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Application" 0x0101

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Application")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Application")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
MTL=midl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir "Release"
# PROP Intermediate_Dir "Release"
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /c
# ADD CPP /nologo /W3 -NEW_RT_REL- /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /subsystem:windows /machine:I386

!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir "Debug"
# PROP Intermediate_Dir "Debug"
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /GZ /c
# ADD CPP /nologo /W3 -NEW_RT_DBG- /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" -NEW_DEFS_DBG- /FD /GZ /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept

!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Static Library
# ===========================
sub get_dsp_head_slib {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Static Library" 0x0104

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Static Library")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Static Library")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir "Release"
# PROP Intermediate_Dir "Release"
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" /YX /FD /c
# ADD CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_REL- /YX /FD /c
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo

!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir "Debug"
# PROP Intermediate_Dir "Debug"
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" /YX /FD /GZ /c
# ADD CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_DBG- /YX /FD /GZ /c
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo

!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Dynamic Library
# ===========================
sub get_dsp_head_dynalib {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

*** TO BE COMPLETED ***TBD***
EOF

	return $dsp_head;
}

sub get_dsp_tail {
	my $dsp_tail = <<EOF;
# End Target
# End Project
EOF

	return $dsp_tail;
}

sub get_dsw_head {
	### default DSW
	my $raw_dswh = <<EOF;
Microsoft Developer Studio Workspace File, Format Version 6.00
# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!

EOF
	return $raw_dswh;
}


sub get_dsw_tail {
	my $raw_dswt = <<EOF;
###############################################################################

Global:

Package=<5>
{{{
}}}

Package=<3>
{{{
}}}

###############################################################################

EOF
	return $raw_dswt;
}

sub get_runtime_stg {
	my ($rtn) = shift;
	if ($rtn == 0) {
		return "/MT";
	} elsif ($rtn == 1) {
		return "/MTd";
	} elsif ($rtn == 2) {
		return "/MD";
	} elsif ($rtn == 3) {
		return "/MDd";
	}
	return "/MT";
}

sub prtw {
	my ($wmsg) = shift;
	prt($wmsg);
	push(@warnings,$wmsg);
}

sub show_warnings {
	if (@warnings) {
		prt( "WARNING: Got ".scalar @warnings." warnings messages ...\n" );
		foreach my $wm (@warnings) {
			prt($wm);
		}
	} else {
		prt( "No warning or error messages ...\n" );
	}
}

# eof - sln2dsw.pl
