#!/perl -w
# NAME: sortres.pl
# AIM: Sort a RESOURCE header file
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_file = "C:\\GTools\\tools\\BglView2\\BvRes.h";
my $out_file = "tempres.h";

#@echo // Commands (ID_* and IDM_*) >> %TEMP1%
#@makehm ID_,HID_,0x10000 IDM_,HIDM_,0x10000 BVRes.h >> %TEMP1%
#@echo. >> %TEMP1%
#@echo // Prompts (IDP_*) >> %TEMP1%
#@makehm IDP_,HIDP_,0x30000 BVRes.h >> %TEMP1%
#@echo. >> %TEMP1%
#@echo // Resources (IDR_*) >> %TEMP1%
#@makehm IDR_,HIDR_,0x20000 BVRes.h >> %TEMP1%
#@echo. >> %TEMP1%
#@echo // Dialogs (IDD_*) >> %TEMP1%
#@makehm IDD_,HIDD_,0x20000 BVRes.h >> %TEMP1%
#@echo. >> %TEMP1%
#@echo // Frame Controls (IDW_*) >> %TEMP1%
#@makehm IDW_,HIDW_,0x50000 BVRes.h >> %TEMP1%

my @resitems = ();
my @resitemss = ();
my @valitems = ();
my @newitems = ();
my @newlines = ();
my $lncnt = 0;
my $rescnt = 0;
if (open INF, "<$in_file") {
	my @lines = <INF>;
	close INF;
	my ($fline, $line, $type, $num, $itm, $vitm, $item, $nxtnum);
	my ($i, $j, $ii, $done);
	my ($ind, $pt1, $pt2, $off);
	$lncnt = scalar @lines;
	prt( "Processing $in_file, $lncnt lines ...\n" );
	foreach $fline (@lines) {
		chomp $fline;
		$line = trim_all($fline);
		$type = 0;
		$num = 0;
		$itm = '';
		if ($line =~ /\s*#define\s+(\w+)\s+(\d+)\s*$/) {
			$itm = $1;
			$num = $2;
			if ($itm =~ /^_APS_NEXT_(\w+)/) {
				$vitm = $1;
				push(@valitems, [$itm, $vitm, $num]);
				prt( "spl: [$itm][$num] - $line\n" );
				$type = 1;
			} else {
				push(@resitems, $itm);
				prt( "[$itm][$num] - $line\n" );
				if ($itm =~ /^IDD_/) {
					$type = 2;
				} elsif ($itm =~ /^IDS_/) {
					$type = 3;
				} elsif ($itm =~ /^IDC_/) {	# use 2000++
					$type = 4;
				} elsif ($itm =~ /^IDI_/) {
					$type = 5;
				} elsif ($itm =~ /^IDB_/) {
					$type = 6;
				} elsif ($itm =~ /^IDR_/) {
					$type = 7;
				} elsif ($itm =~ /^IDM_/) {
					$type = 8;
				} else {
					$type = 9;
					prt( "CHECK ABOVE ITEM\n" );
				}
			}
		}
		push(@newitems, [$fline, $num, $type, 0, $itm]);
	}
	$nxtnum = 1000;
	@resitemss = sort spl_sort @resitems;
	$rescnt = scalar @resitemss;
	prt( "Got $rescnt items to sort ...\n" );
	$j = 0;
	for ($i = 0; $i < $lncnt; $i++) {
		$fline = $newitems[$i][0];
		$num   = $newitems[$i][1];
		$type  = $newitems[$i][2];
		$done  = $newitems[$i][3];
		if ($type > 1) {
			last;
		}
		push(@newlines, $fline);
		$newitems[$i][3] = 1;
	}
	### done up to first
	$i++;
	for( $j = 0; $j < $rescnt; $j++ ) {
		$item = $resitemss[$j];	# get sorted
		$ii = get_offset( $item );
		if ($ii == -1) {
			mydir( "ERROR: Item $item NOT FOUND ...\n" );
		}
		$fline = $newitems[$ii][0];
		$num   = $newitems[$ii][1];
		$type  = $newitems[$ii][2];
		$done  = $newitems[$ii][3];
		###$fline =~ s/$num/$nxtnum/;	# FAILS if number is part of 'item' ...
		$ind = index($fline, $item);
		mydie( "ERROR: Failed to get index [$item] in [$fline] ...\n" ) if ($ind == -1);
		$off = $ind + length($item);
		$pt1 = substr($fline, 0, $off);
		$pt2 = substr($fline, $off + 1);
		$pt2 =~ s/$num/$nxtnum/;	# change number ...
		$fline = $pt1 . $pt2;
		push(@newlines, $fline);
		$newitems[$ii][3] = 1;
		$nxtnum++;
	}
	for (; $i < $lncnt; $i++) {
		$fline = $newitems[$i][0];
		$num   = $newitems[$i][1];
		$type  = $newitems[$i][2];
		$done  = $newitems[$i][3];
		if (!$done) {
			push(@newlines, $fline);
			$newitems[$i][3] = 1;
		}
	}
	write2file( join("\n",@newlines), 'tempres.h' );
} else {
	prt( "ERROR: Unable to open $in_file ... $! ...\n" );
}




close_log($outfile,1);
exit(0);

sub spl_sort {
	my ($ha, $na, $hb, $nb);
	$ha = $a;
	$na = -1;
	$hb = $b;
	$nb = -1;
	if ($a =~ /^([A-Z_]+)(\d+)$/) {
		$ha = $1;
		$na = $2;
	}
	if ($b =~ /^([A-Z_]+)(\d+)$/) {
		$hb = $1;
		$nb = $2;
	}
	if (($ha eq $hb)&&($na != -1)&&($nb != -1)) {
		###prt( "Comparing $a with $b, $na vs $nb ..\n" );
		return ($na <=> $nb);
	}
	return ($a cmp $b);
}

sub get_offset {
	my ($itm) = shift;
	for (my $k = 0; $k < $lncnt; $k++) {
		my $it = $newitems[$k][4];
		my $dn = $newitems[$k][3];
		if ( !$dn && ($itm eq $it)) {
			return $k;
		}
	}
	return -1;
}

# eof
