sub scan_one_configure_file {
    my $filename = shift;
	if (!open(CONFIGURE, $filename)) {
		$err_msg = "WARNING: can't open '$filename': $!\n";
		prtw($err_msg);
		return;
	}
    prt( "$pack: reading $filename\n" ) if $verbose;

    my $in_ac_output = 0;
    my $ac_output_line = '';
    my $ff = '';
	my $cline = '';
	my $rawline = '';
	my %var_hash = ();
	my ($key, $nval, $orgkey, $orgnval, @varr, $vlen, $i, $ky);
    while (<CONFIGURE>) {
		$cline = $_;	# get current line
		chomp $cline;
		$rawline = trim_all($cline);
		###prt( "$cline\n" );
		# Remove comments from current line.
		s/\bdnl\b.*$//;
		s/\#.*$//;
		$cline =~ s/\bdnl\b.*$//;
		$cline =~ s/\#.*$//;
		next if (length($cline) == 0);
		prt( "$cline\n" ) if ($dbg10);
		if ($cline =~ /^(\w+)="(\d+)"$/) {
			prt( "Num Variable $1=$2\n" );
			$var_hash{$1} = $2;
		###} elsif ($cline =~ /^(\w+)="(.+)"$/) {
		} elsif ($cline =~ /^(\w+)=(.+)$/) {
			$key  = $1;
			$nval = $2;
			$orgkey = $key;
			$orgnval = $nval;
			$nval = substr($nval,1,length($nval)-2) if ($nval =~ /^".*"$/);
			prt( "Variable $key=$nval\n" ) if ($dbg14);
			if (index($nval,'.') != -1) {
				@varr = split(/\./,$nval);
				$nval = '';
				$vlen = scalar @varr;
				prt( "Split to $vlen components ...\n" ) if ($dbg11);
				for ($i = 0; $i < $vlen; $i++) {
					$ky = trim_line($varr[$i]);
					prt( "Conponent $ky\n" ) if ($dbg11);
					if (substr($ky,0,1) eq '$') {
						$ky = substr($ky,1);
						if (defined $var_hash{$ky}) {
							$nval .= '.' if (length($nval));
							$nval .= $var_hash{$ky};
						} else {
							$nval .= '.' if (length($nval));
							$nval .= $ky;
						}
					} else {
						$nval .= '.' if (length($nval));
						$nval .= $ky;
					}
				}
			}
			prt( "Substitute $key=$nval\n" ) if ((($orgkey ne $key)||($orgnval ne $nval)) && $dbg16);
			$var_hash{$key} = $nval;
			$config_ac_macros{$key} = $nval;
		} elsif ($cline =~ /^\s+(\w+)=(.+)$/) {
			### prt( "Line [$cline] NOT USED ...\n" ); # there are lots of them ...
		}
		# Skip macro definitions.  Otherwise we might be confused into
		# thinking that a macro that was only defined was actually
		# used.
		next if /AC_DEFUN/;

		if ((/$AC_DEF/) && !(/$AC_DEFINE/)) {
			# indicates should add next line, until complete
			$cline = $_;	# get current line
			chomp $cline;
			prt( "$. Should JOIN lines? - [$cline]\n" ) if ($dbg24);
			$_ = <CONFIGURE>;
		    if ($_) {
				$ky = $cline . ' ' . $_;
				$_ = $ky;
				chomp $ky;
				prt( "$. JOINED - [$ky]\n" ) if ($dbg24);
			}
		} elsif ((/$AC_DEFU/) && !(/$AC_DEFINE_UNQ/)) {
			# indicates should add next line, until complete
			$cline = $_;	# get current line
			chomp $cline;
			prt( "$. Should JOIN lines? - [$cline]\n" ) if ($dbg24);
			$_ = <CONFIGURE>;
		    if ($_) {
				$ky = $cline . ' ' . $_;
				$_ = $ky;
				chomp $ky;
				prt( "$. JOINED - [$ky]\n" ) if ($dbg24);
			}
		}
		if (/$AC_INIT/) {
			prt( "$. Got AC_INIT = [$1]\n" ) if ($dbg26);
			@varr = split(',', $1);
			$vlen = scalar @varr;
			for ($i = 0; $i < $vlen; $i++) {
				$nval = trim_all($varr[$i]);
				if ($i == 0) {
					$nval =~ s/\s/_/g;
					add_2_ac_macros('PACKAGE_NAME', $nval);
					$dsp_package = $nval;
				} elsif ($i == 1) {
					add_2_ac_macros('PACKAGE_VERSION', $nval);
					add_2_ac_macros('PACKAGE_STRING', $config_ac_macros{'PACKAGE_NAME'} .' ' .$nval );
					$dsp_version = $nval;
				} elsif ($i == 2) {
					add_2_ac_macros('PACKAGE_BUGREPORT', $nval);
				} elsif ($i == 3) {
					add_2_ac_macros('PACKAGE_TARNAME', $nval);
				} else {
					$err_msg = "WARNING: $i Split of AC_INIT = $nval\n";
					prtw($err_msg);
				}
			}
			next;
		} elsif (/$AC_DEFINE/) {
			prt( "$. Got AC_DEFINE = [$1]\n" ) if ($dbg26);
			@varr = split(',', $1);
			$vlen = scalar @varr;
			if ($vlen >= 2) {
				$ky = trim_all2($varr[0]);
				$nval = trim_all2($varr[1]);
				add_2_ac_macros( $ky, $nval );
			}
			next;
		} elsif (/$AC_DEFINE_UNQ/) {
			prt( "$. Got AC_DEFINE_UNQUOTED = [$1]\n" ) if ($dbg26);
			@varr = split(',', $1);
			$vlen = scalar @varr;
			if ($vlen >= 2) {
				$ky = trim_all2($varr[0]);
				$nval = trim_all2($varr[1]);
				add_2_ac_macros( $ky, $nval );
			}
			next;
		}

		# Follow includes.  This is a weirdness commonly in use at
		# Cygnus and hopefully nowhere else.
		if (/sinclude\((.*)\)/ && -f ($root_dir . $1))
		{
			$ff = $root_dir . $1;
			scan_one_configure_file ($ff);
		}

		if (! $in_ac_output && ( s/AC_OUTPUT\s*\(\[?// || s/AC_CONFIG_FILES\s*\(\[?// ) ) {
			$in_ac_output = 1;
			$ac_output_line = $.;	# get LINE number
			prt( "Got ac_output_line = line $ac_output_line ... [$rawline]\n" ) if ($dbg13);
		}

		if ($in_ac_output)
		{
			my $closing = 0;
			if (s/[\]\),].*$//)
			{
				$in_ac_output = 0;
				$closing = 1;
				prt( "ac_out: $rawline- CLOSING\n" ) if ($dbg13);
			} else {
				prt( "ac_out: $rawline\n" ) if ($dbg13);
			}

			# Look at potential Makefile.am's
			foreach (split)
			{
				# Must skip empty string for Perl 4.
				next if $_ eq "\\" || $_ eq '';

				my ($local,$input,@rest) = split(/:/);
				if (! $input) {
					$input = $local;
				} else {
					$input =~ s/\.in$//;
				}
				$ff = $root_dir . $input . '.am';
				if (-f $ff) {
					prt( "Adding $input [$ff] to make_input_list ...\n" ) if ($verbose2 || $dbg12a);
					push(@make_input_list, $input);
					$make_list{$input} = join(':', ($local,@rest));
				} else {
					prt( "Adding $input [$ff] to other_input_files ...\n" ) if ($verbose2 || $dbg12b);
					# We have a file that automake should cause to be
					# rebuilt, but shouldn't generate itself.
					push (@other_input_files, $_);
				}
			}
		}

		# Handle configuration headers.  A config header of `[$1]'
		# means we are actually scanning AM_CONFIG_HEADER from
		# aclocal.m4.
		if (/A([CM])_CONFIG_HEADER\s*\((.*)\)/
			&& $2 ne '[$1]')
		{
			&am_conf_line_error
				($filename, $., "\`automake requires \`AM_CONFIG_HEADER', not \`AC_CONFIG_HEADER'")
					if $1 eq 'C';

			$config_header_line = $.;
			my ($one_hdr);
			foreach $one_hdr (split (' ', $2))
			{
				push (@config_fullnames, $one_hdr);
				if ($one_hdr =~ /^([^:]+):(.+)$/)
				{
					push (@config_names, $1);
					push (@config_headers, $2);
				}
				else
				{
					push (@config_names, $one_hdr);
					push (@config_headers, $one_hdr . '.in');
				}
			}
		}

		if (/$AM_CONDITIONAL_PATTERN/o)
		{
			if ( defined $cfg_defines{$1} ) {
				# has been DEFINED in am2dsp?.cfg file
				prt( "Storing configure_cond key $1 ... value=2\n" ) if ($debug_on3);
				$configure_cond{$1} = 2;
			} else {
				prt( "Storing configure_cond key $1 ... value=1\n" ) if ($debug_on3);
				$configure_cond{$1} = 1;
			}
		}

		if (/$AM_INIT_AUTOMAKE/o)
		{
			$dsp_package = $1;
			$dsp_version = $2;
			$dsp_package = do_macro_sub($dsp_package);
			$dsp_version = do_macro_sub($dsp_version);
			prt( "Set DSP package = $dsp_package, DSP version = $dsp_version ...\n" );
		}
    }

    close(CONFIGURE);
}
