sub scan_one_configure_file {
    my ($filename, $rd) = @_;
	if( is_in_ac_done($filename) ) {
		return;
	}
    if (! open(CONFIGURE, $filename) ) {
        prtw( "WARNING: can't open '$filename': $!\n" );
        return;
    }

	push(@ac_scanned, $filename);
    prt( "Processing configure file - $filename ...\n" );
    my $in_ac_output = 0;
    my $ac_output_line = '';
    my $ff = '';
	my $fline = '';
	my $cline = '';
	my $acline = '';
	my $aclnum = 0;
	my %var_hash = ();
	my $key  = '';
	my $nval = '';
    while (<CONFIGURE>) {
		$fline = $_;	# get current file line
		$cline = $fline;	# copy current file line
		chomp $cline;
		$acline = trim_all($cline);
		$aclnum++;
		###prt( "$cline\n" );
		# Remove comments from current line.
		s/\bdnl\b.*$//;
		s/\#.*$//;
		$cline =~ s/\bdnl\b.*$//;
		$cline =~ s/\#.*$//;
		next if (length($cline) == 0);
		prt( "$cline\n" ) if ($dbg1);
		if ($cline =~ /^(\w+)="(\d+)"$/) {
			prt( "Num Variable $1=$2\n" ) if ($dbg3);
			$var_hash{$1} = $2;
		##} elsif ($cline =~ /^(\w+)="(.+)"$/) {
		##} elsif ($cline =~ /^(\w+)="{0,1}(.+)"{0,1}$/) {
		##} elsif ($cline =~ /^(\w+)=(.+)$/) {
		} elsif ($cline =~ /^\s*(\w+)=(.+)$/) {
			$key  = $1;
			$nval = $2;
			if (substr($nval,0,1) eq '"') {
				$nval = substr($nval,1, length($nval)-2);
			}
			prt( "MACRO [$key]=[$nval]\n" ) if ($dbg3a);
			if (index($nval,'.') != -1) {
				my @varr = split(/\./,$nval);
				$nval = '';
				my $vlen = scalar @varr;
				prt( "Split to $vlen components ...\n" ) if ($dbg3);
				for (my $i = 0; $i < $vlen; $i++) {
					my $ky = trim_line($varr[$i]);
					prt( "Conponent $ky\n" ) if ($dbg3);
					if (substr($ky,0,1) eq '$') {
						$ky = substr($ky,1);
						if (defined $var_hash{$ky}) {
							$nval .= '.' if (length($nval));
							$nval .= $var_hash{$ky};
						} else {
							$nval .= '.' if (length($nval));
							$nval .= $ky;
						}
					} else {
						$nval .= '.' if (length($nval));
						$nval .= $ky;
					}
				}
			}
			prt( "Available substitute [$key]=[$nval]\n" ) if ($dbg3);
			$var_hash{$key} = $nval;
			$config_ac_macros{$key} = $nval;
		} elsif ($cline =~ /^(\w+)=(.+)$/) {
			$key  = $1;
			$nval = $2;
			prtw( "WARNING: This should have already been processed!\nWARNING: Variable [$key]=[$nval] no quotes\n\n" );
		}

		# Skip macro definitions.  Otherwise we might be confused into
		# thinking that a macro that was only defined was actually
		# used.
		next if /AC_DEFUN/;

		# Follow includes.  This is a weirdness commonly in use at
		# Cygnus and hopefully nowhere else.
		if (/sinclude\((.*)\)/ && -f ($rd . $1)) {
			$ff = $rd . $1;
			scan_one_configure_file ($ff, $rd);
		}

		if (! $in_ac_output && ( s/AC_OUTPUT\s*\(\[?// || s/AC_CONFIG_FILES\s*\(\[?// ) ) {
			$in_ac_output = 1;
			$ac_output_line = $.;	# get LINE number
			prt( "Got ac_output_line = [$ac_output_line] ...\n" ) if ($dbg4);
		}

		if ($in_ac_output) {
			my $closing = 0;
			if (s/[\]\),].*$//) {
				$in_ac_output = 0;
				$closing = 1;
			}

			# Look at potential Makefile.am's
			foreach (split) {
				# Must skip empty string for Perl 4.
				next if $_ eq "\\" || $_ eq '';

				my ($local,$input,@rest) = split(/:/);
				if (! $input) {
					$input = $local;
				} else {
					$input =~ s/\.in$//;
				}
				$ff = $rd . $input . '.am';
				if (-f $ff) {
					prt( "Adding $input [$ff] to make_input_list ...\n" ) if ($dbg5);
					push(@make_input_list, $input);
					$make_list{$input} = join(':', ($local,@rest));
				} else {
					prt( "Adding $input [$ff] to other_input_files ...\n" ) if ($dbg5);
					# We have a file that automake should cause to be
					# rebuilt, but shouldn't generate itself.
					push (@other_input_files, $_);
				}
			}
		}

		# Handle configuration headers.  A config header of `[$1]'
		# means we are actually scanning AM_CONFIG_HEADER from
		# aclocal.m4.
		if (/A([CM])_CONFIG_HEADER\s*\((.*)\)/ && $2 ne '[$1]') {
			am_conf_line_error($filename, $., "automake requires AM_CONFIG_HEADER, not AC_CONFIG_HEADER")
					if $1 eq 'C';
			$config_header_line = $.;
			my ($one_hdr);
			foreach $one_hdr (split (' ', $2)) {
				push (@config_fullnames, $one_hdr);
				if ($one_hdr =~ /^([^:]+):(.+)$/) {
					push (@config_names, $1);
					push (@config_headers, $2);
				} else {
					push (@config_names, $one_hdr);
					push (@config_headers, $one_hdr . '.in');
				}
			}
		}

		if (/$AM_CONDITIONAL_PATTERN/o) {
			prt( "$aclnum: [$acline]\n" ) if ($dbg2a);
			if ( defined $cfg_defines{$1} ) {
				# has been DEFINED in am2dsp?.cfg file, or previously defined
				prt( "Storing configure_cond key $1 ... value=2\n" ) if ($dbg2);
				$configure_cond{$1} = 2;
			} else {
				prt( "Storing configure_cond key $1 ... value=1\n" ) if ($dbg2);
				$configure_cond{$1} = 1;
			}
		}

		if (/$AM_INIT_AUTOMAKE/o) {
			$dsp_package = $1;
			$dsp_version = $2;
			prt( "Got AM_INIT_AUTOMAKE($dsp_package, $dsp_version) ...\n" );
			$dsp_package = do_macro_sub($dsp_package);
			$dsp_version = do_macro_sub($dsp_version);
			prt( "Set DSP package = $dsp_package, DSP version = $dsp_version ...\n" );
		}
    }

    close(CONFIGURE);
}
