#!/Perl
# test3.pl
# AIM: Check out sorting a multi-dimensional array ...
# in this case text, thus 'lt' and 'gt' used
# for number sort this would be '<' and '>'!
my $verb3 = 0;
prt( "$0...Hello, World...\n");

my @mdarray = (
	[ 'c', 'cast' ],
	[ 'a', 'appl' ],
	[ 'z', 'zero' ],
	[ 'b', 'beat' ]
);

my @mdnarray = (
	[ 3, 'cast' ],
	[ 1, 'appl' ],
	[ 4, 'zero' ],
	[ 2, 'beat' ]
);


my $cnt = scalar @mdarray;
prt( "Array has $cnt members ...\n" );
my @ascarray = sort myasc_ascend @mdarray;
my @decarray = sort myasc_decend @mdarray;
for ($i = 0; $i < $cnt; $i++ ) {
	prt( " ".($i+1)." " );
	prt( "org ($mdarray[$i][0] $mdarray[$i][1]) " ); 
	prt( "asc ($ascarray[$i][0] $ascarray[$i][1]) " ); 
	prt( "dec ($decarray[$i][0] $decarray[$i][1])" );
	prt( "\n" );
}
my @ascnarray = sort mycmp_ascend @mdnarray;
my @decnarray = sort mycmp_decend @mdnarray;
for ($i = 0; $i < $cnt; $i++ ) {
	prt( " ".($i+1)." " );
	prt( "org ($mdnarray[$i][0] $mdnarray[$i][1]) " ); 
	prt( "asc ($ascnarray[$i][0] $ascnarray[$i][1]) " ); 
	prt( "dec ($decnarray[$i][0] $decnarray[$i][1])" );
	prt( "\n" );
}

# put least first
sub myasc_ascend {
	if (${$a}[0] lt ${$b}[0]) {
		prt( "-[".${$a}[0]."] < [".${$b}[0]."] asc\n" ) if $verb3;
		return -1;
	}
	if (${$a}[0] gt ${$b}[0]) {
		prt( "+[".${$a}[0]."] < [".${$b}[0]."] asc\n" ) if $verb3;
		return 1;
	}
	prt( "=[".${$a}[0]."] = [".${$b}[0]."] asc\n" ) if $verb3;
	return 0;
}

sub myasc_decend {
	if (${$a}[0] lt ${$b}[0]) {
		prt( "+[".${$a}[0]."] < [".${$b}[0]."] dec\n" ) if $verb3;
		return 1;
	}
	if (${$a}[0] gt ${$b}[0]) {
		prt( "-[".${$a}[0]."] < [".${$b}[0]."] dec\n" ) if $verb3;
		return -1;
	}
	prt( "=[".${$a}[0]."] < [".${$b}[0]."] dec\n" ) if $verb3;
	return 0;
}

# put least first
sub mycmp_ascend {
	if (${$a}[0] < ${$b}[0]) {
		prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
		return -1;
	}
	if (${$a}[0] > ${$b}[0]) {
		prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
		return 1;
	}
	prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
	return 0;
}

sub mycmp_decend {
	if (${$a}[0] < ${$b}[0]) {
		prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
		return 1;
	}
	if (${$a}[0] > ${$b}[0]) {
		prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
		return -1;
	}
	prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
	return 0;
}


sub prt {
	my ($t) = shift;
	print "$t";
}

# eof - test3.pl
