#!/perl -w
#  *NAME*
# AIM:
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
my $htmfile = 'temp.'.$0.'.htm';

open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my @byte_color_map = (
   # BGN RED ORANGE YELLOW GREEN
     0,  0,204,  0, #   4 RED 80%
    51,  0,204,  0, #  40
    51, 51,204,  0, #  46

     0,  0,255,  0, #   5 RED 100%
    51,  0,255,  0, #  41
    51, 51,255,  0, #  47

   102,102,255,  0, #  89

   153,  0,255,  0, # 113
   153, 51,255,  0, # 119

   153,102,255,  0, # 125
   153,102,204,  0, # 124
   153,153,255,  0, # 131
   153,153,204,  0, # 130

   153, 51,204,  0, # 118
   153,  0,153,  0, # 111
   153,  0,204,  0, # 112

   102,102,204,  0, #  88 ORANGE GREEN
   102,102,153,  0, #  87 ORANGE BLUE

   102,153,255,  0, #  95

   153,204,255,  0, # 137 LIGHT ORANGE
   153,204,204,  0, # 136 ORANGE+TURQ

   102,153,204,  0, #  94
     0,204,255,  0, #  29 ORANGE

     0,204,204,  0, #  28 ORANGE

     0,255,255,  0, #  35 YELLOW 100%
    51,255,255,  0, #  71 YELLOW

   102,255,255,  0, # 107
   102,255,204,  0, # 106
   102,255,153,  0, # 105
   102,255,102,  0, # 104
   102,255, 51,  0, # 103
   102,255,  0,  0, # 102

    51,255,204,  0, #  70 YELLOW 75%
    51,255,153,  0, #  69 YELLOW GREEN

     0,255,204,  0, #  34 YELLOW
     0,255,153,  0, #  33 YELLOW GREEN
     0,255,102,  0, #  32 LIGHT GREEN
     0,255, 51,  0, #  31 LIGHT GREEN

   102,204,255,  0, # 101
   102,204,204,  0, # 100
   102,204,153,  0, #  99
   102,204,102,  0, #  98
   102,204, 51,  0, #  97
   102,204,  0,  0, #  96

   102,153,153,  0, #  93
   102,153,102,  0, #  92
   102,153, 51,  0, #  91
   102,153,  0,  0, #  90

     0,204,153,  0, #  27 ORANGE GREEN
     0,204,102,  0, #  26 GREEN + ORANGE

    51,204,  0,  0, #  60 LIGHT GREEN
    51,204, 51,  0, #  61 LIGHT GREEN
    51,204,102,  0, #  62 LIGHT MUDY GREEN

    51,153,102,  0, #  56 MUDY GREEN
     0,255,  0,  0, #  30 GREEN 100%
    51,255,  0,  0, #  66 GREEN

     0,204,  0,  0, #  24 GREEN
     0,204, 51,  0, #  25 GREEN
 
    51,255, 51,  0, #  67 GREEN
    51,255,102,  0, #  68 GREEN

    51,153,  0,  0, #  54 DARK GREEN
    51,153, 51,  0, #  55 DARK GREEN
    51,102,  0,  0, #  48 DARK GREEN
    51,102, 51,  0, #  49 DARK GREEN
   # END RED ORANGE YELLOW GREEN

     0, 50,  0,  0, # 229
     0, 50,  0,  0, # 227

   153,204,153,  0, # 135 TURQ4+ORANGE
   153,204,102,  0, # 134 TURQ3
   153,204, 51,  0, # 133 TURQ2
   153,204,  0,  0, # 132 TURQ1

   153,255,  0,  0, # 138
   153,255, 51,  0, # 139
   153,255,102,  0, # 140
   153,255,153,  0, # 141
   153,255,204,  0, # 142
   153,255,255,  0, # 143

   204,  0,102,  0, # 146
   204,  0,153,  0, # 147
   204,  0,204,  0, # 148
   204,  0,255,  0, # 149

   204, 51,102,  0, # 152
   204, 51,153,  0, # 153
   204, 51,204,  0, # 154
   204, 51,255,  0, # 155

   204,102,102,  0, # 158
   204,102,153,  0, # 159
   204,102,204,  0, # 160
   204,102,255,  0, # 161

   204,153,102,  0, # 164
   204,153,153,  0, # 165
   204,153,204,  0, # 166
   204,153,255,  0, # 167

   204,204,102,  0, # 170
   204,204,153,  0, # 171
   204,204,255,  0, # 173

   204,255,102,  0, # 176
   204,255,153,  0, # 177
   204,255,204,  0, # 178
   204,255,255,  0, # 179

     0, 50,  0,  0, # 222
     0, 50,  0,  0, # 223

     0,  0,  0,  0, #   0
     0,  0, 51,  0, #   1
     0,  0,102,  0, #   2
     0,  0,153,  0, #   3

     0, 51,  0,  0, #   6
     0, 51, 51,  0, #   7
     0, 51,102,  0, #   8
     0, 51,153,  0, #   9
     0, 51,204,  0, #  10
     0, 51,255,  0, #  11
     0,102,  0,  0, #  12
     0,102, 51,  0, #  13
     0,102,102,  0, #  14
     0,102,153,  0, #  15
     0,102,204,  0, #  16
     0,102,255,  0, #  17
     0,153,  0,  0, #  18
     0,153, 51,  0, #  19
     0,153,102,  0, #  20
     0,153,153,  0, #  21
     0,153,204,  0, #  22
     0,153,255,  0, #  23

     0, 50,  0,  0, # 218
     0, 50,  0,  0, # 219

   255,  0,102,  0, # 182
   255, 51,102,  0, # 188
   255,102,102,  0, # 194
   255,153,102,  0, # 200
   255,204,102,  0, # 206
   255,204,153,  0, # 207

   255,  0,153,  0, # 183
   255, 51,153,  0, # 189
   255,102,153,  0, # 195
   255,153,153,  0, # 201

   255,  0,204,  0, # 184
   255,  0,255,  0, # 185

   255, 51,204,  0, # 190
   255, 51,255,  0, # 191

   255,102,204,  0, # 196
   255,102,255,  0, # 197

   255,153,204,  0, # 202
   255,153,255,  0, # 203

   255,204,204,  0, # 208
   255,204,255,  0, # 209

   255,255,204,  0, # 214
   255,255,255,  0, # 215

     0, 50,  0,  0, # 224
     0, 50,  0,  0, # 225

    51, 51, 51,  0, #  43 GRAY 20%
   102,102,102,  0, #  86 GRAY 40%
   153,153,153,  0, # 129 GRAY 60%
   204,204,204,  0, # 172 GRAY 80%

    51,  0,  0,  0, #  36


   102,102,  0,  0, #  84 GRAY BLUE
   102,102, 51,  0, #  85 GRAY BLUE

     0, 50,  0,  0, # 254
     0, 50,  0,  0, # 255
     0, 50,  0,  0, # 220
     0, 50,  0,  0, # 221

    51,  0, 51,  0, #  37
    51,  0,102,  0, #  38
    51,  0,153,  0, #  39

    51, 51,  0,  0, #  42
    51, 51,102,  0, #  44
    51, 51,153,  0, #  45

    51,102,102,  0, #  50
    51,102,153,  0, #  51
    51,102,204,  0, #  52
    51,102,255,  0, #  53
    51,153,153,  0, #  57
    51,153,204,  0, #  58
    51,153,255,  0, #  59
    51,204,153,  0, #  63
    51,204,204,  0, #  64
    51,204,255,  0, #  65

   102,  0, 51,  0, #  73
   102,  0,102,  0, #  74
   102,  0,153,  0, #  75
   102,  0,204,  0, #  76
   102,  0,255,  0, #  77

   102, 51,  0,  0, #  78
   102, 51, 51,  0, #  79
   102, 51,102,  0, #  80
   102, 51,153,  0, #  81
   102, 51,204,  0, #  82
   102, 51,255,  0, #  83

     0, 50,  0,  0, # 216
   153, 51,153,  0, # 117
     0, 50,  0,  0, # 217
     0, 50,  0,  0, # 228
     0, 50,  0,  0, # 230
     0, 50,  0,  0, # 231
     0, 50,  0,  0, # 232
     0, 50,  0,  0, # 233
     0, 50,  0,  0, # 234
     0, 50,  0,  0, # 235
     0, 50,  0,  0, # 236
     0, 50,  0,  0, # 237
     0, 50,  0,  0, # 238
     0, 50,  0,  0, # 239
     0, 50,  0,  0, # 240
     0, 50,  0,  0, # 241
     0, 50,  0,  0, # 242
     0, 50,  0,  0, # 243
     0, 50,  0,  0, # 244
     0, 50,  0,  0, # 245
     0, 50,  0,  0, # 246
     0, 50,  0,  0, # 247
     0, 50,  0,  0, # 248
     0, 50,  0,  0, # 249
     0, 50,  0,  0, # 250

   153,153,  0,  0, # 126
   153,153, 51,  0, # 127
   153,153,102,  0, # 128

     0, 50,  0,  0, # 251
     0, 50,  0,  0, # 226

   153,  0,102,  0, # 110
   153, 51,102,  0, # 116
   153,102,153,  0, # 123
   153,102,102,  0, # 122

   153,  0, 51,  0, # 109
   153, 51,  0,  0, # 114
   153, 51, 51,  0, # 115

   153,102,  0,  0, # 120
   153,102, 51,  0, # 121

     0, 50,  0,  0, # 252
     0, 50,  0,  0, # 253

   # == BEGIN BLUE SCALE ===
   102,  0,  0,  0, #  72
   153,  0,  0,  0, # 108

   204,  0,  0,  0, # 144
   204,  0, 51,  0, # 145
   204, 51,  0,  0, # 150
   204, 51, 51,  0, # 151

   255,  0,  0,  0, # 180
   255,  0, 51,  0, # 181

   255, 51,  0,  0, # 186
   255, 51, 51,  0, # 187

   204,102,  0,  0, # 156
   255,102, 51,  0, # 193

   204,102, 51,  0, # 157
   255,102,  0,  0, # 192

   204,153,  0,  0, # 162
   204,153, 51,  0, # 163

   255,153,  0,  0, # 198
   255,153, 51,  0, # 199

   255,204,  0,  0, # 204
   255,204, 51,  0, # 205

   204,204,  0,  0, # 168
   204,204, 51,  0, # 169

   204,255,  0,  0, # 174
   204,255, 51,  0, # 175

   255,255,  0,  0, # 210
   255,255, 51,  0, # 211

   255,255,102,  0, # 212
   255,255,153,  0  # 213
   # == END BLUE SCALE ===
);

my $sz = scalar @byte_color_map / 4;
prt( "Have $sz entries ...\n" );
my ($HF, $msg, $clr);
open $HF, ">$htmfile" or mydie( "ERROR: Unable to open $htmfile ...\n" );
html_begin($HF);
print $HF "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
my $cols = 0;
my $wrap = 4;
my $i = 0;
my $j = 0;
my ($r, $g, $b);
my ($hr, $hg, $hb);
my ($sty);
for ($i = 0; $i < $sz; $i++) {
	$j = ($i * 4);
	$b = $byte_color_map[$j];
	$g = $byte_color_map[$j+1];
	$r = $byte_color_map[$j+2];
	$hr = uc(sprintf("%2.2x", $r));
	$hg = uc(sprintf("%2.2x", $g));
	$hb = uc(sprintf("%2.2x", $b));
	if ($cols == 0) {
		print $HF "<tr>\n";
	}
	$sty = "style=background=\"#$hr$hg$hb\"";
	$msg = "<td><p $sty>($r,$g,$b) #$hr$hg$hb</p></td>\n";
	print $HF $msg;
	$cols++;
	if ($cols == $wrap) {
		print $HF "</tr>\n";
		$cols = 0;
	}
}
if ($cols) {
	while ($cols < $wrap) {
		print $HF "<td>&nbsp;</td>\n";
		$cols++;
	}
}
print $HF "</table>\n";
html_end($HF);
close $HF;
system($htmfile);
close_log($outfile,0);
exit(0);

sub html_begin {
	my ($f) = shift;
	print $f <<"EOF";
<html>
<head>
<title>$htmfile</title>
<style type="text/css">
<!-- /* Style Definitions */
body {
margin:1cm 1cm 1cm 1cm;
}
p {
margin:0cm;
padding:0cm
}

-->
</style>

</head>
<body>
<h1>$htmfile</h1>
EOF

}

sub html_end {
	my ($f) = shift;
	print $f <<"EOF";
</body>
</html>
EOF

}

sub URLDecode {
    my $theURL = $_[0];
    $theURL =~ tr/+/ /;
    $theURL =~ s/%([a-fA-F0-9]{2,2})/chr(hex($1))/eg;
    $theURL =~ s/<!--(.|\n)*-->//g;
    return $theURL;
}

sub URLEncode {
    my $theURL = $_[0];
   $theURL =~ s/([\W])/"%" . uc(sprintf("%2.2x",ord($1)))/eg;
   return $theURL;
}

sub URLEncodeORG {
    my $theURL = $_[0];
    my $MetaChars = quotemeta( ';,/?\|=+)(*&^%$#@!~`:');
   $theURL =~ s/([$MetaChars\"\'\x80-\xFF])/"%" . uc(sprintf("%2.2x",         ord($1)))/eg;
   $theURL =~ s/ /\+/g;
   return $theURL;
}


# eof
