#!/perl -w
# trimdf01.pl
# AIM: To input the output of a directory command,
# and output a TRIMMED version ...
# a) remove blank lines ...
# b) remove leading spaces off lines
# c) remove lines -
#	i.  Volume in drive C has no label.
#	ii. Volume Serial Number is D833-AEFA
#	iii.                1 File(s)          7,117 bytes
#	iv.      Total Files Listed:
#	v.             163 File(s)      2,271,636 bytes
#	vi.               0 Dir(s)  176,651,669,504 bytes free

use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';

my $def_in = 'C:\FG\FG0910-7\temposg.txt';
my $in_file = $def_in;
my @lines = ();
my $line = '';
my $lncnt = 0;
my $i = 0;
my @discards = ();
my @newlist = ();

open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
$in_file = pop @ARGV if (@ARGV);
prt( "ERROR: Unable to find [$in_file] ... $! ...\nCheck name, location ...\n" ) if ( !( -f $in_file ) );

sub trim_leading($) {
	my ($ln) = shift;
	while ($ln =~ /^\s/) {
		$ln = substr($ln,1);
	}
	return $ln;
}

open INF, "<$in_file" or mydir( "ERROR: Unable to OPEN [$in_file] ... $! ...\nCheck name, location ...\n" );
@lines = <INF>; # slurp it all in ...
close INF;
$lncnt = scalar @lines;
prt( "Loaded $lncnt lines from [$in_file] ...\n" );
for ($i = 0; $i < $lncnt; $i++) {
	$line = trim_leading($lines[$i]);
	if ($line =~ /^Volume in drive/i) {
		push(@discards, $line);
	} elsif ($line =~ /^Volume Serial Number is/i) {
		push(@discards, $line);
	} elsif ($line =~ /\d+\s+File\(s\)\s+[\d,]+\s+bytes/i) {
		push(@discards, $line);
	} elsif ($line =~ /^Total Files Listed:/i) {
		push(@discards, $line);
	} elsif ($line =~ /\d+\s+Dir\(s\)\s+[\d,]+\s+bytes/i) {
		#	vi. 0 Dir(s)  176,651,669,504 bytes free
		push(@discards, $line);
	} else {
		push(@newlist, $line);
	}
}

prt( "Discard ". scalar @discards ." lines, leaving ". scalar @newlist ." lines for output ...\n" );

foreach $line (@newlist) {
	prt($line);
}
prt( "Done ". scalar @newlist ." lines out ...\n" );
close_log($outfile,1);
exit(0);

# eof
