#!/perl -w
# NAME: xmlsimple.pl
# AIM: Explore XML simple interface ...
use strict;
use warnings;
use XML::Simple;
use Data::Dumper;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
# prt( "$0 ... Hello, World ...\n" );

my $in_xml_file = 'C:\Documents and Settings\Geoff McLane\Desktop\Maroc - June, 2008.flash\imagelist.xml';
my $maxtxt = 1500;
my $doboth = 0;
my $xml = new XML::Simple;

# view XML data
prt( "Loading [$in_xml_file] ...\n" );
my $data1 = $xml->XMLin($in_xml_file);
prt( "Output of [$in_xml_file]...\nUsing (ForceArray => 1) ...\n" );
my $txt1 = Dumper($data1);
my $stxt1 = substr($txt1,0,$maxtxt);
prt( "$stxt1\n");

my $xml2 = new XML::Simple (ForceArray => 1);
my $data2 = $xml2->XMLin($in_xml_file);
my $txt2 = Dumper($data2);
prt( "Output of [$in_xml_file]...\nNOT using (ForceArray => 1) ...\n" );
my $stxt2 = substr($txt1,0,$maxtxt);
if ($stxt1 eq $stxt2) {
	prt( "SAME, with forced array ...\n" );
} else {
	prt( "$stxt2\n" )
}

# access XML data

close_log($outfile,1);
exit(0);

# eof
