#!/perl -w
# NAME: xmlwrapper.pl
# AIM: Test the XML::Paser::Wrapper interface ...
use strict;
use warnings;
use XML::Parser::Wrapper;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ... exploring XML::Parser::Wrapper\n" );
prt( "from: http://search.cpan.org/~dowens/XML-Parser-Wrapper-0.08/lib/XML/Parser/Wrapper.pm\n" );

my $xcnt = 0;
my ($tag, $element, $type);
# without line endings ...
##my $xml = qq{<foo><head id="a">Hello World!</head><head2><test_tag id="b"/></head2></foo>};
# with line endings
my $xml = <<EOF;
<foo>
 <head id="a">Hello World!</head>
 <head2>
  <test_tag id="b"/>
 </head2>
</foo>
EOF

my $root = XML::Parser::Wrapper->new($xml);

my $root_tag_name = $root->name;
my $roots_children = $root->elements;
prt( "root tag name = $root_tag_name ...\n" );
foreach $element (@$roots_children) {
    $xcnt++;
    if ($element->is_text()) {
        $tag = trim_all($element->text());
        $type = 'TEXT';
    } else {
        $tag = $element->name();
        $type = 'element name';
    }
    if (length($tag)) {
        prt( "$xcnt: $type = $tag\n" );
    } else {
        prt( "$xcnt: $type = <all spacey>\n" );
    }
    if ($element->name eq 'head') {
        my $id = $element->attr('id');
        my $hello_world_text = $element->text; # eq "Hello World!"
        prt( " head element has id attr = [$id], and text = [".trim_all($hello_world_text)."] ...\n" );
    }
}

##my $head_element = $root->element('head2');
my $head_elements = $root->elements('head2');
##my $test = $root->element('head2')->element('test_tag');

my $new_element = $root->add_child('test4', { attr1 => 'val1' });

my $kid = $root->update_kid('root_child', { attr2 => 'stuff2' }, 'blah');
$kid->update_node({ new_attr => 'new_stuff' });

$new_element->add_child('child_of_test4', { myattr => 'stuff' }, 'bleh');

my $new_xml = $root->to_xml;
write2file(xml_add_lines($new_xml), "tempnew.xml");
prt( "Modified XML written to tempnew.xml ...\n" );

$xcnt = 0;
prt( "List of modified element names ...\n" );
$roots_children = $root->elements;
foreach $element (@$roots_children) {
    $xcnt++;
    $tag = $element->name();
    if ((defined $tag)&&(length($tag))) {
        prt( "$xcnt: element name = ".$element->name."\n" );
    }
}


close_log($outfile,0);
exit(0);

######################################
### subs only
sub xml_add_lines {
    my ($txt) = shift;
    my $ntxt = '';
    my ($ch, $i, $len, $pch, $i2, $nch);
    $len = length($txt);
    $pch = '';
    for ($i = 0; $i < $len; $i++) {
        $i2 = $i + 1;
        $ch = substr($txt,$i,1);
        $nch = (($i2 < $len) ? substr($txt,$i2,1) : '');
        if (($ch eq '<')&&($pch ne "\n")&&($nch ne '/')) {
            $ntxt .= "\n";
        } elsif (($ch eq '>')&&($nch eq '<')) {
            $ntxt .= $ch;
            $ch = "\n";
        }
        $pch = $ch if (($ch ne ' ')&&($ch ne "\t"));
        $ntxt .= $ch;
    }
    $ntxt .= "\n" if ($ch ne "\n");
    return $ntxt;
}

# eof - xmlwrapper.pl
