#!perl -w
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $AM_CONDITIONAL_PATTERN = "AM_CONDITIONAL\\((\\w+)";
my $AM_INIT_AUTOMAKE = "AM_INIT_AUTOMAKE\\(([^,]+),[ \t]*([^)]+)";
# AC_INIT (package, version, [bug-report], [tarname]) 
# Set the name of the package and its version
my $AC_INIT = "AC_INIT\\((.+)\\)";
my $AC_DEF = "AC_DEFINE\\((.+)";
my $AC_DEFU = "AC_DEFINE_UNQUOTED\\((.+)";
my $AC_DEFINE = "AC_DEFINE\\((.+)\\)";
my $AC_DEFINE_UNQ = "AC_DEFINE_UNQUOTED\\((.+)\\)";

# debug
my $dbg_ac01 = 0;
my $dbg_ac02 = 0;   # show EACH line prt( "$cline
my $dbg_ac03 = 0;
my $dbg_ac04 = 0;
my $dbg_ac05 = 0;
my $dbg_ac06 = 0;
my $dbg_ac07 = 0;
my $dbg_ac08 = 0;
my $dbg_ac09 = 0;
my $dbg_ac10 = 0;
my $dbg_ac11 = 0;

my $in_file = 'C:\FG\PREOSG\SimGear\source\configure.ac';

my %h = scan_one_configure_file($in_file);

show_hash( \%h );

close_log($outfile,1);
exit(0);
###############################################################

sub show_hash {
    my ($hr) = shift;
    my ($v, $itm, $cnt, $v2);
    prt( "\nDisplay of HASH items ...\n" );
    foreach my $k (keys %{$hr}) {
        $v = $$hr{$k};
        if ($k =~ /^A_/) {
            $cnt = scalar @{$v};
            prt("KEY: $k ARRAY $cnt items ...\n");
            $cnt = 0;
            foreach $itm (@{$v}) {
                $cnt++;
                prt( " $cnt: $itm\n" );
            }
        } elsif ($k =~ /^H_/) {
            $cnt = scalar keys( %{$v} );
            prt("KEY: $k HASH $cnt items ...\n");
            $cnt = 0;
            foreach $itm (keys %{$v}) {
                $cnt++;
                $v2 = $$v{$itm};
                prt( " $cnt: $itm=$v2\n" );
            }
        } else {
            prt("KEY: $k VAL: $v\n");
        }
    }
}

sub ac_trim_all2 {
	my ($txt) = shift;
	$txt = trim_all($txt);
	if ($txt =~ /^\[.+\]$/) {
		$txt = substr($txt,1,length($txt)-2);
	}
	$txt = trim_all($txt);
	return $txt;
}


## my %conf_ac_macs = ();
sub ac_do_macro_sub2 {
	my ($item,$rcacm) = shift;
	###prt( "Checking substitution for [$item] ...\n" ) if ($dbg27);
	###if (defined $conf_ac_macs{$item}) {	# if it is IN the MACROS
	###	my $ritem = $conf_ac_macs{$item};	# extract the substitute value
	if (defined $$rcacm{$item}) {	# if it is IN the MACROS
		my $ritem = $$rcacm{$item};	# extract the substitute value
		###prt( "Found: returning [$ritem] ...\n" ) if ($dbg27);
		return $ritem;
	}
	return $item;
}


sub ac_do_macro_sub {
	my ($item, $rcacm) = @_;
	if ($item =~ /^\$/) {
		my $msub = substr($item,1);	# remove leading '$'
		my $ritem = ac_do_macro_sub2($msub, $rcacm);
		if ($ritem ne $msub) {
			return $ritem;
		}
	}
	return $item;
}

sub ac_add_2_ac_macros {
	my ( $key, $val, $rcacm ) = @_;
	$$rcacm{$key} = $val;
}

#ac_am_conf_line_error($filename, 
# $., "automake requires 'AM_CONFIG_HEADER', not 'AC_CONFIG_HEADER'") if $1 eq 'C';
sub ac_am_conf_line_error {
    my ($fname,$lnum,$msg) = @_;
    prt("ERROR: file $fname: line $lnum: $msg\n");
    mydie("Aborting scan ...\n");
}

sub scan_one_configure_file {
    my ($filename) = shift;
    my %hash = ();
    my ($sfilnm,$root_dir) = fileparse($filename);
    my @mk_inp_list = ();
    my %make_list = ();
    my @other_input_files = ();
    my $config_header_line = '';
    my @config_fullnames = ();
    my @config_names = ();
    my @config_headers = ();
    my %cfg_defines = ();
    my %configure_cond = ();
    my ($err_msg);
	if (!open(CONFIGURE, $filename)) {
		$err_msg = "WARNING: can't open '$filename': $!\n";
		prtw($err_msg);
		return;
	}
    prt( "Reading $filename\n" ) if $dbg_ac01;
    my %conf_ac_macs = ();
    my $in_ac_output = 0;
    my $ac_output_line = '';
    my $ff = '';
	my $cline = '';
	my $rawline = '';
	my %var_hash = ();
	my ($key, $nval, $orgkey, $orgnval, @varr, $vlen, $i, $ky, $nline);
    my $lnnum = 0;
    my $ac_prog = '';
    my $ac_vers = '';

    while (<CONFIGURE>) {
		$cline = $_;	# get current line
		chomp $cline;
		$rawline = trim_all($cline);
        $lnnum++;
		# Remove comments from current line.
		s/\bdnl\b.*$//;
		s/\#.*$//;
		$cline =~ s/\bdnl\b.*$//;
		$cline =~ s/\#.*$//;
		next if (length($cline) == 0);

		prt( "ln $lnnum: $cline\n" ) if ($dbg_ac02);

		if ($cline =~ /^(\w+)="(\d+)"$/) {
			prt( "Num Variable $1=$2\n" );
			$var_hash{$1} = $2;
		###} elsif ($cline =~ /^(\w+)="(.+)"$/) {
		} elsif ($cline =~ /^(\w+)=(.+)$/) {
			$key  = $1;
			$nval = $2;
			$orgkey = $key;
			$orgnval = $nval;
			$nval = substr($nval,1,length($nval)-2) if ($nval =~ /^".*"$/);
			prt( "Variable $key=$nval\n" ) if ($dbg_ac03);
			if (index($nval,'.') != -1) {
				@varr = split(/\./,$nval);
				$nval = '';
				$vlen = scalar @varr;
				prt( "Split to $vlen components ...\n" ) if ($dbg_ac04);
				for ($i = 0; $i < $vlen; $i++) {
					$ky = trim_line($varr[$i]);
					prt( "Conponent $ky\n" ) if ($dbg_ac04);
					if (substr($ky,0,1) eq '$') {
						$ky = substr($ky,1);
						if (defined $var_hash{$ky}) {
							$nval .= '.' if (length($nval));
							$nval .= $var_hash{$ky};
						} else {
							$nval .= '.' if (length($nval));
							$nval .= $ky;
						}
					} else {
						$nval .= '.' if (length($nval));
						$nval .= $ky;
					}
				}
			}
			prt( "Substitute $key=$nval\n" ) if ((($orgkey ne $key)||($orgnval ne $nval)) && $dbg_ac05);
			$var_hash{$key} = $nval;
			$conf_ac_macs{$key} = $nval;
		} elsif ($cline =~ /^\s+(\w+)=(.+)$/) {
			### prt( "Line [$cline] NOT USED ...\n" ); # there are lots of them ...
		}
		# Skip macro definitions.  Otherwise we might be confused into
		# thinking that a macro that was only defined was actually
		# used.
		next if /AC_DEFUN/;

		if ((/$AC_DEF/) && !(/$AC_DEFINE/)) {
			# indicates should add next line, until complete
			$cline = $_;	# get current line
			chomp $cline;
			prt( "$. Should JOIN lines? - [$cline]\n" ) if ($dbg_ac06);
			$_ = <CONFIGURE>;
		    if ($_) {
        		$nline = $_;	# get current line
				$ky = $cline . ' ' . $_;
                $lnnum++;
                chomp $nline;
        		prt( "ln $lnnum: $nline\n" ) if ($dbg_ac02);
				$_ = $ky;
				chomp $ky;
				prt( "$. JOINED - [$ky]\n" ) if ($dbg_ac06);
			}
		} elsif ((/$AC_DEFU/) && !(/$AC_DEFINE_UNQ/)) {
			# indicates should add next line, until complete
			$cline = $_;	# get current line
			chomp $cline;
			prt( "$. Should JOIN lines? - [$cline]\n" ) if ($dbg_ac06);
			$_ = <CONFIGURE>;
		    if ($_) {
        		$nline = $_;	# get current line
				$ky = $cline . ' ' . $_;
                chomp $nline;
                $lnnum++;
        		prt( "ln $lnnum: $nline\n" ) if ($dbg_ac02);
				$_ = $ky;
				chomp $ky;
				prt( "$. JOINED - [$ky]\n" ) if ($dbg_ac06);
			}
		}
		if (/$AC_INIT/) {
			prt( "$. Got AC_INIT = [$1]\n" ) if ($dbg_ac07);
			@varr = split(',', $1);
			$vlen = scalar @varr;
			for ($i = 0; $i < $vlen; $i++) {
				$nval = trim_all($varr[$i]);
				if ($i == 0) {
					$nval =~ s/\s/_/g;
					ac_add_2_ac_macros('PACKAGE_NAME', $nval, \%conf_ac_macs);
					$ac_prog = $nval;

				} elsif ($i == 1) {
					ac_add_2_ac_macros('PACKAGE_VERSION', $nval, \%conf_ac_macs);
					ac_add_2_ac_macros('PACKAGE_STRING', $conf_ac_macs{'PACKAGE_NAME'} .' ' .$nval, \%conf_ac_macs );
					$ac_vers = $nval;
				} elsif ($i == 2) {
					ac_add_2_ac_macros('PACKAGE_BUGREPORT', $nval, \%conf_ac_macs);
				} elsif ($i == 3) {
					ac_add_2_ac_macros('PACKAGE_TARNAME', $nval, \%conf_ac_macs);
				} else {
					$err_msg = "WARNING: $i Split of AC_INIT = $nval\n";
					prtw($err_msg);
				}
			}
			next;
		} elsif (/$AC_DEFINE/) {
			prt( "$. Got AC_DEFINE = [$1]\n" ) if ($dbg_ac07);
			@varr = split(',', $1);
			$vlen = scalar @varr;
			if ($vlen >= 2) {
				$ky = ac_trim_all2($varr[0]);
				$nval = ac_trim_all2($varr[1]);
				ac_add_2_ac_macros( $ky, $nval, \%conf_ac_macs );
			}
			next;
		} elsif (/$AC_DEFINE_UNQ/) {
			prt( "$. Got AC_DEFINE_UNQUOTED = [$1]\n" ) if ($dbg_ac07);
			@varr = split(',', $1);
			$vlen = scalar @varr;
			if ($vlen >= 2) {
				$ky = ac_trim_all2($varr[0]);
				$nval = ac_trim_all2($varr[1]);
				ac_add_2_ac_macros( $ky, $nval, \%conf_ac_macs );
			}
			next;
		}

		# Follow includes.  This is a weirdness commonly in use at
		# Cygnus and hopefully nowhere else.
		if (/sinclude\((.*)\)/ && -f ($root_dir . $1))
		{
			$ff = $root_dir . $1;
			scan_one_configure_file ($ff);
		}

		if (! $in_ac_output && ( s/AC_OUTPUT\s*\(\[?// || s/AC_CONFIG_FILES\s*\(\[?// ) ) {
			$in_ac_output = 1;
			$ac_output_line = $.;	# get LINE number
			prt( "Got ac_output_line = line $ac_output_line ... [$rawline]\n" ) if ($dbg_ac08);
		}

		if ($in_ac_output)
		{
			my $closing = 0;
			if (s/[\]\),].*$//)
			{
				$in_ac_output = 0;
				$closing = 1;
				prt( "ac_out: $rawline- CLOSING\n" ) if ($dbg_ac08);
			} else {
				prt( "ac_out: $rawline\n" ) if ($dbg_ac08);
			}

			# Look at potential Makefile.am's
			foreach (split)
			{
				# Must skip empty string for Perl 4.
				next if $_ eq "\\" || $_ eq '';

				my ($local,$input,@rest) = split(/:/);
				if (! $input) {
					$input = $local;
				} else {
					$input =~ s/\.in$//;
				}
				$ff = $root_dir . $input . '.am';
				if (-f $ff) {
					prt( "Adding $input [$ff] to mk_inp_list ...\n" ) if ($dbg_ac01 || $dbg_ac09);
					push(@mk_inp_list, $input);
					$make_list{$input} = join(':', ($local,@rest));
				} else {
					prt( "Adding $input [$ff] to other_input_files ...\n" ) if ($dbg_ac01 || $dbg_ac10);
					# We have a file that automake should cause to be
					# rebuilt, but shouldn't generate itself.
					push (@other_input_files, $_);
				}
			}
		}

		# Handle configuration headers.  A config header of `[$1]'
		# means we are actually scanning AM_CONFIG_HEADER from
		# aclocal.m4.
		if (/A([CM])_CONFIG_HEADER\s*\((.*)\)/ && $2 ne '[$1]')
		{
			ac_am_conf_line_error($filename, 
                $., "automake requires 'AM_CONFIG_HEADER', not 'AC_CONFIG_HEADER'") if $1 eq 'C';

			$config_header_line = $.;
			my ($one_hdr);
			foreach $one_hdr (split (' ', $2))
			{
				push (@config_fullnames, $one_hdr);
				if ($one_hdr =~ /^([^:]+):(.+)$/)
				{
					push (@config_names, $1);
					push (@config_headers, $2);
				}
				else
				{
					push (@config_names, $one_hdr);
					push (@config_headers, $one_hdr . '.in');
				}
			}
		}

		if (/$AM_CONDITIONAL_PATTERN/o)
		{
			if ( defined $cfg_defines{$1} ) {
				# has been DEFINED in am2dsp?.cfg file
				prt( "Storing configure_cond key $1 ... value=2\n" ) if ($dbg_ac11);
				$configure_cond{$1} = 2;
			} else {
				prt( "Storing configure_cond key $1 ... value=1\n" ) if ($dbg_ac11);
				$configure_cond{$1} = 1;
			}
		}

		if (/$AM_INIT_AUTOMAKE/o)
		{
			$ac_prog = $1;
			$ac_vers = $2;
			$ac_prog = ac_do_macro_sub($ac_prog, \%conf_ac_macs);
			$ac_vers = ac_do_macro_sub($ac_vers, \%conf_ac_macs);
            if (defined $hash{'-NEW_PROJECT_NAME-'}) {
                if ($hash{'-NEW_PROJECT_NAME-'} ne $ac_prog) {
                    prtw( "CHANGED DSP package from ".$hash{'-NEW_PROJECT_NAME-'}." to $ac_prog, DSP version = $ac_vers ...\n" );
                }
            } else {
                prt( "Set DSP package = $ac_prog, DSP version = $ac_vers ...\n" );
            }
		}
    }

    close(CONFIGURE);

    $hash{'-NEW_PROJECT_NAME-'} = $ac_prog;
    $hash{'H_CONF_AC_MACS'} = { %conf_ac_macs };
    $hash{'A_MAKE_INPUT_LIST'} = [ @mk_inp_list ];
    #$hash{'A_CONFIG_NAMES'} = [ @config_names ];
    #$hash{'A_CONFIG_HEADERS'} = [ @config_headers ];
    #$hash{'A_CONFIG_NAMES_FULL'} = [ @config_fullnames ];
    #$hash{'A_OTHER_INPUT_FILES'} = [ @other_input_files ];
    #$hash{'H_VAR_HASH'} = { %var_hash };
    return %hash;
}

sub set_ac_scan_debug_on {
    $dbg_ac01 = 1;
    $dbg_ac02 = 1;   # show EACH line prt( "$cline
    $dbg_ac03 = 1;
    $dbg_ac04 = 1;
    $dbg_ac05 = 1;
    $dbg_ac06 = 1;
    $dbg_ac07 = 1;
    $dbg_ac08 = 1;
    $dbg_ac09 = 1;
    $dbg_ac10 = 1;
    $dbg_ac11 = 1;
}

# eof - acscan.pl
