#!/perl -w
# NAME: amscan.pl
# AIM: Given a single Makefile.am, try to SCAN all in the set
# 11/11/2008 - geoff mclane - http://geoffair.net/mperl
# ####################################################
use strict;
use warnings;
use File::Basename;
#require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'C:\FG\27\Atlas-04\Makefile.am';
##my $in_file = 'C:\FG\PREOSG\FlightGear\source\Makefile.am';
##my $in_file = 'C:\FG\FGRUN\gettext\Makefile.am';

# features
my $ignore_EXTRA_DIST = 1;  # no SHOW of 'EXTRA_DIST' key

# CONSTANTS
my $IF_PATTERN = "^if[ \t]+\([A-Za-z][A-Za-z0-9_]*\)[ \t]*\(#.*\)?\$";
my $NIF_PATTERN = "^if[ \t]+!(.+)\$";
my $ELSE_PATTERN = "^else[ \t]*\(#.*\)?\$";
my $ENDIF_PATTERN = "^endif[ \t]*\(#.*\)?\$";
my $PATH_PATTERN='(\\w|/|\\.)+';
# This will pass through anything not of the prescribed form.
my $INCLUDE_PATTERN = "^include[ \t]+((\\\$\\\(top_srcdir\\\)/${PATH_PATTERN})|(\\\$\\\(srcdir\\\)/${PATH_PATTERN})|([^/\\\$]${PATH_PATTERN}))[ \t]*(#.*)?\$";

my %global_hash = (
    'top_srcdir' => "",
    'base_LIBS'  => "",
    'opengl_LIBS' => "",
    'network_LIBS' => "",
    'joystick_LIBS' => "",
    'top_builddir' => "",
    'thread_LIBS' => "",
    'pkgdatadir' => "",
    'openal_LIBS' => "",
    'datadir' => "",
    'srcdir' => "",
    'docdir' => "",
    'localedir' => "",
    'RELOCATABLE_LDFLAGS' => "",
    'LIBTOOL' => "lib",
    'libdir' => "",
    'SHELL' => "",
    'BISON_LOCALEDIR' => "",
    'AM_LIBTOOLFLAGS' => "",
    'bindir' => "",
    'AM_CFLAGS' => "",
    'OPENMP_CFLAGS' => "",
    'DESTDIR' => "",
    'gl_LIBOBJS' => "glu32.lib"
);

my %def_condits = (
    "USE_GLUT" => "TRUE",
    "ENABLE_JPEG_SERVER" => "FALSE",
    "ENABLE_SP_FDM" => "TRUE"
);

# DEBUG
my $dbg_s01 = 0;    # show prt( "$i2: $fline
my $dbg_s02 = 0;    # show prt( "Listing $acnt keys in hash ...
my $dbg_s03 = 0;    # show prt( "No LIBRARY keys ...
my $dbg_s04 = 0;    # show prt( "LIBRARY [$ky] has SOURCES [$val]
my $dbg_s05 = 0;    # show prt( "$am ". ((-f $am) ? "ok" : "no find!")
my $dbg_s06 = 0;    # show prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $fil
my $dbg_s07 = 0;
my $dbg_s08 = 0;    # show prt( "Processing $cnt lines from $fil ...
my $dbg_s09 = 1;    # show prt( "Got $cnt subdirectories [$slist] ...
my $dbg_s10 = 1;    # show prtw("WARNING:1: No substitution for [$ms] found in hash ...

my @warnings = ();
my @subsnotfound = ();

my %programs = ();
my %libraries = ();

my ($root_file, $root_folder) = fileparse($in_file);
prt( "$0 ... Hello, scanning $root_file, in $root_folder ...\n" );

set_debug_all();

process_primary( $in_file );

show_warnings();

close_log($outfile,1);

exit(0);

#####################################################
######## SUBS ONLY ###########
sub sub_common_folder {
    my ($fil,$root) = @_;
    my $lfil = lc(path_u2d($fil));
    my $lrot = lc(path_u2d($root));
    my $len1 = length($lfil);
    my $len2 = length($lrot);
    my ($i);
    for ($i = 0; (($i < $len1)&&($i < $len2)); $i++) {
        if (substr($lfil,$i,1) ne substr($lrot,$i,1)) {
            last;
        }
    }
    return substr($fil,$i);
}

sub sub_root_folder {
    my ($fil) = shift;
    return sub_common_folder($fil,$root_folder);
}

sub get_value_from_hash {
    my ( $rval2, $ms, $rhash ) = @_;
    my ($ky2, @vals, $fnd, $val, @keys, $i);
    my ($itm, $cond);
    $fnd = 0;
    foreach $ky2 (keys %{$rhash}) {
        if ($ky2 =~ /^$ms\s+/) {
            $val = $$rhash{$ky2};
            if (!is_in_array($val, @vals)) {
                push(@vals,$val);
                push(@keys,$ky2);
                $fnd++;
            }
        }
    }
    if ($fnd == 1) {
        $$rval2 = $vals[0]; # just ONE to RETURN
    } elsif ($fnd > 1) {
        my $msg = "WARNING: For sub of [$ms], have [$fnd] to CHOOSE FROM!\n";
        for ($i = 0; $i < $fnd; $i++) {
            $val = $vals[$i];
            $ky2 = $keys[$i];
            $msg .= " or \n" if ($i > 0);
            $msg .= "[$ky2={".$val.'}]';
            if ($ky2 =~ /^$ms\s+if\s+(\w+)\@_(TRUE|FALSE)\@/) {
                $itm = $1;
                $cond = $2;
                $msg .= " [$itm]=[$cond]";
                if (defined $def_condits{$itm}) {
                    if ($def_condits{$itm} eq $cond) {
                        $$rval2 = $val; # RETURN selected
                        ### prtw("CHECK: Returning [$val] for [$ms], due [$itm]=[$cond] in def_condits!\n" );
                        return $fnd;
                    }
                }
            }
        }
        $msg .= " Defaulting to FIRST! CHECK ME!!";
        prtw("$msg\n");
        $$rval2 = $vals[0]; # just RETURN first
    }
    return $fnd;
}


sub extract_from_hash {
    my ($fil, $rhash) = @_;
    my ($a_nm, $a_dir) = fileparse($fil);
    my ($key, $val, @av);
    my (@skeys, @progs, @progkeys, @libs, @libkeys, @srcs, @srckeys);
    my ($ky, $vky, $ms, $val2, $ky2, $orgval, $fnd, $acnt);
    my ($src, $ff, $scnt, $i);
    #my %programs = ();
    #my %libraries = ();
    my %extract = ();
    # really interested in 
    # noinst_LIBRARIES = libAirports.a
    # noinst_PROGRAMS = calc_loc
    # bin_PROGRAMS = fgfs something
    # libAirports_a_SOURCES = apt_loader.cxx apt_loader.hxx ...
    @skeys = sort keys(%{$rhash});
    $acnt = scalar @skeys;
    prt( "extract_from_hash: Listing $acnt keys in hash passed...\n" ) if ($dbg_s02);
    # collect PROGRAM keys
    @progs = ();
    @progkeys = ();
    @libs = ();
    @libkeys = ();
    @srcs = ();
    @srckeys = ();

    # try to do substitutions
    foreach $key (@skeys) {
        $val = $$rhash{$key};
        $orgval = $val;
        if ($val =~ /\$\((\w+)\)/) {
            $ms = $1;
            $val2 = ''; # no sub yet
            $fnd = 0;   # none found
            if (defined $global_hash{$ms}) {
                $val2 = $global_hash{$ms};  # found in global
                $fnd = 1;
            } elsif (defined $$rhash{$ms}) {
                $val2 = $$rhash{$ms}; # found in local
                $fnd = 2;
            } else {
                # hmmm, maybe like 'GFX_CODE if @USE_GLUT_FALSE@ = fg_os_osgviewer.cxx $(GFX_COMMON)'
                $fnd = get_value_from_hash(\$val2, $ms, $rhash ); 
            }
            if ($fnd > 0) {
                $val =~ s/\$\($ms\)/$val2/g;
            } else {
                if ( ! is_in_array($ms,@subsnotfound) ) {
                    prtw("WARNING:1: No substitution for [$ms] found in hash ...\n" ) if ($dbg_s10);
                    push(@subsnotfound,$ms);
                }
            }
        }

        if ($val ne $orgval) {
            $$rhash{$key} = $val;
        }
    }

    # try to do substitutions, twice
    foreach $key (@skeys) {
        $val = $$rhash{$key};
        $orgval = $val;
        if ($val =~ /\$\((\w+)\)/) {
            $ms = $1;
            $val2 = '';
            $fnd = 0;
            if (defined $global_hash{$ms}) {
                $val2 = $global_hash{$ms};
                $fnd = 1;
            } elsif (defined $$rhash{$ms}) {
                $val2 = $$rhash{$ms};
                $fnd = 2;
            } else {
                # hmmm, maybe like 'GFX_CODE if @USE_GLUT_FALSE@ = fg_os_osgviewer.cxx $(GFX_COMMON)'
                foreach $ky2 (keys %{$rhash}) {
                    if ($ky2 =~ /^$ms/) {
                        $val2 = $$rhash{$ky2};
                        $fnd = 3;
                        last;
                    }
                }
            }
            if ($fnd > 0) {
                $val =~ s/\$\($ms\)/$val2/g;
            } else {
                if ( ! is_in_array($ms,@subsnotfound) ) {
                    prtw("WARNING:2: No substitution for [$ms] found in hash ...\n" ) if ($dbg_s10);
                    push(@subsnotfound,$ms);
                }
            }
        }
        if ($val ne $orgval) {
            $$rhash{$key} = $val;
        }
    }


    foreach $key (@skeys) {
        $val = $$rhash{$key};
        if ($key =~ /_PROGRAMS/) {
            push(@progkeys,$key);
            push(@progs,$val);
        } elsif ($key =~ /_LIBRARIES/) {
            push(@libkeys,$key);
            push(@libs,$val);
        } elsif ($key =~ /_SOURCES/) {
            push(@srckeys,$key);
            ###push(@srcs,$val);
        }
    }

    foreach $key (@skeys) {
        $val = $$rhash{$key};
        next if (($key eq 'EXTRA_DIST')&&($ignore_EXTRA_DIST));
        prt( "$key = $val\n" ) if ($dbg_s02);
    }

    if (@libkeys) {
        foreach $key (@libkeys) {
            $val = $$rhash{$key};
            @av = split(/\s/,$val);
            foreach $ky (@av) {
                $ky =~ s/-/_/g;
                $ky =~ s/\./_/g;
                $vky = $ky.'_SOURCES';
                if (defined $$rhash{$vky}) {
                    $val = $$rhash{$vky};
                    @srcs = split(/\s/, $val);
                    $scnt = scalar @srcs;
                    for ($i = 0; $i < $scnt; $i++) {
                        $src = $srcs[$i];
                        #$ff = sub_fg_dir($a_dir.$src);
                        #$srcs[$i] = $ff;
                    }
                    $val = join(' ',@srcs);
                    if (defined $libraries{$ky}) {
                        prtw( "WARNING: libraries[$ky] has value [".$libraries{$ky}."] ADDING $val!\n" );
                        $libraries{$ky} .= ' @AND@ '.$val;
                    } else {
                        $libraries{$ky} = $val;
                    }
                    prt( "LIBRARY [$ky] has SOURCES [$val]\n" ) if ($dbg_s04);
                } else {
                    prtw( "WARNING: No sources for LIBRARY [$ky]\n" );
                }
            }
        }
    } else {
        prt( "No LIBRARY keys ...\n" ) if ($dbg_s03);
    }

    if (@progkeys) {
        foreach $key (@progkeys) {
            $val = $$rhash{$key};
            @av = split(/\s/,$val);
            foreach $ky (@av) {
                $ky =~ s/-/_/g;
                $ky =~ s/\./_/g;
                $vky = $ky.'_SOURCES';
                if (defined $$rhash{$vky}) {
                    $val = $$rhash{$vky};
                    @srcs = split(/\s/, $val);
                    $scnt = scalar @srcs;
                    for ($i = 0; $i < $scnt; $i++) {
                        $src = $srcs[$i];
                        #$ff = sub_fg_dir($a_dir.$src);
                        #$srcs[$i] = $ff;
                    }
                    $val = join(' ',@srcs);
                    if (defined $programs{$ky}) {
                        prtw( "WARNING: programs[$ky] has value [".$programs{$ky}."] ADDING $val!\n" );
                        $programs{$ky} .= ' @AND@ '.$val;
                    } else {
                        $programs{$ky} = $val;
                    }
                    prt( "PROGRAM [$ky] has SOURCES [$val]\n" ) if ($dbg_s04);
                } else {
                    prtw( "WARNING: No sources for PROGRAM [$ky]\n" );
                }
            }
        }
    } else {
        prt( "No PROGRAM keys ...\n" ) if ($dbg_s03);
    }
    $extract{'PROGRAMS'}  = { %programs };
    $extract{'LIBRARIES'} = { %libraries };
    prt( "extract_from_hash: Done $acnt from [".sub_root_folder($fil)."]...\n" ) if ($dbg_s02);

    return %extract;
}


sub process_AM_file {
    my ($fil) = shift;
    my ($a_nm, $a_dir) = fileparse($fil);
    my $sfil = sub_root_folder($fil);
    my %hash = ();
    my ($ff);
    my $dooldext = 0;
    if (open INF, "<$fil") {
        my @lns = <INF>;
        close INF;
        my $cnt = scalar @lns;
        prt("\n") if ($dbg_s07 && $dbg_s08);
        prt( "Processing $cnt lines from $fil ...\n" ) if ($dbg_s08);
        my ($i, $line, $fline, $i2, @av, $key, $val, $j, $acnt, $ifcond);
        my @cond_stack = ();
        $fline = '';
        for ($i = 0; $i < $cnt; $i++) {
            $line = $lns[$i];
            $i2 = $i + 1;
            chomp $line;
            next if ($line =~ /^#/);
            $fline .= trim_all($line);
            next if (length($fline) == 0);
            if ($fline =~ /\\$/) {
                $fline =~ s/\\$/ /;
            } else {
                # deal with the line
                $fline = trim_all($fline);
                if ($fline =~ /$IF_PATTERN/o) {
                    # open an IF
                    $ifcond = $1;
                    push(@cond_stack, $ifcond . "\@_TRUE\@");
                    prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
                } elsif ($fline =~ /$NIF_PATTERN/o) {
                    # open an IF !(SOMETHING)
                    $ifcond = $1;
                    push(@cond_stack, $ifcond . "\@_FALSE\@");
                    prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
                } elsif ($fline =~ /$ELSE_PATTERN/o) {
                    # switch to else
                    if (! @cond_stack) {
                        prtw( "ERROR: else without if! ($sfil:$i2)\n" );
                    } elsif ($cond_stack[$#cond_stack] =~ /\@_FALSE\@$/) {
                        prtw( "ERROR: else after an else! ($sfil:$i2)\n" );
                    } else {
                        if ($cond_stack[$#cond_stack] =~ /\@_TRUE\@$/) {
                            $cond_stack[$#cond_stack] =~ s/\@_TRUE\@$/\@_FALSE\@/;
                        } else {
                            $cond_stack[$#cond_stack] =~ s/\@_FALSE\@$/\@_TRUE\@/;
                        }
                        prt( "Else switched cond_stack to [".$cond_stack[$#cond_stack]."] $sfil\n" ) if ($dbg_s06);
                    }
                } elsif ($fline =~ /$ENDIF_PATTERN/o) {
                    # reached endif
                    if (! @cond_stack) {
                        prtw( "ERROR: endif without if! ($sfil:$i2)\n" );
                    } else {
                        $ifcond = pop (@cond_stack);
                        prt( "Closed cond_stack with [$ifcond] $sfil\n" ) if ($dbg_s06);
                    }
                } elsif ($fline =~ /$INCLUDE_PATTERN/o) {
                    $key = $1;
                    $ff = $a_dir.$key;
                    my $sff = sub_root_folder($ff);
                    if (-f $ff) {
                        my %h = process_AM_file($ff);
                        prt( "ADVICE: Merging include [$sfil] HASH from [$sff]...\n" );
                        foreach my $k (keys %h) {
                            my $v = $h{$k};
                            if (defined $hash{$k}) {
                                $hash{$k} .= ' '.$v;
                            } else {
                                $hash{$k} = $val;
                            }
                        }
                    } else {
                        prtw( "ERROR: Unhandled INCLUDE [$key], ($sfil:$i2) [$sff] NOT FOUND\n" );
                    }

                } elsif ($fline =~ /^(\w+)\s*=\s*(.*)$/) {
                    @av = split('=',$fline);
                    $key = trim_all($av[0]);
                    $acnt = scalar @av;
                    $val = '';  # start with NO VALUE
                    # if can be 'JPEG_SERVER ='
                    for ($j = 1; $j < $acnt; $j++) {
                        if ($j == 1) {
                            $val = trim_all($av[$j]);
                        } else {
                            $val .= '='.trim_all($av[$j]);
                        }
                    }
                    if (@cond_stack) {
                        $ifcond = $cond_stack[$#cond_stack];
                        $key .= ' if '.$ifcond;
                    }
                    if (defined $hash{$key}) {
                        prtw( "WARNING: hash[$key] exists with [".$hash{$key}."]! Adding [$val]!! file=$sfil\n" );
                        $hash{$key} .= '|'.$val;
                    } else {
                        $hash{$key} = $val;
                    }
                } elsif ($fline =~ /^(\w+)\s*\+=\s*(.+)$/) {
                    $key = $1;
                    $val = $2;
                    if (@cond_stack) {
                        $ifcond = $cond_stack[$#cond_stack];
                        $key .= ' if '.$ifcond;
                    }
                    if (defined $hash{$key}) {
                        ##prtw( "WARNING: hash[$key] exists with [".$hash{$key}."]! Adding [$val]!! file=$sfil\n" );
                        $hash{$key} .= ' '.$val;
                    } else {
                        $hash{$key} = $val;
                        ##prtw( "WARNING: hash[$key] DOES NOT exist! Adding [$val]!! file=$sfil\n" );
                    }
                } else {
                    prt( "$i2: [$fline] SKIPPED\n" ) if ($dbg_s01);
                }
                $fline = '';    # kill this processed line
            }
        }
        # done all the LINES, now play with the HASH collected
        $acnt = scalar keys(%hash);
        if ($acnt) {
            extract_from_hash( $fil, \%hash );
        } else {
            prtw( "WARNING: NO KEYS IN HASH! [$sfil]\n" );
        }

        # WARN if conditional stack NOT closed
        prtw( "WARNING: Items still in cond_stack! [".join(' ',@cond_stack)."]\n" ) if (@cond_stack);
    } else {
        prtw( "WARNING: Unable to open $fil ... $! ...\n" );
    }
    return %hash;
}

sub process_one_am_file {
    my ($fil) = shift;
    my $sfil = sub_root_folder($fil);
    my %h = process_AM_file($fil);
    if (defined $h{'SUBDIRS'}) {
        my $slist = $h{'SUBDIRS'};
        my @ar = split(/\s/,$slist);
        my $cnt = scalar @ar;
        my ($p_tit,$p_dir,$p_ext) = fileparse( $fil, qr/\.[^.]*/ );
        prt( "Got $cnt subdirectories [$slist] ...from [$sfil]\n" ) if ($dbg_s09);
        foreach my $dir (@ar) {
            my $am = $p_dir.$dir.'\Makefile.am';
            my $sam = sub_root_folder($am);
            if (-f $am) {
                prt( "Processing AM file [$sam], from [$sfil] ...\n" ) if ($dbg_s05);
            } else {
                prtw( "WARNING: AM [$sam] NOT FOUND in [$dir], from [$sfil]!\n" ) if ($dbg_s05);
            }
            process_one_am_file($am);
        }
    }
}


sub list_to_arrays {
    my %srchash = ();
    my @msvc_c_files = ();
    my @msvc_h_files = ();
    prt("\n");
    prt( "AM files yielded programs ... " );
    #prt( "just for FlightGear, separated into groups ..." ) if ($show_fg_only);
    prt("\n");

    my ($key, $val, @av, $fil);
    my ($src, $tit, $dir, $ext, $cnt);
    my @done = ();
    my $sgrp = get_def_src_grp();    # "Source Files";
    my $sflt = get_def_src_filt();
    my $hgrp = get_def_hdr_grp();    # "Header Files";
    my $hflt = get_def_hdr_filt();
    foreach $key (sort keys %programs) {
        # next if ($show_fg_only && !($key eq $pgm_fg));
        $val = $programs{$key};
        @av = split(/\s/,$val);
        $cnt = scalar @av;
        prt( "PROGRAM [$key] $cnt SOURCES\n" );
        foreach $fil (@av) {
            prt( "$fil\n" ) if ($dbg_s10);
            ###($tit,$dir,$ext) = 	fileparse( $fil, qr/\.[^.]*/ );
            ($tit,$dir) = 	fileparse($fil);
            ###$src = ($grp.'|'.$fil.'|'.$tit);
            if ( is_c_source_extended($fil) ) {
                if ( is_in_array($tit,@done) ) {
                    prtw("Duplicate of FILE NAME $tit ($fil)!!!\n" );
                } else {
                    push(@done,$tit);
                }
                #push(@msvc_c_files, $src);
                push(@msvc_c_files, [$fil, $sgrp, $sflt]);
            } else {
                #push(@msvc_h_files, $src);
                push(@msvc_h_files, [$fil, $hgrp, $hflt]);
            }
        }
    }
    prt("\n") if ($dbg_s10);
    prt( "And following library SOURCES ...\n" );
    foreach $key (sort keys %libraries) {
        $val = $libraries{$key};
        @av = split(/\s/,$val);
        $cnt = scalar @av;
        prt( "LIBRARY [$key] $cnt SOURCES\n" ); # if (!$show_fg_only);
        foreach $fil (@av) {
            prt( "$fil\n" ) if ($dbg_s10);
            ($tit,$dir,$ext) = 	fileparse( $fil, qr/\.[^.]*/ );
            ###$src = ($grp.'|'.$fil.'|'.$tit);
            if (is_c_source($fil)) {
                if (is_in_array($tit,@done)) {
                    prtw("Duplicate of FILE TITLE $tit ($fil)!!!\n" );
                } else {
                    push(@done,$tit);
                }
                ###push(@msvc_c_files, $src);
                push(@msvc_c_files, [$fil, $sgrp, $sflt]);
            } else {
                ###push(@msvc_h_files, $src);
                push(@msvc_h_files, [$fil, $hgrp, $hflt]);
            }
        }
    }

    $key = scalar @msvc_c_files;
    $val = scalar @msvc_h_files;
    prt( "Set of $key C SOURCE files, and $val headers (and others) ...\n" );
    $srchash{'C_SOURCES'} = [ @msvc_c_files ];
    $srchash{'H_SOURCES'} = [ @msvc_h_files ];
    return %srchash;
}

sub process_primary {
    my ($fil) = shift;
    my %eh = process_one_am_file($fil);  # iteratively process the Makefile.am files
    list_to_arrays();
    ##write_temp_dsp($dsp_outfile);
}

sub set_debug_all {
    ##$dbg_s01 = 1;    # show prt( "$i2: $fline
    $dbg_s02 = 1;    # show prt( "Listing $acnt keys in hash ...
    $dbg_s03 = 1;    # show prt( "No LIBRARY keys ...
    $dbg_s04 = 1;    # show prt( "LIBRARY [$ky] has SOURCES [$val]
    ##$dbg_s05 = 1;    # show prt( "$am ". ((-f $am) ? "ok" : "no find!")
    ##$dbg_s06 = 1;    # show prt( "Opened cond_stack with [".$cond_stack[$#cond_stack]."] $fil
    $dbg_s07 = 1;
    $dbg_s08 = 1;    # show prt( "Processing $cnt lines from $fil ...
    $dbg_s09 = 1;    # show prt( "Got $cnt subdirectories [$slist] ...
}

sub prtw {
    my ($tx) = shift;
    $tx =~ s/\n$// if ($tx =~ /\n$/);
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}


# eof
