#!/perl -w
# # Series: Automation Microsfot Graph
# NAME: autogif.pl
# AIM: Generate a GIF file, using Microsoft Graph ??.0 Object Library
# Used OLEVIEW.EXE -> expand 'Type Libraries' to find latest MS Graph Object library.
# 22/08/2007 - geoff mclane - http://geoffair.net/mperl/samples
use strict;
use warnings;
use Win32::OLE qw( with in );
##use Win32::OLE::Const "Microsoft Graph 8.0 Object Library";
##use Win32::OLE::Const "Microsoft Graph 10.0 Object Library";
use Win32::OLE::Const "Microsoft Graph 12.0 Object Library";
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
# this may have to be ADJUSTED to suit your system
my $File = "c:\\tmp\\test2.gif";
my $enumerate = 0;	# just a DEBUG to ENUMERATE the interface
my ($Value, $Axis, $Labels, $PrevText );
my $WIDTH = 640;
my $HEIGHT = 400;
my $TIME = time();
my (@CELLS) = ( 'a'..'zz' );
srand( time() );
my $Class = "MSGraph.Application";
my $Chart = new Win32::OLE( $Class ) ||  mydie( "GO Away. Can not create '$Class'\n" );
prt( "Loaded class '$Class' ...\n" );
if ($enumerate) {
	# got a version loaded ...
	my $kcnt = keys(%$Chart);
	prt( "Output of $kcnt keys ...sorted alphbetically ...\n" );
	foreach my $key (sort keys %$Chart) {
		prt( "$key = $Chart->{$key}\n" );
	}
}
$Chart->{Visible} = 1;	# set visible, to WATCH what happens
# extract DataSheet and Chart HASH
my $Data = $Chart->DataSheet();
my $Graph = $Chart->Chart();
$Graph->{Width} = $WIDTH;
$Graph->{Height} = $HEIGHT;
$Graph->{HasLegend} = 0;
$Graph->{Type} = xlLine;

# Align the chart so it starts on the origin
$Graph->ChartGroups(1)->{HasUpDownBars} = 1 ;
$Graph->ChartGroups(1)->{HasUpDownBars} = 0;

# Add, RANDOM IN THIS CASE, data to the graph
# bumping - only use 34 points ...
foreach $Value ( 0..33 )
{
  my $Date = localtime( $TIME + 3600 * $Value );
  $Data->Range( "$CELLS[$Value]0" )->{Value} = $Date;
  $Data->Range( "$CELLS[$Value]1" )->{Value} = rand( 50 );
}

# Config the x-axis
if( $Axis = $Graph->Axes( xlCategory ) )
{
  $Axis->{HasMajorGridlines} = 0;
  $Axis->{TickLabels}->{orientation} = xlUpward;
  with( $Axis->{TickLabels}->{Font},
        Name    =>  "Tahoma",
        Bold    =>  0,
        Italic  =>  0
  );
}

# Config the y-axis
if( $Axis = $Graph->Axes( xlValue ) )
{
  $Axis->{HasMajorGridlines} = 1;
  $Axis->{MajorGridlines}->{Border}->{Weight} = 1;
  # The color index 48 == 40% gray
  # more colors from - http://msdn2.microsoft.com/en-us/library/aa219159(office.11).aspx
  #$Axis->{MajorGridlines}->{Border}->{ColorIndex} = 48;
  $Axis->{MajorGridlines}->{Border}->{ColorIndex} = 41;	# use BLUE
  $Axis->{MajorGridlines}->{Border}->{LineStyle} = xlContinuous;
  with( $Graph->Axes( xlValue )->{TickLabels}->{Font},
        Name    =>  "Tahoma",
        Bold    =>  0,
        Italic  =>  0
  );
}

# Configure the data point labels for the series collection
$Graph->SeriesCollection( 1 )->{HasDataLabels} = 1;
if( $Labels = $Graph->SeriesCollection(1)->DataLabels() )
{
#  with( $Labels,
#        NumberFormat =>  "#.0",
#        Type         =>  xlDataLabelsShowValues # NOT FOUND
#  );
  with( $Labels,
        NumberFormat =>  "#.0"
  );
  with( $Labels->{Font},
        Name    =>  "Tahoma",
        Bold    =>  0,
        Italic  =>  0,
	    Color   =>  3
  );
}

# Remove any data point labels if they are redundant
$PrevText = '';
foreach my $Point (in( $Graph->SeriesCollection( 1 )->Points()))
{
  my $Text = $Point->{DataLabel}->{Text};
  $Point->{MarkerStyle} = xlMarkerStyleDot;
  $Point->{DataLabel}->{Font}->{Background} = xlBackgroundOpaque;
  $Point->{HasDataLabel} = 0 if( $Text eq $PrevText );
  $PrevText = $Text;
}

# write it out to DISK
$Graph->Export( $File, "GIF", 0 );

if (!$enumerate) {
	print "Any key to continue ...";
	<STDIN>;	# this just gives time to VIEW the generated table and graph in GRAPH
	# before it is CLOSED on this script exit ...
	system( $File );	# load it for viewing in associated graphic display program, if any.
}

close_log($outfile,$enumerate);
exit(0);

#######################
### ENUMERATION example text
#Loaded class 'MSGraph.Application' ...
#Output of 21 keys ...sorted alphbetically ...
#Application = Win32::OLE=HASH(0x1a50efc)
#AutoCorrect = Win32::OLE=HASH(0x1a50ed8)
#CellDragAndDrop = 1
#CommandBars = Win32::OLE=HASH(0x1a50ea8)
#Creator = 1297303378
#DataSheet = Win32::OLE=HASH(0x1a50ee4)
#DisplayAlerts = 0
#HasLinks = 0
#Height = 530
#Left = 66
#MoveAfterReturn = 1
#Name = Microsoft Graph
#Parent = Win32::OLE=HASH(0x1a50f98)
#PlotBy = 1
#ShowChartTipNames = 1
#ShowChartTipValues = 1
#Top = 87
#Version = 12.0
#Visible = 0
#Width = 768
#WindowState = -4143

# eof - autogif.pl
