#!/perl -w
# NAME: chk4key.pl
# AIM: Find a way yo POLL the keyboard
use strict;
use warnings;
use Term::ReadKey;

#ReadMode('cbreak');
#ReadMode 1;     # cooked mode

sub show_hex {
    my ($i) = shift;
	print sprintf( "%03d ", $i );
	if ($i == 0) {
		print "z ";
	} elsif ($i == 8 ) {
		print "d ";
	} elsif ($i == 9 ) {
		print "9 ";
	} elsif ($i == 7 ) {
		print "b ";
	} elsif ($i == 10 ) {
		print "c ";
	} elsif ($i == 13 ) {
		print "l ";
	} else {
		print sprintf( "%c ", $i );
	}
	print sprintf( "%02X ", $i );
    print sprintf( "%03o\n", $i );
}

sub got_keyboard {
    my ($rc) = shift;
    if (defined (my $char = ReadKey(-1)) ) {
		# input was waiting and it was $char
        $$rc = $char;
        return 1;
	}
    return 0;
}

sub delay {
    my ($secs) = shift;
    select(undef, undef, undef, $secs);
}

print "Show keyboard, until ESC to exit ...\n";
#for (my $i = 0; $i < 10; $i++) {
for (my $i = 0; ; $i++) {
    my ($char, $ch, $len, $j);
    if (got_keyboard(\$char)) {
        $len = length($char);
        for ($j = 0; $j < $len; $j++) {
            $ch = substr($char,$j,1);
            show_hex( ord($ch) );
        }
        if ($char eq "\033") {
            print "Got ESC char ...\n";
            last;
        }
    }
    #sleep(1);
    delay(0.1);
}

exit(0);


# eof
