#!/perl -w
# NAME: chkincinc.pl
# AIM: Get list of INCLUDES in a C/C++ file

# remove /* ... */
# and // to end of line
sub delete_comments_from_line($) {
   my ($tln) = shift;
   my $len = length($tln);
   my ($j,$c,$nc);
   my $nln = '';
   for ($j = 0; $j < $len; $j++) {
      $c = substr($tln,$j,1);
      $nc = (($j + 1) < $len) ? substr($tln,$j+1,1) : '';
      if (($c eq '/')&&($nc eq '*')) {
         # stay and EAT comment until end comment
         $j += 2;
         for (; $j < $len; $j++) {
            $c = substr($tln,$j,1);
            $nc = (($j + 1) < $len) ? substr($tln,$j+1,1) : '';
            if (($c eq '*')&&($nc eq '/')) {
               $j++;
               last;
            }
         }
         next;
      } elsif (($c eq '/')&&($nc eq '/')) {
         $j += 2;
         # stay and EAT comment until EOL
         for (; $j < $len; $j++) {
            $c = substr($tln,$j,1);
            if ($c eq "\n") {
               $j--;
               last;
            }
         }
         next;
      }
      $nln .= $c; # add char to 'new' line
   }
   return $nln;
}

sub get_include_file_list($) {
   my ($fil) = shift;
   my ($line,$inc);
   my @arr = ();
   if (open INF, "<$fil") {
      my @lines = <INF>;
      close INF;
      foreach $line (@lines) {
         if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = trim_all($1);
            $inc = delete_comments_from_line($inc);
            $inc = trim_all($inc);
            push(@arr,$inc);
         }
      }
   } else {
      prt("ERROR: Can NOT open file [$fil]!\n");
   }
   return \@arr;
}

1;
# eof - chkincinc.pl

