#!/perl -w
# NAME: chkoutput.pl
# AIM: VERY SPECIFIC - check the MSVC output for 'unknown' lines...
# 2009/09/25  - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = "chkoutput.txt";

sub ignore_output_line($) {
    my ($line) = shift;
    my $xcnt = 0;
    if ($line =~ /^------ Build started/) {
        # like [------ Build started: Project: libswscale, Configuration: Debug Win32 ------]
        $xcnt = 1;
    } elsif ($line =~ /^Linking/) {
        $xcnt = 2;
    } elsif ($line =~ /^Build log was saved/) {
        $xcnt = 3;
    } elsif ($line =~ /^========== Build:/) {
        $xcnt = 4;
    } elsif ($line =~ /.+-\s+(\d+)\s+error\(s\),\s+(\d+)\s+warning\(s\)/) {
        $xcnt = 5;
    } elsif ($line =~ /.+\s+:\s+fatal\s+error\s+.+:\s+(\d+)\s+unresolved/) {
        $xcnt = 6;
    } elsif ($line =~ /^LINK\s+:\s+/) {
        $xcnt = 7;
    } elsif ($line =~ /^Generating\s+Code/) {
        $xcnt = 8;
    } elsif ($line =~ /^Creating\s+library/) {
        $xcnt = 9;
    }
    return $xcnt;
}

sub process_file($) {
    my ($fil) = shift;
    if (open INF, "<$fil") {
        my @lines = <INF>;
        my ($line, $lncnt, $res, $pline, $min, $msg);
        my ($proj,$conf);
        $lncnt = scalar @lines;
        prt("Processing $lncnt lines, from $fil...\n");
        $pline = '';
        $min = 0;
        foreach $line (@lines) {
            chomp $line;
            $res = ignore_output_line($line);
            if ($res) {
                # numbered, if want to do something
            } elsif ($line =~ /^(\w|\.|-)+$/) {
                # just a source name...
                $pline = $line;
            } else {
                $min = length($pline) if (length($pline) > $min);
            }
        }
        $min += 2;
        $pline = '';
        $proj = '';
        $conf = '';
        foreach $line (@lines) {
            chomp $line;
            $res = ignore_output_line($line);
            if ($res) {
                # numbered, if want to do something
                if ($res == 1) {
                    # like [------ Build started: Project: libswscale, Configuration: Debug Win32 ------]
                    if ($line =~ /Project:\s+(.+),\s+Configuration:\s+(.+)\s+-----/) {
                        $proj = $1;
                        $conf = $2;
                    }
                }
                next;
            }
            if ($line =~ /^(\w|\.|-)+$/) {
                # just a source name...
                $pline = $line;
                next;
            }
            $msg = "[$pline]";
            $msg .= ' ' while (length($msg) < $min);
            prt( "$msg $line ($proj $conf)\n" );
        }
    } else {
        prt("ERROR: Unable to open [$fil]!\n" );
    }
}

prt( "$pgmname... Processing [$in_file]...\n" );
process_file($in_file);

close_log($outfile,1);
exit(0);



# eof chkoutput.pl
