#!/perl -w
# NAME: chkrt.pl
# AIM: Check the RUNTIME of -
# DSW set of files		MSVC6
# DSP single file		MSVC6
# SLN set of files		MSVC7 or 8
# vcproj single file	MSVC7 or 8
# 11/08/2010 - Added File::Spec->rel2abs to convert any relative input to absolute
# 03/07/2010 - For vcproj at least, show OutputFile=
# 08/06/2010 - Just a little tidying, and UI enhancements...
# 14/11/2008 - Add show of sources, and add and use prtw();
# 24/09/2007 - Also SHOW output file ...
# ############################################################
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
use Cwd;
##############################################################
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
#require 'fgutils02.pl' or die "Unable to load fgutils02.pl ...\n";
#require 'fgdsphdrs03.pl' or die "Unable to load fgdsphdrs03.pl ...\n";
#require 'scanvc.pl' or die "Unable to load scanvc.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $perl_root = "C:\\GTools\\perl"; 
my $outfile = $perl_root."\\temp.$pgmname.txt";
open_log($outfile);
my $in_file = '';
my $dbg_inp = 0;	# on to run WITHOUT command line ..
my $def_file = 'C:\GTools\perl\dsp\testap6.dsp';
my $out_dsp_dir = $perl_root;
my $do_set = 0;	# set to do SET
my @sln_set = ();

# features
my $load_log = 0;    # load log into Wordpad
my $show_srcs = 0;  # check and display the SOURCE files
my $excl_excluded = 1;	# check for PROP # PROP Exclude_From_Build 1
my $showfiles = 0;	# also OUTPUT the file list
my $showfilter = 0;	# also OUTPUT the filter list
my $showenter = 0;	# show enter and exit - more for debug
my $curr_app_type = '';
my $write_dsp = 1;
my $fix_rel_paths = 0;  # if given an output dsp directory, fix the releative source paths
my $dbg4write = 0;
my $comp_2_dsps = 0;

my ($fil_nm,$fil_dir,$fil_ext);
my @lines = ();
my $line = '';
my @warnings = ();	# push of ALL WARNINGS ...
my $wrnmsg = '';
my $show_out_file = 1;	# show the OUTPUT file also
my $vcprojcnt = 0;
my $projcount = 0;
my $new_runtime = '';

my $tot_dsp_count = 0;
my $tot_vcproj_count = 0;
#########################################################
my %dswprojs = ();
#########################################
### DSP handling sub clear_per_dsp {
my %macros = ();	# clear DSP macro set
my %dspmacros = ();
my $customdbg = '';
my $custonrel = '';
my @discardedsrcs = ();
my $update_bat = '';

# constants
my $COMMENT_PATTERN = "^#";
my $MACRO_PATTERN2 = "^([A-Za-z][A-Za-z0-9_]+)[ \t]*=[ \t]*(.*)\$";

my %runtimes = ();  # store of RUNTIMES found
my %rtlines = ();
my %rtfiles = ();
my %rthash = ();

my $mtrts = 0;
my $dllrts = 0;
my $otherrts = 0;

my @src_list = ();
my @dsp_file_list = ();
my @project_list = ();

#-- get current directory
my $pwd = cwd();

#########################################################
# debug
# DSP debug items
my $dbg_out = 0;	# write the RE-LINED XML to a file
my $dbg5 = 0;	# show "Got Project: $pn, $ff ...
my $dbg6 = 0;	# show "Split is [$if0] == [$if1]
my $dbg8 = 0;	# show "Entered IF [$1] $inanif
my $dbg9 = 0;	# show "SET: MACRO $1, to $2 ...
my $dbg10 = 0;	# show "Begin Group: $1
my $dbg11 = 0;	# show "File $f contains $lncnt lines ...
my $dbg30 = 0;	# show "Discarding [$ls] due to Exclude_From_Build ... if $excl_excluded ON
my $dbg31 = 0;	# show "WARNING: CHECK Discarded [$fline]"
my $dgb32 = 0;	# show "Use_Debug_Libraries $1
my $dgb33 = 0;	# show "RUNTIME: $form $rt
my $dbg34 = 0;	# show "WARNING: Duplicated MACRO $1, now $2, was $macros{$1} ...
my $dbg35 = 0;	# show "$vcprojcnt:$cfgcnt: End Configuration ...

my $dbg40 = 0;  # show "Processing $lc lines ...
my $dbg41 = 0;  # show "Done $lc lines ... $cnt projects ...
my $dbg42 = 0;  # show "\n$vcprojcnt: Processing VCPROJ file [$fil] ...
my $dbg43 = 0;  # show 	"$vcprojcnt: Processing $cnt lines ...
my $dbg44 = 0;  # show "$vcprojcnt: Done $cnt lines ... got $ncnt new lines ...
my $dbg45 = 0;  # show "$vcprojcnt: Project Name = $actname ($actvers)...
my $dbg46 = 0;  # show "$vcprojcnt:$cfgcnt: Config Name = $actcfg ...
my $dbg47 = 0;  # show "$vcprojcnt:$cfgcnt: Preprocessor = $actpp
my $dbg48 = 0;  # show "$cnt: Project [".$arr[0]."] File [".$arr[1]."] ...
my $dbg49 = 0;  # show "$vcprojcnt:$cfgcnt: Runtime = $rt ($rts) ... for $actcfg ($rng)
my $dbg50 = 0;  # show "$vcprojcnt:$cfgcnt: Output = $1
my $dbg51 = 0;  # show "Processing CONCLUDED without WARNINGS!
my $dbg52 = 0;  # show "$vcprojcnt:$cfgcnt: AdditionalDependencies = ...

my $dbg53 = 0; # prt( "[dbg53] $pgmname: Scanning [$in]...\n" ) if ($dbg53);
my $dbg54 = 0;
my $dbg55 = 0;
my $dbg56 = 0;
####################
### WARNING LIST ###

sub prtw($) {
    my ($tx) = shift;
    $tx =~ s/\n$// if ($tx =~ /\n$/);
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings($) {
    my ($dbg) = shift;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } elsif ($dbg) {
        prt("\nNo warnings issued.\n\n");
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    show_warnings($val);
    if (length($msg)) {
        $msg .= "\n" if ( !($msg =~ /\n$/) );
        prt($msg);
    }
    close_log($outfile,$load_log);
    exit($val);
}

# this could be split(/\s/,$line), but there is a
# problem with name="with space", that this overcomes.
# Slower. but sure the split is as desired.
sub space_split_local($) {
	my ($lin) = shift;
	my $ll = length($lin);
	my $tag = '';
	my @rarr = ();
	my $inquots = 0;
	for (my $p = 0; $p < $ll; $p++) {
		my $ch = substr($lin,$p,1);
		if ($inquots) {
			$tag .= $ch;
			if ($ch eq '"') {
				$inquots = 0;
			}
		} else {
			if ($ch =~ /\s/) {
				push(@rarr, $tag) if (length($tag));
				$tag = '';
			} else {
				$tag .= $ch;
				if ($ch eq '"') {
					$inquots = 1;
				}
			}
		}
	}
	push(@rarr, $tag) if (length($tag));
	return @rarr;
}

sub show_sources {
    my $scnt = scalar @src_list;
    prt( "Show of $scnt SOURCE files ...\n" );
    my ($file, $msg, $i, $cnt, $rfil, $proj, $len, $minp, $mins, $sf, $j);
    my ($rsrcs);
    $minp = 0;
    $mins = 0;
    #                  0          1         2      3
    #push(@src_list, [ $actname, [@vcsrcs], $fil, [@srcs] ]);
    # run to get LENGTHS
    for ($i = 0; $i < $scnt; $i++) {
        $proj = $src_list[$i][0];
        $rfil = $src_list[$i][1];
        $len = length($proj);
        $minp = $len if ($len > $minp);
        foreach $file (@{$rfil}) {
            $len = length($file);
            $mins = $len if ($len > $mins);
        }
    }
    # run for DISPLAY
    for ($i = 0; $i < $scnt; $i++) {
        $proj = $src_list[$i][0];
        $rfil = $src_list[$i][1];
        $sf   = $src_list[$i][2];
        $rsrcs= $src_list[$i][3];
        $cnt = scalar @{$rfil};
        $proj .= ' ' while (length($proj) < $minp);
        prt("Project $proj: $cnt sources, from $sf\n");
        $j = 0;
        foreach $file (@{$rfil}) {
            $msg = ((-f $file) ? "ok" : "MISSING");
            $file .= ' ' while (length($file) < $mins);
            prt( " [$file] $msg (${$rsrcs}[$j])\n" );
            $j++;
        }
    }
}

## if (lc($fil_ext) eq 'dsw') {
sub	process_dsw {
	my ($fil) = shift;
	my ($msg, $lc, $lin, $pcnt, $ln, $bal, $pn, $pf, $ff);
	prt( "Processing DSW file [$fil] ...\n" );
	if ( !open INF, "<$fil" ) {
		$msg = "WARNING: Unable to open [$fil] ...";
		prtw( "$msg\n" );
		return 0;
	}
	@lines = <INF>;
	close INF;
	$lc = scalar @lines;
	prt( "Processing $lc lines ...\n" );
	my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
	$pcnt = 0;
	$ln = 0;
	foreach $lin (@lines) {
		# seeking Project: "gennmtab"=".\gennmtab.dsp" - Package Owner=<4>
		chomp $lin;
		$ln++;
		##prt( "$ln [$lin]\n" );
		if ($lin =~ /^Project:\s+(.*)/) {
			$bal = $1;
			###prt( "Got Project: [$bal]...\n" );
			if ($bal =~ /\"(\w+)\"=\"*([\w\.\\\/]+)\"*/) {
				$pn = $1;
				$pf = $2;
				$ff = fix_rel($dir . $pf);
				###prt( "Name = [$pn], file = [$pf][$ff] " );
				prt( "Got Project: $pn, $ff ...\n" ) if ($dbg5);
				if (defined $dswprojs{$pn} ) {
					$msg = "WARNING: Duplicate PROJECT [%pn] ... $pf versus ".$dswprojs{$pn};
					prtw( "$msg\n" );
				} else {
					$dswprojs{$pn} = $ff;	# keep project DSP file
					$pcnt++;
					if ( !(-f $ff) ) {
						$msg = "WARNING: [$ff] CAN NOT BE FOUND ...";
						prtw( "$msg\n" );
					}
				}
			}
		}
	}
	prt( "Done $lc lines ... got $pcnt projects \n" );
	return $lc;
}


## } elsif (lc($fil_ext) eq 'dsp') {
sub	process_dsp {
	my ($fil) = shift;
	my ($lc, $wmsg);
	prt( "\nProcessing DSP file [$fil] ...\n" );
	load_dsp($fil);
}

## } elsif (lc($fil_ext) eq 'sln') {
sub process_sln {
	my ($fil) = shift;
	my ($lc, $wmsg);
	prt( "\nProcessing SLN file [$fil] ...\n" );
	if ( !open INF, "<$fil" ) {
		$wmsg = "WARNING: Unable to open [$fil] ...";
		prtw( "$wmsg\n" );
		return 0;
	}
	@lines = <INF>;
	close INF;
	$lc = scalar @lines;
	prt( "Processing $lc lines ...\n" ) if ($dbg40);
	my $cnt = 0;
	my @projs = ();
	foreach $line (@lines) {
		$line = trim_all($line);
		if ($line =~ /Project\(.*=(.*)/) {
			$cnt++;
			##prt( "$1\n" );
			my @arr = split(/,/, $1);
			if (scalar @arr >= 2) {
				$arr[0] = trim_all($arr[0]);
				$arr[1] = trim_all($arr[1]);
				$arr[0] = substr($arr[0],1,length($arr[0])-2);
				$arr[1] = substr($arr[1],1,length($arr[1])-2);
				prt( "$cnt: Project [".$arr[0]."] File [".$arr[1]."] ...\n" ) if ($dbg48);
				push(@projs, [ $arr[0], $arr[1] ]);
			} else {
        		$wmsg = "WARNING:$cnt:[$fil]: Scalar count of split only ".scalar @arr."???";
		        prtw( "$wmsg\n" );
            }
		}
	}

	$cnt = scalar @projs;
	prt( "Done $lc lines ... $cnt projects ...\n" ) if ($dbg41);
	for (my $i = 0; $i < $cnt; $i++) {
		my $relfil = fix_rel($fil_dir.$projs[$i][1]);
		my ($fnm,$fdir,$fext) = fileparse( $relfil, qr/\.[^.]*/ );
		if (lc($fext) eq '.vcproj') {
			process_vcproj( $relfil );
		} elsif (lc($fext) eq '.csproj') {
			$wrnmsg = "WARNING: Input file [$relfil] is C#, NOT handled ...";
			prtw( "$wrnmsg\n" );
		} else {
			$wrnmsg = "WARNING: Input file [$relfil] NOT of know extension ...";
			prtw( "$wrnmsg\n" );
		}
	}
	return $lc;
}

# ensure -NEW_LIBS- hash ref does NOT contain LIBS already in default
sub fix_lib_list($) {
    my ($rh) = @_;
    my $key = 'PROJECT_CFGS';
    my $chgd = 0;
    my $def = get_def_lib_list();
    my @a2 = split(/\s/,$def);
    if (defined ${$rh}{$key}) {
        my $val = ${$rh}{$key};
        my $k2 = '-NEW_LIBS-';
        my $acnt = scalar @{$val};
        for (my $i = 0; $i < $acnt; $i++) {
            my $rsb = ${$val}[$i][3];   # get -NEW_LIBS- hash ref
            if (defined ${$rsb}{$k2}) {
                my $v2 = ${$rsb}{$k2};
                prt("[dbg_sl_13]  [$v2],\nwith default [$def]\n") if ($dbg54);
                my @a1 = split(/\s/,$v2);
                my $chg = 0;
                my @arr = ();
                my ($lib, $lib2,$fnd,$lclib);
                foreach $lib (@a1) {
                    $lclib = lc($lib);
                    if ($lib =~ /^\/libpath:/i) {  # no change in these
                        push(@arr,$lib);
                    } else {
                        $fnd = 0;   # else check if already in DEFAULTS
                        foreach $lib2 (@a2) {
                            if ($lclib eq lc($lib2)) {
                                $fnd = 1;
                                last;
                            }
                        }
                        if ($fnd) {
                            $chg++; # dump this DUPLICATE
                        } else {
                            push(@arr,$lib);    # else keep this
                        }
                    }
                }
                if ($chg) {
                    $lib = join(" ",@arr);
                    ${$rsb}{$k2} = $lib;
                    prt(" Set NEW [$lib]\n") if ($dbg54);
                    $chgd++;
                }
            }
        }   # for each configuration
        if ($chgd) {
           # pgm_exit(1,"TEMP EXIT");
        }
    }
}

# dbg_show_entering_files();
# dbg_show_source_files();
# dbg_show_output_files(); # { $dbg_v21 = 1; $dbg_v24 = 1; }
# 2009/10/29 - make it work for TWO different forms of VC HASH
sub process_vcproj_file($$) {
    my ($in, $outd) = @_;
    my ($key,$tmp,$out,$cnt,$dsp);
    my ($prjf,$nm,$dir,$ext,$dspf);
    my ($msg);
    my ($rdspf,$fprjf,$fdspf,$dprjf);
    prt( "[dbg_sl_05] $pgmname: Scanning [$in]...\n" ) if ($dbg53);
    my ($vc_name,$vc_dir) = fileparse($in);
    $vc_dir = $pwd."\\" if ($vc_dir =~ /^\.(\\|\/)$/);
    my $rh = process_VCPROJ3($in);

    # check for application type over-ride...
    if (length($curr_app_type)) {
        $key = 'APP_TYPE';
        $key = 'PROJECT_APTP' if (!defined ${$rh}{$key});
        if (defined ${$rh}{$key}) {
            $tmp = ${$rh}{$key};
            ${$rh}{$key} = $curr_app_type;
            if ($tmp ne $curr_app_type) {
                prt("Overrode $key with [$curr_app_type], from [$tmp]\n");
            }
        }
    }

    # 2010-01-15 - get appropriate DSP file name (real = to replace existing, if any)
    $key = 'PROJECT_FILE';
    $fprjf = '';
    $rdspf = '';
    $fdspf = '';
    if (defined ${$rh}{$key}) {
        $fprjf = ${$rh}{$key};
        ($nm,$dprjf,$ext) = fileparse($fprjf, qr/\.[^.]*/);
        $fdspf = $dprjf.$nm.".dsp";   # this may/should be ABSOLUTE
    } else {
        pgm_exit(1,"ERROR: key [$key] NOT IN hash! AND IT MUST BE!! Aborting!!!\n");
    }

    # show_hash_results3($rh) if ($dbg_sl_04);  # this would be BEFORE any changes made in chk_relative_paths...

    $key = '-NEW_PROJECT_NAME-';
    $key = 'PROJECT_NAME' if (!defined ${$rh}{$key});
    if ( $write_dsp && (defined ${$rh}{$key}) ) {
        $tmp = ${$rh}{$key};    # get the PROJECT NAME
        $dsp = $tmp.".dsp";     # make a DSP file name
        ${$rh}{'PROJECT_DSPF'} = $dsp;
        $outd .= "\\" if ( !($outd =~ /[\\\/]$/) ); # ensure out directory ends '\'
        $out = $outd;           # using OUT directory
        $out .= "temp.".$dsp;   # form a TEMPORARY DSP file name

        fix_lib_list($rh);
        # crude game to ensure TEMP DSP name for this project is UNIQUE
        $cnt = 0;
        while ( is_in_array($out, @dsp_file_list) ) {
            $cnt++; # already have a DSP of that name, so
            $out = $outd;   # get OUT directory again, and
            $out .= "temp.".$tmp.$cnt.".dsp";   # add a COUNT to name
        }

        if ($fix_rel_paths) {
            # ok, need to change sources from perhaps '.\src.cxx' to '..\..\lib\src.cxx' - a big job
            chk_relative_paths($rh,$outd,$vc_dir);  # was $perl_base; # this can be changed by -dsp=<new_dir>
        } else {
            prt("No relative path change: vcd=[$vc_dir] out=[$outd]\n");
        }

        show_hash_results3($rh) if ($dbg53);

        # *** WRITE DSP FILE - FIRST TO A 'TEMP' FILE, to do a compare, if needed ***
        # ===========================================================================
        if ( write_hash_to_DSP3( $out, $rh, $dbg4write ) ) {
            push(@dsp_file_list,$out);  # store name
            #     project_list    0     1     2
            #push(@project_list, [ $tmp, $dsp, $out ]);
            push(@project_list, [ $tmp, $fdspf, $out ]);
            $key = 'PROJECT_FILE';
            if (defined ${$rh}{$key}) {
                $prjf = ${$rh}{$key};
                prt( "For '$prjf'\n written '$out'\n" );

                # Uses cmp2dsps[?].pl, external to here...
                if ($comp_2_dsps) {
                    ($nm,$dir,$ext) = fileparse($prjf, qr/\.[^.]*/);
                    $dspf = $dir.$nm.".dsp";
                    if (( -f $dspf)&&( -f $out)) {
                        $msg = "cmp2dsps $dspf $out";
                        $msg .= " -l" if ($load_log);
                        prt("Doing $msg...\n");
                        system("$msg");
                    } else {
                        $msg = "No compare done! ";
                        if ( !(-f $dspf) ) {
                            $msg .= "Missing [$dspf]?";
                        }
                        if ( !(-f $out) ) {
                            $msg .= "Missing [$out]??";
                        }
                        prtw("WARNING: $msg\n");
                    }
                }
                # =======================================
            }
        } else {
            prtw("WARNING: No DSP written for [$tmp] project.\n" );
        }
    } else {
        show_hash_results3($rh) if ($dbg53);
        prtw("WARNING: NO PROJECT NAME! = NO DSP WRITTEN!\n");
    }
    return $rh;
}

######################################
## process a VCPROJ file
######################################
sub process_vcproj {
	my ($fil) = shift;
    #process_vcproj_file($fil, $out_dsp_dir);
	my ($cnt, $ac, $i, $ln, $actcfg, $j, $bgn, $end, $rnt, $rts, $cfgcnt, $incfg, $wmsg);
	my ($fnm,$fdir,$fext) = fileparse( $fil, qr/\.[^.]*/ );
	my (@nlines, $ncnt, @arr, $actname, $actvers, $actpp, $incfgs, $infiles);
	my ($grpname, $grpfilter, $grpfile, $ingrp, $key, $rng, $rtrng);
    my ($ind, @arr2, $tmp1, $tmp2, @adld, $ch);
    my ($ff, $msg, $lnnum, $xln);
    #my ($ratthash);
    my @vcsrcs = ();
    my @srcs = ();
    my %lnmap = ();
	$vcprojcnt++;
	prt( "\n$vcprojcnt: Processing VCPROJ file [$fil] ...\n" ) if ($dbg42);
	if ( !open INF, "<$fil" ) {
		$wmsg = "WARNING: Unable to open [$fil] ...";
		prtw( "$wmsg\n" );
		return 0;
	}
	@lines = <INF>;
	close INF;
	$cnt = scalar @lines;
	prt( "$vcprojcnt: Processing $cnt lines ...\n" ) if ($dbg43);
    $tot_vcproj_count++;
	### push(@nlines, [$nline, $bgn, $end]);
	### @nlines = reline_xml(@lines);
    @nlines = xml_to_lines(\%lnmap, @lines);
	$ncnt = scalar @nlines;
	prt( "$vcprojcnt: Done $cnt lines ... got $ncnt new lines ...\n" ) if ($dbg44);
	if ($dbg_out) {
		my $tmp = "C:\\GTools\\perl\\temp.$fnm.$vcprojcnt.txt";
		my $tln = '';
        $lnnum = 0;
		for ($j = 0; $j < $ncnt; $j++) {
			##$line = $nlines[$j][0];
			##$tln .= "\n" if (length($tln));
            $lnnum++;
			$line = $nlines[$j];
            $xln = $lnmap{$lnnum};
			$tln .= "$xln: [$line]\n";
		}
		write2file( $tln, $tmp );
        prt( "XML written to $tmp ...\n" );
	}

	$actcfg = '';
	$cfgcnt = 0;
	$incfg = 0;
	$actname = '';	# name of the PROJECT
	$actpp = '';
	$incfgs = 0;
	$infiles = 0;
	$grpname = '';
	$grpfilter = '';
	$ingrp = 0;
    $lnnum = 0;
    $rnt = -1;
    $rtrng = '<NR>';
	for ($j = 0; $j < $ncnt; $j++) {
		#$line = $nlines[$j][0];		# XML line
		#$bgn = $nlines[$j][1];		# begin line number
		#$end = $nlines[$j][2];		# end line number
        $lnnum++;
        $line = $nlines[$j];
        $xln = $lnmap{$lnnum};
        @arr = split('-',$xln);
        $bgn = $arr[0];
        $end = $arr[1];
		@arr = space_split_local($line);
		$ac = scalar @arr;
        #$ratthash = line_2_hash_on_equals($line,$lnnum);
        #$tag = $attribs[0];
		$rng = "$bgn,$end";
		if ($line =~ /^<VisualStudioProject\s+/) {
			# <VisualStudioProject ProjectType="Visual C++" Version="8.00" Name="testmem" ProjectGUID="{05A9204E-6130-4347-8C31-7A063C09C276}" >
			for ($i = 0; $i < $ac; $i++) {
				$ln = $arr[$i];
				if ($ln =~ /.*Name=\"(.*)\".*/) {
					$actname = $1;
					$projcount++;
				} elsif ($ln =~ /.*Version=\"(.*)\".*/) {
					$actvers = $1;
				}
			}
			prt( "$vcprojcnt: Project Name = $actname ($actvers)...\n" ) if ($dbg45);
		} elsif ($line =~ /^<Configurations>$/) {
			$incfgs = 1;
			prt( "Enter $line\n" ) if ($showenter);
		} elsif ($line =~ /^<\/Configurations>$/) {
			$incfgs = 0;
			prt( "Exit $line\n" ) if ($showenter);
		} elsif ($line =~ /^<Files>$/) {
			$infiles = 1;
			prt( "Enter $line\n" ) if ($showenter);
		} elsif ($line =~ /^<\/Files>$/) {
			$infiles = 0;
			prt( "Exit $line\n" ) if ($showenter);
		} elsif ($line =~ /^<Configuration\s+/) {
			# <Configuration Name="Release|Win32" OutputDirectory=".\Release" IntermediateDirectory=".\Release" ConfigurationType="1" InheritedPropertySheets="$(VCInstallDir)VCProjectDefaults\UpgradeFromVC60.vsprops" UseOfMFC="0" ATLMinimizesCRunTimeLibraryUsage="false" CharacterSet="2" >
			for ($i = 0; $i < $ac; $i++) {
				$ln = $arr[$i];
				if ($ln =~ /.*Name=\"(.*)\".*/) {
					$actcfg = $1;
					$cfgcnt++;
					$incfg = 1;
					prt( "$vcprojcnt:$cfgcnt: Config Name = $actcfg ..\n" ) if ($dbg46);
					last;
				}
			}
			if (($incfg == 0) || ($i == $ac)) {
				$wmsg = "WARNING: Got Configuration WITHOUT NAME!!! file=$fil";
				prtw( "$wmsg\n" );
			}
		} elsif ($line =~ /^<\/Configuration>/) {
			prt( "$vcprojcnt:$cfgcnt: End Configuration ...\n" ) if ($dbg35);
			$key = $actname.'|'.$actcfg;

            if (defined $rthash{$rnt}) {
                $rthash{$rnt}++;
            } else {
                $rthash{$rnt} = 1;
            }

			if (defined $runtimes{$key}) {
				$wmsg = "WARNING: $key ALREADY EXISTS!!! file=$fil";
				prtw( "$wmsg\n" );
			} else {
				$runtimes{$key} = $rnt;		# keep the RUNTIME
				$rtlines{$key} = $rtrng;	# and the RANGE of LINES
				$rtfiles{$key} = $fil;		# and the FILE
			}
			$actcfg = "NO ACTIVE CONFIG!!!";
			$incfg = 0;
		} elsif ($line =~ /^<Tool\s+(.*)/) {
		#} elsif ($line =~ /^<Tool\s+Name=\"VCLinkerTool\"\s+.+OutputFile=\"([\.\\\/\w]*)\"/) {
			$ln = $1;   # get balance of line, after <Tool ...
			if ($incfgs) {
				if ($ln =~ /\s*Name=\"VCCLCompilerTool\"\s*/) {
					# <Tool
					# Name="VCCLCompilerTool"
					# Optimization="2" 
					# InlineFunctionExpansion="1" 
					# PreprocessorDefinitions="WIN32;NDEBUG;_WINDOWS" 
					# StringPooling="true" 
					# RuntimeLibrary="0" 
					# EnableFunctionLevelLinking="true" 
					# PrecompiledHeaderFile=".\Release/testmem.pch" 
					# AssemblerListingLocation=".\Release/" 
					# ObjectFile=".\Release/" 
					# ProgramDataBaseFileName=".\Release/" 
					# WarningLevel="3" 
					# SuppressStartupBanner="true"
					# />
					for ($i = 0; $i < $ac; $i++) {
						$ln = $arr[$i];
						if ($ln =~ /.*RuntimeLibrary=\"(\d+)\".*/) {
							# RuntimeLibrary="2"
							$rnt = $1;
							$rts = rt_2_switch($rnt);
							#prt( "$line\n" );
							if ($incfg) {
								###prt( "$vcprojcnt:$cfgcnt: Runtime = $rt ($rts) ... for $actcfg ($bgn,$end)\n" );
								prt( "$vcprojcnt:$cfgcnt: Runtime=[$rnt] ($rts)... for $actcfg ($rng)\n" ) if ($dbg49);
								$rtrng = $rng;
							} else {
								$wmsg = "WARNING: NOT IN CONFIG BLOCK!!! file=$fil";
								prtw( "$wmsg\n$vcprojcnt:$cfgcnt: Runtime=[$rnt] ($rts)... for $actcfg ($rng)\n" );
							}
						} elsif ($ln =~ /\s*PreprocessorDefinitions=\"(.*)\"\s*/) { # like WIN32;NDEBUG;_WINDOWS" 
							$actpp = $1;
							if (length($actpp)) {
								prt( "$vcprojcnt:$cfgcnt: Preprocessor = $actpp\n" ) if ($dbg47);
							} else {
								prt( "$vcprojcnt:$cfgcnt:$i:$ac: ZERO Preprocessor = $ln ($line)\n" );
							}
						}
					}
				} elsif ($ln =~ /\s*Name=\"VCLinkerTool\"\s*/ ) {
					#prt( "$vcprojcnt:$cfgcnt: VCLinkerTool = $ln\n" );
                    # <Tool
                    # Name="VCLinkerTool"
                    # AdditionalDependencies="&quot;$(PERL5_LIB)&quot; libtidy.lib"
                    # OutputFile="Tidy.dll"
                    # LinkIncremental="1"
                    # SuppressStartupBanner="true"
                    # AdditionalLibraryDirectories="C:\Projects\Tidy\tidycvs\build\msvc\releaseDLL"
                    # ProgramDatabaseFile=".\Release/Tidy.pdb"
                    # ImportLibrary=".\Release/Tidy.lib"
                    # TargetMachine="1" />
                    @adld = ();
					for ($i = 0; $i < $ac; $i++) {
						$ln = $arr[$i];
                        # AdditionalLibraryDirectories="C:\Projects\Tidy\tidycvs\build\msvc\releaseDLL"
                        if ($ln =~ /AdditionalLibraryDirectories=/) {
                            $ind = index($ln,'"');
                            if ($ind > 0) {
                                $ln = strip_quotes(substr($ln,$ind));
                                @adld = space_split_local($ln);
                            }
                            last;
                        }
                    }
					for ($i = 0; $i < $ac; $i++) {
						$ln = $arr[$i];
                        if ($ln =~ /OutputFile=\"([\.\\\/\w]+)\"/) {
                            prt( "$vcprojcnt:$cfgcnt: Output = $1\n" ) if ($dbg50);
                        ###} elsif ($ln =~ /AdditionalDependencies="([&;\$\(\)\.\\\/\w]+)"/) {
                        } elsif ($ln =~ /AdditionalDependencies=/) {
                            $ind = index($ln,'"');
                            if ($ind > 0) {
                                $ln = strip_quotes(substr($ln,$ind));
                                @arr2 = space_split_local($ln);
                                prt( "$vcprojcnt:$cfgcnt: AdditionalDependencies = \n" ) if ($dbg52);
                                for (my $k = 0; $k < scalar @arr2; $k++) {
                                    $ln = $arr2[$k];
                                    $ln =~ s/&quot;/"/g;
                                    $ln = strip_quotes($ln);
                                    # eek, $key not yet done
                                    $wmsg = "$rnt: ";
                                    # if ti LOOKS like an ENVIRONMENT variable
                                    if ($ln =~ /^\$\((.+)\)/) {
                                        $tmp1 = $1;
                                        $tmp2 = $ENV{$tmp1};
                                        if (defined $tmp2) {
                                            $ln = $tmp2;
                                        }
                                    }
                                    $wmsg .= $ln;
                                    if (-f $ln) {
                                        $wmsg .= ' ok';
                                    } elsif (@adld) {
                                        foreach $tmp1 (@adld) {
                                            $tmp2 = $tmp1;
                                            $ch = substr($tmp1,-1);
                                            if (($ch ne '/')&&($ch ne "\\")) {
                                                $tmp2 .= "\\";
                                            }
                                            $tmp2 .= $ln;
                                            if (-f $tmp2) {
                                                $wmsg .= ' ok';
                                                last;
                                            }
                                        }
                                    }
                                    prt( "$wmsg\n" ) if ($dbg52);
                                }
                            } else {
                                prt( "$vcprojcnt:$cfgcnt: AdditionalDependencies = $ln\n" ) if ($dbg52);
                            }
                        }
                    }
				} elsif ($ln =~ /\s*Name=\"VCLibrarianTool\"\s*/ ) {
					if ($ln =~ /OutputFile=\"([\.\\\/\w]+)\"/) {
						prt( "$vcprojcnt:$cfgcnt: Output = $1\n" ) if ($dbg50);
					}
				}
			}
		} elsif ($infiles) {
			if ($line =~ /^<Filter\s+(.*)/) {
				# <Filter Name="Source Files" Filter="cpp;c;cxx;rc;def;r;odl;idl;hpj;bat" >
				$ln = $1;
				$grpname = '';
				$grpfilter = '';
				for ($i = 0; $i < $ac; $i++) {
					$ln = $arr[$i];
					if ($ln =~ /\s*Name=\"(.*)\"/) {
						$grpname = $1;
					} elsif ($ln =~ /\s*Filter=\"(.*)\"/) {
						$grpfilter = $1;
					}
				}
				prt( "Filter for \"$grpname\" = [$grpfilter]\n" ) if ($showfilter);
				$ingrp = 1;
			} elsif ($line =~ /^<\/Filter.*/) {
				$ingrp = 0;
			} elsif ($line =~ /^<File\s+(.*)/) {
				#<File RelativePath="sprtf.cxx" >
				$ln = $1;
				$grpfile = '';
				for ($i = 0; $i < $ac; $i++) {
					$ln = $arr[$i];
					if ($ln =~ /\s*RelativePath=\"(.*)\"/) {
						$grpfile = $1;
                        $ff = $fdir.$grpfile;
                        $msg = ((-f $ff) ? "ok" : "NOT FOUND");
				        prt( "File \"$grpfile\" $msg\n" ) if ($showfiles);
                        push(@vcsrcs, $ff);
                        push(@srcs,$grpfile);
                        last;
					}
				}
                prtw("WARNING: RelativePath NOT FOUND\n") if (length($grpfile) == 0);
			}
		}
	}
    prtw("WARNING: NO CONFIGURATIONS BLOCKS!!! file=$fil") if ($cfgcnt == 0);
    $cfgcnt = scalar @vcsrcs;
    prtw("WARNING: file=$fil has NO SOURCES!\n") if ($cfgcnt == 0);
    push(@src_list, [ $actname, [@vcsrcs], $fil, [@srcs] ]);
	return $cnt;
}

sub unix_2_dos {
	my ($f) = shift;
	$f =~ s/\//\\/g;
	return $f;
}

sub fix_rel {
	my ($path) = shift;
	$path = unix_2_dos( $path );
	my @a = split(/\\/, $path);
	my $npath = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				prtw( "WARNING: Got relative .. without previous!!!\n" );
			}
		} else {
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}

sub reline_xml {
	my (@lns) = @_;
	my ($i, $ln, $len, $j, $ch, $bgn, $end);
	my $cnt = scalar @lns;
	my $nline = '';
	my @nlines = ();
	for ($i = 0; $i < $cnt; $i++) {
		$ln = trim_all( $lns[$i] );
		$len = length($ln);
		for ($j = 0; $j < $len; $j++) {
			$ch = substr($ln,$j,1);
			$bgn = $i if (length($nline) == 0);
			$nline .= $ch;
			if ($ch eq '>') {
				$end = $i;
				push(@nlines, [$nline, $bgn, $end]);
				###prt( "push(\@nlines, [$nline, $bgn, $end])\n" );
				$nline = '';
			}
		}
		$nline .= ' ' if (length($nline));
	}
	push(@nlines, [$nline, $bgn, $end]) if length($nline);
	return @nlines;
}

sub xml_to_lines {
    my ($rlm, @lns) = @_;
    my $intag = 0;
    my $text = '';  # gather TEXT between tags
    my @nlines = ();
    my ($fln, $ln, $ch, $pch, $nch, $len, $i, $i2, $tag, $xml, $dnx);
    my ($lnnm, $lnb, $nlnm);
    my ($ppch, $incomm);
    my $show_comm_dbg = 0;
    $pch = '';
    $ppch = '';
    $nch = '';
    $tag = '';
    $xml = '';
    $dnx = 0;
    $lnnm = 0;
    $nlnm = 0;
    $lnb = 0;
    $incomm = 0;
    $text = ''; # start NO TEXT
    foreach $fln (@lns) {
        chomp $fln;
        $ln = trim_all($fln);
        $len = length($ln);
        $lnnm++;    # count another xml line
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($ln,$i,1);
            $nch = (($i2 < $len) ? substr($ln,$i2,1) : ' ');
            if ($intag) {
                # on first GREATER THAN - SPACE
                $tag .= $ch;
                if ($ch eq '>') {
                    if ( $incomm ) {
                        prt("$lnnm: potential end of XML tag pch=$pch ppch=$ppch\n") if ($show_comm_dbg);
                        if (($pch eq '-') && ($ppch eq '-')) {
                            $nlnm++;
                            push(@nlines,$tag);
                            ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                            $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                            $tag = '';
                            $intag = 0;
                            $xml = '';
                            $incomm = 0;
                            prt( "$lnnm: Exit comment [$ln]\n" ) if ($show_comm_dbg);
                        }
                    } else {
                        $nlnm++;
                        push(@nlines,$tag);
                        ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                        $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                        $tag = '';
                        $intag = 0;
                        $xml = '';
                        $incomm = 0;
                    }
                }
            } else {
                if ($ch eq '<') {
                    if (length($text)) {
                        $nlnm++;
                        push(@nlines,$text);
                        $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                        $text = '';
                    }
                    $tag = $ch; # start a tag line
                    $intag = 1; # signal in a tag
                    $xml = '';
                    $dnx = 0;
                    $lnb = $lnnm;    # set the BEGIN xml line
                    if ($nch eq '!') {
                        # but watch out for <!DOCTYPE ...>
                        if ($ln =~ /<!--/) {
                            prt( "$lnnm: Entering comment [$ln]\n" ) if ($show_comm_dbg);
                            $incomm = 1;
                        }
                    }
                } else {
                    $text .= $ch;
                }
            }
            $ppch = $pch;
            $pch = $ch;
        }
        # done a line - this is like a SPACE
        if ($intag && length($tag)) {
            $tag .= ' ' if !($tag =~ /(=|\s)$/);
        }
    }
    prtw("WARNING: Exit STILL in comment!\n") if ($incomm);
    if (length($tag)) {
        prtw("WARNING: xml re-lining error! Left pending tag [$tag]\nin $in_file file ...\n");
    }
    return @nlines;
}

sub rt_2_switch($) {
	my ($rt) = shift;
	if ($rt == 0) {
		return "Multi-threaded (/MT)";
	} elsif ($rt == 1) {
		return "Multi-threaded Debug (/MTd)";
	} elsif ($rt == 2) {
		return "Multi-threaded DLL (/MD)";
	} elsif ($rt == 3) {
		return "Multi-threaded Debug DLL (/MDd)";
	}
	return "rt=[$rt]???";
}

#########################################
### DSP handling

sub chkrt_strip_quotes {
	my ($ln) = shift;
	if ($ln =~ /^".*"$/) {
		$ln = substr($ln,1,length($ln)-2);
	}
	return $ln;
}

sub expand_mac {
	my ($m) = shift;
	if (defined $macros{$m}) {
		return $macros{$m};
	}
	return $m;
}

sub do_if_split {
	my ($ife) = shift;
	my @arr = split(/==/,$ife);
	my ($msg);
	if (scalar @arr == 2) {
		my $if0 = strip_quotes(trim_all($arr[0]));
		my $if1 = strip_quotes(trim_all($arr[1]));
		prt( "Split is [$if0] == [$if1]\n" ) if ($dbg6);
		if ($if0 =~ /^\$\((.+)\)$/) {
			my $mac = $1;
			my $emac = expand_mac($mac);
			if ($emac eq $if1) {
				prt( "Or [$emac] == [$if1] = TRUE\n" ) if ($dbg6);
				return "TRUE";
			} else {
				prt( "Or [$emac] == [$if1] = FALSE\n" ) if ($dbg6);
				return "FALSE";
			}
		}
	} else {
		$msg = "WARNING: Did NOT split! [$ife] - returning UNDETERMINED";
		prtw( "$msg\n" );
	}
	return "UNDETERMINED";
}

sub flip_state {
	my ($st) = shift;
	if ($st eq 'TRUE') {
		$st = 'FALSE';
	} elsif ($st eq 'FALSE') {
		$st = 'TRUE';
	}
	return $st;
}

sub clear_per_dsp {
	%macros = ();	# clear DSP macro set
	%dspmacros = ();
	$customdbg = '';
	$custonrel = '';
}

# scan the line, look for clues of the RUNTIME
# and other things ...
# it seems when MSVC8 loads and converts this MSVC6 file,
# it will DEFAULT to /MT or /MTd if nothing is found.
sub get_runtime {
	my ($txt) = shift;
	my $tl = length($txt);
	my $rt = 'Unknown';
	my $tag = '';
	###my $crt = 'S';
	my $crt = 'T';	# if NONE, default to this ...
	my $isdbg = -1;
	for (my $i = 0; $i < $tl; $i++) {
		my $ch = substr($txt,$i,1);
		if ($ch eq '/') {	# got SWITCH
			$i++;
			for ( ; $i < $tl ; $i++) {
				$ch = substr($txt,$i,1);
				if ($ch eq 'D') {	# got /D
					$i++;
					for ( ; $i < $tl ; $i++) {
						$ch = substr($txt,$i,1);
						if ($ch eq '"') {	# got PARAM
							$i++;
							$tag = '';
							for ( ; $i < $tl ; $i++) {
								$ch = substr($txt,$i,1);
								if ($ch eq '"') {
									last;	# exit next SPACE
								}
								$tag .= $ch;
							}
							if ($tag eq '_DEBUG') {
								$isdbg = 1;
							} elsif ($tag eq 'NDEBUG') {
								$isdbg = 0;
							}
							last;	# end /D "something"
						}
					}
				} elsif ($ch eq 'M') {	# got /M
					$i++;
					my $ccrt = '';
					for ( ; $i < $tl ; $i++) {
						$ch = substr($txt,$i,1);
						if ($ch eq 'D') {
							$crt = 'D';
							$ccrt = 'D';
						} elsif ($ch eq 'T') {
							$crt = 'T';
							$ccrt = 'T';
						} elsif ( ($ch eq 'd') && length($ccrt) ) {
							$isdbg = 1;
						} elsif ($ch =~ /\s/) {
							last;	# exit on SPACE
						}
					}
				}
			}
		}
	}
	if ($crt eq 'S') {
		$rt = 'Single-thread';
	} elsif ($crt eq 'D') {
		$rt = 'Multithreaded DLL';
	} else {
		$rt = 'Multithreaded';
	}
	if ($isdbg == 1) {
		$rt .= ' Debug';
	} elsif ($isdbg == 0) {
		$rt .= ' Release';
	}
	return $rt;
}

sub get_rtnum {
	my ($txt) = shift;
	my $rtn = 0;
	if ($txt =~ /DLL/) {
		if ($txt =~ /Debug/) {
			$rtn = 3;
		} else {
			$rtn = 2;
		}
	} else {
		if ($txt =~ /Debug/) {
			$rtn = 1;
		} else {
			$rtn = 0;
		}
	}
	return $rtn;
}

sub get_hyphen_split($) {
    my ($prop) = @_;
    my @arr = split("-",$prop);
    my $cnt = scalar @arr;
    for (my $i = 0; $i < $cnt; $i++) {
        $arr[$i] = trim_all($arr[$i]);
    }
    return @arr;
}

sub get_space_split_2($) {
    my ($cfg) = @_;
    my @arr = split(/\s/,$cfg);
    my $prj = $arr[0];
    my $cfnm = "";
    my $max = scalar @arr;
    if ($max > 1) {
        $cfnm = $arr[1];
        for (my $j = 2; $j < $max; $j++) {
            $cfnm .= ' ';
            $cfnm .= $arr[$j];
        }
    }
    my @narr = ();
    push(@narr,$prj);
    push(@narr,$cfnm);
    return @narr;
}

sub change_the_runtime($$$) {
    my ($fil,$rdlns,$rrtchg) = @_;   # \@dlns,\@rtchange;
    if (length($new_runtime)) {
        my ($lncnt,$key,$len,$i,$is_debug,$fline,$line,$val,$i2);
        $lncnt = scalar @{$rrtchg};
        if ($lncnt && (($new_runtime eq 'D')||($new_runtime eq 'T'))) {
            if ($new_runtime eq 'D') {
                $key = '/MD';
            } elsif ($new_runtime eq 'T') {
                $key = '/MT';
            }
            prt("Changing RUNTIME to [$key] ($new_runtime), on $lncnt lines...\n");
            $len = 0;
            for ($i = 0; $i < $lncnt; $i++) {
                $i2 = ${$rrtchg}[$i][0];
                $is_debug = ${$rrtchg}[$i][1];
                $fline = ${$rdlns}[$i2];	# extract the LINE
                $line = $fline;
                if ($new_runtime eq 'D') {
                    $key = '/MD';
                    $val = '/MT';
                } elsif ($new_runtime eq 'T') {
                    $key = '/MT';
                    $val = '/MD';
                }
                if ($is_debug == 1) {
                    $key .= 'd';
                    $val .= 'd';
                }
                $fline =~ s/$val/$key/;
                if ($line ne $fline) {
                    ${$rdlns}[$i2] = $fline;
                    $len++;
                }
            }
            if ($len) {
                $key = $perl_root."\\temp$tot_dsp_count.dsp";
                write2file(join("",@{$rdlns})."\n",$key);
                prt("Written changed $len lines to [$key]...\n");
                $update_bat .= "\@copy $key $fil\n";
            } else {
                prtw("WARNING: Processed $lncnt lines, BUT NO CHANGES made!\n");
            }
        } else {
            if ($lncnt) {
                prtw("WARNING: No RUNTIME change, due new_runtime not 'T' or 'D'! It is [$new_runtime]\n");
            } else {
                prtw("WARNING: No RUNTIME lines found, so no change to [$new_runtime]!\n");
            }
        }
    }
}

# =========================================================
# Load a DSP file
# ===============
sub load_dsp {
	my ($f) = shift;
	my @dlns = ();
	my $lncnt = 0;
	my @dsrcs = ();
    my @srcs = ();
	my $msg = '';
	if (open FH, "<$f") {
		@dlns = <FH>;
		close FH;
		$lncnt = scalar @dlns;
		prt( "File $f contains $lncnt lines ...\n" ) if ($dbg11);
	} else {
		$msg = "WARNING: FAILED to OPEN [$f] ... $! ...";
		prtw( "$msg\n" );
    	return @dsrcs;
	}
    $tot_dsp_count++;
	my $intarg = 0;
	my @arr = ();
	my $intrue = 0;
	my $inanif = 0;
	my $package = '';
	my $insrc = 0;
	my $group = '';
	my $ifstate = "INDETERMINATE";
	my $prop = '';
	my $ifstr = '';
	my $form = '';
	my $rtdebug = '';
	my $rtrelease = '';
	my $targtyp = '';
	my $targw = '';
	my ($rt, $rtc, $rngdbg, $rngrel, $rtn, $rtdbg, $rtrel, $wmsg);
	my ($dsp_name, $dsp_dir) = fileparse( $f );
	clear_per_dsp();	# like %macros = ();	# clear DSP macro set etc
    my ($i,$fline,$line,$ccnt,$prj,$cfg,$wtyp,$cfnm,$max,$j,$cc,$i2);
    my ($is_debug);
    $ccnt = 0;
    $prj = '';
    my %cfghash = ();
    my %cfghash2 = ();
    my @rtchange = ();  # list of (DSP) RUNTIME lines to CHANGE

    # pre-process
    # Begin Target
    # Name "testap6 - Win32 Release"
    # Name "testap6 - Win32 Debug"
    # Name "testap6 - Win32 Debug_MD"
    # Name "testap6 - Win32 Release_MD"
    $intarg = 0;
    for ($i = 0; $i < $lncnt; $i++) {
        $i2 = $i + 1;
		$fline = $dlns[$i];	# extract the LINE
		chomp $fline;
		$line = trim_tail($fline);
        if ($intarg) {
            if ($line =~ /^#\s+End\s+Target/) {
                $intarg = 0;
            } elsif ($line =~ /^#\s+Name\s+"(.+)"/) {
                $prop = $1;
                @arr = get_hyphen_split($prop);
                $ccnt++;
                if (length($prj)) {
                    if ($prj ne $arr[0]) {
                        prtw("WARNING: Next project name $arr[0] NOT same as [$prj]\n");
                    }
                } else {
                    $prj = $arr[0];
                }
                $cfg = $arr[1];
                @arr = get_space_split_2($cfg);
                $wtyp = $arr[0];
                $cfnm = $arr[1];
                $cc = $wtyp."|".$cfnm;
                prt("[$cc]\n") if ($dbg56);
                if (defined $cfghash{$cc}) {
                    prtw("WARNING: [$cc] already exists...\n");
                } else {
                    $cfghash{$cc} = 1;
                }
            }
        } else {
            if ($fline =~ /^#\s+Begin\s+Target/) {
                $intarg = 1;
            } else {
                # ignore these messages
                # !MESSAGE "testap6 - Win32 Release" (based on "Win32 (x86) Console Application")
                # !MESSAGE "testap6 - Win32 Debug" (based on "Win32 (x86) Console Application")
                # !MESSAGE "testap6 - Win32 Debug_MD" (based on "Win32 (x86) Console Application")
                # !MESSAGE "testap6 - Win32 Release_MD" (based on "Win32 (x86) Console Application")

                # pick up on the IF
                # !IF  "$(CFG)" == "testap6 - Win32 Release"
                # !ELSEIF  "$(CFG)" == "testap6 - Win32 Debug"
                # !ELSEIF  "$(CFG)" == "testap6 - Win32 Debug_MD"
                # !ELSEIF  "$(CFG)" == "testap6 - Win32 Release_MD"
                # !ENDIF 
                if ($fline =~ /^!(I|E){1}(F|L|N){1}.+\s+==\s+"(.+)"/) {
                    prt("[$1][$2] - $fline [$3]\n") if ($dbg55);
                    $prop = $3;
                    @arr = get_hyphen_split($prop);
                    $ccnt++;
                    if (length($prj)) {
                        if ($prj ne $arr[0]) {
                            prtw("WARNING: Next project name $arr[0] NOT same as [$prj]\n");
                        }
                    } else {
                        $prj = $arr[0];
                    }
                    $cfg = $arr[1];
                    @arr = get_space_split_2($cfg);
                    $wtyp = $arr[0];
                    $cfnm = $arr[1];
                    $cc = $wtyp."|".$cfnm;
                    prt("[$cc]\n") if ($dbg56);
                    if (defined $cfghash2{$cc}) {
                        prtw("WARNING: [$cc] already exists...\n");
                    } else {
                        $cfghash2{$cc} = 1;
                    }
                }
            }
        }
    }
    $intarg = 0;
    $is_debug = 2;
	for ($i = 0; $i < $lncnt; $i++) {
        $i2 = $i + 1;
		$fline = $dlns[$i];	# extract the LINE
		chomp $fline;
		$line = trim_tail($fline);
	    if ( $line =~ /$COMMENT_PATTERN/ ) {
			# starts with '#'
			$line = substr($line,1);
			if ($line =~ /\s+Microsoft\s+Developer\s+Studio\s+Project\s+File\s-\sName="(\w+)"\s+/ ) {
				$package = $1;
				$projcount++;
			} elsif ($line =~ /Microsoft Developer Studio Generated Build File, Format Version 6.00/) {
				# ignored
			} elsif ($line =~ /\*\* DO NOT EDIT \*\*/) {
				# ignored
			} elsif ($line =~ /^\s+TARGTYPE\s+"(.*)"\s+/) {
				# # TARGTYPE "Win32 (x86) Console Application" 0x0103
				$targtyp = $1;
				@arr = split(/\s/, $targtyp);
				$targw = $arr[0];
				prt( "$package TARGET: $targtyp\n" );
			} elsif ($line =~ /^\s+Begin\s+Target/) {
				$intarg = 1;
			} elsif ($line =~ /^\s+End\s+Target/) {
				$intarg = 0;
            } elsif ($line =~ /^\s+Begin\s+Group\s+(.+)/) {
				# like "Source Files"
				$group = strip_quotes($1);
				prt( "Begin Group: $1\n" ) if ($dbg10);
            } elsif ($line =~ /^\s+End\s+Group/) {
				$group = '';
			} elsif ($line =~ /\s*Begin\s+Project/ ) {

			} elsif ($line =~ /\s*End\s+Project/ ) {

			} elsif ($line =~ /Begin\s+Special\s+Build\s+Tool/) {

			} elsif ($line =~ /End\s+Special\s+Build\s+Tool/) {

			} elsif ($line =~ /\s*Name\s+(.+)/) {

			} elsif ($line =~ /\s*Begin\s+Source\s+File/) {
				$insrc = 1;
			} elsif ($line =~ /\s*End\s+Source\s+File/) {
				$insrc = 0;
			} elsif ($line =~ /\s*PROP\s+(.*)/) {
				# like '# PROP BASE Use_Debug_Libraries 1'
				$prop = $1;
				if ($prop =~ /\s*BASE\s+(.*)/) {
					$prop = $1;
				}
				if ($prop =~ /Use_Debug_Libraries\s+(\d+)/) {
					prt( "Use_Debug_Libraries $1\n" ) if ($dgb32);
				}
				if ($excl_excluded && $insrc) {
					# PROP Exclude_From_Build 1
					if ($prop =~ /Exclude_From_Build\s+(\d+)/) {
						if ($1) {
							if (@dsrcs) {
								my $ls = pop(@dsrcs);
								push(@discardedsrcs, [$ls, $package, $f]);
								prt( "Discarding [$ls] due to Exclude_From_Build ...\n" ) if ($dbg30);
							}
                            pop @srcs if (@srcs);
						}
					}
				}
			} elsif ($line =~ /\s*ADD\s+(.*)/) {
				# like '# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D
				# and '# ADD CPP /nologo /MDd ...
				$prop = $1;
                if (($line =~ /ADD\s+BASE\s+/) && ($i2 < $lncnt) && ($dlns[$i2] =~ /ADD\s+CPP\s+/)) {
                    # NEXT line for saving the RUNTIME - NOT THIS BASE
                    next;   # just use the NEXT line
                }
				if ($prop =~ /\s*BASE\s+(.*)/) {
					$prop = $1;
				}
				if ($prop =~ /CPP\s+(.*)/) {
					$rt = $1;
					$rtc = get_runtime($rt);
					$rtn = get_rtnum($rtc);
                    if (defined $rthash{$rtn}) {
                        $rthash{$rtn}++;
                    } else {
                        $rthash{$rtn} = 1;
                    }
                    push(@rtchange,[$i,$is_debug]); # save RUNTIME line to change
					prt( "RUNTIME: $form $rt\n" ) if ($dgb33);
					if ($form eq 'Debug') {
						$rtdebug = $rtc;
						$rngdbg = $i + 1;
						$rtdbg = $rtn;
					} elsif ($form eq 'Release') {
						$rtrelease = $rtc;
						$rngrel = $i + 1;
						$rtrel = $rtn;
					}
                    $cfghash2{$cc} = $rtc;
				}
			} elsif ($line =~ /\s*SUBTRACT\s+(.*)/) {
				$prop = $1;
			} elsif ($line =~ /\s*Begin\s+Custom\s+Build(.*)/) {
				$msg = $1;
				$i++;
				for (; $i < $lncnt; $i++) {
					$fline = $dlns[$i];	# extract the LINE
					chomp $fline;
					$line = trim_tail($fline);
					$msg .= "\n$fline";
					if ($line =~ /\s*End\s+Custom\s+Build/) {
						last;
					}
				}
			} else {
				$msg = "WARNING: Line [$line] not handled!";
				prtw("$msg\n");
			}
        } elsif ($line =~ /^!/ ) {
			# starts with '!'
            if ($fline =~ /^!(I|E){1}(F|L|N){1}.+\s+==\s+"(.+)"/) {
                prt("[$1][$2] - $fline [$3]\n") if ($dbg55);
                $prop = $3;
                @arr = get_hyphen_split($prop);
                $ccnt++;
                if (length($prj)) {
                    if ($prj ne $arr[0]) {
                        prtw("WARNING: Next project name $arr[0] NOT same as [$prj]\n");
                    }
                } else {
                    $prj = $arr[0];
                }
                $cfg = $arr[1];
                @arr = get_space_split_2($cfg);
                $wtyp = $arr[0];
                $cfnm = $arr[1];
                $cc = $wtyp."|".$cfnm;
                prt("[$cc]\n") if ($dbg56);
                if (defined $cfghash2{$cc}) {
                    #prt("Found [$cc] in hash...\n");
                } else {
                    $cfghash2{$cc} = 1;
                    prtw("WARNING: Adding [$cc] to hash - NOT SEEN BEFORE here\n");
                }
                if ($fline =~ /Debug/i) {
                    $is_debug = 1;
                } elsif ($fline =~ /Release/i) {
                    $is_debug = 0;
                } else {
                    $is_debug = 2;
                    prtw("WARNING: Could NOT find 'Debug', or 'Release' in [$fline]\n");
                }
            }
			$line = substr($line,1);
			if ($line =~ /^IF\s+(.*)/ ) {
				#' "$(CFG)" == "xmlrpc_sample_add_server - Win32 Release"
				$ifstr = $1;
				$ifstate = do_if_split($ifstr);
				$msg = "Entered IF [$ifstr] ";
				$msg .= $ifstate;
				if ($ifstr =~ /"\$\(CFG\)"/ ) {
					if ($ifstr =~ /\s+-\s+Win32\s+(.*)"/) {
						$form = $1;
						$msg .= " $form ";
					}
				}
				$inanif++;
				prt( "$msg $inanif\n" ) if ($dbg8);
			} elsif ($line =~ /^ELSEIF\s+(.*)/ ) {
				$ifstr = $1;
				$ifstate = do_if_split($ifstr);
				$msg = "Entered ELSEIF [$ifstr] ";
				$msg .= $ifstate;
				if ($ifstr =~ /"\$\(CFG\)"/ ) {
					if ($ifstr =~ /\s+-\s+Win32\s+(.*)"/) {
						$form = $1;
						$msg .= " $form ";
					}
				}
				prt( "$msg $inanif\n" ) if ($dbg8);
			} elsif ($line =~ /^ELSE\s*/ ) {
				$ifstate = flip_state($ifstate);
				prt( "Entered ELSE [$line]\n" ) if ($dbg8);
			} elsif ($line =~ /^ENDIF\s*/ ) {
				prt( "Out IF with ENDIF\n" ) if ($dbg8);
				$inanif = 0;
				$ifstate = 'OUTIF';
			} elsif ($line =~ /^MESSAGE\s*/ ) {
				#prt( "MESSAGE LINE ...\n" );
			} else {
				$msg = "WARNING: What is THIS [$fline]??? in [$f]";
				prtw( "$msg\n" );
			}
		} elsif ($intarg) {
			if( $line =~ /^SOURCE=(.+)/ ) {
				$line = strip_quotes($1);
				my $ff = fix_rel($dsp_dir . $line);
				if (($line =~ /\.cxx$/i) || ($line =~ /\.c$/i) || ($line =~ /\.cpp$/i)) {
					push(@dsrcs, $ff);
                    push(@srcs,$line);
				} else {
					if ( !(($line =~ /\.hxx$/i) || ($line =~ /\.h$/i) || ($line =~ /\.hpp$/i)) ) {
						if ($dbg31) {
							$msg = "WARNING: CHECK Discarded [$fline]";
							prtw( "$msg\n" );
						}
					}
				}
			}
		} else {
			# NOT in Begin Target yet
			if ($line =~ /$MACRO_PATTERN2/) {
				if (defined $macros{$1}) {
					if ($macros{$1} ne $2) {
						if ($dbg34) {
							$msg = "WARNING: Duplicated MACRO $1, now $2, was $macros{$1} ...";
							prtw( "$msg\n" );
						}
					}
				} else {
					$macros{$1} = $2;
					prt( "SET: MACRO $1, to $2 ...\n" ) if ($dbg9);
				}
			}
		}
	}
    my ($key,$min,$len,$val);
    $min = 0;
    foreach $key (keys %cfghash2) {
        $len = length($key);
        $min = $len if ($len > $min);
    }
    foreach $key (keys %cfghash2) {
        $val = $cfghash2{$key};
        $key .= ' ' while (length($key) < $min);
        prt("$package [$key] = $val\n");
    }

	$lncnt = scalar @dsrcs;
	prt( "File $f contains $lncnt SOURCES ...\n" ) if ($dbg11);
    prtw("WARNING: File $f has NO SOURCES!\n") if ($lncnt == 0);
    push(@src_list, [ $package, [@dsrcs], $f, [@srcs] ]);

    change_the_runtime($f,\@dlns,\@rtchange);

	return @dsrcs;
}

##################
### utils
sub trim_tail {
	my ($ln) = shift;
	while ($ln =~ /\s$/) {
		$ln = substr($ln,0,length($ln) - 1); # remove all TRAILING space
	}
	return $ln;
}


sub show_runtimes {
	prt( "\nIn $projcount projects, found following runtimes ...\n" );
	my ($ky, $rt, $be, $min, $len, $msg, $fi, $lastfil, @arr, $lastpj, $i);
    my $rmsg = '';
    my %rtimes = ();
	$min = 0;
    $lastfil = '';
    $lastpj = '';
    $rt = '';
	foreach $ky (keys %runtimes) {
		$rt = $runtimes{$ky};
        if (! defined $rt) {
            pgm_exit(1,"WHAT: key=[$ky] DOES NOT HAVE RUNTIME!!!\n");
        }
		if (($rt == 0)||($rt == 1)) {
			$mtrts++;
		} elsif (($rt == 2)||($rt == 3)) {
			$dllrts++;
		} else {
			$otherrts++;
		}
		$len = length($ky);
		$min = $len if ($len > $min);
	}
	if ($otherrts) {
		$rmsg = "Got $otherrts OTHER RUNTIMES??? MT=$mtrts MD=$dllrts";
	} else {
		if ($mtrts && ($dllrts == 0)) {
			$rmsg = "Got ALL MT RUNTIMES ($mtrts)";
		} elsif ( $dllrts && ($mtrts == 0) ) {
			$rmsg = "Got ALL MD RUNTIMES ($dllrts)";
		} elsif ( ($dllrts == 0) && ($mtrts == 0)) {
			$rmsg = "Got NO RUNTIMES!";
		} else {
			$rmsg = "Got MIXED RUNTIMES - MT=$mtrts MD=$dllrts";
		}
	}

    prt( "$rmsg\n" );

	foreach $ky (sort keys( %runtimes )) {
        @arr = split(/\|/,$ky);
        if ($arr[0] eq $lastpj) {
            $msg = ' ';
    		$msg .= ' ' while (length($msg) < length($lastpj));
            for ($i = 1; $i < scalar @arr; $i++) {
                $msg .= '|';
                $msg .= $arr[$i];
            }
        } else {
            $msg = $ky;
        }
        $lastpj = $arr[0];
		$msg .= ' ' while (length($msg) < $min);
        # extract values
        # ======================================
		$rt = $runtimes{$ky};
		$be = $rtlines{$ky};
		$fi = $rtfiles{$ky};
        # ======================================
		$msg .= " = ".rt_2_switch($rt);
		$msg .= ' ' while (length($msg) < ($min+3+28));
		$msg .= " ($be) ";
		$msg .= ' ' while (length($msg) < ($min+3+28+12));
        $msg .= $fi if ($lastfil ne $fi);
		prt( "$msg\n" );
        $lastfil = $fi;
        if (defined $rtimes{$rt}) {
            $rtimes{$rt}++;
        } else {
            $rtimes{$rt} = 1;
        }
	}
	prt("\n");

    return $rmsg;
}

sub show_rthash() {
    my ($k,$r);
    $r = scalar keys(%rthash);
    prt("Total DSP files = $tot_dsp_count... ") if ($tot_dsp_count);
    prt("Total VCPROJ files = $tot_vcproj_count... ") if ($tot_vcproj_count);
    prt("Got $r keys in rthash...\n");
    foreach $k (sort keys %rthash) {
        $r = $rthash{$k};
        prt("RT $k (".rt_2_switch($k).") = $r\n");
    }
}

# ===========================================
# MAIN #
# ==========================================

parse_args(@ARGV);

if (length($in_file) == 0) {
    pgm_exit(1,"ERROR: No input file located in command!\n");
}
if (! -f $in_file) {
	pgm_exit(1,"ERROR: Unable to locate [$in_file] file ...\n" );
}

if (@sln_set && $do_set) {
	foreach $in_file (@sln_set) {
		($fil_nm,$fil_dir,$fil_ext) = fileparse( $in_file, qr/\.[^.]*/ );
		if (lc($fil_ext) eq '.dsw') {
			process_dsw( $in_file );
		} elsif (lc($fil_ext) eq '.dsp') {
			process_dsp( $in_file );
		} elsif (lc($fil_ext) eq '.sln') {
			process_sln( $in_file );
		} elsif (lc($fil_ext) eq '.vcproj') {
			process_vcproj( $in_file );
		} elsif (lc($fil_ext) eq '.csproj') {
			$wrnmsg = "WARNING: Input file [$in_file] is C#, NOT handled ...";
			prtw( "$wrnmsg\n" );
		} else {
			$wrnmsg = "WARNING: Input file [$in_file] NOT of know extension ...";
			prtw( "$wrnmsg\n" );
		}
	}
} else {
	($fil_nm,$fil_dir,$fil_ext) = fileparse( $in_file, qr/\.[^.]*/ );
	if (lc($fil_ext) eq '.dsw') {
		process_dsw( $in_file );
	} elsif (lc($fil_ext) eq '.dsp') {
		process_dsp( $in_file );
	} elsif (lc($fil_ext) eq '.sln') {
		process_sln( $in_file );
	} elsif (lc($fil_ext) eq '.vcproj') {
		process_vcproj( $in_file );
	} elsif (lc($fil_ext) eq '.csproj') {
		$wrnmsg = "WARNING: Input file [$in_file] is C#, NOT handled ...";
		prtw( "$wrnmsg\n" );
	} else {
		$wrnmsg = "WARNING: Input file [$in_file] NOT of know extension ...";
		prtw( "$wrnmsg\n" );
	}
}
foreach my $key (keys %dswprojs) {
	$in_file = $dswprojs{$key};
	process_dsp($in_file);
}


##my $rtmsg = show_runtimes();

show_sources() if ($show_srcs);

##prt( "To repeat: $rtmsg\n" );
show_rthash();

if (length($update_bat)) {
    $in_file = $perl_root."\\tempupd.bat";
    if (-d 'C:\MDOS') {
        $in_file = 'C:\MDOS\tempupd.bat';
    }
    write2file("\@echo Copy updated DSP file(s) to destination?\n".
        "\@echo BE WARNED! Will OVERWRITE EXISTING!\n".
        "\@pause\n".
        "\@echo ARE YOU VERY SURE? LAST CHANCE!! Ctrl+C to abort\n".
        "\@pause\n".
        "$update_bat",$in_file);
    prt("\nTo UPDATE to changed DSP file(s), use [$in_file]\n\n");
}

pgm_exit(0,"Normal End");

####################
sub give_help {
    prt("$pgmname: version 0.0.3 2010-07-03\n");
    prt("Usage: $pgmname [options] input_file\n");
    prt("Options:\n");
    prt(" --help (-h -?) = This help, and exit 0\n");
    prt(" -l             = Load log at end.\n");
    prt(" -s             = Show source files.\n");
    prt(" -r(T|D)        = Change RUNTIME T=(/MT|/MTd) D=(/MD|/MDd).\n");
    prt("Read input file as MSVC solution type file, and show the truntime.\n");
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while(@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg =~ /^\?/)) {
                give_help();
                pgm_exit(0,"Help Exit");
            } elsif ($sarg =~ /^s/i) {
                #$showfiles = 1;
                $show_srcs = 1;
            } elsif ($sarg =~ /^l/i) {
                $load_log = 1;
            } elsif ($sarg =~ /^r(T|D)$/i) {
                $new_runtime = uc($1);
            } else {
                pgm_exit(1,"ERROR: Unknown [$arg]! Try -?\n");
            }
        } else {
            if (length($in_file)) {
                prt("Already have input file [$in_file]!\n");
                pgm_exit(1,"ERROR: Unknown additional bare argument [$arg]!\n");
            }
            $in_file = File::Spec->rel2abs($arg);
            $dbg_inp = 0;
            prt("Set input file to [$in_file]\n");
        }
        shift @av;
    }

    if ($dbg_inp && length($def_file) && (-f $def_file)) {
        $in_file = $def_file;
        prt("Set input file to DEFAULT [$in_file]\n");
    }
}


# eof - chkrt.pl
