#!/perl -w
# NAME: cleandiff02.pl
# AIM: To remove some things from an input diff file ...
# 1 - remove Only in blah blah ...
# 2 - remove diff of .dsw, .dsp, .sln, .vcproj files ...
# and write results to an output file
use strict;
use warnings;
use Cwd;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:/GTools/perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# features
my $load_log = 0;   # load log file at end
my $keep_only_in = 1;

# program variables
my $in_file  = 'bigdiff2.txt';
my $out_file = 'bigdiff1.txt';

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    prt( "$msg" ) if (length($msg));
    close_log($outfile,$load_log);
    exit($val);
}

sub give_help {
	prt( "Brief HELP for $pgmname script ...\n" );
	prt( "$pgmname [options] -in:input_file -out:output_file\n" );
    prt( "options:\n" );
    prt( " -ko      - Keep 'Only in ...' lines, and add to end.\n" );
    prt( " -ll      - Load log at end.\n" );
	prt( "Defaults: in:$in_file, out:$out_file\n" );
    prt( "Will exit if error found in command!\n" );
}

sub is_excluded_file($) {
    my ($tx) = @_;
    # exclude MSVC make files
    return 1 if ($tx =~ /\.dsp$/i);
    return 2 if ($tx =~ /\.dsw$/i);
    return 3 if ($tx =~ /\.sln$/i);
    return 4 if ($tx =~ /\.vcproj$/i);
    # exclude SVN, CVS, git directory items
    return 5 if ($tx =~ /(\\|\/)\.svn(\\|\/)/);
    return 6 if ($tx =~ /(\\|\/)CVS(\\|\/)/);
    return 7 if ($tx =~ /(\\|\/)\.git(\\|\/)/);
    return 0;
}

sub process_file($) {
	my ($fil) = @_;
	my (@lines, $line, $lncnt, $i, $txt, $lnnum);
	my @nlines = ();
    my @only = ();
	my $newlns = 0;
    my ($res,$proj);
    $proj = '';
	if (open INF, "<$fil") {
		@lines = <INF>;
		close INF;
		$lncnt = scalar @lines;
		prt( "Process $lncnt lines from $fil ...\n" );
		$lnnum = 0;
		for ($i = 0; $i < $lncnt; $i++) {
			$line = $lines[$i];
			chomp $line;
			$lnnum++;
			if ( $line =~ /^diff\s+.+/ ) {
                $res = is_excluded_file($line);
                if ($res) {
                    $i++;
                    # stay here, eating lines, until next NOT excluded item
                    for (; $i < $lncnt; $i++) {
                        $line = $lines[$i];
                        chomp $line;
                        if ($line =~ /^diff\s+.+/) {
                            $res = is_excluded_file($line);
                            last if ( !$res );
                        }
                    }
                    last if ($i == $lncnt);
                }
			} elsif ($line =~ /^Only\s+in\s+/) {
                if ($keep_only_in) {
                    $res = is_excluded_file($line);
                    push(@only,$line) if ($res < 5);   # EXCLUDE \.git\, \.svn\, etc... lines
                }
                next;
            } elsif ($line =~ /^=================(=+)\s(\w+)/) {
                $proj = $2;
                if ($keep_only_in) {
                    push(@only,$line);
                }
            }
			push(@nlines,$line);
			$newlns++;
		}
        if ($keep_only_in) {
            push(@nlines, @only);
        }
	} else {
		prt( "ERROR: Unable to OPEN/READ file $fil ... check name, location...\n" );
	}
    return \@nlines;    # return the array reference
}

sub write_out_lines($$) {
    my ($rnls,$out) = @_;
    my $cnt = scalar @{$rnls};
    if ($cnt) {
        my $txt = join("\n",@{$rnls});
        $txt .= "\n";
        write2file($txt,$out);
        prt("Written $cnt lines to $out...\n" );
    }
}

# =======================================
# MAIN

parse_args(@ARGV);
my $ref_lines = process_file($in_file);
write_out_lines($ref_lines,$out_file);
pgm_exit(0,"Normal exit\n");

# =======================================

sub parse_args {
	my (@av) = @_;
	my ($arg, $ch, $val);
	while(@av) {
		$arg = shift @av;
		$ch = substr($arg,0,1);
		if ($arg =~ /\?/) {
			give_help();
        	pgm_exit(0,"Help exit\n");
		} elsif (($ch eq '-')||($ch eq '/')) {
			$val = substr($arg,1);
            if (($val eq 'h')||($val eq '-help')) {
                give_help();
            	pgm_exit(0,"Help exit\n");
            } elsif ($val =~ /^in:/) {
				$in_file = substr($val,3);
				prt( "Set input file to $in_file ...\n" );
			} elsif ($val =~ /^out:/) {
				$out_file = substr($val,4);
				prt( "Set output file to $out_file ...\n" );
            } elsif ($val eq 'ko') {
                $keep_only_in = 1;
				prt( "Set to keep only in lines...\n" );
            } elsif ($val eq 'll') {
                $load_log = 1;
				prt( "Set to load log at end...\n" );
			} else {
				prt( "ERROR: Unknown argument [$arg]!\n" );
				give_help();
            	pgm_exit(1,"Error exit\n");
			}
		} else {
			prt( "ERROR: Unknown argument [$arg]!\n" );
			give_help();
        	pgm_exit(1,"Error exit\n");
		}
	}
    if ( ! -f $in_file) {
        prt( "ERROR: Unable to locate [$in_file] file! Aborting...\n" );
       	pgm_exit(1,"No file exit\n");
    }
}

# eof - cleandiff02.pl
