#! /perl -w 
# client1.pl - a simple client 
#---------------- 

use strict; 
use Socket; 

my $start_time = time();
my $hdr = 'CLIENT:';
print "$hdr Client1.pl started on " . localtime($start_time);
# initialize [host [and port]], if GIVEN, else DEFAULT to
my $host = shift || 'localhost'; 
my $port = shift || 7890; 
print "$hdr Set host=$host, port=$port ... via tcp ...\n";
my $proto = getprotobyname('tcp'); 

# get the port address 
my $iaddr = inet_aton($host); 
my $paddr = sockaddr_in($port, $iaddr); 
# create the socket, connect to the port 
print "$hdr Creating socket ...\n";
socket(SOCKET, PF_INET, SOCK_STREAM, $proto) or die "socket: $!";
print "$hdr Connecting to socket ...\n";
connect(SOCKET, $paddr) or die "connect: $!"; 
print SOCKET "$hdr HI!\n" or die "print: $!";

my $line; 
print "$hdr Reading socket ...\n";
while ($line = <SOCKET>) { 
	print "$hdr recv[$line]\n"; 
} 

print "$hdr Closing socket ...\n";
close SOCKET or die "close: $!"; 

print "$hdr Client1.pl closing on " . localtime(time());

# EOF
