#!/perl -w
# cross-platform example8, use LF-only on Un*x

use strict;
use vars qw( $OS_win $ob $file );

BEGIN {
        $OS_win = ($^O eq "MSWin32") ? 1 : 0;
        if ($OS_win) {
            eval "use Win32::SerialPort 0.11";
	    die "$@\n" if ($@);
        }
        else {
            eval "use Device::SerialPort";
	    die "$@\n" if ($@);
        }
} # End BEGIN

### $file = 'tpj4.cfg';
$file = 'comm5.txt';

if ($OS_win) {
    $ob = Win32::SerialPort->start ($file);
}
else {
    $ob = Device::SerialPort->start ($file);
}
die "Can't open serial port from $file: $^E\n" unless ($ob);
print "Open serial port from $file ....\n";

my $baud = $ob->baudrate(1200);
print "baud for background demo: $baud\n";

$ob->read_interval(0) if ($OS_win);
$ob->read_const_time(10000);

$ob->write("ATE0X4\r");
sleep 1;
my $result = $ob->input;
print "result = $result\n";

$ob->write("AT&V\r");
print "Starting 500 character background read\n";
my $in;
$in = $ob->read_bg(500) if ($OS_win);
my $done = 0;
my $blk;
my $err;
my $out;
for (;;) {
    ($blk, $in, $out, $err)=$ob->status;
    print "got $in characters so far..\n";
    sleep 1;
    ($done, $in, $result) = $ob->read_done(0) if ($OS_win);
    last if $done;
    last if ($in >= 500);
}

if ($OS_win) {
    print "got = $in\nresult = $result\n";
    $baud = $ob->baudrate(38400);
    sleep 2;
    $result = $ob->input;
}
else {
    my $active = $ob->input;
    print "result = $active\n";
    sleep 1;
    $active = $ob->input;
    $result = "";
    while ($active) {
	$result .= $active;
	sleep 1;
	$active = $ob->input;
    }
}
print "\n\n....And now the rest = \n$result\n";

undef $ob;


