#!/usr/bin/perl
##############################################################################
# Visitor Counter                        Version 2.51                        #
# Copyright 1998-99, UtilMind Solutions  info@utilmind.com                   #
#                                        http://www.utilmind.com             #
# Created: Nov 3, 1998-99                Last Modified: May 03, 2000         #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998-99, UtilMind Solutions  All Rights Reserved.                #
#                                                                            #
# VisCounter may be used and modified free of charge by anyone so long as    #
# this copyright notice and the comments above remain intact.  By using this #
# code you agree to indemnify UtilMind Solutions from any liability that     #
# might arise from it's use.                                                 #
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try and  #
# make money off of our programs.                                            #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.	In all cases copyright and header must remain intact.#
##############################################################################
# Set Variables
$counterfile	= 'counter.txt';

# Get the input
$link = $ENV{'DOCUMENT_URI'};

# Begin Code
open(FILE, $counterfile) || die Can't locate counter file $!;
@DATA = <FILE>;
close(FILE);
$SIZE = @DATA;

if ($SIZE eq 0) {
  $counter = '?';
  &LocateLink;
}

foreach $entry (@DATA) {
  ($counter, $baselink) = split(/'/, $entry);
  chomp($baselink);

  &UpdateStats if ($baselink eq $link);
}

# Add new link to database file
open(FILE, ">>$counterfile") || die Can't locate database file $!;
print FILE "1'$link\n"; # First time
close(FILE);

$counter = '1';

&LocateLink;

# Increase through-link counter
sub UpdateStats {
   $counter++;
   $entry = "$counter'$baselink\n";

   @DATA = sort {($b =~ /(\d+)/)[0] <=> ($a =~ /(\d+)/)[0]} @DATA;

   $tmpfilename = "$counterfile\.$link";
   $tmpfilename =~s/\///g;

   open(FILE, ">$tmpfilename") || die Can't locate database file $!;
   print FILE @DATA;
   close(FILE);
   rename("$tmpfilename", $counterfile);

   &LocateLink;
}

sub LocateLink {
  print "Content-Type: text/html\n\n";
  print $counter;
  exit;
}