#!/Perl
# Currency ISO - ISO 4217?
# ISO' => 'Country'
# The three-character codes are constructed by taking the two-character ISO-3166 country code
# (known as ISO-3166-Alpha-2) and appending a single letter symbolizing the name of the currency
# (e.g., Mexican peso MX+P = MXP; Mexican nuevo peso MX+N = MXN). In most cases, the numeric 
# currency code is identical to the numeric ISO-3166 country code. 
my %CurrencyISO = (
'AED' => 'United Arab Emirates :Dirhams',
'AFA' => 'Afghanistan :Afghanis',
'ALL' => 'Albania :Leke',
'AMD' => 'Armenia :Drams',
'ANG' => 'Netherlands Antilles :Guilders',
'AOA' => 'Angola :Kwanza',	# ISO 4217???
'ARS' => 'Argentina :Pesos',	# ISO 4217???
'AUD' => 'Australia (Australian) :Dollars',
'AWG' => 'Aruba :Guilders',
'AZM' => 'Azerbaijan :Manats',
'BAM' => 'Bosnia and Herzegovina :Convertible Marka', # currency 2 'Convertible Marka'
'BBD' => 'Barbados :Dollars',
'BDT' => 'Bangladesh :Taka',
'BGN' => 'Bulgaria :Leva',	# ISO 4217? BG+N??
'BHD' => 'Bahrain :Dinars',
'BIF' => 'Burundi :Francs',
'BMD' => 'Bermuda :Dollars',
'BND' => 'Brunei :Dollars',
'BOB' => 'Bolivia :Bolivianos',
'BRL' => 'Brazil (Brazilian) :Reais',	# ISO 4217? BR+L??
'BSD' => 'Bahamas :Dollars',
'BTN' => 'Bhutan :Ngultrum',
'BWP' => 'Botswana :Pulas',
'BYR' => 'Belarus :Rubles',
'BZD' => 'Belize :Dollars',
'CAD' => 'Canada (Canadian) :Dollars',
'CDF' => 'Congo/Kinshasa :Francs',
'CHF' => 'Switzerland (Swiss) :Francs',
'CLP' => 'Chile :Pesos',
'CNY' => 'China (Chinese) :Yuan Renminbi',	# currency 2 'Yuan Renminbi'
'COP' => 'Colombia :Pesos',
'CRC' => 'Costa Rica :Colones',
'CSD' => 'Serbia :Dinars',
'CUC' => 'Cuba :Convertible Pesos',	# currency 2 'Convertible Pesos'
'CUP' => 'Cuba :Pesos',
'CVE' => 'Cape Verde :Escudos',
'CYP' => 'Cyprus :Pounds',
'CZK' => 'Czech Republic :Koruny',
'DJF' => 'Djibouti :Francs',
'DKK' => 'Denmark (Danish) :Kroner',
'DOP' => 'Dominican Republic :Pesos',
'DZD' => 'Algeria :Dinars',
'EEK' => 'Estonia :Krooni',
'EGP' => 'Egypt :Pounds',
'ERN' => 'Eritrea :Nakfa',
'ETB' => 'Ethiopia :Birr',
'EUR' => 'European Union :Euro',  # make it 2 country + currency - CHECK! does NOT conform ISO 4217
'FJD' => 'Fiji :Dollars',
'FKP' => 'Falkland Islands :Pounds',
'GBP' => 'United Kingdom (British) :Pounds',
'GEL' => 'Georgia :Lari',
'GGP' => 'Guernsey :Pounds',
'GHC' => 'Ghana :Cedis',
'GIP' => 'Gibraltar :Pounds',
'GMD' => 'Gambia :Dalasi',
'GNF' => 'Guinea :Francs',
'GTQ' => 'Guatemala :Quetzales',
'GYD' => 'Guyana :Dollars',
'HKD' => 'Hong Kong :Dollars',
'HNL' => 'Honduras :Lempiras',
'HRK' => 'Croatia :Kuna',
'HTG' => 'Haiti :Gourdes',
'HUF' => 'Hungary :Forint',
'IDR' => 'Indonesia :Rupiahs',
'ILS' => 'Israel :New Shekels',	# currency 2 - 'New Shekels'
'IMP' => 'Isle of Man :Pounds',
'INR' => 'India :Rupees',
'IQD' => 'Iraq :Dinars',
'IRR' => 'Iran :Rials',
'ISK' => 'Iceland :Kronur',
'JEP' => 'Jersey :Pounds',
'JMD' => 'Jamaica :Dollars',
'JOD' => 'Jordan :Dinars',
'JPY' => 'Japan (Japanese) :Yen',
'KES' => 'Kenya :Shillings',
'KGS' => 'Kyrgyzstan :Soms',
'KHR' => 'Cambodia :Riels',
'KMF' => 'Comoros :Francs',
'KPW' => 'North Korea (South Korean) :Won',
'KRW' => 'South Korea (North Korean) :Won',
'KWD' => 'Kuwait :Dinars',
'KYD' => 'Cayman Islands :Dollars',
'KZT' => 'Kazakhstan :Tenge',
'LAK' => 'Laos :Kips',
'LBP' => 'Lebanon :Pounds',
'LKR' => 'Sri Lanka :Rupees',
'LRD' => 'Liberia :Dollars',
'LSL' => 'Lesotho :Maloti',	# ISO 4217? LS+L??
'LTL' => 'Lithuania :Litai',
'LVL' => 'Latvia :Lati',
'LYD' => 'Libya :Dinars',
'MAD' => 'Morocco :Dirhams',
'MDL' => 'Moldova :Lei',
'MGA' => 'Madagascar :Ariary',
'MKD' => 'Macedonia :Denars',
'MMK' => 'Myanmar :Kyats',
'MNT' => 'Mongolia :Tugriks',
'MOP' => 'Macau :Patacas',
'MRO' => 'Mauritania :Ouguiyas',
'MTL' => 'Malta :Liri',
'MUR' => 'Mauritius :Rupees',
'MVR' => 'Maldives :Rufiyaa',
'MWK' => 'Malawi :Kwachas',
'MXN' => 'Mexico (Mexican) :Pesos',	# ISO 4217? should be 'nuevo peso' - ie MX+N
'MYR' => 'Malaysia :Ringgits',
'MZM' => 'Mozambique :Meticais',
'NAD' => 'Namibia :Dollars',
'NGN' => 'Nigeria :Nairas',
'NIO' => 'Nicaragua :Cordobas',
'NOK' => 'Norway (Norwegian) :Kroner',
'NPR' => 'Nepal :Rupees',
'NZD' => 'New Zealand :Dollars',
'OMR' => 'Oman :Rials',
'PAB' => 'Panama :Balboas',
'PEN' => 'Peru Nuevos :Soles',	# currency 2 'Nuevos Soles'
'PGK' => 'Papua New Guinea :Kina',
'PHP' => 'Philippines :Pesos',
'PKR' => 'Pakistan :Rupees',
'PLN' => 'Poland :Zlotych',
'PYG' => 'Paraguay :Guarani',
'QAR' => 'Qatar :Riyals',
'ROL' => 'Romania :Lei',
#'RUB' => 'Russia :Rubles',
'RUR' => 'Russia :Rubles', # added specially - CHECK!
'RWF' => 'Rwanda :Francs',
'SAR' => 'Saudi Arabia :Riyals',
'SBD' => 'Solomon Islands :Dollars',
'SCR' => 'Seychelles :Rupees',
'SDD' => 'Sudan :Dinars',
'SEK' => 'Sweden (Swedish) :Kronor',
'SGD' => 'Singapore :Dollars',
'SHP' => 'Saint Helena :Pounds',
'SIT' => 'Slovenia :Tolars',
'SKK' => 'Slovakia :Koruny',
'SLL' => 'Sierra Leone :Leones',
'SOS' => 'Somalia :Shillings',
'SPL' => 'Seborga :Luigini',
'SRD' => 'Suriname :Dollars',
'STD' => 'So Tome and Principe :Dobras',
'SVC' => 'El Salvador :Colones',
'SYP' => 'Syria :Pounds',
'SZL' => 'Swaziland :Emalangeni',	# ISO 4217? SZ+L
'THB' => 'Thailand :Baht',
'TJS' => 'Tajikistan :Somoni',
'TMM' => 'Turkmenistan :Manats',
'TND' => 'Tunisia :Dinars',
'TOP' => 'Tonga :Pa\'anga',
'TRL' => 'Turkey :Liras',
'TRY' => 'Turkey :New Lira',
'TTD' => 'Trinidad and Tobago :Dollars',
'TVD' => 'Tuvalu :Dollars',
'TWD' => 'Taiwan New :Dollars',	# currency 2 'New Dollars' ISO 4217?
'TZS' => 'Tanzania :Shillings',
'UAH' => 'Ukraine :Hryvnia',
'UGX' => 'Uganda :Shillings',
'USD' => 'United States (USA) :Dollars',
'UYU' => 'Uruguay :Pesos',	# ISO 4217 UY+U??
'UZS' => 'Uzbekistan :Sums',
'VEB' => 'Venezuela :Bolivares',
'VND' => 'Vietnam :Dong',
'VUV' => 'Vanuatu :Vatu',
'WST' => 'Samoa :Tala',
'XAF' => 'Communaut Financire Africaine :Francs BEAC',	# currency 2 - 'Francs BEAC'
'XAG' => 'Silver Ounces :PM',		# precious metals
'XAU' => 'Gold Ounces :PM',			# precious metals
'XCD' => 'East Caribbean :Dollars',
'XDR' => 'International Monetary Fund Special Drawing Rights :XDR',
'XOF' => 'Communaut Financire Africaine :Francs BCEAO',	# currency 2 - 'Francs BCEAO'
'XPD' => 'Palladium Ounces :PM',	# precious metals
'XPF' => 'Comptoirs Franais du Pacifique :Francs',
'XPT' => 'Platinum Ounces :PM',		# precious metals
'YER' => 'Yemen :Rials',
'ZAR' => 'South Africa :Rand',
'ZMK' => 'Zambia :Kwacha',
'ZWD' => 'Zimbabwe :Dollar' );

# 242 ISO 3166
my %ISO3166 = (
'AF' => 'AFGHANISTAN',
'AX' => 'LAND ISLANDS',
'DZ' => 'ALGERIA',
'AS' => 'AMERICAN SAMOA',
'AD' => 'ANDORRA',
'AO' => 'ANGOLA',
'AI' => 'ANGUILLA',
'AQ' => 'ANTARCTICA',
'AG' => 'ANTIGUA AND BARBUDA',
'AR' => 'ARGENTINA',
'AM' => 'ARMENIA',
'AW' => 'ARUBA',
'AU' => 'AUSTRALIA (Australian)',
'AT' => 'AUSTRIA',
'AZ' => 'AZERBAIJAN',
'BS' => 'BAHAMAS',
'BH' => 'BAHRAIN',
'BD' => 'BANGLADESH',
'BB' => 'BARBADOS',
'BY' => 'BELARUS',
'BE' => 'BELGIUM',
'BZ' => 'BELIZE',
'BJ' => 'BENIN',
'BM' => 'BERMUDA',
'BT' => 'BHUTAN',
'BO' => 'BOLIVIA',
'BA' => 'BOSNIA AND HERZEGOVINA',
'BW' => 'BOTSWANA',
'BV' => 'BOUVET ISLAND',
'BR' => 'BRAZIL (Brazilian)',
# 'IO' => 'BRITISH INDIAN OCEAN TERRITORY', # excluded!!!
'BN' => 'BRUNEI DARUSSALAM',
'BG' => 'BULGARIA',
'BF' => 'BURKINA FASO',
'BI' => 'BURUNDI',
'KH' => 'CAMBODIA',
'CM' => 'CAMEROON',
'CA' => 'CANADA (Canadian)',
'CV' => 'CAPE VERDE',
'KY' => 'CAYMAN ISLANDS',
'CF' => 'CENTRAL AFRICAN REPUBLIC',
'TD' => 'CHAD',
'CL' => 'CHILE',
'CN' => 'CHINA (Chinese)',
'CX' => 'CHRISTMAS ISLAND',
'CC' => 'COCOS (KEELING) ISLANDS',
'CO' => 'COLOMBIA',
'KM' => 'COMOROS',
'CG' => 'CONGO',
'CD' => 'CONGO, THE DEMOCRATIC REPUBLIC OF THE (Zaire)',
'CK' => 'COOK ISLANDS',
'CR' => 'COSTA RICA',
'CI' => 'CTE D\'IVOIRE',
'HR' => 'CROATIA',
'CU' => 'CUBA',
'CY' => 'CYPRUS',
'CZ' => 'CZECH REPUBLIC',
'DK' => 'DENMARK (Danish)',
'DJ' => 'DJIBOUTI',
'DM' => 'DOMINICA',
'DO' => 'DOMINICAN REPUBLIC',
'EC' => 'ECUADOR',
'EG' => 'EGYPT',
'SV' => 'EL SALVADOR',
'GQ' => 'EQUATORIAL GUINEA',
'ER' => 'ERITREA',
'EE' => 'ESTONIA',
'ET' => 'ETHIOPIA',
'EU' => 'EUROPEAN UNION (Euro)',	# add artificial entry!!!
'FK' => 'FALKLAND ISLANDS (MALVINAS)',
'FO' => 'FAROE ISLANDS',
'FJ' => 'FIJI',
'FI' => 'FINLAND',
'FR' => 'FRANCE',
'GF' => 'FRENCH GUIANA',
'PF' => 'FRENCH POLYNESIA',
'TF' => 'FRENCH SOUTHERN TERRITORIES',
'GA' => 'GABON',
'GM' => 'GAMBIA',
'GE' => 'GEORGIA',
'DE' => 'GERMANY',
'GH' => 'GHANA',
'GI' => 'GIBRALTAR',
'GR' => 'GREECE',
'GL' => 'GREENLAND',
'GD' => 'GRENADA',
'GP' => 'GUADELOUPE',
'GU' => 'GUAM',
'GT' => 'GUATEMALA',
'GG' => 'GUERNSEY',
'GN' => 'GUINEA',
'GW' => 'GUINEA-BISSAU',
'GY' => 'GUYANA',
'HT' => 'HAITI',
'HM' => 'HEARD ISLAND AND MCDONALD ISLANDS',
'HN' => 'HONDURAS',
'HK' => 'HONG KONG',
'HU' => 'HUNGARY',
'IS' => 'ICELAND',
'IN' => 'INDIA',
'ID' => 'INDONESIA',
'IR' => 'IRAN, ISLAMIC REPUBLIC OF',
'IQ' => 'IRAQ',
'IE' => 'IRELAND',
'IM' => 'ISLE OF MAN',
'IL' => 'ISRAEL',
'IT' => 'ITALY',
'JM' => 'JAMAICA',
'JP' => 'JAPAN (Japanese)',
'JE' => 'JERSEY',
'JO' => 'JORDAN',
'KZ' => 'KAZAKHSTAN',
'KE' => 'KENYA',
'KI' => 'KIRIBATI',
'KP' => 'KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF (South Korean)',
'KR' => 'KOREA, REPUBLIC OF (North Korean) ',
'KW' => 'KUWAIT',
'KG' => 'KYRGYZSTAN',
'LA' => 'LAO PEOPLE\'S DEMOCRATIC REPUBLIC',
'LV' => 'LATVIA',
'LB' => 'LEBANON',
'LS' => 'LESOTHO',
'LR' => 'LIBERIA',
'LY' => 'LIBYAN ARAB JAMAHIRIYA',
'LI' => 'LIECHTENSTEIN',
'LT' => 'LITHUANIA',
'LU' => 'LUXEMBOURG',
'MO' => 'MACAO',
'MK' => 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF',
'MG' => 'MADAGASCAR',
'MW' => 'MALAWI',
'MY' => 'MALAYSIA',
'MV' => 'MALDIVES',
'ML' => 'MALI',
'MT' => 'MALTA',
'MH' => 'MARSHALL ISLANDS',
'MQ' => 'MARTINIQUE',
'MR' => 'MAURITANIA',
'MU' => 'MAURITIUS',
'YT' => 'MAYOTTE',
'MX' => 'MEXICO (Mexican)',
'FM' => 'MICRONESIA, FEDERATED STATES OF',
'MD' => 'MOLDOVA, REPUBLIC OF',
'MC' => 'MONACO',
'MN' => 'MONGOLIA',
'MS' => 'MONTSERRAT',
'MA' => 'MOROCCO',
'MZ' => 'MOZAMBIQUE',
'MM' => 'MYANMAR',
'NA' => 'NAMIBIA',
'NR' => 'NAURU',
'NP' => 'NEPAL',
'NL' => 'NETHERLANDS',
'AN' => 'NETHERLANDS ANTILLES',
'NC' => 'NEW CALEDONIA',
'NZ' => 'NEW ZEALAND',
'NI' => 'NICARAGUA',
'NE' => 'NIGER',
'NG' => 'NIGERIA',
'NU' => 'NIUE',
'NF' => 'NORFOLK ISLAND',
'MP' => 'NORTHERN MARIANA ISLANDS',
'NO' => 'NORWAY (Norwegian)',
'OM' => 'OMAN',
'PK' => 'PAKISTAN',
'PW' => 'PALAU',
'PS' => 'PALESTINIAN TERRITORY, OCCUPIED',
'PA' => 'PANAMA',
'PG' => 'PAPUA NEW GUINEA',
'PY' => 'PARAGUAY',
'PE' => 'PERU',
'PH' => 'PHILIPPINES',
'PN' => 'PITCAIRN',
'PL' => 'POLAND',
'PT' => 'PORTUGAL',
'PR' => 'PUERTO RICO',
'QA' => 'QATAR',
'RE' => 'RUNION',
'RO' => 'ROMANIA',
'RU' => 'RUSSIAN FEDERATION',
'RW' => 'RWANDA',
'SH' => 'SAINT HELENA',
'KN' => 'SAINT KITTS AND NEVIS',
'LC' => 'SAINT LUCIA',
'PM' => 'SAINT PIERRE AND MIQUELON',
'VC' => 'SAINT VINCENT AND THE GRENADINES',
'WS' => 'SAMOA',
'SM' => 'SAN MARINO',
'ST' => 'SAO TOME AND PRINCIPE',
'SA' => 'SAUDI ARABIA',
'SN' => 'SENEGAL',
'CS' => 'SERBIA AND MONTENEGRO',
'SC' => 'SEYCHELLES',
'SL' => 'SIERRA LEONE',
'SG' => 'SINGAPORE',
'SK' => 'SLOVAKIA',
'SI' => 'SLOVENIA',
'SB' => 'SOLOMON ISLANDS',
'SO' => 'SOMALIA',
'ZA' => 'SOUTH AFRICA',
'GS' => 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS',
'ES' => 'SPAIN',
'LK' => 'SRI LANKA',
'SD' => 'SUDAN',
'SR' => 'SURINAME',
'SJ' => 'SVALBARD AND JAN MAYEN',
'SZ' => 'SWAZILAND',
'SE' => 'SWEDEN (Swedish)',
'CH' => 'SWITZERLAND (Swiss)',
'SY' => 'SYRIAN ARAB REPUBLIC',
'TW' => 'TAIWAN, PROVINCE OF CHINA',
'TJ' => 'TAJIKISTAN',
'TZ' => 'TANZANIA, UNITED REPUBLIC OF',
'TH' => 'THAILAND',
'TL' => 'TIMOR-LESTE',
'TG' => 'TOGO',
'TK' => 'TOKELAU',
'TO' => 'TONGA',
'TT' => 'TRINIDAD AND TOBAGO',
'TN' => 'TUNISIA',
'TR' => 'TURKEY',
'TM' => 'TURKMENISTAN',
'TC' => 'TURKS AND CAICOS ISLANDS',
'TV' => 'TUVALU',
'UG' => 'UGANDA',
'UA' => 'UKRAINE',
'AE' => 'UNITED ARAB EMIRATES',
'GB' => 'UNITED KINGDOM (British)',
'US' => 'UNITED STATES',
'UM' => 'UNITED STATES MINOR OUTLYING ISLANDS',
'UY' => 'URUGUAY',
'UZ' => 'UZBEKISTAN',
'VU' => 'VANUATU',
'VA' => 'Vatican City State (HOLY SEE)',
'VE' => 'VENEZUELA',
'VN' => 'VIET NAM',
'VG' => 'VIRGIN ISLANDS, BRITISH',
'VI' => 'VIRGIN ISLANDS, U.S.',
'WF' => 'WALLIS AND FUTUNA',
'EH' => 'WESTERN SAHARA',
'YE' => 'YEMEN',
'ZM' => 'ZAMBIA',
'ZW' => 'ZIMBABWE'
);

sub ISO2Currency {
	my ($iso) = shift;
	my $ilen = length($iso);
	my $tiso = '';
	my $v = '';
	my $k = '';
	if ($ilen >= 3) {
		$tiso = uc(substr($iso,0,3));
		foreach $k (keys %CurrencyISO) {
			if ($k eq $tiso) {
				$v = $CurrencyISO{$k};
				return $v;
			}
		}
	}
	# just search on the first part
	if ($ilen >= 2) {
		$tiso = substr($iso,0,2);
		foreach $k (keys %CurrencyISO) {
			if ($k =~ /^$tiso/i) {
				$v = $CurrencyISO{$k};
				return $v;	# return
			}
		}
	}
	return "NOT FOUND [$iso]";
}

sub ISO2CurrencyOnly {
	my ($iso) = uc(shift);
	my $v = ISO2Currency($iso);
	if ( !($v =~ /^NOT FOUND/) ) {
		my @a = split(/:/,$v);
		return $a[-1];
	}
	return $v;
}

sub Currency2ISO {
	my ($cur) = shift;
	my %aa = ();
	my $v = '';
	foreach my $k (keys %CurrencyISO) {
		$v = $CurrencyISO{$k};
		if ($v =~ /$cur/i) {
			###prt( "*** added [$k] => [$v] ***\n" );
			$aa{$k} = $v;
		}
	}
	return \%aa;
}

sub ISO2Country {
	my ($iso) = shift;
	my $iso3166 = $iso;
	my $v = '';
	if (length($iso) > 2) {
		$iso3166 = substr($iso,0,2);
	}
	foreach my $k (keys %ISO3166) {
		if ($k eq uc($iso3166)) {
			$v = $ISO3166{$k};
			return $v;
		}
	}
	return "NOT FOUND [$iso]";
}


sub Country2ISO_1 {
	my ($ctry) = shift;
	my $v = '';
	if (length($ctry) == 0) {
		return "NOT FOUND <blank>";
	}
	###foreach my $k (keys %ISO3166) {
	foreach my $k (sort keys %ISO3166) {
		$v = $ISO3166{$k};
		if ($v =~ /$ctry/i) {
			return $k;
		}
	}
	return "NOT FOUND <$ctry>";
}

sub Country2ISO {
	my ($ctry) = shift;
	my $iso = Country2ISO_1($ctry);
	my $nctry = '';
	my $iso2 = '';
	if ($iso =~ /^NOT FOUND/) {
		# missed first time = TRY HARDER?
		# one obvious try is Australian to Australia
		if (lc(substr($ctry, length($ctry)-1, 1)) eq 'n') {
			$mctry = substr($ctry, 0, length($ctry)-1); # drop the 'n'
			$iso2 = Country2ISO_1($mctry);
			if ( !($iso2 =~ /^NOT FOUND/) ) {
				$iso = $iso2;
			}
		}
	}
	return $iso;
}


sub RetISOTableText {
	my $cnt = keys %CurrencyISO; 
	my $msg = "<table border=\"1\" summary=\"Table of ISO 4217 for $cnt codes\">\n";
	$msg .= "<tr><td>ISO Code</td><td>Country Currency</td></tr>\n";
	my $v = '';
	foreach my $k (sort keys %CurrencyISO) {
		$v = $CurrencyISO{$k};
		$msg .= "<tr><td>$k</td><td>$v</td></tr>\n";
	}
	$msg .= "</table>\n";
	return $msg;
}

sub RetISO3166TableText {
	my $cnt = keys %ISO3166; 
	my $msg = "<table border=\"1\" summary=\"Table of ISO 3166 for $cnt codes\">\n";
	$msg .= "<tr><td>ISO</td><td>Country</td></tr>\n";
	my $v = '';
	foreach my $k (sort keys %ISO3166) {
		$v = $ISO3166{$k};
		$msg .= "<tr><td>$k</td><td>$v</td></tr>\n";
	}
	$msg .= "</table>\n";
	return $msg;
}

1;

