#!/Perl
# diffanal1.pl
# AIM: to read a diff file, and search for specific items
# 2006.09.10 - added missing files, but must exclude _cti_cnf
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file and some other utility subs

# logfile stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
my $listfile  = 'tempdiff.lst';
my $listfile2 = 'tempdiff2.lst';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $in_file = 'tempd';
open IF, "<$in_file";
my @lines = <IF>; # slurp it all in...
close(IF);
my $lncnt = scalar @lines;
prt("Processing $lncnt lines from $in_file ...\n");
my $line = '';
my $dcnt = 0;
my $file1 = '';
my $file2 = '';
my $fn = '';
my $pn = '';
my $indiff = 0;
my @dlines = ();
my $dlcnt = 0;
my $gotem = 0;
my $spcf = 0;
my $i = 0;
my @difflist = ();
my @newlist = ();
foreach $line (@lines) {
	chomp $line;
	$line =~ s/\r$//; # and remove CR, if present
	my @arr = split(/\s/,$line);
	if ($line =~ /^diff\s+/i) {
		show_diff();
		if (scalar @arr >= 3) {
			$file1 = $arr[1];
			$file2 = $arr[2];
			$fn = my_file($file1);
			$pn = my_path($file1);
			###prt( "[$pn] [$fn]\n" );
		} else {
			prt( "CHECK ME: [$line]\n" );
		}
		$dcnt++;
		@dlines = ();
		$gotem = 0;
		$spcf = 0;
	} elsif ($line =~ /^Only in/) {
		prt( "$line\n" );
		my $acnt = scalar @arr;
		##for ($i = 0; $i < $acnt; $i++) {
		##	prt( " $i [".$arr[$i]."]" );
		##}
		##$file = $arr[3];
		$file = $arr[-1];
		if ($file =~ /^_vti_cnf/) {
			prt("NOTE EXCLUDED FILE ($file) !!!\n");
		} else {
			prt(" ($file)\n");
			push(@newlist,$file); # keep the NEW files
		}
	} else {
		if ($line =~ /geoffair/i) {
			$gotem = 1;
		}
		if ($line =~ /<span class="f">/i) {
			$spcf = 1;
		}
		push(@dlines, $line);
	}
}
show_diff();
$dcnt = scalar @difflist;
prt( "Got $dcnt files in the difflist ... writing to $listfile ...\n" );
write2file( join("\n",@difflist), $listfile );
$dcnt = scalar @newlist;
prt( "Got $dcnt NEW files in the difflist ... writing to $listfile2 ...\n" );
write2file( join("\n",@newlist), $listfile2 );
append2file( "\n", $listfile2 );
append2file( join("\n",@difflist), $listfile2 );

close_log($outfile,1);
exit(0);

#############
sub show_diff {
	$dlcnt = scalar @dlines;
	my $nfn = $fn;
	while (length($nfn) < 20) {
		$nfn .= ' ';
	}
	if ($dlcnt) {
		if ($dlcnt > 4) {
			prt( "$nfn with $dlcnt lines of diff ..." );
			if ($spcf) {
				prt( "with span..." );
			}
			if ($gotem) {
				prt( "with email.." );
			}
			prt("\n");
			push(@difflist, $fn);
		} elsif ($spcf || $gotem) {
			prt( "$nfn CHECK: Got span or email?\n" ); 
		}
	} else {
			prt( "$nfn CHECK where dcnt is ZERO?\n" );
	}
}


sub my_file {
	my ($f) = shift;
	$f =~ s/\\/\//g;
	my @a = split(/\//, $f);
	my $cnt = scalar @a;
	if ($cnt > 1) {
		$f = pop @a;
	}
	return $f;
}

sub my_path {
	my ($f) = shift;
	$f =~ s/\\/\//g;
	my @a = split(/\//, $f);
	my $cnt = scalar @a;
	if ($cnt > 1) {
		pop @a;
		$f = join('/', @a);
	}
	return $f;
}


# eof - diffanal1.pl
