#!/perl -w
# NAME: dir2list02.pl
# AIM: Take a directory listing file, and write it as a simple list
use strict;
use warnings;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
	my @tmpsp = split(/(\\|\/)/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $perl_root = 'C:\GTools\perl';
my $outfile = $perl_root."\\temp.$pgmname.txt";
open_log($outfile);

# features
my $load_log = 1;
my $just_simple_list = 1;
my $sort_the_list = 0;
my $suppress_common = 0;

my $def_file = 'C:\FG\27\tempdsp';
#my $def_file = 'C:\HOMEPAGE\tempdefold';
my @input_files = ();

sub pgm_exit($$) {
   my ($val,$msg) = @_;
   if (length($msg)) {
      $msg .= "\n" if (!($msg =~ /\n$/));
      prt($msg);
   }
   close_log($outfile,$load_log);
   exit($val);
}

sub mycmp_decend {
	my $off = 0;
	if (${$a}[$off] < ${$b}[$off]) {
		return 1;
	}
	if (${$a}[$off] > ${$b}[$off]) {
		return -1;
	}
	return 0;
}

sub suppress_last($$) {
   my ($last,$dir) = @_;
   my $len1 = length($last);
   my $len2 = length($dir);
   my $len = (($len2 > $len1) ? $len1 : $len2);
   my $ndir = '';
   my $i = 0;
   for (; $i < $len; $i++) {
      if (substr($last,$i,1) eq substr($dir,$i,1)) {
         $ndir .= ' ';
      } else {
         last;
      }
   }
   $ndir .= substr($dir,$i);
   return $ndir;
}

sub process_input_file($) {
   my ($in_file) = @_;
   my (@in_lines,$gottot,$line,@list,@lastlns,$dir);
   my ($date,$time,$ampm,$size,$name);
   my ($dy,$mt,$yr,$hr,$mn,$tm,$cnt,$i);
   my ($minlen,$len);
   my ($lastdir,$outdir,$dircount);
   my (@slist);
   prt( "Processing [$in_file]... " );
   open IF, "<$in_file" or mydie( "Can not OPEN [$in_file] ... $1 ...\n" );
   @in_lines = <IF>;
   close IF;
   prt( " ".scalar @in_lines." lines..." );
   $gottot = 0;
   $line = '02/09/2004  05:13 PM            10,104 Multipad.mak';
   ##if ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+([\d,]+)\s+(\w+.*)/) {
   ##	print "ok\n";
   ##} else {
   ##	print "FAILED\n";
   ##}
   @list = ();
   @lastlns = ();
   $cnt = 0;
   $dircount = 0;
   foreach $line (@in_lines) {
      ###prt( $line );
      chomp $line;
      $line =~ s/\r$//;
      next if ($line =~ /^\s*$/);
      # like 'Directory of F:\GTools\ASM\e'
      if ($gottot) {
         ###prt( "$line\n" );
         push(@lastlns, $line) if (length($line));
         $gottot = 0;
      } else {
         #  Volume Serial Number is D833-AEFA
         if ($line =~ /^\s*Volume\s+Serial\s+Number\s+is\s+(.+)\s*$/) {
            # skip this line
         #  Volume in drive C is DRIVEC-D1
         } elsif ($line =~ /^\s*Volume\s+in\s+drive\s+(\w+)\s+is\s+(.+)\s*$/) {
            # drive and volume name
         } elsif ($line =~ /\s+Directory of (.*)/) {
            $dir = $1;
            ##prt( "$dir\n" );
         # like '02/09/2004  05:10 PM             4,301 FindI32.mak'
         } elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+(\w{2})\s+([\d,]+)\s+(\w+.*)/) {
            $date = $1;
            $time = $2;
            $ampm = $3;
            $size = $4;
            $name = $5;
            ($dy,$mt,$yr) = split('/',$date);
            ($hr,$mn) = split(':',$time);
            if ($ampm eq 'PM') { $hr += 12; }
            $tm = $yr * 365 * 24 * 60;
            $tm += $mt * 30 * 24 * 60;
            $tm += $dy * 24 * 60;
            $tm += $mn * 60;
            ###prt( "[$date] [$time] [$ampm] [$size] [$name] [$dir]\n" );
            ###prt( "[$dy/$mt/$yr] [$time] [$ampm] [$size] [$name] [$dir]\n" );
            ###prt( "$tm [$dy/$mt/$yr] [$hr:$mn] [$ampm] [$size] [$name] [$dir]\n" );
            push(@list, [$tm, $date, $time, $ampm, $size, $name, $dir]);
         #      '05/01/2010  12:16             1,882 default.phtml
         } elsif ($line =~ /^(\d{2}\/\d{2}\/\d{4})\s+(\d{2}:\d{2})\s+([\d,]+)\s+(\w+.*)$/) {
            $date = $1;
            $time = $2;
            $size = $3;
            $name = $4;
            ($dy,$mt,$yr) = split('/',$date);
            ($hr,$mn) = split(':',$time);
            $tm = $yr * 365 * 24 * 60;
            $tm += $mt * 30 * 24 * 60;
            $tm += $dy * 24 * 60;
            $tm += $mn * 60;
            $ampm = ' ';   # none = 24 hours clock
            push(@list, [$tm, $date, $time, $ampm, $size, $name, $dir]);
         #      Total Files Listed:
         } elsif ($line =~ /^\s+Total Files Listed:/) {
            $gottot = 1;
         #    1 File(s)          4,001 bytes
         } elsif ($line =~ /^\s*([\d,]+)\s+File\(s\)\s+([\d,]+)\s+bytes\s*$/) {
            # what to do about this line????
         #               0 Dir(s)  17,821,298,688 bytes free
         } elsif ($line =~ /^\s*([\d,]+)\s+Dir\(s\)\s+([\d,]+)\s+bytes\s+free\s*$/) {
            # keep this value?
         } elsif ($line =~ /\d+\/\d+\/\d+\s+\d+:\d+\s+<DIR>\s+(.+)$/) {
            # 12/07/2008  17:17    <DIR>          Win32-API-0.41
            # discard directories
            $dircount++;
         } else {
            prt("CHECK ME: [$line]\n");
         }
      }
   }

   prt(", $dircount DIRECTORIES...") if ($dircount);
   $cnt = scalar @list;
   prt( ", got $cnt files ...\n" );
   if ($sort_the_list) {
      @slist = sort mycmp_decend @list;
   } else {
      @slist = @list;
   }
   $minlen = 0;
   for ($i = 0; $i < $cnt; $i++ ) {
      $name = $slist[$i][5];
      $len = length($name);
      $minlen = $len if ($len > $minlen);
   }
   $lastdir = '';
   for ($i = 0; $i < $cnt; $i++ ) {
      $date = $slist[$i][1];
      $time = $slist[$i][2];
      $ampm = $slist[$i][3];
      $size = $slist[$i][4];
      $name = $slist[$i][5];
      $dir  = $slist[$i][6];
      if ($just_simple_list) {
         if ($suppress_common) {
            $outdir = suppress_last($lastdir,$dir);
            prt("$outdir\\$name\n");
            $lastdir = $dir;
         } else {
            prt("$dir\\$name\n");
         }
      } else {
         while (length($size) < 12) { $size = ' '.$size; }
         while (length($name) < $minlen) { $name .= ' '; }
         prt( "$date $time $ampm $size $name $dir\n" );
      }
   }
   $cnt = scalar @lastlns;
   for ($i = 0; $i < $cnt; $i++) {
      prt( $lastlns[$i]."\n" );
   }
}

sub process_input_files($) {
   my ($ra) = @_;
   foreach my $file (@{$ra}) {
      process_input_file($file);
   }
}

process_args(@ARGV);
process_input_files(\@input_files);
pgm_exit(0,"Normal exit.");

sub process_args {
   my (@av) = @_;
   while (@av) {
      my $farg = $av[0];
      if (! -f $farg) {
         prt("ERROR: Can NOT locate [$farg] file!\n");
         pgm_exit(1,"Check name, location...\n");
      }
      push(@input_files,$farg);
      prt("Added [$farg] to input file list...\n");
      shift @av;
   }
   if (! @input_files) {
      if (-f $def_file) {
         push(@input_files,$def_file);
         prt("Added DEFAULT [$def_file] to input file list...\n");
      } else {
         pgm_exit(1,"ERROR: No input file, or files found on command line!\n");
      }
   }
}

# eof - dir2list02.pl
