#!/Perl
#
# doupload.pl
# As the name implies, this is to do an UPLOAD of an image file to the HOST
# The actual FTP transfer is accomplished with a putimage.bat file,
# which, in fact presently uses java FtpPutB to 'control' the transfer
# Here are the simple contents of the putimage.bat file ---
## @echo off
## cd C:\Gtools\java
## @if NOT EXIST %1 goto NOFILE
## @java FtpPutB gee.exetel.com.au images friendofflowers PtRv55ttL %1
## cd C:\Gtools\perl
## @goto End
## :NOFILE
## @echo Unable to loacte file %1 ...
## @goto End
## :End
#
# The AIM is to search for NEWLY created file, of the form 'temp' + ? + ???? . jpg 
# This is done by doing a DIRECTORY read, each ??? seconds ...
# Then interate through the FILES found, witha DATE greater = later than the start time
# When found they are placed in a @m_todo array
# The @m_todo is interated every ??? seconds, compared with teh @m_done array
# If the file is NOT in the @m_done array, then it is TRANSFERRED,
# then placed in the @m_done ... simple. but effective ... geoff.
#
use strict;
use Cwd;
use File::stat;
my $start_time = time();

print "doupload: Started on " . localtime($start_time) . " ...\n";
my $m_folder = 'C:/Gtools/java/images';
my $m_seconds = 34; # wait 34 seconds between each interation

my @m_dirlist = ();
my @m_todo = ();
my @m_done = ();
my $m_entry = '';
my $m_typ = 'a';
my $last_time = $start_time;
my $verb = 0;
my $uploaded = 0;
my $nc = 0;

print "Entering MAIN loop ... FOREVER ... Ctrl+C to stop it ...\n";
while(1) {
	$nc = 0;
	process_folder();
	sleep (1);
	foreach my $f (@m_todo) {
		if (in_done ($f) == 0) {
			my $cmd = 'putimage ';
			$cmd .= "$m_folder/$f"; 
			system( $cmd );
			$uploaded++;
			push(@m_done, $f);
			$nc++;
		}
	}
	if ($nc > 0) {
		print "Uploaded $nc, total $uploaded, to date ... Ctrl+C to exit!\n";
	}
	sleep ($m_seconds);
}

sub in_todo {
	my ($fl) = @_; # get param
	foreach my $ts (@m_todo) {
		##print "Checking $fl vs $ts ...\n";
		if ($ts eq $fl) {
			return 1;
		}
	}
	return 0;
}

sub in_done {
	my ($fl) = @_; # get param
	foreach my $ts (@m_done) {
		##print "Checking $fl vs $ts ...\n";
		if ($ts eq $fl) {
			return 1;
		}
	}
	return 0;
}


sub process_folder {
	print "Processing folder [$m_folder] ...\n" if $verb;
	opendir(THEDIR, $m_folder) || die("Couldn't open [$m_folder] directory!!!\n");
	@m_dirlist = readdir(THEDIR);
	closedir(THEDIR);
	print "Found " . scalar(@m_dirlist) . " items in $m_folder ... Crl+C to exit\n";
	foreach $m_entry (@m_dirlist) {
		my $df = $m_folder . '/' . $m_entry;
		if ( -f $df) {
			my $sb = stat($df);
			my $ln = length($m_entry);
			if ($ln > (4+4+1+3)) {
				my $idx = index ($m_entry, '.'); # get pos of (first) dot
				if (($idx > 0) &&
					(substr($m_entry, 0, 4) eq 'temp')) {
					my $typ = substr($m_entry, 4, 1);
					### if ($typ eq $m_typ) {
					if ($sb->mtime > $start_time) {
					##if ($sb->mtime > $last_time) {
						if (in_todo( $m_entry ) > 0) {
							print "Skipped $m_entry ... is in_todo list ...\n" if $verb;
						} else {
							###print "File=$m_entry len=$ln typ=$typ ...\n";
							###printf "File is %s, size is %s, perm %04o, mtime %s (%u)\n",
							###	$m_entry, $sb->size, ($sb->mode & 07777),
							###	scalar localtime $sb->mtime, $sb->mtime;
							printf "New is %s %s %s (%u)\n",
								$m_entry, $sb->size,
								scalar localtime $sb->mtime, $sb->mtime;
							push(@m_todo, $m_entry); # add new entry, to be done
						}
					}
				}
			}
		}
	}
}

# eof
