#!/perl -w
# NAME: fgscenery.pl
# AIM: To check and advise what FG scenery is install in a given folder - 2007/03/20 - geoff.
# Scenery / Objects and Terrain
# the enumeration of Terrain (and Objects)
# each base Terrain folder, like say e000n40, contains 10x10 degrees of data
# So the base of e000n40 contains
# -----------------------------
# e000n40, e000n41, ... e000n49
# e001n40, e001n41, ... e000n49
# ...
# e009n40, e009n41, ... e001n49
# -----------------------------
# Then each sub-folder is further borken down into tiles (or buckets)
# so scenery\Terrain\e000n40\e000n40
# contains tiles 2957440.btg.gz, 2957448.btg.gz, ..., 2957499.btg.gz
# with corresponding .stg files ...
# from tileentry.hxx
#// ssg tree structure for this tile is as follows:
#// osg::Group(scene)
#//     - osg::Group(terrain)
#//        - SGPlacementTransform(tile)
#//           - osg::LOD(tile)
#//              - ssgEntity(tile)
#//                 - kid1(fan)
#//                 - kid2(fan)
#//                   ...
#//                 - kidn(fan)
# this service, from newbucket.cxx converts a tile index to lat,lon,x,y
#// Parse a unique scenery tile index and find the lon, lat, x, and y
#SGBucket::SGBucket(const long int bindex) {
#    long int index = bindex;
#    lon = index >> 14;
#    index -= lon << 14;
#    lon -= 180;
#    lat = index >> 6;
#    index -= lat << 6;
#    lat -= 90;
#    y = index >> 3;
#    index -= y << 3;
#    x = index;
#}

use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
# for DEBUG
my $dbg1 = 1;	# use a DEFAULT input
my $dbg2 = 0;	# add aditional output during find ...
#my $defin = 'C:\FG\12\data';
#my $defin = 'C:\FG\11\data';
#my $defin = 'C:\FG\11\data';
#my $defin = 'C:\FG\10\data';
my $defin = 'D:\FG\Scenery';
my $inpdir = '';
my @infolders = ();
my $gcnt = 0;
my $tcnt = 0;
my $scnt = 0;
my $cnt = 0;
my $dir = '';
my $ff = '';
my $sf = '';
my @inobjects = ();
my @interrain = ();
parse_args( @ARGV );
if ( ! -d $inpdir) {
	mydie( "ERROR: $inpdir is NOT a DIRECTORY!\n" );
}
prt("Processing folder $inpdir for flightgear scenery ...\n");
@infolders = process_folder( $inpdir, 0 );
$gcnt += $tcnt;
$cnt = scalar @infolders;
prt("Processing total $cnt folders ... ($gcnt)\n");
my $scen = '';
my @sfolders = sort @infolders;
$cnt = scalar @sfolders;
###foreach $dir (@infolders) {
###foreach $dir (sort @infolders) {
for (my $i = 0; $i < $cnt; $i++) {
	$dir = $sfolders[$i];
	if (length($dir)) {
		$sf = submain($dir, $inpdir);
	} else {
		$sf = $dir;
	}
	if ($sf =~ /^Scenery$/i) {
		prt( "Got Scenery [$dir] ...\n" );
		$scen = $sf;
	} elsif (defined $sf && length($sf)) {
		if (defined $scen && length($scen)) {
			$sf = submain2($sf, $scen);
		}
		if (defined $sf && length($sf)) {
			if ($sf =~ /^Terrain$/i) {
				prt( "Got Terrain [$dir] ...\n" );
				$i++;
				for ( ; $i < $cnt; $i++) {
					$dir = $sfolders[$i];
					if (length($dir)) {
						$sf = submain($dir, $inpdir);
					} else {
						$sf = $dir;
					}
					if ($sf =~ /Terrain[\\\/](.*)/i) {
						add_2_terrrain($1);
					} else {
						$i--;
						last;
					}
				}
			} elsif ($sf =~ /^Objects$/i) {
				prt( "Got Objects [$dir] ...\n" );
				$i++;
				for ( ; $i < $cnt; $i++) {
					$dir = $sfolders[$i];
					if (length($dir)) {
						$sf = submain($dir, $inpdir);
					} else {
						$sf = $dir;
					}
					if ($sf =~ /Objects[\\\/](.*)/i) {
						add_2_objects($1);
					} else {
						$i--;
						last;
					}
				}
			}
		}
	}
}
$tcnt = scalar @interrain;
$scnt = scalar @inobjects;
prt( "Got $tcnt terrrain and $scnt object folders ...\n" );
foreach $dir (@interrain) {
	prt( "Terrrain/$dir\n" );
}
foreach $dir (@inobjects) {
	prt( "Objects/$dir\n" );
}
close_log($outfile,1);
exit(0);

#####################################
# subs below
sub add_2_terrrain { # ($1);
	my ($d) = shift;
	my $ud = dos_2_unix($d);
	if ( !($ud =~ /.*\/*CVS$/i) ) {
		push(@interrain, $ud);
	}
}
sub add_2_objects { # ($1);
	my ($d) = shift;
	my $ud = dos_2_unix($d);
	if ( !($ud =~ /.*\/*CVS$/i) ) {
		push(@inobjects, $ud);
	}
}

sub submain {
	my ($d, $m) = @_;
	$d = substr($d, length($m)+1); 
	return $d;
}
sub submain2 {
	my ($d, $m) = @_;
	if (defined $d) {
		if (defined $m) {
			my $l = length($m);
			if ($l) {
				$l += 1 if (length($d) > $l);
				$d = substr($d, $l); 
			}
		}
		return $d; 
	} else {
		return '';
	}
}

sub process_folder {
	my ($in, $level) = @_;
	if ($level == 0) {
		prt( "\nProcessing folder $in ... \n" );
	}
	my @dirs = ();
	if ( !opendir(DIR, $in) ) {
		prt( "ERROR: Unable to open directory [$in] ...\n" );
		return @dirs;
	}
	my @files = readdir(DIR);
	closedir DIR;
	my $cnt = 0;
	foreach my $file (@files) {
		if (($file eq '.') || ($file eq '..')) {
			next;
		}
		$cnt++;
		my $ff = $in . '\\' . $file;
		if ( -d $ff ) {
			push(@dirs, $ff);
			$tcnt++;
		}
	}
	my $cnt2 = scalar @dirs;
	prt( "Found $cnt items, $cnt2 directories ...\n" ) if $dbg2 && ($cnt2 > 0);
	my @sdirs = @dirs;
	foreach my $dir (@sdirs) {
		my @subdirs = process_folder($dir, ($level + 1));
		foreach $dir (@subdirs) {
			push(@dirs, $dir);
		}
	}
	if ($tcnt > 1000) {
		$gcnt += $tcnt;
		prt( "Got $gcnt folders, so far ...\n" );
		$tcnt = 0;
	}
	return @dirs;
}

sub parse_args {
	my (@av) = @_;
	while (@av) {
		my $arg = shift @av;
		if (length($inpdir)) {
			prt( "ERROR: Already have folder $inpdir ...\n" );
				mydie( "Only input is a single scenery folder ...\n" );
		}
		$inpdir = $arg;
	}
	if ( !length($inpdir) ) {
		if ($dbg1) {
			$inpdir = $defin;
		} else {
			prt( "ERROR: Folder name not found!\n" );
			mydie( "Useage: scenery_folder ...\n" );
		}
	}
}

sub dos_2_unix($) {
	my ($du) = shift;
	$du =~ s/\\/\//g;
	return $du;
}

#SGBucket::SGBucket(const long int bindex) {
sub conv_bucket_index {
	my ($ind) = shift;
#    long int index = bindex;
#    lon = index >> 14;
	my $lon = $ind >> 14;
#    index -= lon << 14;
#    lon -= 180;
	$ind -= $lon << 14;
	$lon -= 180;
#    lat = index >> 6;
	my $lat = $ind >> 6;
#    index -= lat << 6;
#    lat -= 90;
	$ind -= $lat << 6;
	$lat -= 90;
#    y = index >> 3;
	my $y = $ind >> 3;
#    index -= y << 3;
	$ind -= $y << 3;
#    x = index;
	my $x = $ind;
	my @arr = ();
	push(@arr, $lon);
	push(@arr, $lat);
	push(@arr, $y);
	push(@arr, $x);
	return @arr;
}

# eof - fgscenery.pl
