#!/perl -w
# NAME: fixboostlist.pl
# AIM: VERY SPECIFIC
use strict;
use warnings;
use File::Basename;
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;

my $inp_file = "C:\\FG\\32\\templist.txt";
my $out_file = "C:\\FG\\32\\templis2.txt";
my $cmp_file = "C:\\FG\\32\\boostlist.txt";

my $lead_len = 21;

### program variables
my @warnings = ();
my $cwd = cwd();

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub process_file($) {
    my ($inf) = shift;
    if (!open INF, "<$inf") {
        pgm_exit(1,"ERROR: Can NOT open [$inf]!\n");
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Got $lncnt lines, from $inf...\n");
    my @narr = ();
    my ($line);
    foreach $line (@lines) {
        chomp $line;
        # remove 'C:\FG\32\boost-trunk\'
        if (length($line) > $lead_len) {
            $line = substr($line,$lead_len);
            push(@narr,$line) if ($line =~ /\.hpp$/);
        }
    }
    #my @snarr = sort @narr;
    prt("Remains ".scalar @narr." lines...\n");
    return \@narr;
}

sub write_arr_ref($$) {
    my ($ar,$out) = @_;
    write2file(join("\n",@{$ar})."\n",$out);
    prt("Written to $out...\n");
}

sub cmp_arr_ref($$) {
    my ($ar,$inf) = @_;
    if (!open INF, "<$inf") {
        pgm_exit(1,"ERROR: Can NOT open [$inf]!\n");
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Got $lncnt lines, from $inf...\n");
    my ($line,$fnd,$ln);
    foreach $line (@lines) {
        chomp $line;
        $fnd = 0;
        foreach $ln (@{$ar}) {
            $fnd = 1 if ($line eq $ln);
            last if ($fnd);
        }
        prt("$line NOT FOUND!\n") if (!$fnd);
    }
    foreach $ln (@{$ar}) {
        $fnd = 0;
        foreach $line (@lines) {
            chomp $line;
            $fnd = 1 if ($line eq $ln);
            last if ($fnd);
        }
        prt("$ln NOT FOUND!\n") if (!$fnd);
    }
}

#########################################
### MAIN ###
my $arr_ref = process_file($inp_file);
write_arr_ref($arr_ref,$out_file);
cmp_arr_ref($arr_ref,$cmp_file);

pgm_exit(0,"Normal exit(0)");
########################################
# eof - template.pl
