#!/perl -w
# NAME: genhtmindex.pl
# AIM: Given a BASE folder, seek all HTML files, and build
# an 'index' table, as HTML ...
# Commands: in-folder [-out out-file]
use strict;
use warnings;
use File::Basename;
use File::stat;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my $def_in = "G:\\HOMEPAGE\\Max5\\1lynesite";
my $in_folder = '';
my $out_file = 'temphout.htm';
my @htmfiles = qw( .htm .html .php );
my @filelist = ();
my @fpfolders = qw( _vti_cnf _vti_cnf _private _derived );
# debug stuff
my $dbg1 = 1;	# use default in folder
my $dbg2 = 0;	# use full file name, else relative

my $html_bgn = <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" 
"http://www.w3.org/TR/html4/loose.dtd">

<html>
<head>
<meta http-equiv="Content-Language" content="en-gb">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<meta name="generator" content="genindex3.pl">
<title>HTML Index</title>
<style type="text/css">
<!-- /* some style 2007.05.24 */
body {
   margin:0cm 1cm;
   background-image:url('clds3.jpg');
}
h1{
	background:#efefef;
	border-style:solid;
	border-color:#d9e2e2;
	border-width:1px;
	padding-top:2px;
	padding-bottom:2px;
	padding-left:2px;
	padding-right:2px;
	font-size:200%;
	text-align:center;
}
h2 { font-size: 12pt; font-weight: bold; background-color: #CCCCFF }
.ctr { text-align:center; }
-->
</style>
</head>

<body>
<h1>HTML Index</h1>
<p class="ctr"><a href="../home2.htm">home</a></p>
<div align="center">
  <center>
  <table border="2" cellpadding="2" bordercolor="#0000FF" id="Num1" summary="Table of HTML files">

EOF

my $html_end = <<"EOF";
  </table>
  </center>
</div>
<p class="ctr"><a href="../home2.htm">home</a></p>
</body>
</html>
EOF

parse_args(@ARGV);

collect_image_files( $in_folder );
my $cnt = scalar @filelist;
prt( "Found $cnt HTML files ...\n" );
open OUTF, ">$out_file" or mydie( "ERROR: Unable to open $out_file ...\n" );

print OUTF $html_bgn;

print OUTF "<tr>\n";
print OUTF "<th>HTML FILES</th>\n";
print OUTF "</tr>\n";

#foreach my $fil (@filelist) {
for (my $i = 0; $i < $cnt; $i++) {
	my $fil = $filelist[$i];
	my $sf = substr( $fil, length($in_folder) + 1 );
	my ($nm, $dir, $ext) = fileparse( $sf, qr/\.[^.]*/ );
	my $sb = stat($fil);
	my $of = '';
	$dir = "." if (length($dir) == 0);
	if ($dbg2) {
		$of = dos_2_unix($fil)
	} else {
		$of = dos_2_unix($sf)
	}
	print OUTF "<tr>\n";
	print OUTF "<td><a href=\"$of\">$of</td>\n";
	print OUTF "</tr>\n";
	# prt( "$sf ...\n" );
}

print OUTF $html_end;
close OUTF;
system $out_file;
close_log($outfile,1);
exit(0);


sub parse_args {
	my (@av) = @_;
	while (@av) {
		my $arg = $av[0];
		if (substr($arg,0,1) eq "-") {
			if ($arg eq '-out') {
				shift @av;
				if (@av) {
					$out_file = $av[0];
					prt( "Set out file to [$out_file] ...\n" );
				} else {
					mydie( "ERROR: -out MUST have a following file name ...\n" );
				}
			}
		} else {
			if (length($in_folder)) {
				mydie( "ERROR: Already have IN-FOLDER [$in_folder]! What is this? [$arg]?\n" );
			}
			$in_folder = $arg;
			prt( "Set in folder to [$in_folder] ...\n" );
		}
		shift @av;
	}

	if (length($in_folder) == 0) {
		if ($dbg1) {
			$in_folder = $def_in;
			prt( "Set in folder to [$in_folder] debug default ...\n" );
		} else {
			mydie( "ERROR: No input folder found ...\n" );
		}
	}

}

sub my_htm_file {
	my ($fil) = shift;
	my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
	foreach my $e (@htmfiles) {
		if (lc($e) eq lc($ext)) {
			return 1;
		}
	}
	return 0;
}

sub is_fp_folder {
	my ($fil) = shift;
	foreach my $fp (@fpfolders) {
		if (lc($fp) eq lc($fil)) {
			return 1;
		}
	}
	return 0;
}


sub collect_image_files {
	my $inf = shift;
	prt( "Processing $inf folder ...\n" );
	if ( opendir( DIR, $inf ) ) {
		my @files = readdir(DIR);
		closedir DIR;
		foreach my $fl (@files) {
			if (($fl eq '.') || ($fl eq '..') ||
				 is_fp_folder($fl) ) {
				next;
			}
			my $ff = $inf . "\\" . $fl;
			if (-d $ff) {
				collect_image_files($ff);
			} else {
				if (my_htm_file($fl)) {
					push(@filelist, $ff);
				}
			}
		}
	} else {
		prt( "WARNING: Can NOT open $inf ... $! ...\n" );
	}
}

sub get_nn { # perl nice number nicenum add commas
	my ($n) = shift;
	if (length($n) > 3) {
		my $mod = length($n) % 3;
		my $ret = (($mod > 0) ? substr( $n, 0, $mod ) : '');
		my $mx = int( length($n) / 3 );
		for (my $i = 0; $i < $mx; $i++ ) {
			if (($mod == 0) && ($i == 0)) {
				$ret .= substr( $n, ($mod+(3*$i)), 3 );
			} else {
				$ret .= ',' . substr( $n, ($mod+(3*$i)), 3 );
			}
		}
		return $ret;
	}
	return $n;
}

sub dos_2_unix {
	my ($du) = shift;
	$du =~ s/\\/\//g;
	return $du;
}

# eof - genimgindex.pl
