#!/perl -w
# NAME: gethostbyip.pl
# AIM: Get the HOST name, given an IP address
use strict;
use warnings;
use Socket;
my $dbg1 = 1;	# test without input
my @ips = ();
my $iaddr = '';
my $ip = '';
if (@ARGV) {
	parse_args(@ARGV);
} else {
	if ($dbg1) {
		# just some samples
		push(@ips, "192.168.1.150");
		push(@ips, "203.8.188.169");
	} else {
		die "Enter an IP number, form nn.nn.nn.nn\nto try to find the host name ...\n";
	}
}
# to convert IP address to an IP string
# ($a,$b,$c,$d) = unpack('C4',$addr[0]); or
# $straddr = inet_ntoa($iaddr);
foreach $ip (@ips) {
	print "IP address [$ip]\n";
	$iaddr = inet_aton($ip); # convert address
    my $name  = gethostbyaddr($iaddr, AF_INET);
	if (defined $name) {
		print "resolved to name [$name] ...\n";
	} else {
		print "COULD NOT BE RESOLVED!\n";
	}
}
exit(0);

sub parse_args {
	my (@av) = @_;
	my $cnt = 0;
	while (@av) {
		$cnt++;
		my $a = shift @av; # get and move to next
		if ($a =~ /\d+\.{1}\d+\.{1}\d+\.{1}\d+/) {
			push(@ips, $a);
		} else {
			die "Input [$a] does not appear to be an IP address of the form nn.nn.nn.nn ...\n";
		}
	} # while arguments
}

# eof - gethostbyip.pl
