#!/perl -w
# NAME: hasmain.pl
# AIM: Read a C/C++ file, and search for main() { } function ...
# 09/08/2010 - Added UI
# 20/11/2007 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_base = 'C:\GTools\perl';
unshift(@INC,$perl_base);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'chkmain.pl' or die "Unable to load chkmain.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = $perl_base."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $do_chkmain = 1;
my $in_file = '';
my $load_log = 0;

### program variables
my @in_files = ();
my @warnings = ();
my $cwd = cwd();
my $os = $^O;
my @missed_main = ();

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

# remove anything trailing the included file name
sub trim_include_tail {
	my ($inc) = shift;
	my $ill = length($inc);
	my $i = 0;
	###prt( "Trimming  [$inc]$ill ...\n" );
	if ($ill) {
		my $ch = substr($inc,$i,1);
		if (($ch eq '"')||($ch eq '<')) {
			$i++;
			$ch = '>' if ($ch eq '<');
			for ( ; $i < $ill; $i++) {
				my $ch2 = substr($inc,$i,1);
				if ($ch2 eq $ch) {
					$i++;
					last;
				}
			}
			$inc = substr($inc,0,$i);
		}
	}
	###prt( "Returning [$inc]$i ...\n" );
	return $inc;
}

sub get_includes {
	my ($fil) = shift;
	my $fndm = 0;
	my ($ccnt, $pline, $j, $k, $k2, $ch, $pch, $cline, $tline, $ll, $incomm, $tag, $fnd1, $comment);
	my ($lncomm, $wascomm);
	my @incs = ();
	if (open INF, "<$fil") {
		my @clines = <INF>;
		close INF;
		$ccnt = scalar @clines;
		$incomm = 0;
		$lncomm = 0;
		###prt( "\nProcessing $ccnt lines of $fil ...\n" );
		for ($k = 0; $k < $ccnt; $k++) {
			$cline = $clines[$k];
			$k2 = $k + 1;
			chomp $cline;
			$tline = $cline;	# trim_all($cline);
			$ll = length($tline);
			if ( !$incomm && ($tline =~ /^\s*#\s*include\s+(.*)$/)) {
				push(@incs,trim_include_tail($1));
				next;	# skip '#include <main/main.h>' like INCLUDE lines
			}
			$lncomm = 0;
			$pch = '';
			for ($j = 0; $j < $ll; $j++) {
				$ch = substr($tline,$j,1);
				if ($incomm) {
					# only looking for CLOSE comment */
					if (($ch eq '/') && ($pch eq '*')) {
						$incomm = 0;
					}
				} else {
					if ($ch eq '"') {
						# start of QUOTE
						$j++;	# to next char
						$pch = $ch;
						for ( ; $j < $ll; $j++) {
							$ch = substr($tline,$j,1);
							if (($ch eq '"')&&($pch ne "\\")) {
								last;	# out of here
							}
							$pch = $ch;
						}
					} elsif (($ch eq '*') && ($pch eq '/')) {
						# comment start /* until */
						$incomm = 1;
						$wascomm = 1;
					} elsif (($ch eq '/') && ($pch eq '/')) {
						$j = $ll;	# skip rest of line
						$lncomm = 1;
					}
				}
				$pch = $ch;
			}
			###prt( "line $k2:[$tline]$ll ($incomm:$lncomm) $fnd1 $fndm\n" );
			$wascomm = $incomm;
			$pline = $cline;
		}
	} else {
		prt( "WARNING: Unable to open [$fil] file ... $! ...\n" );
	}
	return @incs;
}



sub process_files($) {
    my ($ra) = @_;  # \@in_files
    foreach my $file (@{$ra}) {
        my @arr = ();
        my $mo = '';
        if ($do_chkmain) {
            if ( !chk_main( $file, \@arr ) ) {
                prt( "NOTE: NO MAIN FOUND in $file\n" );
                push(@missed_main, $file);
            } else {
                $mo = "$file - HAS MAIN";
                my $ac = scalar @arr;
                for (my $m = 0; $m < $ac; $m++) {
                    $mo .= "\n  ".$arr[$m][0].": ". $arr[$m][1];
                    $mo .= " cond " . $arr[$m][2] if (length($arr[$m][2]));
                }
                prt( "$mo\n" );
            }
        } else {
            my @is = get_includes($file);
            prt( "\nCount: ".scalar @is." includes in: $file\n". join(", ",@is) ."\n" );
        }
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);

process_files( \@in_files );

if (@missed_main) {
	prt( "\nNOTE: ".scalar @missed_main." file with NO 'main' ...\n" );
	prt( join("\n", @missed_main)."\n\n");
}

pgm_exit(0,"");
#############################################

sub give_help {
    prt("$pgmname: version 0.0.1 2010-05-05\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have follwoing argument!\n")
        if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /-/);
            if (($sarg =~ /h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            push(@in_files,$in_file);
            prt("Added input [$in_file]\n");
        }
        shift @av;
    }
    if (!@in_files) {
        pgm_exit(1,"ERROR: No INPUT file found in command!\n");
    }

}

# eof
