#!/perl -w
# hrefsub - make substitutions in <A HREF="..."> fields of HTML files
# from : Gisle Aas <gisle@aas.no>
# changed: FIX20060917
sub usage { die "Usage: $0 <from> <to> <file>...\n" }

my $from = shift or usage;
my $to   = shift or usage;
usage unless @ARGV;

# The HTML::Filter subclass to do the substitution.

package MyFilter;
require HTML::Filter;
@ISA=qw(HTML::Filter);
use HTML::Entities qw(encode_entities);

sub start {
   my($self, $tag, $attr, $attrseq, $orig) = @_;
   if ($tag eq 'a' && exists $attr->{href}) {
           if ($attr->{href} =~ s/\Q$from/$to/g) {
               # must reconstruct the start tag based on $tag and $attr.
               # wish we instead were told the extent of the 'href' value
               # in $orig.
               my $tmp = "<$tag";
               for (@$attrseq) {
                   my $encoded = encode_entities($attr->{$_});
                   ### FIX20060917 $tmp .= qq( $_="$encoded ");
                   $tmp .= qq( $_="$encoded");
               }
               $tmp .= ">";
               $self->output($tmp);
               return;
           }
   }
   $self->output($orig);
}

# Now use the class.

package main;
foreach (@ARGV) {
        MyFilter->new->parse_file($_);
}

#-----------------------------
#eof
