#!/perl -w
# NAME: imglist.pl
# AIM: Given a folder, search for ALL image files
# 08/12/2008 - revisited, and works fine as a SIMPLE LIST
# 19/07/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
use File::stat; # to get the file date
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_folder = '';
my $def_folder = 'C:\HOMEPAGE\GA';
$in_folder = shift @ARGV || $def_folder;

my @graf_ext = qw( .jpg .jpeg .gif .png .bmp .ico .mpg .tif );
my @fpfolders = qw( _vti_cnf _vti_pvt _private _derived );

my @imagelist = ();
my $fndcnt = 0;
my $filcnt = 0;
my $dircnt = 0;
my $file = '';
my $start_time = time();
prt( "Processing folder $in_folder ...\n" );

get_image_list($in_folder);
$fndcnt = scalar @imagelist;
prt( "Found $fndcnt images ... in $dircnt directories, $filcnt files ... (".elapsed_seconds()." secs)\n" );

foreach $file (@imagelist) {
    prt( "$file\n" );
}
prt( "Done $fndcnt images ... (".elapsed_seconds()." secs)\n" );

close_log($outfile,1);
exit(0);

###########################################

sub elapsed_seconds {
    my $tm = time();
    return ($tm - $start_time);
}

#########################################################
# Passed an array of extensions,
# check if this is one of them?
#########################################################
sub is_my_ext {
	my ($fil, @exts) = @_;
	my ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
	foreach my $ex (@exts) {
		if (lc($ex) eq lc($ext)) {
			return 1;
		}
	}
	return 0;
}

############################################
# only looking for GRAPHIC extensions,
# could be extended to others maybe ...
############################################
sub is_graphic_ext {
	my ($fil) = shift;
	return( is_my_ext($fil, @graf_ext) );
}

sub is_fp_folder {
    my ($fdr) = shift;
    my $tst;
    foreach $tst (@fpfolders) {
        if ($tst eq $fdr) {
            return 1;
        }
    }
    return 0;
}

sub get_image_list {
    my ($inf) = shift;
    my ($itm, $ff);
    my @fldrs = ();
	if ( opendir( DIR, $inf ) ) {
		my @files = readdir(DIR);
		closedir DIR;
		foreach $itm (@files) {
			if (($itm eq '.') || ($itm eq '..')) {
				next;
			}
			$ff = $inf . "\\" . $itm;
			if (-d $ff) {
                push(@fldrs,$ff) if !is_fp_folder($itm);
                $dircnt++;
                if (($dircnt % 100) == 0) {
                    prt( "Found ".scalar @imagelist." images ... in $dircnt directories, $filcnt files ... (".elapsed_seconds()." secs)\n" );
                }
                ##last if ($dircnt > 2000);
            } else {
                push(@imagelist, $ff) if (is_graphic_ext($itm));
                $filcnt++;
            }
        }
        foreach $itm (@fldrs) {
            get_image_list($itm);
        }
    } else {
        prt( "ERROR: Failed to OPEN $inf ...\n" );
    }
}


# eof
