#!/perl -w
# *NAME* temp5.pl
use strict;
use warnings;
use Math::Trig;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $showref = 0; # output the color reference list, and exit
my $outfile = 'temp.'.$0.'.txt';
my $htmfile = 'temp.'.$0.'.htm';
# debug items
my $dbg1 = 0;	# show each is_in_used call
my $dbg2 = 0;	# show paragraph added to table
my $dbg3 = 0;	# list, as text, the standard generated colors
my $lunarPeriod  = 29*(24*3600*1000) + 12*(3600*1000) + 44.05*(60*1000);
my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
my @weekDays = qw(Sun Mon Tue Wed Thu Fri Sat Sun);
my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings);
# A number of time/date functions refer to 'seconds since the epoch.' 
# On UNIX, the 'epoch' would be midnight Jan. 1, 1970. On the Mac, it is 
# midnight, Jan. 1, 1904. The entry in "Perl in a Nutshell" for time states:
# Returns the number of non-leap seconds since January 1, 1970, UTC.
#// Get Date (GMT) for recent full moon NOTE: months, hours, and minutes are 0 based
#	var blueMoonDate = new Date(96, 1, 3, 16, 15, 0);
my $blueMoonDate = ((1996-1970)*365*24*3600) + (34*24*3600) + (16*3600) + (15*60);
($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = localtime();
my $year = 1900 + $yearOffset;
my $theTime = "$hour:$minute:$second, $weekDays[$dayOfWeek] $months[$month] $dayOfMonth, $year";
($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = gmtime();
my $gmyear = 1900 + $yearOffset;
my $theGMTime = "$hour:$minute:$second, $weekDays[$dayOfWeek] $months[$month] $dayOfMonth, $gmyear";
my $blueEpoc = 820746900;
($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = gmtime($blueEpoc);
my $bmyear = 1900 + $yearOffset;
my $theBMTime = "$hour:$minute:$second, $weekDays[$dayOfWeek] $months[$month] $dayOfMonth, $gmyear";

open_log($outfile);
prt( "$0 ... Hello, World ... $theTime (GMT $theGMTime) (BM $theBMTime) $blueMoonDate $blueEpoc\n" );

my ($HF, $msg, $clr);
open $HF, ">$htmfile" or mydie( "ERROR: Unable to open $htmfile ...\n" );

my $t45 = tan(deg2rad(45));
my $at = rad2deg(atan(1));

prt( "tan(45) = $t45 ... atan(1) = $at \n");

# HTML OUTPUT
# ===========
html_begin($HF);
print $HF "<p>$0 ... Hello, World ... $theTime (GMT $theGMTime) (BM $theBMTime) $blueMoonDate $blueEpoc</p>\n";
gen_circle($HF);
###out_color_wheel( $HF );
out_moon_circle( $HF, 50, 40, 50 );
html_end($HF);
# END HTML OUTPUT

close $HF;
system($htmfile);
close_log($outfile,1);
exit(0);

sub html_begin {
	my ($f) = shift;
	print $f <<"EOF";
<html>
<head>
<title>$htmfile</title>
<style type="text/css">
<!-- /* Style Definitions */
body {
margin:1cm 1cm 1cm 1cm;
}
p {
margin:0cm;
padding:0cm
}

-->
</style>

</head>
<body>
<h1>$htmfile</h1>
EOF

}

sub html_end {
	my ($f) = shift;
	print $f <<"EOF";
</body>
</html>
EOF

}


sub floor { ($_[0]<0) ? -int -$_[0]+1 : int $_[0] } 
sub ceil { ($_[0]<0) ?  -int -$_[0] : int $_[0]+1 } 
sub round { ($_[0]>0) ?  int $_[0]+0.5 : int $_[0]-0.5 } 

# 0,0 cx=26,cx=26 angle=45 rx=18.3847763108502, ry=18.3847763108502 ... quad=1
# ...
# 25,0 cx=1,cx=1 angle=2.20259816176581 rx=0.999261174631314, ry=25.9807905404142 ... quad=1
# 26,0 cx=0,cx=0 angle=0 rx=0, ry=26 ... quad=2
# 27,0 cx=-1,cx=-1 angle=-2.20259816176581 rx=-0.999261174631314, ry=25.9807905404142 ... quad=2
# ...
# 51,25 cx=-25,cx=-25 angle=-87.7093899573615 rx=-25.9792249267665, ry=1.03916899707066 ... quad=2
# 0,26 cx=26,cx=26 angle=89.9977963161737 rx=25.9999999807692, ry=0.00099999999926155 ... quad=4
# ...
# 25,26 cx=1,cx=1 angle=89.9427042395855 rx=25.9999870000097, ry=0.0259999870000083 ... quad=4
# 26,26 cx=0,cx=0 angle=0 rx=0, ry=26 ... quad=3
# 27,26 cx=-1,cx=-1 angle=-89.9427042395855 rx=-25.9999870000097, ry=0.0259999870000083 ... quad=3
# ...
# 51,51 cx=-25,cx=-25 angle=45 rx=18.3847763108502, ry=18.3847763108502 ... quad=3
sub out_of_circle {
	my ($x, $y, $rx, $ry, $rad) = @_;
	my $rval = 0;
	my $xmin = abs($rx);
	my $xmax = $rad + ($rad - abs($rx));
	my $ymin = $rad - abs($ry);
	my $ymax = $rad + abs($ry);
	if (($x < $xmin)||($x > $xmax)||($y < $ymin)||($y > $ymax)) {
		$rval = 1;
	}
	if ($x == 0) {
		prt("\n");
	}
	prt( sprintf("$x,$y %2.2f,%2.2f ", $rx, $ry) );
	prt( sprintf("(%2.2f %2.2f %2.2f %2.2f) ", $xmin, $xmax, $ymin, $ymax) );
	prt( "x < min " ) if ($x < $xmin);
	prt( "x > max " ) if ($x > $xmax);
	prt( "y < min " ) if ($y < $ymin);
	prt( "y > max " ) if ($y > $ymax);
	prt( ($rval ? "Out" : "IN") );
	prt( "\n" );
	return $rval;
}

sub get_bg_color {
	my ($x, $y, $grid, $part) = @_;
	my $max = $grid * $part;
	my $rad = $max / 2;
	my $fact = 256 / ($max - 1);
	my ($r, $g, $b);
	my ($xf, $yf);
	my $cx = $rad - $x;
	my $cy = $rad - $y;
	#my $dx = $cx - $x;
	#my $dy = $y - $cy;
	#my $q = 'quad ';
	my $qn = 0;
	if ($x < $rad) {
		if ($y < $rad) {
			$qn = 1;
		} else {
			$qn = 4;
		}
	} else {
		if ($y < $rad) {
			$qn = 2;
		} else {
			$qn = 3;
		}
	}
	if ($cy == 0) {
		$cy = 0.001;
	}
	my $rang = atan( $cx / $cy );
	my $rx = $rad * sin($rang);
	my $ry = $rad * cos($rang);
	my $out = out_of_circle( $x, $y, $rx, $ry, $rad );
	if ($x == 0) {
		prt("\n");
	}
	prt( "$x,$y cx=$cx,cx=$cx angle=".sprintf("%2.2f",rad2deg($rang))." out=$out\n" );
	
	$r = $g = $b = 0;
	$xf = int($x * $fact);
	$xf = 255 if ($xf >= 256);
	$yf = int($y * $fact);
	$yf = 255 if ($yf >= 256);
	$b = 255 - $xf;
	$g = $xf;
	my $c = '#FFFFFF';
	if ( ! $out ) {
		$c = uc(sprintf("#%2.2x%2.2x%2.2x", $r, $g, $b ));
	}
	return $c;
}


# color wheel
# see : javascipt/colorwheel.htm, using colorwheel.jpg
#          Turquoise
#     Blue          Green
#          \       /
#            Black 
#      Mauve   |   Yellow
#             Red
#
sub out_color_wheel {
	my ($f) = shift;
	my $grid = 13;
	my $part = 4;
	my $max = $grid * $part;
	my $msg = '';
	my $hdr = "Color Wheel - $max x $max grid";
	prt( "Out put of $hdr ...\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\" width=\"100%\">\n";
	my $cols = 0;
	my $i = 0;
	my $j = 0;
	my ($r, $g, $b);
	my ($hr, $hg, $hb);
	my ($sty);
	for ($i = 0; $i < $max; $i++) {
		print $f "<tr>\n";
		for ($j = 0; $j < $max; $j++) {
			$msg = "<td bgcolor=\"".get_bg_color($j, $i, $grid, $part)."\">";
			if ($j == 0) {
				$msg .= "$i";
			} else {
				$msg .= ".";
			}
			$msg .= "</td>\n";
			print $f $msg;
		}
		print $f "</tr>\n";
	}
	print $f "</table>\n";
}

sub simple_circle {
	my ($i, $x, $y);
	my $rad = 70;
	my $max = pi * 6;
	my $step = 0.03;
	my $cnt = 0;
	my $mrad = sprintf("%2.4f", $max);
	prt( "Gen circle, radius $rad, for 0 to $mrad (6 * pi), step $step ...\n" );
	for ($i = 0; $i < $max; $i += $step)
	{
		$cnt++;
		$x = cos($i) * $rad;
		$y = sin($i) * $rad;
		prt( sprintf("%3d %2.3f x,y = %3.2f,%3.2f ...\n", $cnt, $i, $x, $y ));
	}
}

sub in_circ {
	# x and y reference commence upper left
	my ($x, $y, $rad) = @_;
	my ($cx, $cy, $nx, $ny, $xok, $yok, $io, $err);
	if ($x < $rad) {
		$cx = $rad - $x;
	} else {
		$cx = $x - $rad;
	}
	if ($y < $rad) {
		$cy = $rad - $y;
	} else {
		$cy = $y - $rad;
	}
	# have a $cx, and $cy, find angle(radians)
	$cy = 0.001 if ($cy == 0);
	my $ang = atan( $cx / $cy );
	my $ex = cos($ang) * $rad;
	my $ey = sin($ang) * $rad;
	$err = '';
	if ($x < $rad) {
		$nx = round($ex);
		if( $x < $nx ) {
			$xok = 0;
			$err .= 'x < nx ';
		} else {
			$xok = 1;
		}
	} else {
		$nx = round($rad + $ex);
		if ($x > $nx) {
			$xok = 0;
			$err .= 'x > nx ';
		} else {
			$xok = 1;
		}
	}
	if ($y < $rad) {
		$ny = round($ey);
		if ($y < $ny) {
			$yok = 0;
			$err .= 'y < ny ';
		} else {
			$yok = 1;
		}
	} else {
		$ny = round($ey + $rad);
		if ($y > $ny) {
			$yok = 0;
			$err .= 'y > ny ';
		} else {
			$yok = 1;
		}
	}
	if ($xok && $yok) {
		$io = 'IN';
	} else {
		$io = 'OT';
	}

	##prt( "$x,$y ".sprintf("%2.2f,%2.2f %2.2f,%2.2f", $ex, $ey, $nx, $ny )." ($cx,$cy) ... $io ... $err \n" );
	prt( "$x,$y ".sprintf("%2.2f,%2.2f %2d,%2d", $ex, $ey, $nx, $ny )." ($cx,$cy) ... $io ... $err \n" );

	return $io;
}

sub gen_circle {
	my ($f) = shift;
	my ($i, $x, $y);
	my $rad = 5;
	my $diam = $rad * 2;
	my $cnt = 0;
	my $out = 0;
	my $fill = '';
	my $hdr = "Generate grid - $rad x $rad";
	prt( "$hdr ...\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\">\n";
	for( $y = 0; $y < $diam; $y++ ) {
		printf $f "<tr>\n";
		for ($x = 0; $x < $diam; $x++) {
			$out = in_circ( $x, $y, $rad );
			printf $f "<td>$out</td>\n";
		}
		printf $f "</tr>\n";
	}
	print $f "</table>\n";
}

sub out_moon_circle {
	my ($f, $siz, $moonPhaseTime, $lunarPeriod) = @_;
	my ($i, $ss, $msg);
	# Compute various percentages of lunar cycle
	$ss = $siz * $siz;
	my $percentRaw = ($moonPhaseTime / $lunarPeriod);
	my $percent    = round( 100 * $percentRaw ) / 100;
	my $percentBy2 = round( 200 * $percentRaw );
  	if ($percentBy2 > 100) {
   		$percentBy2 -= 100;
    }
	my $phasePc = $percent * 100;
	my $fullPc = $percentBy2;
	
	my $left  = ($percentRaw >= 0.5) ? "black.gif" : "white.gif";
	my $right = ($percentRaw >= 0.5) ? "white.gif" : "black.gif";
	prt( "Rawpct = $percentRaw, pctx2 = $percentBy2 ... left=$left right=$right ...\n" );
	print $f "<p>Rawpct = $percentRaw, pctx2 = $percentBy2 ... left=$left right=$right ...</p>\n";

   printf $f "<center>\n";
   printf $f "<table border=\"1\"><tr>\n";
   printf $f "<td align=\"center\" bgcolor=\"#aaaaff\">\n";
   for ( $i = -($siz - 1); $i < $siz; $i++ ) {
	   my $val = $ss - ( $i * $i );
	   my $wid = 2 * sqrt( $val );
	   $msg = '';
	   if ($percentBy2 != 100) {
		   $msg .= "<img src=\"" . $left . "\" height=\"1\" width=\"";
		   $msg .= int( $wid * ( (100 - $percentBy2 ) / 100 ));
		   $msg .= "\">";
	   }
	   if ($percentBy2 != 0) {
		   $msg .= "<img src=\"". $right . "\" height=\"1\" width=\"";
		   $msg .= int( $wid * ( $percentBy2 / 100 ) );
		   $msg .= "\">";
	   }
	   printf $f $msg;
	   prt( "$i $msg \n" );
	   printf $f "<br>\n";
   }
   printf $f "</td></tr></table>\n";
   printf $f "</center>\n";

}


#-----------------------------
sub hypotenuse {
    my ($side1, $side2) = @_;
    return sqrt( ($side1 ** 2) + ($side2 ** 2) );
}


# eof - colors2.pl
