#!/perl -w
# NAME: movedsp.pl
# WORK IN PROGRESS
# AIM: Given a path to a DSP file, move it to a new target directory,
# fixing all the relative paths of the SOURCE files, and maybe attempting
# to 'fix' the CPP lines
# 05/03/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename; # split ($name,$dir) = fileparse($ff); or ($nm,$dir,$ext) = fileparse( $fil, qr/\.[^.]*/ );
unshift(@INC, 'C:/GTools/perl');
#require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'fgutils02.pl' or die "Unable to load fgutils02.pl ...\n";
require 'fgdsphdrs03.pl' or die "Unable to load fgdsphdrs03.pl ...\n";
require 'scanvc.pl' or die "Unable to load scanvc.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $load_out = 0; # load output at end

my $in_file = 'C:\FG\27\curl\build\postit2.dsp';
#my $in_file  = 'C:\GTools\tools\Spy5\Spy5.dsp';
my $targ_dir = 'C:\GTools\tools\Spy5\build';
# DEBUG
my $dbg_01 = 0; # prt("Enter CFG [$cfg]\n") if ($dbg_01);, AND ELSIF, ENDIF
my $dbg_02 = 0; # debug space_split (and EXIT)
my $dbg_03 = 0; # try big list

my @warnings = ();
# forward
sub show_warnings($);

sub pgm_exit($$) {
   my ($val,$msg) = @_;
   if (length($msg)) {
      $msg .= "\n" if !($msg =~ /\n$/);
      prt($msg);
   }
   show_warnings($val);
   close_log($outfile,$load_out);
   exit($val);
}

sub prtw($) {
    my ($tx) = shift;
    $tx =~ s/\n$//;
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings($) {
	my ($dbg) = shift;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } elsif ($dbg) {
        prt("\nNo warnings issued.\n\n");
    }
}

# APP_TYPE - PROJECT_APTP
# $app_console_stg  = 'Console Application'
# $app_windows_stg  = 'Application'
# $app_dynalib_stg  = 'Dynamic-Link Library'
# $app_statlib_stg  = 'Static Library'
# DSP TYPES
# TARGTYPE "Win32 (x86) Application" 0x0101
# TARGTYPE "Win32 (x86) Dynamic-Link Library" 0x0102
# TARGTYPE "Win32 (x86) Console Application" 0x0103
# TARGTYPE "Win32 (x86) Static Library" 0x0104

# from scanvc.pl library
#sub get_default_ref_hash($) {
#    my ($fil) = @_;
#    my %hash = ();
#    my $rh = \%hash;
#    ${$rh}{'PROJECT_VERS'} = 1; # version of the HASH
#    ${$rh}{'PROJECT_FILE'} = $fil;
#    ${$rh}{'PROJECT_FLAG'} = 0;
#    ${$rh}{'PROJECT_APTP'} = '';
#    ${$rh}{'PROJECT_CCNT'} = 0; # count of configurations
#    ${$rh}{'PROJECT_CFGS'} = [ ];
#    ${$rh}{'PROJECT_SRCS'} = [ ];
#    ${$rh}{'CURR_FLAG'}    = 0;
#    ${$rh}{'CURR_LOFF'}    = 0; # last/current source OFFSET
#    ${$rh}{'CURR_LINE'}    = '<not started>';
#    return $rh;
#}
sub get_def_dsp_hash_ref($) {
    my ($fil) = @_;
    my $rh = get_default_ref_hash($fil);
    #${$rh}{'PROJECT_VERS'} = 1; # version of the HASH
    #${$rh}{'PROJECT_FILE'} = $fil;
    #${$rh}{'PROJECT_FLAG'} = 0;
    #${$rh}{'PROJECT_APTP'} = '';
    ${$rh}{'PROJECT_NAME'} = '';
    #${$rh}{'PROJECT_CCNT'} = 0; # count of configurations
    #${$rh}{'PROJECT_CFGS'} = [ ];
    #${$rh}{'PROJECT_SRCS'} = [ ];
    #${$rh}{'CURR_FLAG'}    = 0;
    #${$rh}{'CURR_LOFF'}    = 0; # last/current source OFFSET
    #${$rh}{'CURR_LINE'}    = '<not started>';
    return $rh;
}

sub get_tool_set_ref() {
   my %tools = (
      'CFG' => '',
      'CPP' => '',
      'RSC' => '',
      'BSC32' => '',
      'LINK32' => '',
      'MTL' => '',
      'LIB32' => '',
      'F90' => ''
   );
   return \%tools;
}

#  ( $cfgnm, \%cfgnames, $cfgnamcnt );
sub check_cfg_name($$$) {
   my ($test,$rcns, $ccnt) = @_;
   my ($tmp);
   my $fnd = 0;
   foreach $tmp (keys %{$rcns}) {
      $fnd++;
      if ($tmp eq $test) {
         return $fnd;
      }
   }
   prt("ERROR: CFG Name NOT found [$test]! Have list $ccnt...\n");
   foreach $tmp (keys %{$rcns}) {
      prt("$tmp\n");
   }
   pgm_exit(1,"ERROR: Check and FIX CODE for [$test]\n");
   return 0;
}

# $tmp, \@targtypes, $targtcnt );
sub check_targ_type($$$) {
   my ($test, $ra, $cnt) = @_;
   my ($k);
   for ($k = 0; $k < $cnt; $k++) {
      if (${$ra}[$k] eq $test) {
         return ($k + 1);
      }
   }
   prt( "ERROR: DIFFERENT TARG TYPE! [$test] Have $cnt, as follows...\n" );
   for ($k = 0; $k < $cnt; $k++) {
      prt( "${$ra}[$k]\n");
   }
   pgm_exit(1,"ERROR: DIFFERENT TARG TYPE! [$test] FIX, CHECK CODE\n");
   return 0;
}

# how it is done in scanvc.pl
#     1    2    3    4      5    6         7     8
# my ($xln,$rah,$tag,$pname,$fil,$projname,$line,$flag);
#sub extract_curr_items($$$$$$$$$) {
#            1     2     3     4     5     6     7     8
#    my ($rh,$rxln,$rrah,$rtag,$rpnm,$rfil,$rnam,$rlin,$rflg) = @_;
#    ${$rxln} = ${$rh}{'CURR_LINE'};   # 1
#    ${$rrah} = ${$rh}{'CURR_HASH'};   # 2
#    ${$rtag} = ${$rh}{'CURR_TAG'};    # 3
#    ${$rpnm} = ${$rh}{'CURR_NAME'};   # 4
#    ${$rfil} = ${$rh}{'PROJECT_FILE'};# 5
#    ${$rnam} = ${$rh}{'PROJECT_NAME'};# 6
#    ${$rlin} = ${$rh}{'CURR_TEXT'};   # 7
#    ${$rflg} = ${$rh}{'CURR_FLAG'};   # 8
#}
#sub add_vs_config_item($) {
sub add_dsp_config_item($) {
    my ($rh) = @_;
    my ($xln,$rah,$tag,$pname,$fil,$projname,$line,$flag);
    extract_curr_items($rh,\$xln,\$rah,\$tag,\$pname,\$fil,\$projname,\$line,\$flag);
    my $conf = $pname;              # like ReleaseSSE|WIN32
    my @arr = split(/\|/,$pname);   # split it
    my $confname = $arr[0];         # get just 'ReleaseSSE' 
    ${$rh}{'CURR_CONF'} = $confname;
    ${$rh}{'CURR_CON1'} = $conf;
    my $dnapptype = ${$rh}{'PROJECT_APTP'};
    # 28/09/2008 - note, has quotes added
    # "-NEW_OUTD-" $out_dir
    # "-NEW_INTER-" $int_dir
    my $var1 = "-NEW_OUTD-";
    my $var2 = "-NEW_INTER-";
    my ($dsp_sub_sub, $seek, $adddeps, $apptype);
    if ($conf =~ /Debug/i) {
        $dsp_sub_sub = get_default_sub3(1);
    } else {
        $dsp_sub_sub = get_default_sub3(0);
        if (!($conf =~ /Release/i)) {
            prtw( "WARNING:$xln pname=[$conf] NOT Debug or Release - def to REL! [$fil]\n" );
        }
    }
    my $rcfgs = get_project_configs($rh);   # 'PROJECT_CFGS'
    push(@{$rcfgs}, [ $confname, $var1, $conf, $dsp_sub_sub ]);
}

# # Microsoft Developer Studio Project File - Name="FlightGear" - Package Owner=<4>
# # Microsoft Developer Studio Generated Build File, Format Version 6.00
# # ** DO NOT EDIT **
# # TARGTYPE "Win32 (x86) Console Application" 0x0103
# CFG=FlightGear - Win32 Debug
# !MESSAGE This is not a valid makefile. To build this project using NMAKE,
# !IF "$(CFG)" == "someconfig"

# # Begin Target
# # Name "FlightGear - Win32 Release"
# # Name "FlightGear - Win32 Debug"
# # Begin Group "Lib_Aircraft"
# # PROP Default_Filter ""
# # Begin Source File

sub process_dsp_file($) {
   my ($dsp) = @_;
   my $dsp_ref_hash = get_def_dsp_hash_ref($dsp);
   my @sources = ();
   if (open INF, "<$dsp") {
      my @lines = <INF>;
      close INF;
      my $lncnt = scalar @lines;
      prt("Processing $lncnt lines from [$dsp] file...\n");
      my ($gotdsp,$lnn,$projname,$targnum);
      my ($key,$var,$cfg,$bgntarg,$bgnproj,$bgnsrc,$group);
      my ($custom,$prop,$version,$cfgnmcnt,$cfgnm,$add);
      my ($cpp,$rsc,$bsc32,$link32,$customstg,$mtl,$lib32,$f90);
      my ($base,$line,$oline,@arr);
      my ($cfg_proj,$cfg_name,$cfg_plat,$cfg_type,$tmp);
      my ($flist,$tdir,$igexlib,$intdir,$outdir,$exfrmbld);
      my ($special,$specstg);
      my ($k,$tmp2,$isdebug);
      my (@targtypes,$targtcnt,$targtype1);
      my ($dsp_sub_sub,$rcfgs,$var1);
      my ($ingroup);
      @targtypes = ();  # multiple target types
      $targtcnt = 0;    # count of found
      $targtype1 = '';  # although DSP can support multiple types, keep only the first

      $isdebug = 0;
      $gotdsp = 0;
      $lnn = 0;
      $bgntarg = 0;
      $bgnproj = 0;
      $bgnsrc = 0;
      $cfg = '';
      $group = '';
      $custom = '';
      $customstg = '';
      $prop = '';
      $version = '';
      $cfgnmcnt = 0;
      $add = 0;
      $cpp = '';
      $rsc = '';
      $bsc32 = '';
      $link32 = '';
      $lib32 = '';
      $f90 = '';
      $base = 0;
      #my %cfgnms = ();
      my %cfgnames = ();
      my $cfgnamcnt = 0;
      my $ref_tools = get_tool_set_ref();
      $special = 0;  # Begin to End Special Build Tool
      $specstg = '';
      $ingroup = 0;
      $group = '';   # group name
      $flist = '';   # filter list for group
      foreach $oline (@lines) {
         $lnn++;
         chomp $oline;
         $oline = substr($oline,0,length($oline)-1) while ($oline =~ /\s$/);
         next if (length($oline) == 0);
         $line = $oline;
         $add = 0;
         $base = 0;
         if ($gotdsp) {
            if ($line =~ /^#\s+/) {
               $line = substr($line,2);
               if ($line =~ /^ADD /) {
                  $add = 1;
                  $line = substr($line, 4);
               } elsif ($line =~ /^SUBTRACT /) {
                  $add = -1;
                  $line = substr($line, 9);
               }
               if ($line =~ /^BASE\s+/) {
                  $base = 1;
                  $line = substr($line, 5);
               }
               if ($line =~ /^TARGTYPE\s+"(.+)"\s+(.+)\s*$/) {
                  $tmp = $1;
                  $targnum = $2;
                  push(@targtypes, $tmp);   # set target type string - san double quotes
                  $targtcnt++;
                  if (length($targtype1) == 0) {
                     # DSP TYPES 0      1    2            3
                     # TARGTYPE "Win32 (x86) Application" 0x0101
                     # TARGTYPE "Win32 (x86) Dynamic-Link Library" 0x0102
                     # TARGTYPE "Win32 (x86) Console Application" 0x0103
                     # TARGTYPE "Win32 (x86) Static Library" 0x0104
                     @arr = split(/\s/,$tmp);
                     $tmp2 = scalar @arr;
                     for ($k = 2; $k < $tmp2; $k++) {
                        $targtype1 .= ' ' if length($targtype1);
                        $targtype1 .= $arr[$k];
                     }
                     ${$dsp_ref_hash}{'PROJECT_APTP'} = $targtype1;
                  }
                  prt("$targtcnt: TARGTYPE = [$tmp] num [$targnum]\n");
               } elsif ($line =~ /^Microsoft\s+Developer\s+Studio\s+Generated\s+Build\s+File,\s+Format\s+Version\s+(.+)\s*$/) {
                  $version = $1;
               } elsif (($line =~ /^\*\*\s+DO\s+NOT\s+EDIT\s+\*\*\s*$/)||
                  ($line =~ /\*\* NICHT BEARBEITEN \*\*/)) {
                  # skip it
               } elsif ($line =~ /^Begin\s+Target\s*$/) {
                  $bgntarg = 1;
               } elsif ($line =~ /^Begin\s+Project\s*$/) {
                  $bgnproj = 1;
               } elsif ($line =~ /^End\s+Target\s*$/) {
                  $bgntarg = 0;
               } elsif ($line =~ /^End\s+Project\s*$/) {
                  $bgnproj = 0;
               } elsif ($line =~ /^End\s+Source\s+File\s*$/) {
                  $bgnsrc = 0;
               } elsif ($line =~ /^Begin\s+Source\s+File\s*$/) {
                  $bgnsrc = 1;
               } elsif ($line =~ /^Begin\s+Group\s+(.+)\s*$/) {
                  # # Begin Group "Source Files"
                  $group = strip_quotes($1);   # usually with quotes
                  $ingroup = 1;
               } elsif ($line =~ /^End\s+Group\s*$/) {
                  $group = '';
                  $ingroup = 0;
               } elsif ($line =~ /^Begin\s+Custom\s+Build\s+(.+)\s*$/) {
                  $custom = $1;
               } elsif ($line =~ /^End\s+Custom\s+Build\s*$/) {
                  $custom = '';
                  $customstg = '';
               } elsif ($line =~ /^Begin Special Build Tool$/) {
                  $special = 1;
                  $specstg = '';
                  # # Begin Special Build Tool
                  # OutDir=.\Release
                  # SOURCE="$(InputPath)"
                  # PostBuild_Cmds=$(outdir)\VisualPng.exe ..\..\contrib\pngsuite\basn6a16.png
                  # # End Special Build Tool
               } elsif ($line =~ /^End Special Build Tool$/) {
                  $special = 0;
               } elsif ($line =~ /^PROP\s+(.+)\s*$/) {
                  $prop = $1;
                  # ALL THE '# PROP ' TYPE ENTRIES
                  if ($prop =~ /^BASE\s+/) {
                     $prop = substr($prop,5);
                     $base = 1;
                  }
                  if ($prop =~ /^Default_Filter\s+(.+)$/) {
                     # PROP Default_Filter "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat"
                     # PROP Default_Filter "h;hpp;hxx;hm;inl"
                     # PROP Default_Filter ""
                     $flist = strip_quotes($1);
                  } elsif ($prop =~ /^Target_Dir\s+(.+)$/) {
                     # PROP BASE Target_Dir ""
                     # PROP Target_Dir ""
                     $tdir = strip_quotes($1);
                  } elsif ($prop =~ /^Ignore_Export_Lib\s+(.+)$/) {
                     # PROP Ignore_Export_Lib 0
                     $igexlib = $1;
                  } elsif ($prop =~ /^Intermediate_Dir\s+(.+)$/) {
                     # PROP BASE Intermediate_Dir "Release"
                     # PROP Intermediate_Dir "Release"
                     # PROP BASE Intermediate_Dir "Debug"
                     # PROP Intermediate_Dir "Debug"
                     $intdir = strip_quotes($1);
                  } elsif ($prop =~ /^Output_Dir\s+(.+)$/) {
                     # PROP BASE Output_Dir "Debug"
                     # PROP Output_Dir "Debug"
                     # PROP BASE Output_Dir "Release"
                     # PROP Output_Dir "Release"
                     $outdir = strip_quotes($1);
                  } elsif ($prop =~ /^Use_Debug_Libraries\s+(.+)$/) {
                     # PROP BASE Use_Debug_Libraries 0
                     # PROP Use_Debug_Libraries 0
                     # PROP BASE Use_Debug_Libraries 1
                     # PROP Use_Debug_Libraries 1
                  } elsif ($prop =~ /^Use_MFC\s+(.+)$/) {
                     # PROP BASE Use_MFC 0
                     # PROP Use_MFC 0
                  } elsif ($prop =~ /^AllowPerConfigDependencies\s+(.+)$/) {
                     # PROP AllowPerConfigDependencies 0
                  } elsif ($prop =~ /^Scc_ProjName\s+(.+)$/) {
                     # PROP Scc_ProjName ""
                  } elsif ($prop =~ /^Scc_LocalPath\s+(.+)$/) {
                     # PROP Scc_LocalPath ""
                  } elsif ($prop =~ /^Exclude_From_Build\s+(.+)$/) {
                     # PROP Exclude_From_Build 1
                     $exfrmbld = $1;
                  } else {
                     pgm_exit(1,"ERROR: Uncased PROP [$prop] [$oline]\n");
                  }
               } elsif ($line =~ /^Name\s+(.+)\s*$/) {
                  $cfgnm = strip_quotes($1);
                  # like from
                  # # Begin Target
                  # # Name "minigzip - Win32 DLL Release"
                  # # Name "minigzip - Win32 DLL Debug"
                  # # Name "minigzip - Win32 DLL ASM Release"
                  # etc
                  # # Begin Group "Source Files"
                  $cfgnmcnt++;
                  prt( "$cfgnmcnt: CFG Name: [$cfgnm]\n");
                  check_cfg_name( $cfgnm, \%cfgnames, $cfgnamcnt );
               } elsif ($line =~ /^CPP /) {
                  $cpp = substr($line,4);
               } elsif ($line =~ /^RSC /) {
                  $rsc = substr($line,4);
               } elsif ($line =~ /^BSC32 /) {
                  $bsc32 = substr($line,6);
               } elsif ($line =~ /^LINK32 /) {
                  $link32 = substr($line,7);
               } elsif ($line =~ /^MTL /) {
                  $mtl = substr($line, 4);
               } elsif ($line =~ /^LIB32 /) {
                  $lib32 = substr($line,6);
               } elsif ($line =~ /^F90 /) {
                  # ADD BASE F90 /compile_only /nologo /warn:nofileopt
                  $f90 = substr($line,4);
               } else {
                  pgm_exit(1, "ERROR: $lnn: [$oline]\n [$line]\n cfg=$cfg - CHECK ME#! NOT CODED!!\n");
               }
            } else {
               if ($line =~ /^!MESSAGE/) {
                  $line = substr($line,8);
                  # skip most message lines, but it does give a LIST of CONFIGURATIONS
                  # !MESSAGE "minigzip - Win32 DLL Release" (based on "Win32 (x86) Console Application")
                  # !MESSAGE "minigzip - Win32 DLL Debug" (based on "Win32 (x86) Console Application")
                  # !MESSAGE "minigzip - Win32 DLL ASM Release" (based on "Win32 (x86) Console Application")
                  # etc
                  @arr = space_split($line);
                  if ($line =~ /^\s*"/) {
                     $tmp = $arr[-1];  # get last
                     $tmp =~ s/\)$//;  # strip ')' tail
                     $tmp = strip_quotes($tmp); # and quotes
                     check_targ_type( $tmp, \@targtypes, $targtcnt );
                     $tmp2 = strip_quotes($arr[0]);
                     if (defined $cfgnames{$tmp2}) {
                        pgm_exit(1, "ERROR: Duplicated CONFIG NAME! [$tmp2]\n");
                     } else {
                        # accumulate CFG names, into hash, keeping count
                        $cfgnamcnt++;
                        $cfgnames{$tmp2} = $cfgnamcnt;
                     }
                     if ($dbg_02) {
                        prt("Check out a SPACE split [$line]...\n");
                        foreach $tmp (@arr) {
                           prt("$tmp\n");
                        }
                        pgm_exit(1,"CHECK SPLIT!");
                     }
                  }
               } elsif ($line =~ /^(\w+)\s*=\s*(.+)\s*$/) {
                  # got something=that, but can be
                  # LIB32=link.exe -lib
                  $key = $1;
                  $var = $2;
                  #@arr = split(/\s/,$var);
                  #$var = $arr[0];
                  if ($special) {
                     $specstg .= "\n" if (length($specstg));
                     $specstg .= $line;
                  } elsif (length($custom)) {
                     $customstg .= "\n" if (length($customstg));
                     $customstg .= $line;
                  } else {
                     # # Begin Target
                     # # Name - "find_window - Win32 Release"
                     # # Name - "find_window - Win32 Debug"
                     # # Begin Group "Source Files"
                     # # PROP Default_Filter "cpp;c;cxx;def;odl;idl;hpj;bat;asm;asmx"
                     # # Begin Source File
                     # SOURCE=.\find_ABT.cpp
                     # # End Source File
                     if ($key eq 'SOURCE') {
                        # SOURCE FILE
                        if ($bgnsrc) {
                           #                     0     1       2       3  4
                           # push(@{$src_ref}, [ $src, $group, $flist, 0, '' ]); # and PUSH onto SOURCE stack
                           push(@sources,[ $var, $group, $flist, 0, '' ]);
                        } else {
                           pgm_exit(1,"ERROR: $lnn: key [$key] = [$var] OUTSIDE BEGIN SOURCE\n[$oline]\n");
                        }
                     } else {
                        if (defined ${$ref_tools}{$key}) {
                           ${$ref_tools}{$key} = $var;
                        } else {
                           pgm_exit(1, "ERROR:$lnn: key [$key] = [$var] NOT IN 'tools' set\n[$oline]\n");
                        }
                     }
                  }
               } elsif ($line =~ /^!IF\s+"\$\(CFG\)"\s+==\s+"(.+)"\s*$/) {
                  $tmp = $1;
                  prtw("WARNING: Discarded CONFIG [$cfg]!\n") if (length($cfg));       
                  $cfg = $tmp;
                  # "Spy5 - Win32 Debug" or
                  # "minigzip - Win32 DLL ASM Release"
                  if ($cfg =~ /Debug/i) {
                     $tmp2 = "Debug";
                     $isdebug = 1;
                     $dsp_sub_sub = get_default_sub3(1);
                  } elsif ($cfg =~ /Release/i) {
                     $tmp2 = "Release";
                     $isdebug = 0;
                     $dsp_sub_sub = get_default_sub3(0);
                  } elsif ($cfg =~ /DLL/) {  # exception for DLL
                     $tmp2 = "ReleaseDLL";
                     $isdebug = 0;
                     $dsp_sub_sub = get_default_sub3(0);
                  } else {
                     pgm_exit(1,"ERROR: Did NOT find 'Debug' or 'Release' in [$cfg]!\n");
                  }
                  @arr = split(/\s/,$cfg);
                  $tmp = scalar @arr;
                  if ($tmp < 4) {
                     pgm_exit(1,"ERROR: UNmanaged split of [$cfg]. Expected min 4, got $tmp! FIX CODE!\n");
                  }
                  $cfg_proj = $arr[0];
                  $cfg_plat = $arr[2]; # Platform
                  $cfg_type = $arr[3]; # Release, Debug, etc 'DLL Universal Unicode Release', or ...
                  $cfg_name = $cfg_type;
                  # from : C:\FG\27\wxWidgets-2.8.10\build\msw\wx_adv.dsp
                  # adv - Win32 DLL Universal Unicode Release
                  if ($tmp > 4) {
                     $cfg_type = '';
                     for ($k = 3; $k < $tmp; $k++) {
                        if (($arr[$k] =~ /Release/i)||($arr[$k] =~ /Debug/i)) {
                           $cfg_type = $arr[$k];
                           $arr[$k] = '';
                        }
                     }
                     $cfg_type = 'Release' if (length($cfg_type)==0);
                     $cfg_name = $cfg_type;
                     for ($k = 3; $k < $tmp; $k++) {
                        $cfg_type .= $arr[$k];
                     }
                  }
                  prt("[dbg_01] Enter CFG [$cfg] [$cfg_name]\n") if ($dbg_01);
                  check_cfg_name( $cfg, \%cfgnames, $cfgnamcnt );
                  $var1 = "-NEW_OUTD-";
                  $tmp2 = "$cfg_type|$cfg_plat";
                  $rcfgs = ${$dsp_ref_hash}{'PROJECT_CFGS'};
                  #                   0       1      2      3
                  # push(@{$rcfgs}, [ $pname, $var1, $conf, $dsp_sub_sub ]);
                  push(@{$rcfgs}, [ $cfg_name, $var1, $tmp2, $dsp_sub_sub ]);
               } elsif ($line =~ /^!ELSEIF\s+"\$\(CFG\)"\s+==\s+"(.+)"\s*$/) {
                  $cfg = $1;
                  if ($cfg =~ /Debug/i) {
                     $tmp2 = "Debug";
                     $isdebug = 1;
                     $dsp_sub_sub = get_default_sub3(1);
                  } elsif ($cfg =~ /Release/i) {
                     $tmp2 = "Release";
                     $isdebug = 0;
                     $dsp_sub_sub = get_default_sub3(0);
                  } elsif ($cfg =~ /DLL/) {  # exception for DLL
                     $tmp2 = "ReleaseDLL";
                     $isdebug = 0;
                     $dsp_sub_sub = get_default_sub3(0);
                  } else {
                     pgm_exit(1,"ERROR: Did NOT find 'Debug' or 'Release' in [$cfg]!\n");
                  }
                  @arr = split(/\s/,$cfg);
                  $tmp = scalar @arr;
                  if ($tmp < 4) {
                     pgm_exit(1,"ERROR: UNmanaged split of [$cfg]. Expected min 4, got $tmp! FIX CODE!\n");
                  }
                  $cfg_proj = $arr[0];
                  $cfg_plat = $arr[2]; # Platform
                  $cfg_type = $arr[3]; # Release, Debug, etc 'DLL Universal Unicode Release', or ...
                  $cfg_name = $cfg_type;
                  # from : C:\FG\27\wxWidgets-2.8.10\build\msw\wx_adv.dsp
                  # adv - Win32 DLL Universal Unicode Release
                  if ($tmp > 4) {
                     $cfg_type = '';
                     for ($k = 3; $k < $tmp; $k++) {
                        if (($arr[$k] =~ /Release/i)||($arr[$k] =~ /Debug/i)) {
                           $cfg_type = $arr[$k];
                           $arr[$k] = '';
                        }
                     }
                     $cfg_type = 'Release' if (length($cfg_type)==0);
                     $cfg_name = $cfg_type;
                     for ($k = 3; $k < $tmp; $k++) {
                        $cfg_type .= $arr[$k];
                     }
                  }
                  prt("[dbg_01] Elsif CFG [$cfg] [$cfg_name]\n") if ($dbg_01);
                  check_cfg_name( $cfg, \%cfgnames, $cfgnamcnt );
                  $var1 = "-NEW_OUTD-";
                  $tmp2 = "$cfg_type|$cfg_plat";
                  $rcfgs = ${$dsp_ref_hash}{'PROJECT_CFGS'};
                  #                   0       1      2      3
                  # push(@{$rcfgs}, [ $pname, $var1, $conf, $dsp_sub_sub ]);
                  push(@{$rcfgs}, [ $cfg_name, $var1, $tmp2, $dsp_sub_sub ]);
               } elsif ($line =~ /^!ENDIF\s*$/) {
                  prt("[dbg_01] Endif CFG [$cfg]\n") if ($dbg_01);
                  $cfg = '';
               } else {
                  if (length($custom)) {
                     $customstg .= "\n" if (length($customstg));
                     $customstg .= $line;
                  } else {
                     prt( "$lnn: [$line] CHECK ME2!!!\n");
                  }
               }
            }
         } else {
            if ($line =~ /^#\s+Microsoft\s+Developer\s+Studio\s+Project\s+File\s+-\s+Name="(.+)"\s+-\s+/) {
               $projname = $1;
               prt("Project name = [$projname]\n");
               $gotdsp = 1;
               ${$dsp_ref_hash}{'PROJECT_NAME'} = $projname;
            }
         }
      }
   } else {
      prt("ERROR: Unable to open [$dsp] file!\n");
      pgm_exit(1,"");
   }

   ${$dsp_ref_hash}{'PROJECT_SRCS'} = [ @sources ];
   return $dsp_ref_hash;
}

sub process_dsp_list($) {
   my ($fil) = @_;
   if (open DL, "<$fil") {
      my @lines = <DL>;
      close DL;
      my $max = scalar @lines;
      my $cnt = 0;
      foreach my $line (@lines) {
         chomp $line;
         $cnt++;
         prt("$cnt of $max: $line\n");
         my $rh = process_dsp_file($line);
         my ($name,$dir) = fileparse($line);
         my $tmp_out = "temp.$name.dsp";
         if ( write_hash_to_DSP3( $tmp_out, $rh, 0 ) ) {
            prt( "From [$line]\nOK, written $tmp_out\n" );
         } else {
            prt( "From [$line]\nFAILED on $tmp_out\n" );
         }
      }
   }
}

my $temp_out = 'tempd.dsp';
#my $dbg4write = 0;
my $dbg4write = -1;
my $ref_hash = process_dsp_file($in_file);
my ($nm,$dr) = fileparse($in_file);
$temp_out = "temp.$nm.dsp";

if ( write_hash_to_DSP3( $temp_out, $ref_hash, $dbg4write ) ) {
   prt( "From [$in_file]\nOK written $temp_out.\n" );
} else {
   prt( "From [$in_file]\nFAILED on $temp_out\n" );
}
if ($dbg_03) {
   process_dsp_list('fgdsplist.txt');
}

pgm_exit(0,"Normal exit");

# cmp2dsp C:\GTools\tools\Spy5\Spy5.dsp temp.Spy5.dsp.dsp
# eof - movedsp.pl
