#!/perl -w
# NAME: printenv.pl
# AIM: print out the environment strings ...
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

foreach my $key (sort keys(%ENV)) { 
      prt( "$key = $ENV{$key}\n" ); 
} 
close_log($outfile,1);
exit(0);

# eof - printenv.pl
