#!/perl -w
# NAME: relinejs.pl
# AIM: Attempt to reline javescript files...
# 20/12/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

#my $in_file = "C:\\HOMEPAGE\\HOMnew\\test22\\swfobject.js";
my $in_file = "C:\\DTEMP\\swfaddress-2.4\\js\\swfaddress.js";
my $curr_tab = '   ';

my $load_log = 1;

# DEBUG
my $dbg_01 = 0; # prt("$lnn:$i2:$nlcnt: Stored [$accum]...\n") if ($dbg_01);

sub pgm_end($$) {
   my ($val,$msg) = @_;
   if (length($msg)) {
      $msg .= "\n" if ( !($msg =~ /\n$/) );
      prt($msg);
   }
   close_log($outfile,$load_log);
   exit($val);
}


sub process_file($) {
   my ($fil) = @_;
   my @newlines = ();

   if (open INF, "<$fil") {
      my @lns = <INF>;
      my $filcnt = scalar @lns;
      my ($line,$len,$lnn,$cc,$pc,$nc,$i,$incomment,$i2);
      my ($accum,$nlcnt,$indent,$indcnt,$j,$inquots);
      prt("Processing $filcnt lines, from $fil...\n");
      $lnn = 0;
      $cc = '';
      $incomment = 0;
      $accum = '';
      $indent = '';
      $indcnt = 0;
      $inquots = 0;
      foreach $line (@lns) {
         chomp $line;
         $lnn++;
         $len = length($line);
         prt("$lnn: $len chars...\n");
         for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $pc = $cc;
            $cc = substr($line,$i,1);
            $nc = (($i + 1) < $len ? substr($line,$i+1,1) : '');
            if ($incomment) {
               # /* ... */
               if (($cc eq '/')&&($pc eq '*')) {
                  $incomment = 0;
                  $accum .= $cc;
                  push(@newlines,$accum);
                  $nlcnt = scalar @newlines;
                  prt("$lnn:$i2:$nlcnt: Exit    comment...\n");
                  $accum = '';
                  next;
               }
            } else {
               if (($cc eq '/')&&($nc eq '*')) {
                  $incomment = 1;
                  push(@newlines,$accum) if (length($accum));
                  $nlcnt = scalar @newlines;
                  prt("$lnn:$i2:$nlcnt: Entered comment...\n");
                  $accum = $cc;
                  next;
               }
            }

            # ****** BEFORE ADD CHARACTER ******
            if (($cc eq '}')&& !($nc eq ';')) {
               push(@newlines,$accum) if (length($accum) && !($accum =~ /^\s+$/));
               $indcnt-- if ($indcnt);
               $j = $indcnt;
               $indent = '';
               while ($j--) {
                  $indent .= $curr_tab;
               }
               $accum = $indent;
               push(@newlines,$accum.$cc);
               next;
            }
            $accum .= $cc; # add this character
            # ****** AFTER ADD CHARACTER ******
            if ($cc eq '"') {
               if ($inquots) {
                  $inquots = 0;
               } else {
                  $inquots = 1;
               }
            } elsif ($cc eq '{') {
               push(@newlines,$accum);
               $nlcnt = scalar @newlines;
               prt("$lnn:$i2:$nlcnt: Stored [$accum]...\n") if ($dbg_01);
               $indcnt++;
               $j = $indcnt;
               $indent = '';
               while ($j--) {
                  $indent .= $curr_tab;
               }
               $accum = $indent;
#            } elsif (($cc eq '}')&& !($nc eq ';')) {
#               push(@newlines,$accum);
#               $nlcnt = scalar @newlines;
#               prt("$lnn:$i2:$nlcnt: Stored [$accum]...\n") if ($dbg_01);
#               $indcnt-- if ($indcnt);
#               $j = $indcnt;
#               $indent = '';
#               while ($j--) {
#                  $indent .= $curr_tab;
#               }
#               $accum = $indent;
            } elsif (($cc eq '&')&&($pc eq '&')) {
               push(@newlines,$accum);
               $accum = $indent . $curr_tab;
            } elsif (($cc eq '|')&&($pc eq '|')) {
               push(@newlines,$accum);
               $accum = $indent . $curr_tab;
            } elsif (($cc eq ',')&& !$inquots) {
               push(@newlines,$accum);
               $accum = $indent . $curr_tab;
            } elsif (($cc eq ';')&& !$inquots) {
               push(@newlines,$accum);
               $accum = $indent;
            }
         }  # process whole line

         if (length($accum)) {
            push(@newlines,$accum);
            $nlcnt = scalar @newlines;
            prt("$lnn:$i2:$nlcnt:EOL: Stored [$accum]...\n");
         }
         $accum = $indent;
      }  # process all the lines
      push(@newlines,$accum) if (length($accum));
      $accum = '';
      $nlcnt = scalar @newlines;
      prt("Got $nlcnt lines of output...\n");
   } else {
      prt("ERROR: Can not open file [$fil]!\n");
   }
   return \@newlines;
}

sub write_ref_arr($) {
   my ($ra) = @_;
   my $txt = join("\n",@{$ra});
   $txt .= "\n";
   write2file($txt,'tempnew.js');
}

my $ref_arr = process_file($in_file);
write_ref_arr($ref_arr);
pgm_end(0,"Normal end");

# eof - relinejs.pl
