#!/perl -w
# NAME: tafacronyms.pl
# AIM: List of TAF acronyms
use strict;
use warnings;

my %taf_acronyms = (
	'$' => 'maintenance check indicator',
	'-' => 'light intensity',
	'+' => 'heavy intensity',
	'/' => 'indicator that visual range data follows; separator between temperature and dew point data.',
	'ACC' => 'altocumulus castellanus',
	'ACFT MSHP' => 'aircraft mishap',
	'ACSL' => 'altocumulus standing lenticular cloud',
	'AFT' => 'after',
	'AO1' => 'automated station without precipitation discriminator',
	'AO2' => 'automated station with precipitation discriminator',
	'ALP' => 'airport location point',
	'AMD' => 'amended',
	'AND' => 'and',
	'APCH' => 'approach',
	'APRNT' => 'apparent',
	'APRX' => 'approximately',
	'ATCT' => 'airport traffic control tower',
	'AUTO' => 'fully automated report',
	'B' => 'began',
	'BC' => 'patches',
	'BKN' => 'broken (5-7 oktas)',
	'BL' => 'blowing',
	'BR' => 'mist',
	'C' => 'center (with reference to runway designation)',
	'CA' => 'cloud-air lightning',
	'CAVOK' => 'Ceiling And Visibility OKay (no cloud below 5000 feet, vis 6 S.Miles+, no rain)',
	'CB' => 'cumulonimbus cloud',
	'CBMAM' => 'cumulonimbus mammatus cloud',
	'CC' => 'cloud-cloud lightning',
	'CCSL' => 'cirrocumulus standing lenticular cloud',
	'cd' => 'candela',
	'CG' => 'cloud-ground lightning',
	'CHI' => 'cloud-height indicator',
	'CHINO' => 'sky condition at secondary location not available',
	'CIG' => 'ceiling',
	'CLD' => 'cloud',
	'CLR' => 'clear',
	'CNL' => 'cancelled',
	'CONS' => 'continuous',
	'COR' => 'correction to a previously disseminated observation',
	'DOC' => 'Department of Commerce',
	'DOD' => 'Department of Defense',
	'DOT' => 'Department of Transportation',
	'DR' => 'low drifting',
	'DS' => 'duststorm',
	'DSIPTG' => 'dissipating',
	'DSNT' => 'distant',
	'DU' => 'widespread dust',
	'DSNT' => 'distant',
	'DVR' => 'dispatch visual range',
	'DZ' => 'drizzle',
	'E' => 'east, ended, estimated ceiling (SAO)',
	'FAA' => 'Federal Aviation Administration',
	'FC' => 'funnel cloud',
	'FEW' => 'few (1-2 oktas)',
	'FG' => 'fog',
	'FIBI' => 'filed but impracticable to transmit',
	'FIRST' => 'first observation after a break in coverage at manual station',
	'FMH-1' => ' ',
	'FMH2' => ' ',
	'FRQ' => 'frequent',
	'FROPA' => 'frontal passage',
	'FT' => 'feet',
	'FU' => 'smoke',
	'FZ' => 'freezing',
	'FZRANO' => 'freezing rain sensor not available',
	'G' => 'gust',
	'GR' => 'hail',
	'GS' => 'small hail and/or snow pellets',
	'HLSTO' => 'HLSTO hailstone',
	'HZ' => 'haze',
	'IC' => 'ice crystals, in-cloud lightning',
	'ICAO' => 'International Civil Aviation Organization',
	'INCRG' => 'increasing',
	'INTMT' => 'intermittent',
	'KT' => 'KNOTS',
	'L' => 'left (with reference to runway designation)',
	'LAST' => 'last observation before a break in coverage at a manual station',
	'LST' => 'Local Standard Time',
	'LTD' => 'limited',
	'LTG' => 'lightning',
	'LWR' => 'lower',
	'M' => 'minus, less than',
	'max' => 'maximum',
	'METAR' => 'routine weather report provided at fixed intervals',
	'MI' => 'shallow',
	'min' => 'minimum',
	'MOV' => 'moved/moving/movement',
	'MT' => 'mountains',
	'N' => 'north',
	'N/A' => 'not applicable',
	'NCDC' => 'National Climatic Data Center',
	'NE' => 'northeast',
	'NOS' => 'National Ocean Survey',
	'NOSIG' => 'no significant changes next 2 hours',
	'NOSPECI' => 'no SPECI reports are taken at the station',
	'NOTAM' => 'Notice to Airmen',
	'NSW' => 'no significant weather',
	'NW' => 'northwest',
	'NWS' => 'National Weather Service',
	'OCNL' => 'occasional',
	'OFCM' => 'Office of the Federal Coordinator for Meteorology',
	'OHD' => 'overhead',
	'OVC' => 'overcast (7-8 octas)',
	'0VC' => 'overcast (7-8 octas)',
	'OVR' => 'over',
	'P' => 'indicates greater than the highest reportable value',
	'PCPN' => 'precipitation',
	'PL' => 'ice pellets',
	'PK WND' => 'peak wind',
	'PNO' => 'precipitation amount not available',
	'PO' => 'dust/sand whirls (dust devils)',
	'PRES' => 'pressure',
	'PR' => 'partial',
	'PRESFR' => 'pressure falling rapidly',
	'PRESRR' => 'pressure rising rapidly',
	'PWINO' => 'precipitation identifier sensor not available',
	'PY' => 'spray',
	'R' => 'right (with reference to runway designation), runway',
	'RA' => 'rain',
	'RTD' => 'Routine Delayed (late) observation',
	'RV' => 'reportable value',
	'RVR' => 'Runway Visual Range',
	'RVRNO' => 'RVR system values not available',
	'RY' => 'runway',
	'S' => 'snow, south',
	'SA' => 'sand',
	'SCSL' => 'stratocumulus standing lenticular cloud',
	'SCT' => 'scattered (3-4 oktas)',
	'SE' => 'southeast',
	'SFC' => 'surface',
	'SG' => 'snow grains',
	'SH' => 'shower(s)',
	'SKC' => 'sky clear',
	'SLP' => 'sea-level pressure',
	'SLPNO' => 'sea-level pressure not available',
	'SM' => 'statute miles',
	'SN' => 'snow',
	'SNINCR' => 'snow increasing rapidly',
	'SP' => 'snow pellets',
	'SPECI' => 'an unscheduled report taken when certain criteria have been met',
	'SQ' => 'squalls',
	'SS' => 'sandstorm',
	'STN' => 'station',
	'SW' => 'snow shower, southwest',
	'TCU' => 'towering cumulus',
	'TO' => 'to',
	'TS' => 'thunderstorm',
	'TSNO' => 'thunderstorm information not available',
	'TWR' => 'tower',
	'UNKN' => 'unknown',
	'UP' => 'unknown precipitation',
	'UTC' => 'Coordinated Universal Time',
	'V' => 'variable',
	'VA' => 'volcanic ash',
	'VC' => 'in the vicinity',
	'VFR' => 'visual flight rules',
	'VIS' => 'visibility',
	'VISNO' => 'visibility at secondary location not available',
	'VR' => 'visual range',
	'VRB' => 'variable',
	'VV' => 'vertical visibility (0 octas)',
	'W' => 'west',
	'WG/SO' => 'Working Group for Surface Observations',
	'WIND' => 'wind',
	'WMO' => 'World Meteorological Organization',
	'WND' => 'wind',
	'WSHFT' => 'wind shift',
	'Z' => 'zulu, i.e., Coordinated Universal Time '
);

sub get_acro_desc {
	my ($acr) = shift;
	if (defined $taf_acronyms{$acr}) {
		return $taf_acronyms{$acr};
	}
	return 'NONE';
}

my @taf_exceptions = qw(
FCST CNCLD DUE END OF FLYING PROGRAM NO OBS NOT AVBL DUE INSUFFICIENT
ADVISORY OFFSITE CANCELLED KANDALA VALIDITY 
CANCEL MPZZMAMX MUHAYMYX MWCRYMYX MYNNYMYX SAEZYMYX SBBRYZYX 
SEGUYMYX SEQUYMYX SEZZMAMX SKBQYMYX SKZZMAMX SPZZMAMX ENDING 
KATLYTAA KWBCYMYX KWBCYZYX MDSDMAMX MDSDYMYX MKJKYMYX MKJPYMYX 
MGGTYMYX SPIMYZYX TJSJYMYX MZBZYMYX MUHAYNYX MROCYOYX MTPPYMYX 
SVZZMAMX TBPBYMYX TTPPYMYX MNMGYMYX MHTGYMYX SAZZMAMX SCZZMAMX 
SGZZMAMX SLZZMAMX SOZZMAMX SUZZMAMX MSLPYMYX KILNABXD WSCONDS 
SENSOR METWATCH WBCTAFLYH WBCSIGE OUTLOOK ISSUANCES RECENT 
CENTER SYNOPSIS ADDXYYF LIIIYFYC 
HNNQCGG DRZZNAZX DIZZXLAX FCZZXLBX FVHAYMYX LFZZMTXX LFZZMAFI 
HAABYPYX FTXX99 CYMYX MPMGYMYX MROCYMYX
ISPRAWLENIE
HAZZYPYX HDAMYMYX FMMIYPYX ACTIVIDAR RAVCSH
CHECK TEXT NEW BY SRUR02 38F783A8 NL
FPKKHZ KANDLA TAGHNIIE DRZZNJZX GG ADDED WRQOPPZ
FTGU31 21032TK MZB FTBH31
);

sub is_in_taf_exceptions {
	my ($txt) = shift;
	foreach my $ex (@taf_exceptions) {
		if ($ex eq $txt) {
			return 1;
		}
	}
	return 0;
}

my @taf_spl_exceptions = qw(
FTIL31 AA
);

sub is_in_taf_spl_exceptions {
	my ($txt) = shift;
	foreach my $ex (@taf_spl_exceptions) {
		if ($ex eq $txt) {
			return 1;
		}
	}
	return 0;
}


1;
# eof - tafacronyms.pl
