#!perl -w
use strict;
use warnings;
###require 'fgscanvc.pl' or die "Unable to load fgscanvc.pl ...\n";

my $log_file = "tempxlog.txt";
my $in_file='C:\FG\27\data\materials.xml';
###my $in_file='C:\Projects\Tidy\tests\Bob\tidy1.xml';
open LOG, ">$log_file" or die "Can not create LOG!\n";

sub trim_xml($) {
	my ($ln) = shift;
	$ln =~ s/\n/ /gm;	# replace CR (\n)
	$ln =~ s/\r/ /gm;	# replace LF (\r)
	### $ln =~ s/\t/ /g;	# TAB(s) to a SPACE
	$ln = substr($ln,1) while ($ln =~ /^\s/); # remove all LEADING space
	$ln = substr($ln,0, length($ln) - 1) while ($ln =~ /\s$/); # remove all TRAILING space
	### $ln =~ s/\s{2}/ /g while ($ln =~ /\s{2}/);	# all double space to SINGLE
	return $ln;
}

# relinexml - 20090125
# Need to add some options, like
# - indenting
# <open>text</close> on same line
sub xml_to_lines {
    my ($rlm, @lns) = @_;
    my $intag = 0;
    my $text = '';  # gather TEXT between tags
    my @nlines = ();
    my ($fln, $ln, $ch, $pch, $nch, $len, $i, $i2, $tag, $xml, $dnx);
    my ($lnnm, $lnb, $nlnm);
    my ($ppch, $incomm);
    my $show_comm_dbg = 0;
    $pch = '';
    $ppch = '';
    $nch = '';
    $tag = '';
    $xml = '';
    $dnx = 0;
    $lnnm = 0;
    $nlnm = 0;
    $lnb = 0;
    $incomm = 0;
    $text = ''; # start NO TEXT
    foreach $fln (@lns) {
        chomp $fln;
        $ln = trim_xml($fln);
        $len = length($ln);
        $lnnm++;    # count another xml line
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($ln,$i,1);
            $nch = (($i2 < $len) ? substr($ln,$i2,1) : ' ');
            if ($intag) {
                # on first GREATER THAN - SPACE
                $tag .= $ch;
                if ($ch eq '>') {
                    if ( $incomm ) {
                        prt("$lnnm: potential end of XML tag pch=$pch ppch=$ppch\n") if ($show_comm_dbg);
                        if (($pch eq '-') && ($ppch eq '-')) {
                            $nlnm++;
                            push(@nlines,$tag);
                            ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                            $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                            $tag = '';
                            $intag = 0;
                            $xml = '';
                            $incomm = 0;
                            prt( "$lnnm: Exit comment [$ln]\n" ) if ($show_comm_dbg);
                        }
                    } else {
                        $nlnm++;
                        push(@nlines,$tag);
                        ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                        $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                        $tag = '';
                        $intag = 0;
                        $xml = '';
                        $incomm = 0;
                    }
                }
            } else {
                if ($ch eq '<') {
                    if (length($text)) {
                        $nlnm++;
                        push(@nlines,$text);
                        $$rlm{$nlnm} = "$lnb-$lnnm";    # each NEW line has BEGIN and END
                        $text = '';
                    }
                    $tag = $ch; # start a tag line
                    $intag = 1; # signal in a tag
                    $xml = '';
                    $dnx = 0;
                    $lnb = $lnnm;    # set the BEGIN xml line
                    if ($nch eq '!') {
                        # but watch out for <!DOCTYPE ...>
                        if ($ln =~ /<!--/) {
                            prt( "$lnnm: Entering comment [$ln]\n" ) if ($show_comm_dbg);
                            $incomm = 1;
                        }
                    }
                } else {
                    $text .= $ch;
                }
            }
            $ppch = $pch;
            $pch = $ch;
        }
        # done a line - this is like a SPACE
        if ($intag && length($tag)) {
            $tag .= ' ' if !($tag =~ /(=|\s)$/);
        }
    }
    prtw("WARNING: Exit STILL in comment!\n") if ($incomm);
    if (length($tag)) {
        prtw("WARNING: xml re-lining error! Left pending tag [$tag]\nin $in_file file ...\n");
    }
    return @nlines;
}

sub prt($) {
    my ($t) = shift;
    print $t;
    print LOG $t;
}

sub outfile($$) {
    my ($fil, $tx) = @_;
    if (open OUTF, ">$fil") {
        print OUTF $tx;
        close OUTF;
    } else {
        prt("ERROR: Could not create $fil!\n");
    }
}

sub process_in_file($) {
    my ($inf) = shift;
    my (%lnmap);
    if (open INF, "<$inf") {
        my @lines = <INF>;
        close INF;
        #@lines = fg_xml_to_lines(\%lnmap, @lines);
        @lines = xml_to_lines(\%lnmap, @lines);
        my $lncnt = scalar @lines;
        prt( "Processing $lncnt lines from $inf...\n" );
        my $txt = join("\n",@lines);
        $txt .= "\n";
        outfile("tempxml3.xml",$txt);
        prt( "Written ".scalar @lines." lines to tempxml3.xml");
    }
}

process_in_file($in_file);

close LOG;
###system($log_file);