#!/Perl

# AIM: Download the $URL, and find the currency
# heading in table, after CLEAN
#<td></td>
#<td>Code</td><td></td><td>Currency</td><td></td><td>fcu/CAD</td><td></td><td>fcu/USD</td>
#<td></td>
#<td>Code</td><td></td><td>Currency</td><td></td><td>fcu/CAD</td><td></td><td>fcu/USD</td>
#<td></td>
# sample row from table
#<tr>
#<td></td>
#<td> <tt>ARS</tt> </td><td></td><td>Argentine Pesos</td><td></td><td>2.7941</td><td></td><td>3.0958</td>
#<td></td>
#<td> <tt>MAD</tt> </td><td></td><td>Moroccan Dirham</td><td></td><td>7.8186</td><td></td><td>8.6630</td>
#<td></td>
#</tr>

use LWP::Simple;
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file and some other utility subs
require "htmltools.pl" or die "Missing htmltools.pl ...\n";
require "currencyISO.pl" or die "Missing currencyISO.pl ...\n";
my $vers = '04';
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
my $outfil1 = 'tempcurr'.$vers.'.htm';
my $outfil2 = 'tempcurr'.$vers.'.csv';
# program variables
my $URL = 'http://fx.sauder.ubc.ca/today.html';
my $dbg1 = 0;
my $dbg2 = 0;
my $dbg3 = 0;
my $dbg4 = 0;
my @hrefs = ();
my @imgs = ();
my @currency = ();
my $m_date1 = '';
my $m_date2 = '';
my $etext = '';
my @cols = qw( 2, 4, 6, 8, 10, 12, 14, 16 );
my @colnms = qw( Code, Currency, fcu/CAD, fcu/USD, Code, Currency, fcu/CAD, fcu/USD );

open_log($outfile);
prt( "$0 ... Hello, World...\n" );
prt("Fetching text from $URL ...\n");
my $text = get("$URL");
my $tcnt = length($text);
prt( "Got $tcnt characters from URL $URL ...\n");
$etext = htmlexpand($text);
my $ctext = htmlcleanall($etext);
write2file($ctext,$outfil1);
###prt("[$ctext]\n");
prt( "len=".length($ctext)."\n"); # "[$txt2]\n");
my $ccnt = 0;
my $ccnt = extractcurrencies04($ctext);
###my $ccnt = scalar @currency;
prt( "Got $ccnt currencies ...\n" );
my $msg = '';
my $txt = '';
if ($ccnt) {
	open OF, ">$outfil2" or mydie("ERROR: Unable to open CSV out file!\n");
	prt("Writing CSV file $outfil2 ...\n");
	$msg = "Country,Currency,ISO,Rate $m_date1,Rate $m_date2"; 
	prt("$msg\n");
	print OF $msg."\n";
	for (my $i = 0; $i < $ccnt; $i++) {
		###$msg = "".($currency[$i][0]).",".($currency[$i][1]).",".($currency[$i][2]).",".($currency[$i][3]).",".($currency[$i][4]);
		$msg = '';
		for (my $i2 = 0; $i2 < 5; $i2++) {
			$txt = "".($currency[$i][$i2]);
			if ($txt =~ /,/) {
				$txt = '"'.$txt.'"';
			}
			if (length($msg)) {
				$msg .= ",";
			}
			$msg .= $txt;
		}
		prt( "$msg\n" );
		print OF $msg."\n";
	}
	$msg = "From [$URL] on ".(scalar localtime);
	prt("$msg\n");
	print OF $msg."\n";
	close(OF);
} else {
	prt( "WARNING: FAILED TO EXTRACT ANY CURRENCIES!!!\n" );
}
prt( "All done ...\n" );
prt("[$ctext]\n") if ($dbg4);
close_log($outfile,1);
###system( $outfil1 );
###system( $outfil2 );
exit(0);


sub extractcurrencies04 {
	my ($txt) = shift;
	my @arr = split( /\n/, $txt );
	my $lcnt = scalar @arr;
	my $ccnt = 0;
	my $intbl = 0;
	my $bgn = 0;
	my $ictry = '';	# country
	my $ctry = '';	# country
	my $curr = '';	# currency
	my @itmarr = ();
	my $itm = '';
	my $v1 = ''; # quoted rate
	my $v2 = ''; # quoted rate
	my $bcnt = 0;
	my %hiso = ();
	my $kcnt = 0;
	my $mcnt = 0;
	my $srch = '';
	my $iso = '';
	my $tms = get_YYYYMMDD(scalar localtime);
	my $cyear = substr($tms,0,4);
	my $tblcnt = 0;
	my $rowcnt = 0;
	my $colcnt = 0;
	$m_date1 = 'fcu/CAD';
	$m_date2 = 'fcu/USD';
	prt("Processing $lcnt lines ...\n");
	foreach my $line (@arr) {
		chomp $line;
		if (substr($line, length($line)-1) eq "\r") {
			$line = substr($line,0,length($line)-1);
		}
		if ($intbl) {
			if ($line =~ /<\/table.*>/i) {
				$intbl = 0;
				if ($tblcnt == 3) {
					prt("Exit TABLE $tblcnt tag ...[$line]\n") if $dbg1;
				}
			} else {
				if ($line =~ /^<tr.*>/i) {
					$rowcnt++;
					prt("Start row $rowcnt ...\n") if $dbg1;
					$colcnt = 0;
				} elsif ($line =~ /<\/tr>/i) {
					prt("End row $rowcnt ...\n") if $dbg1;
				} elsif ($line =~ /^<td.*>/i) {
					$colcnt++;
					$itm = '';
					if ($line =~ /^<td.*>(.*)<\/td>/i) {
						$itm = $1;
					}
					prt("Start column $colcnt ...[$line]...[$itm]\n") if $dbg1;
					## my @cols = qw(   2,    4,        6,       8,       10,   12,       14,      16 );
					## my @colnms = qw( Code, Currency, fcu/CAD, fcu/USD, Code, Currency, fcu/CAD, fcu/USD );
					if ($rowcnt == 1) {
						# deal with headers
					} else {
						if (($colcnt == 2)||($colcnt == 10)) {
							$ictry = ISO2Currency($itm);
							$ctry = '';
							$curr = '';
							$iso = $itm;
							if ($ictry =~ /^NOT FOUND \[.*\]/) {
								prt( "$ictry = FAILED TO GET ISO [$itm]!\n" );
							} else {
								@itmarr = split(/\s/,$ictry);
								if (@itmarr) {
									$curr = pop @itmarr;
									$ctry = join(' ',@itmarr);
								}
							}
							###prt( "Col $colcnt = $ctry\n" );
						} elsif (($colcnt == 4)||($colcnt == 12)) {
							if (length($itm)) {
								prt( "[$ictry] should be [$itm] ... ".(($ictry eq $itm) ? 'ok' : 'diff')." ...\n" ) if $dbg2;
								if (length($ctry) == 0) {
									@itmarr = split(/\s/,$itm);
									if (@itmarr) {
										$curr = pop @itmarr;
										$ctry = join(' ',@itmarr);
										prt( "Set \$curr=$curr and \$ctry=$ctry from [$itm] ... CHECK!\n" );
									}
								}
							} else {
								prt("Warning: got zero length \$itm ...[$line]...\n");
							}
						} elsif (($colcnt == 6)||($colcnt == 14)) {
							$v1 = $itm;
						} elsif (($colcnt == 8)||($colcnt == 16)) {
							$v2 = $itm;
							# $msg = "Country,Currency,ISO,Rate $m_date1,Rate $m_date2";
							if (length($ctry) && length($curr)) {
								push(@currency, [$ctry, $curr, $iso, $v1, $v2]);
								prt( "push(\@currency, [$ctry, $curr, $iso, $v1, $v2]);\n" ) if $dbg3;
								$ccnt++;
							} else {
								prt( "FAILED: push(\@currency, [$ctry, $curr, $iso, $v1, $v2]);\n" );
							}
						}
						##} elsif ($colcnt == 10) {
						##} elsif ($colcnt == 12) {
						##} elsif ($colcnt == 14) {
						##} elsif ($colcnt == 16) {	}
					}
				}
			}
		} elsif ($line =~ /<table.*>/i) {
			$tblcnt++;
			if ($tblcnt == 3) {
				prt("Entering TABLE tag $tblcnt ...[$line]\n") if $dbg1;
				$intbl = 1;
			}
		}
	}
	return $ccnt;
}

## month to number
sub mth_to_num {
	my ($mth) = shift;
	my $cnt = 0;
	my @mths = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	###prt( "Chk [$mth] " );
	foreach my $m (@mths) {
		$cnt++;
		if ($m eq $mth) {
			###prt( "Is $m - return $cnt\n" );
			return $cnt;
		}
	}
	mydie( "ERROR: Returning 0!!! for [$mth]\n" );
	return '??';
}

# translated to YYYY/MM/DD, like 2005/03/12
sub get_YYYYMMDD {
	my ($tm) = shift;
	my @arr = split( / /, $tm ); # time of form 'Sat Mar 12 03:11:55 2005'
	my $ac = scalar @arr;
	my $doff = 2;
	my $yoff = 4;
	if ($ac == 5) {
		$doff = 2;
		$yoff = 4;
	} elsif ($ac == 6) {
		$doff = 3;
		$yoff = 5;
	} else {
		mydie( "ERROR: Time ($tm) did NOT split correctly!\n" );
	}
	my $mn = mth_to_num( $arr[1] );
	if ($mn < 10) {
		$mn = '0'.$mn;
	}
	my $dn = $arr[$doff];
	if ($dn < 10) {
		$dn = '0'.$dn;
	}
	my $dtt = $arr[$yoff].'/'.$mn.'/'.$dn; # translated to 2005/03/12
	return $dtt;
}

# diagnostic output shows
#Entering TABLE tag 3 ...[<TABLE width="640" cellspacing="0" cellpadding="0" border="0">]
#Start row 1 ...
#Start column 1 ...[<td></td>]
# Start column 2 ...[<td>Code</td>]
#Start column 3 ...[<td></td>]
# Start column 4 ...[<td>Currency</td>]
#Start column 5 ...[<td></td>]
# Start column 6 ...[<td>fcu/CAD</td>]
#Start column 7 ...[<td></td>]
# Start column 8 ...[<td>fcu/USD</td>]
#Start column 9 ...[<td></td>]
# Start column 10 ...[<td>Code</td>]
#Start column 11 ...[<td></td>]
# Start column 12 ...[<td>Currency</td>]
#Start column 13 ...[<td></td>]
# Start column 14 ...[<td>fcu/CAD</td>]
#Start column 15 ...[<td></td>]
# Start column 16 ...[<td>fcu/USD</td>]
#Start column 17 ...[<td></td>]
#End row 1 ...
#Start row 2 ...
#End row 2 ...
#Start row 3 ...
#Start column 1 ...[<td></td>]
# Start column 2 ...[<td> <tt>ARS</tt> </td>]
#Start column 3 ...[<td></td>]
# Start column 4 ...[<td>Argentine Pesos</td>]
#Start column 5 ...[<td></td>]
# Start column 6 ...[<td>2.7941</td>]
#Start column 7 ...[<td></td>]
# Start column 8 ...[<td>3.0958</td>]
#Start column 9 ...[<td></td>]
# Start column 10 ...[<td> <tt>MAD</tt> </td>]
#Start column 11 ...[<td></td>]
# Start column 12 ...[<td>Moroccan Dirham</td>]
#Start column 13 ...[<td></td>]
# Start column 14 ...[<td>7.8186</td>]
#Start column 15 ...[<td></td>]
# Start column 16 ...[<td>8.6630</td>]
#Start column 17 ...[<td></td>]
#End row 3 ...

# eof = autoexch03.pl
