#!/Perl
# Series: Automation of Microsoft Word 
# From : http://aspn.activestate.com/ASPN/docs/ActivePerl/5.8/faq/Windows/ActivePerl-Winfaq12.html
# Purpose: Use Win32::OLE to PRINT a document, to the DEFAULT printer ...
# Geoff McLane - mailto: geoffair@hotmail.com - 2006-06-12
#
use strict;
use Win32::OLE;
use Win32::OLE::Const 'Microsoft Word';

# *** ALTER THIS TO POINT TO YOUR OWN TEST WORD DOCUMENT ***
my $File = "C:\\tmp\\test.doc";

# Load MS Word ...
my $Word = Win32::OLE->new('Word.Application', 'Quit');
if (! $Word) {
	die "ERROR: Failed to load Microsoft Word ...\n";
}

$Word->{'Visible'} = 1;  # if you want to see what's going on

$Word->Documents->Open($File)
    || die("Unable to open document ", Win32::OLE->LastError());

# see http://msdn.microsoft.com/library/default.asp?url=/library/en-us/vbawd11/html/womthSaveAs1_HV05213080.asp
# for more information ...
# Prints all or part of the specified document.
# expression.PrintOut(Background, Append, Range, OutputFileName, From, To, 
#  Item, Copies, Pages, PageType, PrintToFile, Collate, FileName, 
#  ActivePrinterMacGX, ManualDuplexPrint, PrintZoomColumn, PrintZoomRow, 
#  PrintZoomPaperWidth, PrintZoomPaperHeight)

# other print items
## $Word->Selection->{PageSetup}->{LeftMargin}=150;
## $Word->Selection->{PageSetup}->{RightMargin}=150;
## $Word->Selection->{PageSetup}->{TopMargin}=50;
## $Word->Selection->{PageSetup}->{BottomMargin}=50;

$Word->ActiveDocument->PrintOut({
    Background => 0,
    Append     => 0,
    Range      => wdPrintAllDocument,
    Item       => wdPrintDocumentContent,
    Copies     => 1,
    PageType   => wdPrintAllPages,
});

# or simply
# $Word->ActiveDocument->PrintOut;

$Word->Documents->Close; 
$Word->Documents->Quit; 

# eof - autoword01.pl

