#!/perl -w
# NAME: basename.pl
# AIM: simple example of using fileparse, and basename ...
# see http://perldoc.perl.org/File/Basename.html
use strict;
use warnings;
use File::Basename;
my $fullname = 'C:\path1\path2\basename.txt';
show_split( $fullname );
$fullname = 'C:\path1/path2/somename.html'; # mixed unix windows spearator
show_split( $fullname );
$fullname = '.\relname.c'; # simple relative path
show_split( $fullname );
$fullname = 'C:\path1\path2\./relname2'; # without ext
show_split( $fullname );
exit(0);

# subs
sub show_split {
	my ($fil) = shift;
	my ($name,$path,$suffix) = fileparse($fil);
	print "name=[$name], path=[$path], suffix=[$suffix] ... expect no suffix\n";
	my $filename = basename($fil,  ".".get_suffix($fil));
	print "filename=[$filename] ...\n";
	($name,$path,$suffix) = fileparse($fil, qr/\.[^.]*/ );
	print "name=[$name], path=[$path], suffix=[$suffix] ... suffix separated\n";
}

sub get_suffix {
	my ($f) = shift;
	my @arr = split(/\./,$f);
	return $arr[-1];
}

# eof - basename.pl
