#!/usr/bin/perl -w
# NAME: chkcmake.pl
# AIM: Given an input folder, follow the CMakeLists.txt file
# 25/10/2011 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2011-10-25";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $debug_on = 1;
my $def_file = 'C:\FG\30\flightgear';
my $show_mess = 0;

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

my @cmake_actions = qw(CMAKE_MINIMUM_REQUIRED INCLUDE PROJECT 
 SET FILE STRING MESSAGE FIND_LIBRARY LIST FIND_PACKAGE
 EXECUTE_PROCESS OPTION GET_FILENAME_COMPONENT CHECK_INCLUDE_FILE
 CHECK_CXX_SOURCE_COMPILES INCLUDE_DIRECTORIES
 ADD_DEFINITIONS CHECK_FUNCTION_EXISTS CONFIGURE_FILE 
 ADD_SUBDIRECTORY INSTALL CONFIGURE_FILE
 ADD_CUSTOM_TARGET
);

# DEBUG
my $dbg_01 = 0;
my $dbg_02 = 0;
my $dbg_03 = 0;

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ### prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub clean_action($) {
    my $act = shift;
    $act =~ s/^\(//;
    $act =~ s/\)$//;
    return $act;
}

sub extract_var($) {
    my $var = shift;
    # ${FLIGHTGEAR_VERSION}
    # ${versionFile}
    if ($var =~ /^\$\{(.+)\}$/) {
        return $1;
    }
    return $var;
}


sub process_action($) {
    my $rh = shift;
    my ($tag,$action,$lnn,$tline,$val);
    my ($item1,$item2,$item3);
    my $bfile = ${$rh}{"BASE_FILE"};
    $tag =  ${$rh}{"ACT_TAG"};
    $action = ${$rh}{"ACT_ACT"};
    $lnn = ${$rh}{"ACT_LNN"};
    $tline = ${$rh}{"ACT_LINE"};
    my $rdefs = ${$rh}{'CMAKE_DEFINES'}; # = \%defines;
    my ($msg,$act,@arr,$act2,$file,$var,$act3);
    my ($nm,$dr);
    my ($i,$i2);
    prt("Action [$tag] $action\n") if ($dbg_02);
    $act = clean_action($action);
    @arr = space_split($act);
    if ($tag eq "CMAKE_MINIMUM_REQUIRED") {
    } elsif ($tag eq "INCLUDE") {
    } elsif ($tag eq 'PROJECT') {
        $val = strip_quotes($arr[0]);
        ${$rh}{'PROJ_NAME'} = $val;
        prt("$lnn: $tag = $val\n");
    } elsif ($tag eq 'SET') {
    } elsif ($tag eq 'FILE') {
        # file(READ version versionFile)
        $act2 = $arr[0];
        if ($act2 eq 'READ') {
            $file = strip_quotes($arr[1]);
            $val  = strip_quotes($arr[2]);
            ${$rh}{"FILE_VAR"} = $val;
            if (! -f $file) {
                ($nm,$dr) = fileparse($bfile);
                $file = $dr.$file
            }
            if (-f $file) {
                if (open FIL,"<$file") {
                    my @lines = <FIL>;
                    close FIL;
                    ${$rh}{$val} = join(" ",@lines);
                    prt("Loaded [".${$rh}{$val}."] into $val\n");
                } else {
                    prtw("WARNING: $lnn: Unable to open FILE [$file] $tline\n");
                }
            } else {
                prtw("WARNING: $lnn: Unable to find FILE [$file] $tline\n");
            }
        } else {
            prtw("WARNING: $lnn: Uncase FILE action [$act2] $tline\n");
        }
    } elsif ($tag eq 'STRING') {
        #        0     1     2                                3                     4
        #        act2  act3  $item1                           $item2                $item3
        # string(REGEX MATCH "([0-9]+)\\.([0-9]+)\\.([0-9]+)" CPACK_PACKAGE_VERSION ${FLIGHTGEAR_VERSION} )
        $act2 = $arr[0];
        if ($act2 eq 'STRIP') {
            # string(STRIP ${versionFile} FLIGHTGEAR_VERSION) 
            $item1 = extract_var($arr[1]);
            $item2 = $arr[2];
            if (defined ${$rh}{$item1}) {
                ${$rh}{$item2} = trim_all(${$rh}{$item1});
            } else {
                prtw("WARNING: $lnn: Undefined STRIP item [$item1] $tline\n");
            }
        } elsif ($act2 eq 'REGEX') {
            $act3 = $arr[1];
            if ($act3 eq 'MATCH') {
                $item1 = strip_quotes($arr[2]);
                $item1 =~ s/\\\\/\\/g;
                $item2 = $arr[3];
                $item3 = extract_var($arr[4]);
                if (defined ${$rh}{$item3}) {
                    $val = ${$rh}{$item3};
                    if ($val =~ m/($item1)/) {
                        ${$rdefs}{$item2} = $1;
                        for ($i = 1; ; $i++) {
                            $i2 = $i + 1;
                            if (eval "defined \$$i2") {
                                $var = "CMAKE_MATCH_$i";
                                ${$rdefs}{$var} = eval "\$$i2";
                                prt("\$$i2 = ".${$rdefs}{$var}." in $var\n");
                            } else {
                                last;
                            }
                        }
                        prt("Got $item2 = ".${$rdefs}{$item2}."\n");
                    } else {
                        prtw("REGEX MATCH FAILED! on if ($val =~ /($item1)/)!\n");
                    }
                } else {
                    prtw("WARNING: $lnn: Undefined REGEX MATCH item [$item3] $tline\n");
                }
            } else {
                prtw("WARNING: $lnn: Uncase STRING [$act2] $act3 action - $tline\n");
            }
        } else {
            prtw("WARNING: $lnn: Uncase STRING action [$act2] $tline\n");
        }
    } elsif ($tag eq 'MESSAGE') {
        prt("$lnn: $tag $arr[0] [".strip_quotes($arr[1])."]\n") if ($show_mess || $dbg_03);
    } elsif ($tag eq 'FIND_LIBRARY') {
    } elsif ($tag eq 'LIST') {
    } elsif ($tag eq 'FIND_PACKAGE') {
    } elsif ($tag eq 'EXECUTE_PROCESS') {
    } elsif ($tag eq 'OPTION') {
        # option(SP_FDMS "Set to ON to build FlightGear with special-purpose FDMs" OFF)
        $item1 = $arr[0];
        $item2 = $arr[1];
        $item3 = $arr[2];
        ${$rdefs}{$item1} = ($item3 eq 'OFF') ? 0 : ($item3 eq 'ON') ? 1 : 0);
        ${$rdefs}{"MESSAGE-$item1"} = strip_quote($item2);
    } elsif ($tag eq 'GET_FILENAME_COMPONENT') {
    } elsif ($tag eq 'CHECK_INCLUDE_FILE') {
    } elsif ($tag eq 'CHECK_CXX_SOURCE_COMPILES') {
    } elsif ($tag eq 'INCLUDE_DIRECTORIES') {
    } elsif ($tag eq 'ADD_DEFINITIONS') {
    } elsif ($tag eq 'CHECK_FUNCTION_EXISTS') {
    } elsif ($tag eq 'CONFIGURE_FILE') {
    } elsif ($tag eq 'ADD_SUBDIRECTORY') {
    } elsif ($tag eq 'INSTALL') {
    } elsif ($tag eq 'CONFIGURE_FILE') {
    } elsif ($tag eq 'ADD_CUSTOM_TARGET') {
    } else {
        prtw("WARNING: $lnn: Action [$tag] $action NOT CASED!\n");
    }
}

sub process_cmake_list($) {
    my $rh = shift;
    my ($rlines,$name);
    $name = ${$rh}{"BASE_FILE"};
    $rlines = ${$rh}{"BASE_LINES"};
    my $lcnt = scalar @{$rlines};
    prt("Got $lcnt lines, from $name\n");
    my ($i,$lnn,$line,$tline,$len,$ch,$j,$tag,$test,$fnd,@braces,$action,$inquot);
    my @ifstack = ();
    my %iftags = ();
    for ($i = 0; $i < $lcnt; $i++) {
        $lnn = $i + 1;
        $line = ${$rlines}[$i];
        chomp $line;
        $tline = trim_all($line);
        $len = length($tline);
        next if ($len == 0);
        next if ($tline =~ /^\#/);
        if ($tline =~ /^if\s*\((.*)\)/i) {
            $tag = $1;
            prt("$lnn: IF($tag)\n") if ($dbg_01);
            push(@ifstack,[$tag,$lnn]);
            if (length($tag)) {
                $iftags{$tag} = 1;
            } else {
                prtw("WARNING: $lnn: Got an IF with NO tag! [$tline]!\n");
            }
        } elsif ($tline =~ /^else\s*\((.*)\)/i) {
            $tag = $1;
            prt("$lnn: ELSE($tag)\n") if ($dbg_01);
        } elsif ($tline =~ /^elseif\s*\((.*)\)/i) {
            $tag = $1;
            prt("$lnn: ELSEIF($tag)\n") if ($dbg_01);
        } elsif ($tline =~ /^endif\s*\((.*)\)/i) {
            $tag = $1;
            prt("$lnn: ENDIF($tag)\n") if ($dbg_01);
            if (@ifstack) {
                pop @ifstack;
            }
        } else {
            $tag = '';
            $fnd = 0;
            for ($j = 0; $j < $len; $j++) {
                $ch = substr($tline,$j,1);
                last if ($ch =~ /\W/);
                $tag .= $ch;
            }
            $tag = uc($tag);
            foreach $test (@cmake_actions) {
                ### $test = uc($test);
                if ($test eq $tag) {
                    $fnd = 1;
                    last;
                }
            }
            for (; $j < $len; $j++) {
                $ch = substr($tline,$j,1);
                last if ($ch =~ /\S/);
            }
            if ($ch eq '(') {
                @braces = ();
                push(@braces,$ch);
                $j++;
                $action = $ch;
                $inquot = 0;
                for (; $j < $len; $j++) {
                    $ch = substr($tline,$j,1);
                    $action .= $ch;
                    if ($inquot) {
                        $inquot = 0 if ($ch eq '"');
                    } else {
                        if ($ch eq '(') {
                            push(@braces,$ch);
                        } elsif ($ch eq ')') {
                            if (@braces) {
                                pop @braces;
                            } else {
                                prtw("WARNING: $lnn: Encountered ')' with none on stack! $tline\n");
                            }
                        } elsif ($ch eq '"') {
                            $inquot = 1;
                        }
                    }
                }
                prtw("WARNING: $lnn: Ended line in QUOTES! $tline\n") if ($inquot);
                while (@braces) {
                    $i++;
                    $action .= ' ';
                    if ($i < $lcnt) {
                        $lnn = $i + 1;
                        $line = ${$rlines}[$i];
                        chomp $line;
                        $tline = trim_all($line);
                        $len = length($tline);
                        for ($j = 0; $j < $len; $j++) {
                            $ch = substr($tline,$j,1);
                            $action .= $ch;
                            if ($inquot) {
                                $inquot = 0 if ($ch eq '"');
                            } else {
                                if ($ch eq '(') {
                                    push(@braces,$ch);
                                } elsif ($ch eq ')') {
                                    if (@braces) {
                                        pop @braces;
                                    } else {
                                        prtw("WARNING: $lnn: Encountered ')' with none on stack! $tline\n");
                                    }
                                } elsif ($ch eq '"') {
                                    $inquot = 1;
                                }
                            }
                        }
                    } else {
                        prtw("WARNING: $lnn: ran out of line in a brace!\n");
                        last;
                    }
                }
                prtw("WARNING: $lnn: Ended lines in QUOTES! $tline\n") if ($inquot);
                if ($fnd) {
                    #prt("Action [$tag] $action\n");
                    ${$rh}{"ACT_TAG"} = $tag;
                    ${$rh}{"ACT_ACT"} = $action;
                    ${$rh}{"ACT_LNN"} = $lnn;
                    ${$rh}{"ACT_LINE"} = $tline;
                    #process_action($tag,$action,$lnn,$tline);
                    process_action($rh);
                } else {
                    prtw("WARNING: tag $tag NOT FOUND! $tline");
                }
            } else {
                prtw("WARNING: First char NOT '('! $tline");
            }
        }
    }
    if (@ifstack) {
        prtw("WARNING: Still entries in IF stack!\n");
    }
    my $itcnt = scalar keys(%iftags);
    prt("Got $itcnt IF tags...\n");
}


sub process_in_dir($) {
    my ($dir) = @_;
    if (! opendir(DIR, $dir) ) {
        pgm_exit(1,"ERROR: Unable to open directory [$dir]\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($base_file);
    $dir .= "\\" if ( !($dir =~ /(\\|\/)$/) );
    $base_file = $dir."CMakeLists.txt";
    if (! open(FIL,"<$base_file") ) {
        pgm_exit(1,"ERROR: Unable to locate file [$base_file]\n");
    }
    my @lines = <FIL>;
    close FIL;
    ### my $lcnt = scalar @lines;
    ### prt("Got $lcnt lines, from $base_file\n");
    my %hash = ();
    $hash{'PROJECT_SOURCE_DIR'} = $dir;
    $hash{"BASE_FILE"} = $base_file;
    $hash{"BASE_LINES"} = \@lines;
    my %defines = ();
    $hash{'CMAKE_DEFINES'} = \%defines;
    #process_cmake_list(\@lines,$base_file);
    process_cmake_list(\%hash);
}

#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_in_dir($in_file);
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /v/) {
                if ($sarg =~ /v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -d $in_file) {
        pgm_exit(1,"ERROR: Unable to find in directory [$in_file]! Check name, location...\n");
    }
}

# eof - template.pl
