#!/perl -w
# NAME: chkinclist.pl
# AIM: VERY SPECIFIC - read MSVC 'include' list found, and analyse
# 8/27/2009 - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'avcodincs.txt';
prt( "$0 ... processing $in_file ...\n" );

sub process_file($) {
	my ($fil) = shift;
	my (@lines, $line, $max, $i, $line2);
	my (@arr, $ac, $part, $inc, $cnt);
	my ($key, $val, $len, $msg, $fwinc);
	my (@arr2, $f, $d);
	my %files_wincs = ();
	my %inc_files = ();
	if (open INF, "<$fil") {
		@lines = <INF>;
		close INF;
		$max = scalar @lines;
		prt( "Processing $max lines, from $fil...\n" );
		for ($i = 0; $i < $max; $i++) {
			$line = $lines[$i];
			chomp $line;
			$line2 = trim_all($line);
			$line2 = substr($line2,2) if ($line2 =~ /^\w{1}:/);
			@arr = split(/:/, $line2);
			$ac = scalar @arr;
			$fwinc = $arr[0];	# get the include file
			$fwinc =~ s/\(\d+\)$//;
			($f,$d) = fileparse($fwinc);
			#prt( "$fwinc\n" );
			if ($ac > 1) {
				$part = $arr[1];
				#prt( "$part \n" );
				if ($part =~ /#\s*include\s+["'<]{1}(.+)["'>]{1}/) {
					$inc = $1;
					#prt( "$inc " );
					if (defined $inc_files{$inc}) {
						$inc_files{$inc}++;
					} else {
						$inc_files{$inc} = 1;
					}
#					if (defined $files_wincs{$fwinc}) {
#						$val = $files_wincs{$fwinc};
#						push(@{$val}, $inc);
#						$files_wincs{$fwinc} = $val;
#					} else {
#						@arr2 = ();
#						push(@arr2,$inc);
#						$files_wincs{$fwinc} = [@arr2];
#					}
					if (defined $files_wincs{$f}) {
						$val = $files_wincs{$f};
						push(@{$val}, $inc);
						$files_wincs{$f} = $val;
					} else {
						@arr2 = ();
						push(@arr2,$inc);
						$files_wincs{$f} = [@arr2];
					}
				}
			}
		}
		prt("\n");
		$cnt = scalar keys(%inc_files);
		prt( "Got $cnt include files...\n" );
		$max = 0;
		foreach $key (keys %inc_files) {
			$len = length($key);
			$max = $len if ($len > $max);
		}
		$cnt = 0;
		foreach $key (keys %inc_files) {
			$msg = $key;
			$msg .= ' ' while (length($msg) < $max);
			$val = $inc_files{$key};
			$cnt++;
			prt("$cnt: $msg $val\n");
		}
		$cnt = 0;
		$max = 0;
		foreach $key (keys %files_wincs) {
			$len = length($key);
			$max = $len if ($len > $max);
		}
		foreach $key (keys %files_wincs) {
			$val = $files_wincs{$key};
			$msg = $key;
			$msg .= ' ' while (length($msg) < $max);
			$msg .= ' [';
			foreach $f (@{$val}) {
				$msg .= "$f ";
			}
			$msg =~ s/ $//;
			$msg .= ']';
			prt("$msg\n");
		}

	} else {
		prt( "ERROR: unable to open [$fil]...\n" );
	}
}

process_file($in_file);

close_log($outfile,1);
exit(0);

# eof
