#!/perl -w
# NAME: chklib.pl
# AIM: VERY SPECIFIC - check LIBCMT or LIBCMTD in library
# Uses my 'fa4' utitlity
use strict;
use warnings;
use Cwd;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $load_log = 1;

my $base_dir = "C:\\Projects\\hb\\HandBrake\\build\\msvc";
my @lib_listD = qw( libavcodecD.lib libavformatD.lib libswscaleD.lib libavutilD.lib libdvdreadD.lib libdvdcssD.lib zlibD.lib libvorbisD.lib libmp3lameD.lib mpglibD.lib libfaacD.lib libdca.lib liba52D.lib libtheora_static.lib libx264D.lib libiconvD.lib libmpeg2.lib libsamplerateD.lib libnutD.lib liboggD.lib libmp4v2D.lib libdvdnavD.lib libmkvD.lib libspeexD.lib libwinportD.lib LibOpenJPEGD.lib libxvidcoreD.lib libgsmD.lib libfaadD.lib libdiracD.lib libvaD.lib pthreadsD.lib );
my $includesD = '..\..\..\ffmpeg\build\msvc\lib;..\..\..\libdvdread\build\msvc\lib;..\..\..\libdvdcss\msvc\lib;..\..\..\zlib\lib;..\..\..\libvorbis\win32\VS2008\libvorbis\lib;..\..\..\lame\vc_solution\lib;..\..\..\libwinport\lib;..\..\..\faac\libfaac\lib;"..\..\..\libdca\vc++\Debug";"..\..\..\a52dec\vc++\lib";..\..\..\theora\win32\VS2008\Win32\Debug;..\..\..\x264\build\win32\bin;..\..\..\libiconv\build\msvc\lib;"..\..\..\\mpeg2\vc++\Debug";..\..\..\libsamplerate\Win32\lib;..\..\..\libnut\win32\lib;..\..\..\libogg\win32\msvc\lib;..\..\..\mp4v2\build\msvc\lib;..\..\..\libdvdnav\msvc\install\lib;..\..\..\libmkv\build\msvc\lib;..\..\..\speex\win32\VS2008\libspeex\lib;..\..\..\schroedinger\build\msvc\lib;..\..\..\liboil\build\msvc\lib;..\..\..\OpenJPEG\lib;..\..\..\xvidcore\build\win32\bin;..\..\..\gsm\build\msvc\lib;..\..\..\faad2\libfaad\lib;..\..\..\dirac\win32\msvc\lib;..\..\..\libva\build\msvc\lib;..\..\..\pthreads\build\msvc\lib';

my @lib_list = qw( libavcodec.lib libavformat.lib libswscale.lib libavutil.lib libdvdread.lib libdvdcss.lib zlib.lib libvorbis.lib libmp3lame.lib mpglib.lib libfaac.lib libdca.lib liba52.lib libtheora.lib libx264.lib libiconv.lib libmpeg2.lib libsamplerate.lib libnut.lib libogg.lib libmp4v2.lib libdvdnav.lib libmkv.lib libspeex.lib libwinport.lib LibOpenJPEG.lib libxvidcore.lib libgsm.lib libfaad.lib libdirac.lib libva.lib pthreads.lib );
my $includes = '..\..\..\ffmpeg\build\msvc\lib;..\..\..\libdvdread\build\msvc\lib;..\..\..\libdvdcss\msvc\lib;..\..\..\zlib\lib;..\..\..\libvorbis\win32\VS2008\libvorbis\lib;..\..\..\lame\vc_solution\lib;..\..\..\libwinport\lib;..\..\..\faac\libfaac\lib;"..\..\..\libdca\vc++\Release";"..\..\..\a52dec\vc++\lib";..\..\..\theora\win32\VS2008\libtheora\lib;..\..\..\x264\build\win32\bin;..\..\..\libiconv\build\msvc\lib;"..\..\..\\mpeg2\vc++\Release";..\..\..\libsamplerate\Win32\lib;..\..\..\libnut\win32\lib;..\..\..\libogg\win32\msvc\lib;..\..\..\mp4v2\build\msvc\lib;..\..\..\libdvdnav\msvc\install\lib;..\..\..\libmkv\build\msvc\lib;..\..\..\speex\win32\VS2008\libspeex\lib;..\..\..\schroedinger\build\msvc\lib;..\..\..\liboil\build\msvc\lib;..\..\..\OpenJPEG\lib;..\..\..\xvidcore\build\win32\bin;..\..\..\gsm\build\msvc\lib;..\..\..\faad2\libfaad\lib;..\..\..\dirac\win32\msvc\lib;..\..\..\libva\build\msvc\lib;..\..\..\pthreads\build\msvc\lib';

my @warnings = ();

sub prtw($) {
    my ($tx) = shift;
    $tx =~ s/\n$//;
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings() {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}

sub check_lib($) {
    my ($lib) = @_;
    my %done = ( 'OLDNAMES' => 1 );
    my $cnt = 0;
    if (-f $lib) {
    	if (open (FA4, "fa4 \"LIBCMT\" -c $lib|")) {
            my @arr = <FA4>;
            close FA4;
    		foreach my $ln (@arr) {
	    		chomp $ln;
                $ln = trim_all($ln);
		    	if( length($ln) ) {
                    my @arr2 = split(/\s/,$ln);
                    my ($itm,$res);
                    foreach $itm (@arr2) {
                        if ($itm =~ /DEFAULTLIB:"(\w+)"/) {
                            $res = $1;
                            if ( !defined $done{$res} ) {
                                $done{$res} = 1;
                                prt("$res ");
                                $cnt++;
                            }

                        }
                    }
			    }
		    }
            prt(" found in [$lib]\n") if ($cnt);
        } else {
            prt( "FAILED to run FA4!\n" );
        }
    } else {
        prt( "Can NOT locate [$lib] file!\n" );
    }
}

sub process_libs($$$) {
    my ($rla, $inc, $base) = @_;
    my $cnt = scalar @{$rla};
    my @incs = split(";",$inc);
    my $cnt2 = scalar @incs;
    prt( "Checking $cnt libraries, with $cnt2 rel include paths... base=$base\n" );
    my ($lib,$path,$np,$fnd,$ff,$cnt3);
    my @libs = ();
    my @missed = ();
    foreach $lib (@{$rla}) {
        $fnd = 0;
        $lib = strip_quotes($lib);
        foreach $path (@incs) {
            $path = strip_quotes($path);
            $ff = $base;
            $ff .= "\\" if (!(($ff =~ /(\\|\/)$/)||($path =~ /^(\\|\/)/)));
            $ff .= $path;
            $ff .= "\\" if (!(($ff =~ /(\\|\/)$/)||($lib =~ /^(\\|\/)/)));
            $ff .= $lib;
            $np = fix_rel_path($ff);
            if (-f $np) {
                $fnd = 1;
                push(@libs,$np);
            }
        }
        if (!$fnd) {
            prt( "Unable to locate [$lib]\n" );
            push(@missed,$lib);
        }
    }
    $cnt2 = scalar @libs;
    $cnt3 = scalar @missed;
    prt( "Done $cnt libraries, found $cnt2, missed $cnt3... \n" );
    return \@libs;
}

sub check_contents($) {
    my ($rla) = @_;
    my ($lib);
    foreach $lib (@{$rla}) {
        check_lib($lib);
    }
}


my $ref_libs = process_libs( \@lib_list, $includes, $base_dir );
check_contents($ref_libs);

my $ref_libsD = process_libs( \@lib_listD, $includesD, $base_dir );
check_contents($ref_libsD);

close_log($outfile,$load_log);
exit(0);

# eof
