#!/perl -w
# NAME: chkpath.pl
# AIM: Find a file using the PATH environment variable ...
# 01/12/2007 - geoff mclane - geoffair.net/mperl
use strict;
use warnings;
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}

my $fnd_file = 'makehm.exe';
my @found = ();
my $verb = 0;

parse_args(@ARGV);

my $path_env = $ENV{"PATH"};
if (defined $path_env) {
	my @folds = split(/;/,$path_env);
	my $fcnt = scalar @folds;
	prt( "Got $fcnt folders to search for $fnd_file ...\n" );
	foreach my $fdr (@folds) {
		$fdr = strip_quotes($fdr);
		$fdr = unix_2_dos($fdr);
		$fdr .= "\\" if !($fdr =~ /\\$/);
		my $ff = $fdr . $fnd_file;
		if (-f $ff) {
			prt( "Found $ff ...\n" );
			push(@found,$ff);
		} else {
			prt( "NOT FOUND $ff ...\n" ) if ($verb);
		}
	}
} else {
	prt( "ERROR: PATH NOT IN ENVIRONEMNT???\n" );
}

if (@found) {
	prt( "\nGot ".scalar @found." finds of $fnd_file ...\n" );
	prt( join("\n",@found)."\n" );
}

exit(0);

sub prt {
	my ($msg) = shift;
	print $msg;
}

sub mydie {
	my ($msg) = shift;
	die $msg;
}


sub unix_2_dos {
	my ($f) = shift;
	$f =~ s/\//\\/g;
	return $f;
}

sub parse_args {
	my (@av) = @_;
	my $inf = '';
	while (@av) {
		my $arg = $av[0];
		if ($arg =~ /^-/) {
			if ($arg =~ /^-+v/i) {
				prt( "Setting verbosity ON\n" );
				$verb = 1;
			} else {
				mydie( "Unknowm argument [$arg] ... only -v allowed.\n" );
			}
		} else {
			$inf = $arg;
			prt( "Got input [$inf] ...\n" );
		}
		shift @av;
	}

	if (length($inf)) {
		$fnd_file = $inf;
	} else {
		mydie( "No input file found in command!\n" );
	}
}

sub strip_quotes {
	my ($ln) = shift;
	if ($ln =~ /^".*"$/) {
		$ln = substr($ln,1,length($ln)-2);
	}
	return $ln;
}


# eof - chkpath.pl
