#!/usr/bin/perl -w
# NAME: chkrequire.pl
# AIM: Givin an input perl script file name, search for files 'required' by that script
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';

### Debug
my $debug_on = 0; # run with default input file
my $def_file = 'C:\GTools\perl\acscan03.pl';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub process_file($) {
    my ($inf) = @_;
    if (!open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to OPEN file [$inf]!\n");
    }
    my @lines = <INF>;
    close INF;
    my ($line,$cnt,$rem,$file);
    $cnt = 0;
    my @files = ();
    foreach $line (@lines) {
        chomp $line;
        if ($line =~ /^\s*require\s+(.+)$/) {
            $rem = $1;
            $file = '';
            if (($rem =~ /^('|")([-\w\.]+)('|')/) && ($1 eq $3)) {
                $file = $2;
                push(@files,$file);
            }
            $cnt++;
            prt("$cnt: [$line] [$file]\n");
        }
    }
    if ($cnt) {
        prt("Found and shown $cnt 'required' files, in [$inf]...\n");
        my $cnt2 = scalar @files;
        if ($cnt2) {
            prt("\nList of $cnt2 is = [".join(", ",@files)."]\n\n");
        }
    } else {
        prt("No 'required' files, in [$inf]...\n");
    }
}

sub do_test() {
    my $rem = "'lib_acscan.pl' or die \"Unab";
    my $file = 'NONE';
    if (($rem =~ /^('|")([-\w\.]+)('|')/) && ($1 eq $3)) {
        $file = $2;
    }
    prt("$file\n");
    exit(1);
}

#########################################
### MAIN ###
parse_args(@ARGV);
#do_test();
process_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-08-14\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}
sub parse_args {
    my (@av) = @_;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /^-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }
    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        prt("[DEBUG_ON] Set input to default [$in_file]\n");
    }

    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }

    if (! -f $in_file) {
        prt("Presently running in current directory [$cwd]\n");
        pgm_exit(1,"ERROR: Unable to locate file [$in_file]! Check name, location...\n");
    }

}

# eof - template.pl
