#!/usr/bin/perl -w
# NAME: chkwebsrc.pl
# AIM: SPECIFIC - Compare the soures published on the my web, with the original,
# and report changes...
# 29/12/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
use File::stat; # to get the file date, time, size, etc
use Time::gmtime;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';
my $hp_root = "C:\\HOMEPAGE\\GA\\mperl";
my $web_dir = $hp_root."\\src";
my $src_dir = "C:\\GTools\\perl";

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        #prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub get_YYYYMMDD_hhmmss_UTC($) {
    my ($t) = shift;
    # sec, min, hour, mday, mon, year, wday, yday, and isdst.
    my $tm = gmtime($t);
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d",
        $tm->year() + 1900, $tm->mon() + 1, $tm->mday(), $tm->hour(), $tm->min(), $tm->sec());
    return $m;
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub get_html_list($) {
    my $dir = shift;
    my @arr = ();
    if (opendir(DIR,"$dir")) {
        my @files = readdir(DIR);
        close DIR;
        $dir .= "\\" if ( !($dir =~ /(\\|\/)$/) );
        my ($fil,$ff,$n,$d,$e);
        foreach $fil (@files) {
            next if (($fil eq '.')||($fil eq '..'));
            $ff = $dir.$fil;
            if (-f $ff) {
                ($n,$d,$e) = fileparse($ff, qr/\.[^.]*/ );
                if ($e =~ /^\.htm$/i) {
                    push(@arr,[$ff,$n,$fil]);
                }
            }
        }
    } else {
        prt("ERROR: Unable to open directory [$dir]!\n");
    }
    return \@arr;
}

sub process_web_dir($) {
    my $dir = shift;
    my @arr = ();
    if (opendir(DIR,"$dir")) {
        my @files = readdir(DIR);
        close DIR;
        $dir .= "\\" if ( !($dir =~ /(\\|\/)$/) );
        my ($fil,$ff,$n,$d,$e);
        foreach $fil (@files) {
            next if (($fil eq '.')||($fil eq '..'));
            $ff = $dir.$fil;
            if (-f $ff) {
                ($n,$d,$e) = fileparse($ff, qr/\.[^.]*/ );
                if ($e =~ /^\.txt$/i) {
                    push(@arr,[$ff,$n,$fil]);
                }
            }
        }
    } else {
        prt("ERROR: Unable to open directory [$dir]!\n");
    }
    return \@arr;
}

sub process_src_dir($$$) {
    my ($ra,$dir,$wd) = @_;
    my $cnt = scalar @{$ra};
    prt("Got $cnt files to check... in directory [$wd]\n");
    my ($i,$ff,$nm,$nf,$sb1,$sb2,$msg,$diff,$tdiff,$show,$fil);
    if (! -d $dir) {
        prt("ERROR: $dir is NOT a directory!\n");
        return 0;
    }
    $dir .= "\\" if ( !($dir =~ /(\\|\/)$/) );
    my @diffs = ();
    my $dcnt = 0;
    for ($i = 0; $i < $cnt; $i++) {
        $ff = ${$ra}[$i][0];
        if ($sb1 = stat($ff)) {
            $nm = ${$ra}[$i][1];
            $fil = ${$ra}[$i][2];
            $nf = $dir.$nm.'.pl';
            if (-f $nf) {
                if ($sb2 = stat($nf)) {
                    $show = 0;
                    $msg = "Compare $nm... ";
                    $diff = $sb1->size - $sb2->size;
                    $tdiff = $sb1->mtime - $sb2->mtime;
                    if (($diff == 0)&&($tdiff == 0)) {
                        $msg .= "same SIZE and TIME";
                    } else {
                        $msg .= "Diff ";
                        if ($diff != 0) {
                            $msg .= "SIZE ".$sb1->size."/".$sb2->size." ";
                        }
                        if ($tdiff != 0) {
                            $msg .= "TIME ".get_YYYYMMDD_hhmmss_UTC($sb1->mtime)." - ".
                                get_YYYYMMDD_hhmmss_UTC($sb2->mtime)." ";
                        }
                        $show = 1;
                        #            0   1   2    3   4 5
                        push(@diffs,[$ff,$nm,$fil,$nf,0,'']);
                        $dcnt++;
                    }
                    prt("$msg\n") if ($show);
                } else {
                    prt("No stat of [$nf]\n");
                }
            } else {
                prt("No locate of [$nf]\n");
            }
        } else {
            prt("stat of [$ff] FAILED\n");
        }
    }
    if (@diffs) {
        my $rahtm = get_html_list($hp_root);
        my $hcnt = scalar @{$rahtm};
        prt("Got $hcnt HTM files to check for $dcnt files...\n");
        my ($j,$line);
        for ($j = 0; $j < $hcnt; $j++) {
            $ff = ${$rahtm}[$j][0];
            if (open INF, "<$ff") {
                my @lines = <INF>;
                close INF;
                for ($i = 0; $i < $dcnt; $i++) {
                    $fil = $diffs[$i][2];
                    foreach $line (@lines) {
                        if ($line =~ /$fil/) {
                            prt("Found [$fil], in [$ff]\n");
                            $diffs[$i][4]++;
                            $diffs[$i][5] .= " $ff";
                            last;
                        }
                    }
                }
            }
        }
        for ($i = 0; $i < $dcnt; $i++) {
            $fil = $diffs[$i][2];
            if ($diffs[$i][4] == 0) {
                prt("Not found [$fil]...\n");
            }
        }
    } else {
        prt("No differences founds...\n");
    }
}

#########################################
### MAIN ###
#parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
#process_in_file($in_file);
my $ref_arr = process_web_dir($web_dir);
process_src_dir($ref_arr,$src_dir,$web_dir);
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - chkwebsrc.pl
