#!/perl -w
# NAME: cleanup02.pl
# AIM: Given an input folder, search for where there exists object files,
# and clean these up using a special CLOBNOW batch file ...
# This is a re-write - See cleanup.pl for previous version 
# 12/07/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
use Cwd;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_folder = 'C:\Projects';
##my $in_folder = 'C:\FG\FGCOMXML';
##my $in_folder = 'C:\FG';
my $recursive = 1;
my $fldrcnt = 0;
my $donefolders = 0;
my $donefiles = 0;
my $out_file = 'tempclean.bat';

my @fpfolders = qw( _vti_cnf _vti_cnf _private _derived );
my @cleanexts = qw( .obj .old .bak .pdb .pch .ilk .ncb .plg .opt .idb .aps .sbr .suo .user );
my @cleanfils = qw( BuildLog.htm );

my @toclean = ();
my $cwdir = getcwd();
if (@ARGV) {
    $in_folder = pop @ARGV;
}

sub unix_2_dos($) {
	my ($f) = shift;
	$f =~ s/\//\\/g;
	return $f;
}

sub is_in_list_nc {
    my ($itm, @lst) = @_;
    $itm = lc($itm);
    foreach my $chk (@lst) {
        if (lc($chk) eq $itm) {
            return 1;
        }
    }
    return 0;
}

sub is_fp_folder($) {
	my ($fil) = shift;
    if (is_in_list_nc($fil, @fpfolders)) {
		return 1;
	}
	return 0;
}

sub is_my_file($) {
	my ($fil) = shift;
	my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
    if (is_in_list_nc($ext, @cleanexts)||
        is_in_list_nc($nm.$ext,@cleanfils)) {
		return 1;
	}
	return 0;
}

sub add_if_not_repeat($) {
    my ($fil) = shift;
    if ( !is_in_list_nc($fil, @toclean) ) {
        push(@toclean, $fil);
        return 1;
    }
    return 0;
}

sub process_folder($) {
    my ($inf) = shift;
    my (@files, $fl, $ff, @fldrs);
    @fldrs = ();
    my $cnt = 0;
    if ( opendir( DIR, $inf ) ) {
        @files = readdir(DIR);
        closedir DIR;
        $donefolders++;
        prt( "Done $donefolders folders, $donefiles files ... got ".scalar @toclean." to clean ...\n" ) if (($donefolders % 1000) == 0);
        foreach $fl (@files) {
            if (($fl eq '.') || ($fl eq '..') || is_fp_folder($fl) ) {
                next;
            }
            $ff = $inf . "\\" . $fl;
            if (-d $ff) {
                push(@fldrs, $ff) if $recursive;
            } else {
                $donefiles++;
                if (is_my_file($fl)) {
                    $cnt += add_if_not_repeat($inf);
                }
            }
        }
        foreach $fl (@fldrs) {
            $cnt += process_folder($fl);
        }
    } else {
        prt("ERROR: Can NOT OPEN directory $inf...\n" );
    }
    return $cnt;
}

prt( "$0 ... Processing $in_folder ...\n" );
if (-d $in_folder) {
    $fldrcnt = process_folder($in_folder);
} else {
    prt("ERROR: Can NOT locate $in_folder ...\n" );
}

prt( "Processed $donefolders directories, $donefiles files ...\n" );
if (@toclean) {
    my $msg = "Got ".scalar @toclean." folders to clean ...";
    prt( "$msg ($fldrcnt)\n" );
    $msg = "\@echo ".$msg."\n";
    foreach my $dir (@toclean) {
        if ($dir =~ /\s+/) {
            $msg .= "cd \"$dir\"\n";
        } else {
            $msg .= "cd $dir\n";
        }
        $msg .= "\@call clobnow\n";
        prt( "$dir\n" );
    }
    $msg .= "cd ".unix_2_dos($cwdir)."\n";
    $msg .= "\@echo Done $fldrcnt folders ...\n";
    write2file($msg,$out_file);
    prt( "Written clean $fldrcnt folders to $out_file ...\n" );
} else {
    prt( "Appears NO folders to clean for root $in_folder ...\n" );
}

close_log($outfile,1);
exit(0);

# eof - cleanup02.pl
