#!/perl -w
#################################################################
# *NAME* colors2.pl
# AIM: To develop a color map to use with DEM elevations mapping
# Esentially two groups
# BLUE - Ocean
# RED/ORANGE/YELLOW/GREEN - Land
# goeff mclane - http://geoffmclane.com - 20070209
#################################################################

use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $showref = 0; # output the color reference list, and exit
my $outfile = 'temp.'.$0.'.txt';
my $htmfile = 'temp.'.$0.'.htm';
my @stdarr = ();
my @newarr = ();
my @used_colors = ();
my @used_counts = ();
# debug items
my $dbg1 = 0;	# show each is_in_used call
my $dbg2 = 0;	# show paragraph added to table
my $dbg3 = 0;	# list, as text, the standard generated colors

open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

# Color  Color Name RGB Value  
# Repeated
# Aqua #00FFFF as Cyan
# Fuchsia #FF00FF as Magenta
my @color_ref = qw(
 LightPink #FFB6C1 
 Pink #FFC0CB 
 Crimson #DC143C 
 LavenderBlush #FFF0F5 
 PaleVioletRed #DB7093 
 HotPink #FF69B4 
 DeepPink #FF1493 
 MediumVioletRed #C71585 
 Orchid #DA70D6 
 Thistle #D8BFD8 
 Plum #DDA0DD 
 Violet #EE82EE 
 MagentaOrFuchsia #FF00FF 
 DarkMagenta #8B008B 
 Purple #800080 
 MediumOrchid #BA55D3 
 DarkViolet #9400D3 
 DarkOrchid #9932CC 
 Indigo #4B0082 
 BlueViolet #8A2BE2 
 MediumPurple #9370DB 
 MediumSlateBlue #7B68EE 
 SlateBlue #6A5ACD 
 DarkSlateBlue #483D8B 
 Lavender #E6E6FA 
 GhostWhite #F8F8FF 
 Blue #0000FF 
 MediumBlue #0000CD 
 MidnightBlue #191970 
 DarkBlue #00008B 
 Navy #000080 
 RoyalBlue #4169E1 
 CornflowerBlue #6495ED 
 LightSteelBlue #B0C4DE 
 LightSlateGray #778899 
 SlateGray #708090 
 DodgerBlue #1E90FF 
 AliceBlue #F0F8FF 
 SteelBlue #4682B4 
 LightSkyBlue #87CEFA 
 SkyBlue #87CEEB 
 DeepSkyBlue #00BFFF 
 LightBlue #ADD8E6 
 PowderBlue #B0E0E6 
 CadetBlue #5F9EA0 
 Azure #F0FFFF 
 LightCyan #E0FFFF 
 PaleTurquoise #AFEEEE 
 CyanOrAqua #00FFFF 
 DarkTurquoise #00CED1 
 DarkSlateGray #2F4F4F 
 DarkCyan #008B8B 
 Teal #008080 
 MediumTurquoise #48D1CC 
 LightSeaGreen #20B2AA 
 Turquoise #40E0D0 
 Aquamarine #7FFFD4 
 MediumAquamarine #66CDAA 
 MediumSpringGreen #00FA9A 
 MintCream #F5FFFA 
 SpringGreen #00FF7F 
 MediumSeaGreen #3CB371 
 SeaGreen #2E8B57 
 Honeydew #F0FFF0 
 LightGreen #90EE90 
 PaleGreen #98FB98 
 DarkSeaGreen #8FBC8F 
 LimeGreen #32CD32 
 Lime #00FF00 
 ForestGreen #228B22 
 Green #008000 
 DarkGreen #006400 
 VeryDarkGreen #003200 
 Chartreuse #7FFF00 
 LawnGreen #7CFC00 
 GreenYellow #ADFF2F 
 DarkOliveGreen #556B2F 
 YellowGreen #9ACD32 
 OliveDrab #6B8E23 
 Beige #F5F5DC 
 LightGoldenrodYellow #FAFAD2 
 Ivory #FFFFF0 
 LightYellow #FFFFE0 
 Yellow #FFFF00 
 Olive #808000 
 DarkKhaki #BDB76B 
 LemonChiffon #FFFACD 
 PaleGoldenrod #EEE8AA 
 Khaki #F0E68C 
 Gold #FFD700 
 Cornsilk #FFF8DC 
 Goldenrod #DAA520 
 DarkGoldenrod #B8860B 
 FloralWhite #FFFAF0 
 OldLace #FDF5E6 
 Wheat #F5DEB3 
 Moccasin #FFE4B5 
 Orange #FFA500 
 PapayaWhip #FFEFD5 
 BlanchedAlmond #FFEBCD 
 NavajoWhite #FFDEAD 
 AntiqueWhite #FAEBD7 
 Tan #D2B48C 
 BurlyWood #DEB887 
 Bisque #FFE4C4 
 DarkOrange #FF8C00 
 Linen #FAF0E6 
 Peru #CD853F 
 PeachPuff #FFDAB9 
 SandyBrown #F4A460 
 Chocolate #D2691E 
 SaddleBrown #8B4513 
 Seashell #FFF5EE 
 Sienna #A0522D 
 LightSalmon #FFA07A 
 Coral #FF7F50 
 OrangeRed #FF4500 
 DarkSalmon #E9967A 
 Tomato #FF6347 
 MistyRose #FFE4E1 
 Salmon #FA8072 
 Snow #FFFAFA 
 LightCoral #F08080 
 RosyBrown #BC8F8F 
 IndianRed #CD5C5C 
 Red #FF0000 
 Brown #A52A2A 
 FireBrick #B22222 
 DarkRed #8B0000 
 Maroon #800000 
 White #FFFFFF 
 WhiteSmoke #F5F5F5 
 Gainsboro #DCDCDC 
 LightGrey #D3D3D3 
 Silver #C0C0C0 
 DarkGray #A9A9A9 
 Gray #808080 
 DimGray #696969 
 Black #000000 
);

my @byte_color_map = (
   # BGN RED ORANGE YELLOW GREEN
     0,  0,204,  0, #   4 RED 80%
    51,  0,204,  0, #  40
    51, 51,204,  0, #  46

     0,  0,255,  0, #   5 RED 100%
    51,  0,255,  0, #  41
    51, 51,255,  0, #  47

   102,102,255,  0, #  89

   153,  0,255,  0, # 113
   153, 51,255,  0, # 119

   153,102,255,  0, # 125
   153,102,204,  0, # 124
   153,153,255,  0, # 131
   153,153,204,  0, # 130

   153, 51,204,  0, # 118
   153,  0,153,  0, # 111
   153,  0,204,  0, # 112

   102,102,204,  0, #  88 ORANGE GREEN
   102,102,153,  0, #  87 ORANGE BLUE

   102,153,255,  0, #  95

   153,204,255,  0, # 137 LIGHT ORANGE
   153,204,204,  0, # 136 ORANGE+TURQ

   102,153,204,  0, #  94
     0,204,255,  0, #  29 ORANGE

     0,204,204,  0, #  28 ORANGE

     0,255,255,  0, #  35 YELLOW 100%
    51,255,255,  0, #  71 YELLOW

   102,255,255,  0, # 107
   102,255,204,  0, # 106
   102,255,153,  0, # 105
   102,255,102,  0, # 104
   102,255, 51,  0, # 103
   102,255,  0,  0, # 102

    51,255,204,  0, #  70 YELLOW 75%
    51,255,153,  0, #  69 YELLOW GREEN

     0,255,204,  0, #  34 YELLOW
     0,255,153,  0, #  33 YELLOW GREEN
     0,255,102,  0, #  32 LIGHT GREEN
     0,255, 51,  0, #  31 LIGHT GREEN

   102,204,255,  0, # 101
   102,204,204,  0, # 100
   102,204,153,  0, #  99
   102,204,102,  0, #  98
   102,204, 51,  0, #  97
   102,204,  0,  0, #  96

   102,153,153,  0, #  93
   102,153,102,  0, #  92
   102,153, 51,  0, #  91
   102,153,  0,  0, #  90

     0,204,153,  0, #  27 ORANGE GREEN
     0,204,102,  0, #  26 GREEN + ORANGE

    51,204,  0,  0, #  60 LIGHT GREEN
    51,204, 51,  0, #  61 LIGHT GREEN
    51,204,102,  0, #  62 LIGHT MUDY GREEN

    51,153,102,  0, #  56 MUDY GREEN
     0,255,  0,  0, #  30 GREEN 100%
    51,255,  0,  0, #  66 GREEN

     0,204,  0,  0, #  24 GREEN
     0,204, 51,  0, #  25 GREEN
 
    51,255, 51,  0, #  67 GREEN
    51,255,102,  0, #  68 GREEN

    51,153,  0,  0, #  54 DARK GREEN
    51,153, 51,  0, #  55 DARK GREEN
    51,102,  0,  0, #  48 DARK GREEN
    51,102, 51,  0, #  49 DARK GREEN
   # END RED ORANGE YELLOW GREEN

     0, 50,  0,  0, # 229
     0, 50,  0,  0, # 227

   153,204,153,  0, # 135 TURQ4+ORANGE
   153,204,102,  0, # 134 TURQ3
   153,204, 51,  0, # 133 TURQ2
   153,204,  0,  0, # 132 TURQ1

   153,255,  0,  0, # 138
   153,255, 51,  0, # 139
   153,255,102,  0, # 140
   153,255,153,  0, # 141
   153,255,204,  0, # 142
   153,255,255,  0, # 143

   204,  0,102,  0, # 146
   204,  0,153,  0, # 147
   204,  0,204,  0, # 148
   204,  0,255,  0, # 149

   204, 51,102,  0, # 152
   204, 51,153,  0, # 153
   204, 51,204,  0, # 154
   204, 51,255,  0, # 155

   204,102,102,  0, # 158
   204,102,153,  0, # 159
   204,102,204,  0, # 160
   204,102,255,  0, # 161

   204,153,102,  0, # 164
   204,153,153,  0, # 165
   204,153,204,  0, # 166
   204,153,255,  0, # 167

   204,204,102,  0, # 170
   204,204,153,  0, # 171
   204,204,255,  0, # 173

   204,255,102,  0, # 176
   204,255,153,  0, # 177
   204,255,204,  0, # 178
   204,255,255,  0, # 179

     0, 50,  0,  0, # 222
     0, 50,  0,  0, # 223

     0,  0,  0,  0, #   0
     0,  0, 51,  0, #   1
     0,  0,102,  0, #   2
     0,  0,153,  0, #   3

     0, 51,  0,  0, #   6
     0, 51, 51,  0, #   7
     0, 51,102,  0, #   8
     0, 51,153,  0, #   9
     0, 51,204,  0, #  10
     0, 51,255,  0, #  11
     0,102,  0,  0, #  12
     0,102, 51,  0, #  13
     0,102,102,  0, #  14
     0,102,153,  0, #  15
     0,102,204,  0, #  16
     0,102,255,  0, #  17
     0,153,  0,  0, #  18
     0,153, 51,  0, #  19
     0,153,102,  0, #  20
     0,153,153,  0, #  21
     0,153,204,  0, #  22
     0,153,255,  0, #  23

     0, 50,  0,  0, # 218
     0, 50,  0,  0, # 219

   255,  0,102,  0, # 182
   255, 51,102,  0, # 188
   255,102,102,  0, # 194
   255,153,102,  0, # 200
   255,204,102,  0, # 206
   255,204,153,  0, # 207

   255,  0,153,  0, # 183
   255, 51,153,  0, # 189
   255,102,153,  0, # 195
   255,153,153,  0, # 201

   255,  0,204,  0, # 184
   255,  0,255,  0, # 185

   255, 51,204,  0, # 190
   255, 51,255,  0, # 191

   255,102,204,  0, # 196
   255,102,255,  0, # 197

   255,153,204,  0, # 202
   255,153,255,  0, # 203

   255,204,204,  0, # 208
   255,204,255,  0, # 209

   255,255,204,  0, # 214
   255,255,255,  0, # 215

     0, 50,  0,  0, # 224
     0, 50,  0,  0, # 225

    51, 51, 51,  0, #  43 GRAY 20%
   102,102,102,  0, #  86 GRAY 40%
   153,153,153,  0, # 129 GRAY 60%
   204,204,204,  0, # 172 GRAY 80%

    51,  0,  0,  0, #  36


   102,102,  0,  0, #  84 GRAY BLUE
   102,102, 51,  0, #  85 GRAY BLUE

     0, 50,  0,  0, # 254
     0, 50,  0,  0, # 255
     0, 50,  0,  0, # 220
     0, 50,  0,  0, # 221

    51,  0, 51,  0, #  37
    51,  0,102,  0, #  38
    51,  0,153,  0, #  39

    51, 51,  0,  0, #  42
    51, 51,102,  0, #  44
    51, 51,153,  0, #  45

    51,102,102,  0, #  50
    51,102,153,  0, #  51
    51,102,204,  0, #  52
    51,102,255,  0, #  53
    51,153,153,  0, #  57
    51,153,204,  0, #  58
    51,153,255,  0, #  59
    51,204,153,  0, #  63
    51,204,204,  0, #  64
    51,204,255,  0, #  65

   102,  0, 51,  0, #  73
   102,  0,102,  0, #  74
   102,  0,153,  0, #  75
   102,  0,204,  0, #  76
   102,  0,255,  0, #  77

   102, 51,  0,  0, #  78
   102, 51, 51,  0, #  79
   102, 51,102,  0, #  80
   102, 51,153,  0, #  81
   102, 51,204,  0, #  82
   102, 51,255,  0, #  83

     0, 50,  0,  0, # 216
   153, 51,153,  0, # 117
     0, 50,  0,  0, # 217
     0, 50,  0,  0, # 228
     0, 50,  0,  0, # 230
     0, 50,  0,  0, # 231
     0, 50,  0,  0, # 232
     0, 50,  0,  0, # 233
     0, 50,  0,  0, # 234
     0, 50,  0,  0, # 235
     0, 50,  0,  0, # 236
     0, 50,  0,  0, # 237
     0, 50,  0,  0, # 238
     0, 50,  0,  0, # 239
     0, 50,  0,  0, # 240
     0, 50,  0,  0, # 241
     0, 50,  0,  0, # 242
     0, 50,  0,  0, # 243
     0, 50,  0,  0, # 244
     0, 50,  0,  0, # 245
     0, 50,  0,  0, # 246
     0, 50,  0,  0, # 247
     0, 50,  0,  0, # 248
     0, 50,  0,  0, # 249
     0, 50,  0,  0, # 250

   153,153,  0,  0, # 126
   153,153, 51,  0, # 127
   153,153,102,  0, # 128

     0, 50,  0,  0, # 251
     0, 50,  0,  0, # 226

   153,  0,102,  0, # 110
   153, 51,102,  0, # 116
   153,102,153,  0, # 123
   153,102,102,  0, # 122

   153,  0, 51,  0, # 109
   153, 51,  0,  0, # 114
   153, 51, 51,  0, # 115

   153,102,  0,  0, # 120
   153,102, 51,  0, # 121

     0, 50,  0,  0, # 252
     0, 50,  0,  0, # 253

   # == BEGIN BLUE SCALE ===
   102,  0,  0,  0, #  72
   153,  0,  0,  0, # 108

   204,  0,  0,  0, # 144
   204,  0, 51,  0, # 145
   204, 51,  0,  0, # 150
   204, 51, 51,  0, # 151

   255,  0,  0,  0, # 180
   255,  0, 51,  0, # 181

   255, 51,  0,  0, # 186
   255, 51, 51,  0, # 187

   204,102,  0,  0, # 156
   255,102, 51,  0, # 193

   204,102, 51,  0, # 157
   255,102,  0,  0, # 192

   204,153,  0,  0, # 162
   204,153, 51,  0, # 163

   255,153,  0,  0, # 198
   255,153, 51,  0, # 199

   255,204,  0,  0, # 204
   255,204, 51,  0, # 205

   204,204,  0,  0, # 168
   204,204, 51,  0, # 169

   204,255,  0,  0, # 174
   204,255, 51,  0, # 175

   255,255,  0,  0, # 210
   255,255, 51,  0, # 211

   255,255,102,  0, # 212
   255,255,153,  0  # 213
   # == END BLUE SCALE ===
);

# 400 colors
my $htm400 = <<EOF;
<CENTER>
<TABLE BORDER="1" CELLSPACING="0" CELLPADDING="0" WIDTH="612" HEIGHT="360">
<TR>
<TD BGCOLOR="#FFFF00" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFF00</P></TD>
<TD BGCOLOR="#EEEE00" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEEE00</P></TD>
<TD BGCOLOR="#CDCD00" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDCD00</P></TD>
<TD BGCOLOR="#8B8B00" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8B00 </FONT></P></TD>
<TD BGCOLOR="#FFD700" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFD700</P></TD>
<TD BGCOLOR="#EEC900" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEC900</P></TD>
<TD BGCOLOR="#CDAD00" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDAD00</P></TD>
<TD BGCOLOR="#8B7500" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B7500 </FONT></P></TD>
<TD BGCOLOR="#FFC125" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFC125</P></TD>
<TD BGCOLOR="#EEB422" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEB422</P></TD>
<TD BGCOLOR="#CD9B1D" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD9B1D</P></TD>
<TD BGCOLOR="#8B6914" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B6914 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFB90F" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFB90F</P></TD>
<TD BGCOLOR="#EEAD0E" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEAD0E</P></TD>
<TD BGCOLOR="#CD950C" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD950C</P></TD>
<TD BGCOLOR="#EEDD82" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEDD82</P></TD>
<TD BGCOLOR="#DAA520" WIDTH=51 HEIGHT=20 VALIGN=top><P> DAA520</P></TD>
<TD BGCOLOR="#B8860B" WIDTH=51 HEIGHT=20 VALIGN=top><P> B8860B</P></TD>
<TD BGCOLOR="#BC8F8F" WIDTH=51 HEIGHT=20 VALIGN=top><P> BC8F8F</P></TD>
<TD BGCOLOR="#8B658B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B658B </FONT></P></TD>
<TD BGCOLOR="#FFC1C1" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFC1C1</P></TD>
<TD BGCOLOR="#EEB4B4" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEB4B4</P></TD>
<TD BGCOLOR="#CD9B9B" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD9B9B</P></TD>
<TD BGCOLOR="#8B6969" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B6969 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#FF6A6A" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF6A6A</P></TD>
<TD BGCOLOR="#EE6363" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE6363</P></TD>
<TD BGCOLOR="#CD5555" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD5555</P></TD>
<TD BGCOLOR="#CD5C5C" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD5C5C</P></TD>
<TD BGCOLOR="#8B3A3A" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B3A3A </FONT></P></TD>
<TD BGCOLOR="#8B4513" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B4513 </FONT></P></TD>
<TD BGCOLOR="#A0522D" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> A0522D </FONT></P></TD>
<TD BGCOLOR="#CD853F" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD853F</P></TD>
<TD BGCOLOR="#DEB887" WIDTH=51 HEIGHT=20 VALIGN=top><P> DEB887</P></TD>
<TD BGCOLOR="#F5F5DC" WIDTH=51 HEIGHT=20 VALIGN=top><P> F5F5DC</P></TD>
<TD BGCOLOR="#F5DEB3" WIDTH=51 HEIGHT=20 VALIGN=top><P> F5DEB3</P></TD>
<TD BGCOLOR="#F4A460" WIDTH=51 HEIGHT=20 VALIGN=top><P> F4A460</P></TD>
</TR>
<TR>
<TD BGCOLOR="#D2B48C" WIDTH=51 HEIGHT=20 VALIGN=top><P> D2B48C</P></TD>
<TD BGCOLOR="#FF8247" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF8247</P></TD>
<TD BGCOLOR="#EE7942" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE7942</P></TD>
<TD BGCOLOR="#CD6839" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD6839</P></TD>
<TD BGCOLOR="#8B4726" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B4726 </FONT></P></TD>
<TD BGCOLOR="#FFD39B" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFD39B</P></TD>
<TD BGCOLOR="#EEC591" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEC591</P></TD>
<TD BGCOLOR="#CDAA7D" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDAA7D</P></TD>
<TD BGCOLOR="#8B7355" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B7355 </FONT></P></TD>
<TD BGCOLOR="#FFE7BA" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE7BA</P></TD>
<TD BGCOLOR="#EED8AE" WIDTH=51 HEIGHT=20 VALIGN=top><P> EED8AE</P></TD>
<TD BGCOLOR="#CDBA96" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDBA96</P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B7E66" WIDTH=51 HEIGHT=20 VALIGN=top><P> 8B7E66</P></TD>
<TD BGCOLOR="#FFA54F" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFA54F</P></TD>
<TD BGCOLOR="#EE9A49" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE9A49</P></TD>
<TD BGCOLOR="#CD853F" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD853F</P></TD>
<TD BGCOLOR="#8B5A2B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B5A2B </FONT></P></TD>
<TD BGCOLOR="#FF7F24" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF7F24</P></TD>
<TD BGCOLOR="#EE7621" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE7621</P></TD>
<TD BGCOLOR="#D2691E" WIDTH=51 HEIGHT=20 VALIGN=top><P> D2691E</P></TD>
<TD BGCOLOR="#CD661D" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD661D</P></TD>
<TD BGCOLOR="#8B4513" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B4513 </FONT></P></TD>
<TD BGCOLOR="#FF3030" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF3030 </FONT></P></TD>
<TD BGCOLOR="#EE2C2C" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE2C2C </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#CD2626" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD2626 </FONT></P></TD>
<TD BGCOLOR="#B22222" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> B22222 </FONT></P></TD>
<TD BGCOLOR="#8B1A1A" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B1A1A </FONT></P></TD>
<TD BGCOLOR="#FF4040" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF4040 </FONT></P></TD>
<TD BGCOLOR="#EE3B3B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE3B3B </FONT></P></TD>
<TD BGCOLOR="#CD3333" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD3333 </FONT></P></TD>
<TD BGCOLOR="#A52A2A" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> A52A2A </FONT></P></TD>
<TD BGCOLOR="#8B2323" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B2323 </FONT></P></TD>
<TD BGCOLOR="#FF8C69" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF8C69</P></TD>
<TD BGCOLOR="#EE8262" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE8262</P></TD>
<TD BGCOLOR="#E9967A" WIDTH=51 HEIGHT=20 VALIGN=top><P> E9967A</P></TD>
<TD BGCOLOR="#FA8072" WIDTH=51 HEIGHT=20 VALIGN=top><P> FA8072</P></TD>
</TR>
<TR>
<TD BGCOLOR="#CD7054" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD7054</P></TD>
<TD BGCOLOR="#8B4C39" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B4C39 </FONT></P></TD>
<TD BGCOLOR="#FFA07A" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFA07A</P></TD>
<TD BGCOLOR="#EE9572" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE9572</P></TD>
<TD BGCOLOR="#CD8162" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD8162</P></TD>
<TD BGCOLOR="#8B5742" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B5742 </FONT></P></TD>
<TD BGCOLOR="#FFA500" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFA500</P></TD>
<TD BGCOLOR="#EE9A00" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE9A00</P></TD>
<TD BGCOLOR="#CD8500" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD8500</P></TD>
<TD BGCOLOR="#8B5A00" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B5A00 </FONT></P></TD>
<TD BGCOLOR="#FF7F00" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF7F00</P></TD>
<TD BGCOLOR="#EE7600" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE7600</P></TD>
</TR>
<TR>
<TD BGCOLOR="#FF8C00" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF8C00</P></TD>
<TD BGCOLOR="#CD6600" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD6600</P></TD>
<TD BGCOLOR="#8B4500" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B4500 </FONT></P></TD>
<TD BGCOLOR="#FF7F50" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF7F50</P></TD>
<TD BGCOLOR="#F08080" WIDTH=51 HEIGHT=20 VALIGN=top><P> F08080</P></TD>
<TD BGCOLOR="#FF7256" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF7256</P></TD>
<TD BGCOLOR="#EE6A50" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE6A50</P></TD>
<TD BGCOLOR="#CD5B45" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD5B45</P></TD>
<TD BGCOLOR="#8B3E2F" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B3E2F </FONT></P></TD>
<TD BGCOLOR="#FF6347" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF6347</P></TD>
<TD BGCOLOR="#EE5C42" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE5C42</P></TD>
<TD BGCOLOR="#CD4F39" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD4F39</P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B3626" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B3626 </FONT></P></TD>
<TD BGCOLOR="#FF4500" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF4500 </FONT></P></TD>
<TD BGCOLOR="#EE4000" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE4000 </FONT></P></TD>
<TD BGCOLOR="#CD3700" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD3700 </FONT></P></TD>
<TD BGCOLOR="#8B2500" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B2500 </FONT></P></TD>
<TD BGCOLOR="#FF0000" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF0000 </FONT></P></TD>
<TD BGCOLOR="#EE0000" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE0000 </FONT></P></TD>
<TD BGCOLOR="#CD0000" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD0000 </FONT></P></TD>
<TD BGCOLOR="#8B0000" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B0000 </FONT></P></TD>
<TD BGCOLOR="#FF1493" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF1493 </FONT></P></TD>
<TD BGCOLOR="#EE1289" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE1289 </FONT></P></TD>
<TD BGCOLOR="#CD1076" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD1076 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B0A50" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B0A50 </FONT></P></TD>
<TD BGCOLOR="#FF6EB4" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF6EB4</P></TD>
<TD BGCOLOR="#EE6AA7" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE6AA7</P></TD>
<TD BGCOLOR="#CD6090" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD6090</P></TD>
<TD BGCOLOR="#FF69B4" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF69B4</P></TD>
<TD BGCOLOR="#FF1493" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF1493 </FONT></P></TD>
<TD BGCOLOR="#FFC0CB" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFC0CB</P></TD>
<TD BGCOLOR="#FFB6C1" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFB6C1</P></TD>
<TD BGCOLOR="#DB7093" WIDTH=51 HEIGHT=20 VALIGN=top><P> DB7093</P></TD>
<TD BGCOLOR="#B03060" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> B03060 </FONT></P></TD>
<TD BGCOLOR="#C71585" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> C71585 </FONT></P></TD>
<TD BGCOLOR="#D02090" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> D02090 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B3A62" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B3A62 </FONT></P></TD>
<TD BGCOLOR="#FFB5C5" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFB5C5</P></TD>
<TD BGCOLOR="#EEA9B8" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEA9B8</P></TD>
<TD BGCOLOR="#CD919E" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD919E</P></TD>
<TD BGCOLOR="#8B636C" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B636C </FONT></P></TD>
<TD BGCOLOR="#FFAEB9" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFAEB9</P></TD>
<TD BGCOLOR="#EEA2AD" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEA2AD</P></TD>
<TD BGCOLOR="#CD8C95" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD8C95</P></TD>
<TD BGCOLOR="#8B5F65" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B5F65 </FONT></P></TD>
<TD BGCOLOR="#FF82AB" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF82AB</P></TD>
<TD BGCOLOR="#EE799F" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE799F</P></TD>
<TD BGCOLOR="#CD6889" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD6889</P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B475D" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B475D </FONT></P></TD>
<TD BGCOLOR="#FF34B3" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF34B3 </FONT></P></TD>
<TD BGCOLOR="#EE30A7" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE30A7 </FONT></P></TD>
<TD BGCOLOR="#CD2990" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD2990 </FONT></P></TD>
<TD BGCOLOR="#8B1C62" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B1C62 </FONT></P></TD>
<TD BGCOLOR="#FF3E96" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF3E96 </FONT></P></TD>
<TD BGCOLOR="#EE3A8C" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE3A8C </FONT></P></TD>
<TD BGCOLOR="#CD3278" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD3278 </FONT></P></TD>
<TD BGCOLOR="#8B2252" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B2252 </FONT></P></TD>
<TD BGCOLOR="#FF00FF" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> FF00FF </FONT></P></TD>
<TD BGCOLOR="#EE00EE" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> EE00EE </FONT></P></TD>
<TD BGCOLOR="#CD00CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> CD00CD </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B008B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B008B </FONT></P></TD>
<TD BGCOLOR="#EE82EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE82EE</P></TD>
<TD BGCOLOR="#FF83FA" WIDTH=51 HEIGHT=20 VALIGN=top><P> FF83FA</P></TD>
<TD BGCOLOR="#EE7AE9" WIDTH=51 HEIGHT=20 VALIGN=top><P> EE7AE9</P></TD>
<TD BGCOLOR="#DA70D6" WIDTH=51 HEIGHT=20 VALIGN=top><P> DA70D6</P></TD>
<TD BGCOLOR="#CD69C9" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD69C9</P></TD>
<TD BGCOLOR="#8B4789" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B4789 </FONT></P></TD>
<TD BGCOLOR="#FFBBFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFBBFF</P></TD>
<TD BGCOLOR="#EEAEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEAEEE</P></TD>
<TD BGCOLOR="#DDA0DD" WIDTH=51 HEIGHT=20 VALIGN=top><P> DDA0DD</P></TD>
<TD BGCOLOR="#CD96CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> CD96CD</P></TD>
<TD BGCOLOR="#8B668B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B668B </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#E066FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> E066FF</P></TD>
<TD BGCOLOR="#D15FEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> D15FEE</P></TD>
<TD BGCOLOR="#B452CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> B452CD</P></TD>
<TD BGCOLOR="#BA55D3" WIDTH=51 HEIGHT=20 VALIGN=top><P> BA55D3</P></TD>
<TD BGCOLOR="#9932CC" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 9932CC </FONT></P></TD>
<TD BGCOLOR="#9400D3" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 9400D3 </FONT></P></TD>
<TD BGCOLOR="#8A2BE2" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8A2BE2 </FONT></P></TD>
<TD BGCOLOR="#A020F0" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> A020F0 </FONT></P></TD>
<TD BGCOLOR="#7A378B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 7A378B </FONT></P></TD>
<TD BGCOLOR="#BF3EFF" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> BF3EFF </FONT></P></TD>
<TD BGCOLOR="#B23AEE" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> B23AEE </FONT></P></TD>
<TD BGCOLOR="#9A32CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 9A32CD </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#68228B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 68228B </FONT></P></TD>
<TD BGCOLOR="#9B30FF" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 9B30FF </FONT></P></TD>
<TD BGCOLOR="#912CEE" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 912CEE </FONT></P></TD>
<TD BGCOLOR="#7D26CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 7D26CD </FONT></P></TD>
<TD BGCOLOR="#551A8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 551A8B </FONT></P></TD>
<TD BGCOLOR="#AB82FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> AB82FF</P></TD>
<TD BGCOLOR="#9F79EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9F79EE</P></TD>
<TD BGCOLOR="#8968CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8968CD </FONT></P></TD>
<TD BGCOLOR="#5D478B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 5D478B </FONT></P></TD>
<TD BGCOLOR="#FFE1FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE1FF</P></TD>
<TD BGCOLOR="#EED2EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> EED2EE</P></TD>
<TD BGCOLOR="#CDB5CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDB5CD</P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B7B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B7B8B </FONT></P></TD>
<TD BGCOLOR="#9370DB" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9370DB</P></TD>
<TD BGCOLOR="#836FFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 836FFF</P></TD>
<TD BGCOLOR="#7A67EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7A67EE</P></TD>
<TD BGCOLOR="#6959CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 6959CD </FONT></P></TD>
<TD BGCOLOR="#473C8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 473C8B </FONT></P></TD>
<TD BGCOLOR="#4876FF" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 4876FF </FONT></P></TD>
<TD BGCOLOR="#436EEE" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 436EEE </FONT></P></TD>
<TD BGCOLOR="#3A5FCD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 3A5FCD </FONT></P></TD>
<TD BGCOLOR="#27408B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 27408B </FONT></P></TD>
<TD BGCOLOR="#0000FF" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 0000FF </FONT></P></TD>
<TD BGCOLOR="#0000EE" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 0000EE </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#0000CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 0000CD </FONT></P></TD>
<TD BGCOLOR="#00008B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 00008B </FONT></P></TD>
<TD BGCOLOR="#1E90FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 1E90FF</P></TD>
<TD BGCOLOR="#1C86EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 1C86EE</P></TD>
<TD BGCOLOR="#1874CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 1874CD</P></TD>
<TD BGCOLOR="#104E8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 104E8B </FONT></P></TD>
<TD BGCOLOR="#63B8FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 63B8FF</P></TD>
<TD BGCOLOR="#5CACEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 5CACEE</P></TD>
<TD BGCOLOR="#4F94CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 4F94CD</P></TD>
<TD BGCOLOR="#6495ED" WIDTH=51 HEIGHT=20 VALIGN=top><P> 6495ED</P></TD>
<TD BGCOLOR="#483D8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 483D8B </FONT></P></TD>
<TD BGCOLOR="#6A5ACD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 6A5ACD </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#7B68EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7B68EE</P></TD>
<TD BGCOLOR="#8470FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 8470FF</P></TD>
<TD BGCOLOR="#0000CD" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 0000CD </FONT></P></TD>
<TD BGCOLOR="#4169E1" WIDTH=51 HEIGHT=20 VALIGN=top><P> 4169E1</P></TD>
<TD BGCOLOR="#191970" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 191970 </FONT></P></TD>
<TD BGCOLOR="#000080" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 000080 </FONT></P></TD>
<TD BGCOLOR="#36648B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 36648B </FONT></P></TD>
<TD BGCOLOR="#00BFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00BFFF</P></TD>
<TD BGCOLOR="#00B2EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00B2EE</P></TD>
<TD BGCOLOR="#009ACD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 009ACD</P></TD>
<TD BGCOLOR="#00688B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 00688B </FONT></P></TD>
<TD BGCOLOR="#87CEFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 87CEFF</P></TD>
</TR>
<TR>
<TD BGCOLOR="#7EC0EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7EC0EE</P></TD>
<TD BGCOLOR="#6CA6CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 6CA6CD</P></TD>
<TD BGCOLOR="#4A708B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 4A708B </FONT></P></TD>
<TD BGCOLOR="#B0E2FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> B0E2FF</P></TD>
<TD BGCOLOR="#A4D3EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> A4D3EE</P></TD>
<TD BGCOLOR="#8DB6CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 8DB6CD</P></TD>
<TD BGCOLOR="#607B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 607B8B </FONT></P></TD>
<TD BGCOLOR="#C6E2FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> C6E2FF</P></TD>
<TD BGCOLOR="#B9D3EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> B9D3EE</P></TD>
<TD BGCOLOR="#9FB6CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9FB6CD</P></TD>
<TD BGCOLOR="#6C7B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 6C7B8B </FONT></P></TD>
<TD BGCOLOR="#CAE1FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> CAE1FF</P></TD>
</TR>
<TR>
<TD BGCOLOR="#BCD2EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> BCD2EE</P></TD>
<TD BGCOLOR="#A2B5CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> A2B5CD</P></TD>
<TD BGCOLOR="#6E7B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 6E7B8B </FONT></P></TD>
<TD BGCOLOR="#BFEFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> BFEFFF</P></TD>
<TD BGCOLOR="#B2DFEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> B2DFEE</P></TD>
<TD BGCOLOR="#9AC0CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9AC0CD</P></TD>
<TD BGCOLOR="#68838B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 68838B </FONT></P></TD>
<TD BGCOLOR="#E0FFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> E0FFFF</P></TD>
<TD BGCOLOR="#D1EEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> D1EEEE</P></TD>
<TD BGCOLOR="#B4CDCD" WIDTH=51 HEIGHT=20 VALIGN=top><P> B4CDCD</P></TD>
<TD BGCOLOR="#7A8B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 7A8B8B </FONT></P></TD>
<TD BGCOLOR="#BBFFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> BBFFFF</P></TD>
</TR>
<TR>
<TD BGCOLOR="#AEEEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> AEEEEE</P></TD>
<TD BGCOLOR="#96CDCD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 96CDCD</P></TD>
<TD BGCOLOR="#688B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 688B8B </FONT></P></TD>
<TD BGCOLOR="#98F5FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 98F5FF</P></TD>
<TD BGCOLOR="#8EE5EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 8EE5EE</P></TD>
<TD BGCOLOR="#7AC5CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7AC5CD</P></TD>
<TD BGCOLOR="#5F9EA0" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 5F9EA0 </FONT></P></TD>
<TD BGCOLOR="#53868B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 53868B </FONT></P></TD>
<TD BGCOLOR="#708090" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 708090 </FONT></P></TD>
<TD BGCOLOR="#778899" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 778899 </FONT></P></TD>
<TD BGCOLOR="#2F4F4F" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 2F4F4F </FONT></P></TD>
<TD BGCOLOR="#87CEEB" WIDTH=51 HEIGHT=20 VALIGN=top><P> 87CEEB</P></TD>
</TR>
<TR>
<TD BGCOLOR="#87CEFA" WIDTH=51 HEIGHT=20 VALIGN=top><P> 87CEFA</P></TD>
<TD BGCOLOR="#4682B4" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 4682B4 </FONT></P></TD>
<TD BGCOLOR="#B0C4DE" WIDTH=51 HEIGHT=20 VALIGN=top><P> B0C4DE</P></TD>
<TD BGCOLOR="#ADD8E6" WIDTH=51 HEIGHT=20 VALIGN=top><P> ADD8E6</P></TD>
<TD BGCOLOR="#B0E0E6" WIDTH=51 HEIGHT=20 VALIGN=top><P> B0E0E6</P></TD>
<TD BGCOLOR="#AFEEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> AFEEEE</P></TD>
<TD BGCOLOR="#00CED1" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00CED1</P></TD>
<TD BGCOLOR="#48D1CC" WIDTH=51 HEIGHT=20 VALIGN=top><P> 48D1CC</P></TD>
<TD BGCOLOR="#40E0D0" WIDTH=51 HEIGHT=20 VALIGN=top><P> 40E0D0</P></TD>
<TD BGCOLOR="#00FA9A" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00FA9A</P></TD>
<TD BGCOLOR="#20B2AA" WIDTH=51 HEIGHT=20 VALIGN=top><P> 20B2AA</P></TD>
<TD BGCOLOR="#00F5FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00F5FF</P></TD>
</TR>
<TR>
<TD BGCOLOR="#00E5EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00E5EE</P></TD>
<TD BGCOLOR="#00C5CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00C5CD</P></TD>
<TD BGCOLOR="#00868B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 00868B </FONT></P></TD>
<TD BGCOLOR="#00FFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00FFFF</P></TD>
<TD BGCOLOR="#00EEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00EEEE</P></TD>
<TD BGCOLOR="#00CDCD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00CDCD</P></TD>
<TD BGCOLOR="#008B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 008B8B </FONT></P></TD>
<TD BGCOLOR="#97FFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> 97FFFF</P></TD>
<TD BGCOLOR="#8DEEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> 8DEEEE</P></TD>
<TD BGCOLOR="#79CDCD" WIDTH=51 HEIGHT=20 VALIGN=top><P> 79CDCD</P></TD>
<TD BGCOLOR="#528B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 528B8B </FONT></P></TD>
<TD BGCOLOR="#7FFFD4" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7FFFD4</P></TD>
</TR>
<TR>
<TD BGCOLOR="#76EEC6" WIDTH=51 HEIGHT=20 VALIGN=top><P> 76EEC6</P></TD>
<TD BGCOLOR="#66CDAA" WIDTH=51 HEIGHT=20 VALIGN=top><P> 66CDAA</P></TD>
<TD BGCOLOR="#458B74" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 458B74 </FONT></P></TD>
<TD BGCOLOR="#C1FFC1" WIDTH=51 HEIGHT=20 VALIGN=top><P> C1FFC1</P></TD>
<TD BGCOLOR="#B4EEB4" WIDTH=51 HEIGHT=20 VALIGN=top><P> B4EEB4</P></TD>
<TD BGCOLOR="#9BCD9B" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9BCD9B</P></TD>
<TD BGCOLOR="#698B69" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 698B69 </FONT></P></TD>
<TD BGCOLOR="#54FF9F" WIDTH=51 HEIGHT=20 VALIGN=top><P> 54FF9F</P></TD>
<TD BGCOLOR="#4EEE94" WIDTH=51 HEIGHT=20 VALIGN=top><P> 4EEE94</P></TD>
<TD BGCOLOR="#43CD80" WIDTH=51 HEIGHT=20 VALIGN=top><P> 43CD80</P></TD>
<TD BGCOLOR="#2E8B57" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 2E8B57 </FONT></P></TD>
<TD BGCOLOR="#3CB371" WIDTH=51 HEIGHT=20 VALIGN=top><P> 3CB371</P></TD>
</TR>
<TR>
<TD BGCOLOR="#8FBC8F" WIDTH=51 HEIGHT=20 VALIGN=top><P> 8FBC8F</P></TD>
<TD BGCOLOR="#98FB98" WIDTH=51 HEIGHT=20 VALIGN=top><P> 98FB98</P></TD>
<TD BGCOLOR="#9AFF9A" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9AFF9A</P></TD>
<TD BGCOLOR="#90EE90" WIDTH=51 HEIGHT=20 VALIGN=top><P> 90EE90</P></TD>
<TD BGCOLOR="#7CCD7C" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7CCD7C</P></TD>
<TD BGCOLOR="#548B54" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 548B54 </FONT></P></TD>
<TD BGCOLOR="#00FF7F" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00FF7F</P></TD>
<TD BGCOLOR="#00EE76" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00EE76</P></TD>
<TD BGCOLOR="#00CD66" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00CD66</P></TD>
<TD BGCOLOR="#008B45" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 008B45 </FONT></P></TD>
<TD BGCOLOR="#00FF00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00FF00</P></TD>
<TD BGCOLOR="#00EE00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00EE00</P></TD>
</TR>
<TR>
<TD BGCOLOR="#00CD00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 00CD00</P></TD>
<TD BGCOLOR="#008B00" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 008B00 </FONT></P></TD>
<TD BGCOLOR="#228B22" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 228B22 </FONT></P></TD>
<TD BGCOLOR="#006400" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 006400 </FONT></P></TD>
<TD BGCOLOR="#32CD32" WIDTH=51 HEIGHT=20 VALIGN=top><P> 32CD32</P></TD>
<TD BGCOLOR="#9ACD32" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9ACD32</P></TD>
<TD BGCOLOR="#ADFF2F" WIDTH=51 HEIGHT=20 VALIGN=top><P> ADFF2F</P></TD>
<TD BGCOLOR="#7CFC00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7CFC00</P></TD>
<TD BGCOLOR="#7FFF00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 7FFF00</P></TD>
<TD BGCOLOR="#76EE00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 76EE00</P></TD>
<TD BGCOLOR="#66CD00" WIDTH=51 HEIGHT=20 VALIGN=top><P> 66CD00</P></TD>
<TD BGCOLOR="#458B00" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 458B00 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#C0FF3E" WIDTH=51 HEIGHT=20 VALIGN=top><P> C0FF3E</P></TD>
<TD BGCOLOR="#B3EE3A" WIDTH=51 HEIGHT=20 VALIGN=top><P> B3EE3A</P></TD>
<TD BGCOLOR="#9ACD32" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9ACD32</P></TD>
<TD BGCOLOR="#6B8E23" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 6B8E23 </FONT></P></TD>
<TD BGCOLOR="#698B22" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 698B22 </FONT></P></TD>
<TD BGCOLOR="#556B2F" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 556B2F </FONT></P></TD>
<TD BGCOLOR="#CAFF70" WIDTH=51 HEIGHT=20 VALIGN=top><P> CAFF70</P></TD>
<TD BGCOLOR="#BCEE68" WIDTH=51 HEIGHT=20 VALIGN=top><P> BCEE68</P></TD>
<TD BGCOLOR="#A2CD5A" WIDTH=51 HEIGHT=20 VALIGN=top><P> A2CD5A</P></TD>
<TD BGCOLOR="#6E8B3D" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 6E8B3D </FONT></P></TD>
<TD BGCOLOR="#BDB76B" WIDTH=51 HEIGHT=20 VALIGN=top><P> BDB76B</P></TD>
<TD BGCOLOR="#EEE8AA" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE8AA</P></TD>
</TR>
<TR>
<TD BGCOLOR="#FAFAD2" WIDTH=51 HEIGHT=20 VALIGN=top><P> FAFAD2</P></TD>
<TD BGCOLOR="#FFF68F" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF68F</P></TD>
<TD BGCOLOR="#EEE685" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE685</P></TD>
<TD BGCOLOR="#CDC673" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC673</P></TD>
<TD BGCOLOR="#8B864E" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B864E </FONT></P></TD>
<TD BGCOLOR="#FFEC8B" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFEC8B</P></TD>
<TD BGCOLOR="#EEDC82" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEDC82</P></TD>
<TD BGCOLOR="#CDBE70" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDBE70</P></TD>
<TD BGCOLOR="#8B814C" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B814C </FONT></P></TD>
<TD BGCOLOR="#FFFFE0" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFFE0</P></TD>
<TD BGCOLOR="#EEEED1" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEEED1</P></TD>
<TD BGCOLOR="#CDCDB4" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDCDB4</P></TD>
</TR>
<TR>
<TD BGCOLOR="#8B8B7A" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8B7A </FONT></P></TD>
<TD BGCOLOR="#FFFAFA" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFAFA</P></TD>
<TD BGCOLOR="#F8F8FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> F8F8FF</P></TD>
<TD BGCOLOR="#F5F5F5" WIDTH=51 HEIGHT=20 VALIGN=top><P> F5F5F5</P></TD>
<TD BGCOLOR="#DCDCDC" WIDTH=51 HEIGHT=20 VALIGN=top><P> DCDCDC</P></TD>
<TD BGCOLOR="#FFFAF0" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFAF0</P></TD>
<TD BGCOLOR="#FDF5E6" WIDTH=51 HEIGHT=20 VALIGN=top><P> FDF5E6</P></TD>
<TD BGCOLOR="#FAF0E6" WIDTH=51 HEIGHT=20 VALIGN=top><P> FAF0E6</P></TD>
<TD BGCOLOR="#FAEBD7" WIDTH=51 HEIGHT=20 VALIGN=top><P> FAEBD7</P></TD>
<TD BGCOLOR="#FFEFD5" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFEFD5</P></TD>
<TD BGCOLOR="#FFEBCD" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFEBCD</P></TD>
<TD BGCOLOR="#FFE4C4" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE4C4</P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFDAB9" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFDAB9</P></TD>
<TD BGCOLOR="#FFDEAD" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFDEAD</P></TD>
<TD BGCOLOR="#FFE4B5" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE4B5</P></TD>
<TD BGCOLOR="#FFF8DC" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF8DC</P></TD>
<TD BGCOLOR="#FFFFF0" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFFF0</P></TD>
<TD BGCOLOR="#FFFACD" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFACD</P></TD>
<TD BGCOLOR="#FFF5EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF5EE</P></TD>
<TD BGCOLOR="#F0FFF0" WIDTH=51 HEIGHT=20 VALIGN=top><P> F0FFF0</P></TD>
<TD BGCOLOR="#F5FFFA" WIDTH=51 HEIGHT=20 VALIGN=top><P> F5FFFA</P></TD>
<TD BGCOLOR="#F0FFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> F0FFFF</P></TD>
<TD BGCOLOR="#F0F8FF" WIDTH=51 HEIGHT=20 VALIGN=top><P> F0F8FF</P></TD>
<TD BGCOLOR="#E6E6FA" WIDTH=51 HEIGHT=20 VALIGN=top><P> E6E6FA</P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFF0F5" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF0F5</P></TD>
<TD BGCOLOR="#FFE4E1" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE4E1</P></TD>
<TD BGCOLOR="#FFFFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFFFF</P></TD>
<TD BGCOLOR="#D8BFD8" WIDTH=51 HEIGHT=20 VALIGN=top><P> D8BFD8</P></TD>
<TD BGCOLOR="#FFFAFA" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFAFA</P></TD>
<TD BGCOLOR="#EEE9E9" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE9E9</P></TD>
<TD BGCOLOR="#CDC9C9" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC9C9</P></TD>
<TD BGCOLOR="#8B8989" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8989 </FONT></P></TD>
<TD BGCOLOR="#FFF5EE" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF5EE</P></TD>
<TD BGCOLOR="#EEE5DE" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE5DE</P></TD>
<TD BGCOLOR="#CDC5BF" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC5BF</P></TD>
<TD BGCOLOR="#8B8682" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8682 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFEFDB" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFEFDB</P></TD>
<TD BGCOLOR="#EEDFCC" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEDFCC</P></TD>
<TD BGCOLOR="#CDC0B0" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC0B0</P></TD>
<TD BGCOLOR="#8B8378" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8378 </FONT></P></TD>
<TD BGCOLOR="#FFE4C4" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE4C4</P></TD>
<TD BGCOLOR="#EED5B7" WIDTH=51 HEIGHT=20 VALIGN=top><P> EED5B7</P></TD>
<TD BGCOLOR="#CDB79E" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDB79E</P></TD>
<TD BGCOLOR="#8B7D6B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B7D6B </FONT></P></TD>
<TD BGCOLOR="#FFDAB9" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFDAB9</P></TD>
<TD BGCOLOR="#EECBAD" WIDTH=51 HEIGHT=20 VALIGN=top><P> EECBAD</P></TD>
<TD BGCOLOR="#CDAF95" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDAF95</P></TD>
<TD BGCOLOR="#8B7765" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B7765 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFDEAD" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFDEAD</P></TD>
<TD BGCOLOR="#EECFA1" WIDTH=51 HEIGHT=20 VALIGN=top><P> EECFA1</P></TD>
<TD BGCOLOR="#CDB38B" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDB38B</P></TD>
<TD BGCOLOR="#8B795E" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B795E </FONT></P></TD>
<TD BGCOLOR="#FFFACD" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFACD</P></TD>
<TD BGCOLOR="#EEE9BF" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE9BF</P></TD>
<TD BGCOLOR="#CDC9A5" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC9A5</P></TD>
<TD BGCOLOR="#8B8970" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8970 </FONT></P></TD>
<TD BGCOLOR="#FFF8DC" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF8DC</P></TD>
<TD BGCOLOR="#EEE8CD" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE8CD</P></TD>
<TD BGCOLOR="#CDC8B1" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC8B1</P></TD>
<TD BGCOLOR="#8B8878" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8878 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFFFF0" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFFFF0</P></TD>
<TD BGCOLOR="#EEEEE0" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEEEE0</P></TD>
<TD BGCOLOR="#CDCDC1" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDCDC1</P></TD>
<TD BGCOLOR="#8B8B83" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8B83 </FONT></P></TD>
<TD BGCOLOR="#F0FFF0" WIDTH=51 HEIGHT=20 VALIGN=top><P> F0FFF0</P></TD>
<TD BGCOLOR="#E0EEE0" WIDTH=51 HEIGHT=20 VALIGN=top><P> E0EEE0</P></TD>
<TD BGCOLOR="#C1CDC1" WIDTH=51 HEIGHT=20 VALIGN=top><P> C1CDC1</P></TD>
<TD BGCOLOR="#838B83" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 838B83 </FONT></P></TD>
<TD BGCOLOR="#FFF0F5" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFF0F5</P></TD>
<TD BGCOLOR="#EEE0E5" WIDTH=51 HEIGHT=20 VALIGN=top><P> EEE0E5</P></TD>
<TD BGCOLOR="#CDC1C5" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDC1C5</P></TD>
<TD BGCOLOR="#8B8386" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B8386 </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#FFE4E1" WIDTH=51 HEIGHT=20 VALIGN=top><P> FFE4E1</P></TD>
<TD BGCOLOR="#EED5D2" WIDTH=51 HEIGHT=20 VALIGN=top><P> EED5D2</P></TD>
<TD BGCOLOR="#CDB7B5" WIDTH=51 HEIGHT=20 VALIGN=top><P> CDB7B5</P></TD>
<TD BGCOLOR="#8B7D7B" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 8B7D7B </FONT></P></TD>
<TD BGCOLOR="#F0FFFF" WIDTH=51 HEIGHT=20 VALIGN=top><P> F0FFFF</P></TD>
<TD BGCOLOR="#E0EEEE" WIDTH=51 HEIGHT=20 VALIGN=top><P> E0EEEE</P></TD>
<TD BGCOLOR="#C1CDCD" WIDTH=51 HEIGHT=20 VALIGN=top><P> C1CDCD</P></TD>
<TD BGCOLOR="#838B8B" WIDTH=51 HEIGHT=20 VALIGN=top><P> 838B8B</P></TD>
<TD BGCOLOR="#BEBEBE" WIDTH=51 HEIGHT=20 VALIGN=top><P> BEBEBE</P></TD>
<TD BGCOLOR="#D3D3D3" WIDTH=51 HEIGHT=20 VALIGN=top><P> D3D3D3</P></TD>
<TD BGCOLOR="#000000" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 000000 </FONT></P></TD>
<TD BGCOLOR="#1C1C1C" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 1C1C1C </FONT></P></TD>
</TR>
<TR>
<TD BGCOLOR="#363636" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 363636 </FONT></P></TD>
<TD BGCOLOR="#4F4F4F" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 4F4F4F </FONT></P></TD>
<TD BGCOLOR="#696969" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 696969 </FONT></P></TD>
<TD BGCOLOR="#828282" WIDTH=51 HEIGHT=20 VALIGN=top><P><FONT COLOR=White> 828282 </FONT></P></TD>
<TD BGCOLOR="#9C9C9C" WIDTH=51 HEIGHT=20 VALIGN=top><P> 9C9C9C</P></TD>
<TD BGCOLOR="#B5B5B5" WIDTH=51 HEIGHT=20 VALIGN=top><P> B5B5B5</P></TD>
<TD BGCOLOR="#CFCFCF" WIDTH=51 HEIGHT=20 VALIGN=top><P> CFCFCF</P></TD>
<TD BGCOLOR="#E8E8E8" WIDTH=51 HEIGHT=20 VALIGN=top><P> E8E8E8</P></TD>
<TD BGCOLOR="#A9A9A9" WIDTH=51 HEIGHT=20 VALIGN=top><P> A9A9A9</P></TD>
<TD BGCOLOR="#C0C0C0" WIDTH=51 HEIGHT=20 VALIGN=top><P> C0C0C0</P></TD>
<TD BGCOLOR="#COCOCO" WIDTH=51 HEIGHT=20 ALIGN=right><P> color</P></TD>
<TD BGCOLOR="#COCOCO" WIDTH=51 HEIGHT=20 ALIGN=left><P> combo</P></TD>
</TR>
</TABLE>
</CENTER>
EOF

my $sz = scalar @byte_color_map / 4;
my $ccnt = scalar @color_ref / 2;
prt( "Have $sz entries ... and $ccnt ref colors ...\n" );
my ($HF, $msg, $clr);
open $HF, ">$htmfile" or mydie( "ERROR: Unable to open $htmfile ...\n" );
gen_std_array();

# HTML OUTPUT
# ===========
html_begin($HF);
print $HF "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
my $cols = 0;
my $wrap = 4;
my $i = 0;
my $j = 0;
my ($r, $g, $b);
my ($hr, $hg, $hb);
my ($sty);

show_ref_colors() if ($showref);
out_an_array( $HF, 4, 1, "Out manual array ...", \@byte_color_map );
list_std_colors( $HF ) if ($dbg3);
out_std_array( $HF );
check_used_std( $HF );
sort_std_array();
out_an_array( $HF, 0, 1, "Out SORTED standard array ...", \@stdarr );
build_new_array();
out_an_array( $HF, 0, 1, "Out BLUE/RED/GREEN SORTED standard array ...", \@newarr );
out_400_table( $HF );
out_color_wheel( $HF );
html_end($HF);
# END HTML OUTPUT

close $HF;
system($htmfile);
close_log($outfile,1);
exit(0);

sub html_begin {
	my ($f) = shift;
	print $f <<"EOF";
<html>
<head>
<title>$htmfile</title>
<style type="text/css">
<!-- /* Style Definitions */
body {
margin:1cm 1cm 1cm 1cm;
}
p {
margin:0cm;
padding:0cm
}

-->
</style>

</head>
<body>
<h1>$htmfile</h1>
EOF

}

sub html_end {
	my ($f) = shift;
	print $f <<"EOF";
</body>
</html>
EOF

}

sub list_std_colors {
   my ($f) = shift;
   my ($r, $g, $b);
   my ($i, $j, $k);
   my $fact = 256 / 5;
   my $cnt = 0;
   my $br = '';
   $r = $g = $b = 0;
   prt( "byte _gen_color_map[] = {\n" );
   print $f "<pre>\n";
   print $f "<p>byte _gen_color_map[] = {$br\n";
   for( $i = 0; $i < 6; $i++ ) {
      $b = int($i * $fact);
	  $b = 255 if ($b >= 256);
      for( $j = 0; $j < 6; $j++ ) {
         $g = int($j * $fact);
		 $g = 255 if ($g >= 256);
         for( $k = 0; $k < 6; $k++ ) {
			$r = int($k * $fact);
			$r = 255 if ($r >= 256);
            prt( sprintf("   %3d,%3d,%3d,  0, // %3d\n", $b, $g, $r, $cnt) );
            print $f sprintf("   %3d,%3d,%3d,  0, // %3d$br\n", $b, $g, $r, $cnt);
            $cnt++;
         }
      }
   }
   $r = 0;
   $g = 50;
   $b = 0;
   for( ; $cnt < 256; $cnt++) {
      prt( sprintf("   %3d,%3d,%3d,  0, // %3d\n", $b, $g, $r, $cnt) );
      print $f sprintf("   %3d,%3d,%3d,  0, // %3d$br\n", $b, $g, $r, $cnt);
   }
   prt( "};\n" );
   print $f "};</p>\n";
   print $f "</pre>\n";
   ###sort_cmap( cmap );
}

sub gen_std_array {
	my ($r, $g, $b);
	my ($i, $j, $k);
	my $fact = 256 / 5;
	my $cnt = 0;
	my $br = '';
	$r = $g = $b = 0;
	prt( "Generating standard array ...\n" );
	for( $i = 0; $i < 6; $i++ ) {
		$b = int($i * $fact);
		$b = 255 if ($b == 256);
		for( $j = 0; $j < 6; $j++ ) {
			$g = int($j * $fact);
			$g = 255 if ($g == 256);
			for( $k = 0; $k < 6; $k++ ) {
				$r = int($k * $fact);
				$r = 255 if ($r == 256);
				push(@stdarr, $b);
				push(@stdarr, $g);
				push(@stdarr, $r);
				push(@stdarr, 0);
				prt( sprintf("   %3d,%3d,%3d,  0, // %3d (I=$i,J=$j,K=$k)\n", $b, $g, $r, $cnt) );
				$cnt++;
			}
		}
	}
	$r = 0;
	$g = 50;
	$b = 0;
	for( ; $cnt < 256; $cnt++) {
		push(@stdarr, $b);
		push(@stdarr, $g);
		push(@stdarr, $r);
		push(@stdarr, 0);
        prt( sprintf("   %3d,%3d,%3d,  0, // %3d\n", $b, $g, $r, $cnt) );
	}
}

sub out_an_array {
	my ($f, $wrap, $nearest, $hdr, $arrref) = @_;
	my $max = scalar @{$arrref} / 4;
	prt( "$hdr ... count = $max\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\" width=\"100%\">\n";
	my $cols = 0;
	my $i = 0;
	my $j = 0;
	my ($r, $g, $b);
	my ($hr, $hg, $hb);
	my ($sty);
	for ($i = 0; $i < $max; $i++) {
		$j = ($i * 4);
		$b = ${$arrref}[$j];
		$g = ${$arrref}[$j+1];
		$r = ${$arrref}[$j+2];
		$hr = uc(sprintf("%2.2x", $r));
		$hg = uc(sprintf("%2.2x", $g));
		$hb = uc(sprintf("%2.2x", $b));
		if ($cols == 0) {
			print $f "<tr>\n";
		}
		$sty = "style=\"background: #$hr$hg$hb;";
		if (($r + $g + $b) <= 153) {
			$sty .= " color: #ffffff";
		}
		$sty .= '"';
		$msg = "<td><p $sty>($r,$g,$b) #$hr$hg$hb</p></td>\n";
		$msg = "<td><p $sty>($r,$g,$b) #$hr$hg$hb";
		if ($nearest) {
			if ($wrap) {
				$msg .= "<br>";
			} else {
				$msg .= " ";
			}
			$msg .= closest_color_span($r, $g, $b);
		}
		$msg .= "</p></td>\n";
		print $f $msg;
		prt( $msg ) if ($dbg2);
		$cols++;
		if (($cols == $wrap)||($wrap == 0)) {
			print $f "</tr>\n";
			$cols = 0;
		}
	}
	if ($cols) {
		while ($cols < $wrap) {
			print $f "<td>&nbsp;</td>\n";
			$cols++;
		}
	}
	print $f "</table>\n";
}

sub out_std_array {
	my ($f) = shift;
	out_an_array( $f, 4, 1, "Out standard array ...", \@stdarr );
}

sub out_std_array_OK {
	my ($f) = shift;
	prt( "Out standard array ...\n" );
	print $f "<hr>\n";
	print $f "<p>Out standard array ...</p>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
	my $cols = 0;
	my $wrap = 4;
	my $i = 0;
	my $j = 0;
	my ($r, $g, $b);
	my ($hr, $hg, $hb);
	my ($sty);
	for ($i = 0; $i < $sz; $i++) {
		$j = ($i * 4);
		$b = $stdarr[$j];
		$g = $stdarr[$j+1];
		$r = $stdarr[$j+2];
		$hr = uc(sprintf("%2.2x", $r));
		$hg = uc(sprintf("%2.2x", $g));
		$hb = uc(sprintf("%2.2x", $b));
		if ($cols == 0) {
			print $HF "<tr>\n";
		}
		$sty = "style=\"background: #$hr$hg$hb;";
		if (($r + $g + $b) <= 153) {
			$sty .= " color: #ffffff";
		}
		$sty .= '"';
		$msg = "<td><p $sty>($r,$g,$b) #$hr$hg$hb</p></td>\n";
		$msg = "<td><p $sty>($r,$g,$b) #$hr$hg$hb<br>";
		$msg .= closest_color_span($r, $g, $b);
		$msg .= "</p></td>\n";
		print $f $msg;
		prt( $msg ) if ($dbg2);
		$cols++;
		if ($cols == $wrap) {
			print $f "</tr>\n";
			$cols = 0;
		}
	}
	if ($cols) {
		while ($cols < $wrap) {
			print $f "<td>&nbsp;</td>\n";
			$cols++;
		}
	}
	print $f "</table>\n";
}


sub split_words {
	my ($hw) = shift;
	my ($tmp, $off);
	if ($hw =~ /^[A-Z]/) {
		$tmp = substr($hw,1); # remove initial capital
		if ($tmp =~ /([A-Z])/) { # if we have other capital(s)
			$off = index($tmp, $1);	# get index of CAPITAL
			###if (($off != -1)&&($off > 1)) { # use this to NOT split "AB"
			if ($off != -1) {
				$hw = substr($hw,0,$off+1).' '.split_words(substr($hw,$off+1));
			}
		}
	}
	return $hw;
}

sub in_used {
	my ($used) = shift;
	my ($i, $cnt, $usd);
	$cnt = scalar @used_colors;
	for ($i = 0; $i < $cnt; $i++) {
		$usd = $used_colors[$i];
		if ($usd eq $used) {
			return 1;
		}

	}
	return 0;
}

sub is_in_used {
	my ($used) = shift;
	my ($i, $cnt, $usd);
	$cnt = scalar @used_colors;
	for ($i = 0; $i < $cnt; $i++) {
		$usd = $used_colors[$i];
		if ($usd eq $used) {
			$used_counts[$i]++;
			prt( "Already exists ... used $used_counts[$i] times ...\n" ) if ($dbg1);
			return $used_counts[$i];
		}

	}
	return 0;
}

sub save_used_colors {
	my $used = shift;
	prt( "Saving used $used ...\n" ) if ($dbg1);
	if (is_in_used( $used ) ) {
		return 1;
	}
	prt( "Is NEW ...\n" ) if ($dbg1);
	push(@used_colors, $used);
	push(@used_counts, 1);
	return 0;
}

sub get_closest_color {
	my ($r, $g, $b) = @_;
	my ($mr, $mg, $mb);
	my ($hr, $hg, $hb);
	my ($tmp, $diff, $mdiff);
	my $ind = $ccnt;
	$mdiff = (256+256+256);
	for (my $i = 0; $i < $ccnt; $i++) {
		my $j = $i * 2;
		## $msg = $color_ref[$j];
		$tmp = substr($color_ref[$j+1], 1);
		$hr = substr($tmp,0,2);
		$hg = substr($tmp,2,2);
		$hb = substr($tmp,4,2);
		$mr = hex($hr);
		$mg = hex($hg);
		$mb = hex($hb);
		$diff = abs($r - $mr) + abs($g - $mg) + abs($b - $mb);
		if (($r == $mr)&&($g == $mg)&&($b == $mb)) {
			$mdiff = $diff;
			$ind = $j;
			last;
		}
		if ($diff < $mdiff) {
			$mdiff = $diff;
			$ind = $j;
		}
	}
	$tmp = $color_ref[$ind].' '.$color_ref[$ind+1];
	return $tmp;
}

sub get_closest_generated {
	my ($r, $g, $b) = @_;
	my ($mr, $mg, $mb);
	my ($hr, $hg, $hb);
	my ($tmp, $diff, $mdiff, $sacnt);
	my ($i, $j, $ind);
	$mdiff = (256+256+256);
	$sacnt = scalar @stdarr / 4;
	$ind = 0;
	for ($i = 0; $i < $sacnt; $i++) {
		$j = $i * 4;
		## find in @stdarr
		$mb = $stdarr[$j];
		$mg = $stdarr[$j+1];
		$mr = $stdarr[$j+2];
		$diff = abs($r - $mr) + abs($g - $mg) + abs($b - $mb);
		if (($r == $mr)&&($g == $mg)&&($b == $mb)) {
			$mdiff = $diff;
			$ind = $j;
			last;
		}
		if ($diff < $mdiff) {
			$mdiff = $diff;
			$ind = $j;
		}
	}
	$j = $ind;
	$mb = $stdarr[$j];
	$mg = $stdarr[$j+1];
	$mr = $stdarr[$j+2];
	$tmp = "$mr,$mg,$mb ". uc(sprintf( "#%2.2x%2.2x%2.2x", $mr, $mg, $mb ));
	return $tmp;
}

sub inverted_hex_color {
	my ($clr) = shift;
	my $tmp = $clr;
	my $rclr = $clr;
	my ($hr, $hg, $hb);
	my ($mr, $mg, $mb);
	if (substr($tmp,0,1) eq '#') {
		$tmp = substr($tmp,1);
	}
	if (length($tmp) == 6) {
		$hr = substr($tmp,0,2);
		$hg = substr($tmp,2,2);
		$hb = substr($tmp,4,2);
		$mr = hex($hr);
		$mg = hex($hg);
		$mb = hex($hb);
		$rclr = '#';
		$rclr .= uc(sprintf("%2.2x%2.2x%2.2x", (255-$mr), (255-$mg), (255-$mb)));
	}
	return $rclr;
}

sub check_used_std {
	my ($f) = shift;
	my ($i, $j, $r, $g, $b, $cnt, $mcnt, $spw, $m, $clr, $nsc);
	my ($hr, $hg, $hb, $sty);
	my $tmp = ' ';
	my @arr = ();
	prt( "Checking standard USED of X11 list ...\n" );
	for ($i = 0; $i < $sz; $i++) {
		$j = ($i * 4);
		$b = $stdarr[$j];
		$g = $stdarr[$j+1];
		$r = $stdarr[$j+2];
		$tmp = get_closest_color( $r, $g, $b );
		@arr = split(/\s/, $tmp);
		save_used_colors( $arr[0] );
	}
	$cnt = scalar @used_colors;
	prt( "Done stored list $cnt ...\n" );
	print $f "<hr>\n";
	print $f "<p>Out X-11 array ...</p>\n";
	print $f "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\">\n";
	my $cols = 0;
	my $wrap = 4;
	$mcnt = 0;
	for ($i = 0; $i < $ccnt; $i++) {
		$j = $i * 2;
		$tmp = $color_ref[$j];
		$clr = $color_ref[$j+1];
		$sty = substr($clr, 1);	# remove '#'
		$hr = substr($sty,0,2);
		$hg = substr($sty,2,2);
		$hb = substr($sty,4,2);
		$r = hex($hr);
		$g = hex($hg);
		$b = hex($hb);
		if ($cols == 0) {
			printf $f "<tr>\n";
		}
		$spw = split_words($tmp);
		if ( !in_used( $tmp ) ) {
			$mcnt++;
			$nsc = get_closest_generated( $r, $g, $b );
			$m = "<td><p style=\"background: $clr\">$tmp $clr<br>";
			@arr = split(/\s/,$nsc);
			$m .= "<span style=\"background: $arr[-1]\">$nsc</span>";
			$m .= "</p></td>\n";
			prt( "Missed $spw $clr ... closest gen $nsc ...\n" );
		} else {
			$m = "<td><p style=\"color: $clr; background: ";
			$m .= inverted_hex_color($clr);	# "#000000";
			$m .= "\">$tmp $clr<br>";
			$m .= "<span style=\"color: #000000; background: #ffffff\">Used...</span>";
			$m .= "</p></td>\n";
		}
		printf $f $m;
		$cols++;
		if ($cols == $wrap) {
			printf $f "</tr>\n";
			$cols = 0;
		}
	}
	if ($cols) {
		while ($cols < $wrap) {
			print $f "<td>&nbsp;</td>\n";
			$cols++;
		}
	}
	print $f "</table>\n";
	print $f "Unused of X.11 array = $mcnt of $ccnt ...</p>\n";
	prt( "Unused of X.11 array = $mcnt of $ccnt ...\n" );
}

sub closest_color_span {
	my ($r, $g, $b) = @_;
	my $tmp = get_closest_color( $r, $g, $b );
	my @arr = split(/\s/, $tmp);
	$tmp = "<span style=\"background: $arr[-1]\">$tmp</span>";
	return $tmp;
}

sub	show_ref_colors {
	prt( "Out reference colors ...\n" );
	for ($i = 0; $i < $ccnt; $i++) {
		$j = $i * 2;
		$msg = $color_ref[$j];
		$sty = substr($color_ref[$j+1], 1);
		$hr = substr($sty,0,2);
		$hg = substr($sty,2,2);
		$hb = substr($sty,4,2);
		$r = hex($hr);
		$g = hex($hg);
		$b = hex($hb);
		prt( "$msg $sty ...($r,$g,$b)\n" );

	}
	exit(0);
}


sub URLDecode {
    my $theURL = $_[0];
    $theURL =~ tr/+/ /;
    $theURL =~ s/%([a-fA-F0-9]{2,2})/chr(hex($1))/eg;
    $theURL =~ s/<!--(.|\n)*-->//g;
    return $theURL;
}

sub URLEncode {
    my $theURL = $_[0];
   $theURL =~ s/([\W])/"%" . uc(sprintf("%2.2x",ord($1)))/eg;
   return $theURL;
}

sub URLEncodeORG {
    my $theURL = $_[0];
    my $MetaChars = quotemeta( ';,/?\|=+)(*&^%$#@!~`:');
   $theURL =~ s/([$MetaChars\"\'\x80-\xFF])/"%" . uc(sprintf("%2.2x",         ord($1)))/eg;
   $theURL =~ s/ /\+/g;
   return $theURL;
}

sub sort_std_array {
	prt( "sorting standard array ... by blue,green,red ... ");
	my ($i, $j, $j2);
	my ($r, $g, $b);
	my ($r2, $g2, $b2);
	my ($val1, $val2);
	my $chg = 1;
	my $ign = (50 << 8);
	while ($chg) {
		$chg = 0;
		for ($i = 0; $i < 255; $i++) {
			$j = ($i * 4);
			$j2 = (($i + 1) * 4);
			$b  = $stdarr[$j];
			$g  = $stdarr[$j+1];
			$r  = $stdarr[$j+2];
			$b2 = $stdarr[$j2];
			$g2 = $stdarr[$j2+1];
			$r2 = $stdarr[$j2+2];
			$val1 = ($b << 16) + ($g << 8) + $r;
			$val2 = ($b2 << 16) + ($g2 << 8) + $r2;
			if( $val2 == $ign ) {
				last;
			}
			if ($val1 > $val2) {
				$stdarr[$j]    = $b2;
				$stdarr[$j+1]  = $g2;
				$stdarr[$j+2]  = $r2;
				$stdarr[$j2]   = $b;
				$stdarr[$j2+1] = $g;
				$stdarr[$j2+2] = $r;
				$chg++;
			}
		}
	}
}

sub build_new_array {
	prt( "Building NEW array ...\n" );
	my @copystd = @stdarr; # copy the standard
	my $max = scalar @copystd / 4;
	my ($i, $j, $r, $g, $b, $cnt, $tcnt);
	for ($i = 0; $i < $max; $i++) {
		$j = ($i * 4);
		$copystd[$j+3] = 0;
	}
	# extract BLUE
	$tcnt = 0;
	$cnt = 0;
	for ($i = 0; $i < $max; $i++) {
		$j = ($i * 4);
		$b  = $copystd[$j];
		$g  = $copystd[$j+1];
		$r  = $copystd[$j+2];
		if (($b == 0)&&($g == 50)&&($r == 0)) {
			next;
		}
		if(($b > $g) && ($b > $r)) {
			push(@newarr, $b);
			push(@newarr, $g);
			push(@newarr, $r);
			push(@newarr, 0);
			$copystd[$j+3] = 1;
			$cnt++;
		}
	}
	prt( "Extracted $cnt BLUE to NEW array ...\n" );
	$tcnt += $cnt;
	# extract RED
	$cnt = 0;
	for ($i = 0; $i < $max; $i++) {
		$j = ($i * 4);
		if ($copystd[$j+3] == 0) {
			$b  = $copystd[$j];
			$g  = $copystd[$j+1];
			$r  = $copystd[$j+2];
			if (($b == 0)&&($g == 50)&&($r == 0)) {
				next;
			}
			if(($r > $g) && ($r > $b)) {
				push(@newarr, $b);
				push(@newarr, $g);
				push(@newarr, $r);
				push(@newarr, 0);
				$copystd[$j+3] = 1;
				$cnt++;
			}
		}
	}
	prt( "Extracted $cnt RED to NEW array ...\n" );
	$tcnt += $cnt;
	# extract GREEN
	$cnt = 0;
	for ($i = 0; $i < $max; $i++) {
		$j = ($i * 4);
		if ($copystd[$j+3] == 0) {
			$b  = $copystd[$j];
			$g  = $copystd[$j+1];
			$r  = $copystd[$j+2];
			if (($b == 0)&&($g == 50)&&($r == 0)) {
				next;
			}
			if(($g > $r) && ($g > $b)) {
				push(@newarr, $b);
				push(@newarr, $g);
				push(@newarr, $r);
				push(@newarr, 0);
				$copystd[$j+3] = 1;
				$cnt++;
			}
		}
	}
	prt( "Extracted $cnt GREEN to NEW array ...\n" );
	$tcnt += $cnt;
	# extract OTHERS
	$cnt = 0;
	for ($i = 0; $i < $max; $i++) {
		$j = ($i * 4);
		if ($copystd[$j+3] == 0) {
			$b  = $copystd[$j];
			$g  = $copystd[$j+1];
			$r  = $copystd[$j+2];
			push(@newarr, $b);
			push(@newarr, $g);
			push(@newarr, $r);
			push(@newarr, 0);
			$cnt++;
		}
	}
	$tcnt += $cnt;
	prt( "Extracted $cnt OTHERS to NEW array ...total $tcnt ...\n" );
}

sub same_nums_together {
	# build an array where same numbers are together
	# start 000000 then 
	# (51)
	# 330000 003300 000033 333300 330033 003333 333333
	# (102)
	# 660000 663300 660033 663333 - 006600 336600 006633 336633 - 000066 330066 003366 333366 - ETC
	# (153)
	# 990000 993300 990033 993333 - 009900
	# Nope, no use ;=))
}


sub out_400_table {
	my ($f) = shift;
	print $f "<HR>\n";
	print $f "<H1>400 TABLE</H1>\n";
	print $f "$htm400\n";
	print $f "<HR>\n";
}

sub floor { ($_[0]<0) ? -int -$_[0]+1 : int $_[0] } 
sub ceil { ($_[0]<0) ?  -int -$_[0] : int $_[0]+1 } 
sub round { ($_[0]>0) ?  int $_[0]+0.5 : int $_[0]-0.5 } 

sub get_bg_color {
	my ($x, $y, $grid, $part) = @_;
	my ($r, $g, $b);
	my ($rx, $ry, $rz);
	my $fact = 256 / 5;
	### my $part = $max / 13;
	my $max = $grid * $part;
	my $xp = int( $x / $part );
	my $yp = int( $y / $part );
	my $xx = int( $x / $part / 2 );
	my $yy = int( $y / $part / 2 );

	$rx = int( $xx * $fact );
	$ry = int( $yy * $fact );
	if( $rx >= 256 ) {
		$rx = 255;
	}
	if ($ry >= 256 ) {
		$ry = 255;
	}

	$r = $g = $b = 0;
	$rz = 0;
	# in upper left quadrant
	if ($yp < 6) {
		$rz = int( $yp * $fact );
		$rz = 255 if ($rz >= 256);
		if ($xp < 6) {
			if ($xp == $yp) {
				$b = 255 - $rz;
				$g = 0;
			} elsif ( $xp < $yp ) {
				$b = 0;
				$g = 0;
			} else {
				$b = 255 - $rz;
				$g = $rz;
			}
		} elsif ( $xp == 6 ) {
			$b = 0;
			$g = 0;
		} else {	# upper right
			$g = 255 - $rz;
			$b = $rz;
		}
		$r = 0;
	} elsif ( $yp == 6 ) {
		$r = 0;
		$g = 0;
		$b = 0;
	} else {
		$rz = int( ( $yp - 6 ) * $fact);
		$rz = 255 if ($rz >= 256);
		if (($xp > 2) && ($xp < 10)) {
			$b = 0;
			$g = 0;
			$r = $rz;
		}
	}

	my $c = uc(sprintf("#%2.2x%2.2x%2.2x", $r, $g, $b ));
	if ((($x == 0)||($x == floor($max / 2))||($x == ($max - 1)))&&(($y % 4)==0)) {
		if ($x == 0) {
			prt("\n");
		}
		prt( "Color $x,$y - xp=$xp yp=$yp xx=$xx yy=$yy - rx=$rx ry=$ry rz=$rz - $c ($r,$g,$b) ...\n" );
	}
	return $c;
}

# color wheel
# see : javascipt/colorwheel.htm, using colorwheel.jpg
#          Turquoise
#     Blue          Green
#          \       /
#            Black 
#      Mauve   |   Yellow
#             Red
#
sub out_color_wheel {
	my ($f) = shift;
	my $hdr = "Color Wheel - 44x44 grid";
	prt( "Out put of $hdr ...\n" );
	print $f "<hr>\n";
	print $f "<h1>$hdr</h1>\n";
	print $f "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" summary=\"$hdr\" width=\"100%\">\n";
	my $grid = 13;
	my $part = 4;
	my $max = $grid * $part;
	my $cols = 0;
	my $i = 0;
	my $j = 0;
	my ($r, $g, $b);
	my ($hr, $hg, $hb);
	my ($sty);
	for ($i = 0; $i < $max; $i++) {
		print $f "<tr>\n";
		for ($j = 0; $j < $max; $j++) {
			print $f "<td bgcolor=\"".get_bg_color($j, $i, $grid, $part)."\">.</td>\n";
		}
		print $f "</tr>\n";
	}
	print $f "</table>\n";
}

# eof - colors2.pl
