#!/usr/bin/perl -w
# dirbydate.pl
# AIM: Read a file output from the DIR command, and order the files in DATE
# order ... drop out the pure <DIR> entries ...
# 09/09/2011 - FIX20110909 -Since Qt use 'gcc', add *.o to -x-msvc built files
# 03/08/2011 - FIX20110803 - Option -dir-list adds the file item name
# 24/04/2011 - FIX20110424 - Add -t nn option; begin using short args...
# 26/03/2011 - Add skip-repo to skip .git .svn and CVS directories
# 01/07/2010 - Fix bug in $tail_cnt listing...
# 28/06/2010 - Add -tail=<num> 0 for all, else only show tail of this count.
# 25/06/2010 - Add -skip-cvs to SKIP showing the 'CVS' directory, and skip-git to skip '.git'
# 01/05/2010 - Added -v to set $verbose, and reduced output if not
# 04/03/2010 - Limit maximum list width
# 2010/01/02 - Add parse_args(), and add some switches
# 2/13/2009 - Add delete (unlink) of log file at end, and skip if <DIR> is 3[2] or 4th[3] entry...
# 10/18/2008 - Account for American MM/DD/YEAR, and inhibit <DIR> listings
# 20061219 - Can NOT use just $0 to get script name, since when directly invoke from
# a command prompt, it becomes C:\GTools\Perl\dirbydate.pl, so added some regex to
# massage the name, and just get the perl script name ... if a DRIVE included /^\w{1}:\\.*/
# AND, to enable it to FIND the logfile.pl, add unshift(@INC, 'C:/GTools/perl');
# OR this can be use lib '/Users/User/perl-lib';, or perl -MC:/GTools/perl -e dirbydate.pl
# and added a $evenspace option ...
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
use Cwd;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";

my $pgm_vers = "0.0.2 2011/04/24";
# a good version $pgm_vers = "0.0.1 2010/01/02"

# options
my $verbose = 0;
my $evenspace = 1;
my $excldirs = 1;	# exclude DIRECTORIES from final list
my $maxname = 0;
my $maxsize = 0;
my $loadout = 0;
my $maxlines = 300;	# if greater than ??? lines, $loadout in notepad ...
my $fixtm = 0;
my $limit_max_name = 1;
my $tail_cnt = 5;
my $tail_both = 0;

# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
	my @tmpsp = split(/(\\|\/)/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $perl_root = 'C:\GTools\perl';
my $outfile = $perl_root."\\temp.$pgmname.txt";
open_log($outfile);

###my $in_file = 'C:/DTEMP/tempall6.txt';
my $inp_file = '';
my @filelist = ();
my @sortlist = ();
my $basedir = '';
my @dirlist = ();
my %h_dir_list = ();
my %h_file_list = ();
my @user_exclude_ext = ();

my %fpfolders = (   # front page folders
 '_vti_cnf' => 1,
 '_vti_pvt' => 2,
 '_private' => 3,
 '_derived' => 4
);


# features
my $skip_frontpage = 1;
my $skip_cvs = 0;
my $skip_svn = 0;
my $skip_git = 0;
my $dir_list = 0;
my $dir_list2 = 0;
my $exclude_msvc_ext = 0;

my @def_msvc_excludes = qw( .obj .dep .dll .res .lib .exe .ilk .pdb .manifest .exp .idb
    .user .vcproj .dsp .sln .dsw .ncb .o );

# program variables
my $line = '';
my $tln = '';
my $act_folder = '';
my $arb_max_line = 'Fly Online with VATSIM.net - Virtual Air Traffic Simulation';
my $max_name = length($arb_max_line);

my %excluded_dirs = (); # list of user excluded directories

# debug output
my $dbg01 = 0;	# show each FOLDER as found ...
my $dbg02 = 0;	# show count and bytes as found ...
my $dbg03 = 0;	# show files, as found
my $verb3 = 0;	# show sort compare ...

sub VERB1() { return ($verbose > 0); }
sub VERB2() { return ($verbose > 1); }
sub VERB3() { return ($verbose > 2); }
sub VERB9() { return ($verbose > 8); }

sub pgm_exit($$) {
   my ($val,$msg) = @_;
   if (length($msg)) {
      $msg .= "\n" if (!($msg =~ /\n$/));
      prt($msg) if (VERB2() || $val);
   }
   close_log($outfile,$loadout);
   unlink($outfile);
   exit($val);
}

################################################
# my $ignfpd = 1;	# ignore FRONTPAGE folders
################################################
sub is_frontpage_folder {
	my ($inf) = shift;
   if (defined $fpfolders{$inf}) {
      return 1;
   }
	#foreach my $fil (@fpfolders) {
	#	if (lc($inf) eq lc($fil)) {
	#		return 1;
	#	}
	#}
	return 0;
}

sub got_fp_dir($) {
   my ($dir) = @_;
   $dir =~ s/\//\\/g;
   my @arr = split(/\\/,$dir);
   foreach my $d (@arr) {
      if (defined $fpfolders{$d}) {
         return 1;
      }
   }
   return 0;
}

# files has an EXCLUDED (case insensitive) extension
# controlled by $exclude_msvc_ext
sub has_excluded_ext_i($) {
    my $file = shift;
    my ($n,$d,$e) = fileparse($file, qr/\.[^.]*/);
    my ($ext,$lce,$lcext);
    $lce = lc($e);
    foreach $ext (@def_msvc_excludes) {
        $lcext = lc($ext);
        return 1 if ($lce eq $lcext);
    }
    return 0;
}

sub has_user_excluded_ext_i($) {
    my $file = shift;
    my ($n,$d,$e) = fileparse($file, qr/\.[^.]*/);
    my ($ext,$lce,$lcext);
    $lce = lc($e);
    foreach $ext (@user_exclude_ext) {
        $lcext = lc($ext);
        return 1 if ($lce eq $lcext);
    }
    return 0;
}


sub got_cvs_dir($) {
   my ($dir) = @_;
   $dir =~ s/\//\\/g;
   my @arr = split(/\\/,$dir);
   foreach my $d (@arr) {
      return 1 if ($d eq 'CVS');
   }
   return 0;
}
sub got_git_dir($) {
   my ($dir) = @_;
   $dir =~ s/\//\\/g;
   my @arr = split(/\\/,$dir);
   foreach my $d (@arr) {
      return 1 if ($d eq '.git');
   }
   return 0;
}
sub got_svn_dir($) {
   my ($dir) = @_;
   $dir =~ s/\//\\/g;
   my @arr = split(/\\/,$dir);
   foreach my $d (@arr) {
      return 1 if ($d eq '.svn');
   }
   return 0;
}


sub skip_line($$) {
	my ($l,$add) = @_;
	#  Volume in drive C has no label.
	#  Volume Serial Number is D833-AEFA
	if ($l =~ /Volume in drive (.*)/ ) {
		return 1;	# ignore
	} elsif ($l =~ /Volume Serial Number is (.*)/ ) {
		return 1;	# ignore
	} elsif ($l =~ /Total Files Listed/ ) {
		return 1;	# ignore
	} elsif ($l =~ /Directory of (.*)/ ) {
		$act_folder = $1;
        if ($add) {
            if ( ! defined $h_dir_list{$act_folder} ) {
                $h_dir_list{$act_folder} = 1;
                push(@dirlist,$act_folder);
            }
        }
		prt( "Folder [$act_folder] ...\n" ) if ($dbg01);
		return 1;
	} elsif ($l =~ /\d+\s+File\(s\)\s+[\d,]+\s+bytes/ ) {
		prt( $l ) if ($dbg02);
		return 1;
	} elsif ($l =~ /\d+\s+Dir\(s\)\s+[\d,]+\s+bytes/ ) {
		prt( $l ) if ($dbg02);
		return 1;
	}
	return 0;
}

sub remdir($) {
	my ($f) = shift;
	my $b2 = quotemeta($basedir);
	$f =~ s/^$b2\\//; # remove beginning ...
	return $f;
}

# put least first
sub mycmp_ascend {
   if (${$a}[0] < ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   if (${$a}[0] > ${$b}[0]) {
      prt( "+[".${$a}[0]."] > [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   prt( "=[".${$a}[0]."] = [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub mycmp_decend {
   if (${$a}[0] < ${$b}[0]) {
      prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (${$a}[0] > ${$b}[0]) {
      prt( "-[".${$a}[0]."] > [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   prt( "=[".${$a}[0]."] = [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub in_user_excluded($) {
    my $reldir = shift;
    return 1 if (defined $excluded_dirs{$reldir}); # FIX20110424 - begin using short args = -x <dir?
    my @arr = split(/(\\|\/)/, $reldir);
    my ($dir);
    foreach $dir (@arr) {
        return 1 if (defined $excluded_dirs{$dir}); # FIX20110424 - begin using short args = -x <dir?
    }
    return 0;
}
#                   0    1    2    3            4        5        6
# push(@filelist, [$ft, $nm, $csz, $act_folder, $arr[0], $arr[1], 0]);
sub out_sorted_list($) {
   my ($rsl) = @_;
   my $fcs = scalar @{$rsl};
   prt( "Got $fcs sorted files ...\n" ) if (VERB1());
   my $msg = '';
   my $mmax = $maxname;
   my $outcnt = 0;
   my @outlist = ();
   my ($i,$begin,$max_dsp,$flsz,$len,$nm,$sz,$nlen,$reldir,$diff,$dspcnt);
   if ($dir_list) {
       my ($ra,$fil);
       $mmax = scalar @dirlist;
       prt( "List of $mmax directories found...\n");
       foreach $msg (@dirlist) {
           if ($dir_list2 && defined $h_file_list{$msg}) {
               $ra = $h_file_list{$msg};
               foreach $fil (@{$ra}) {
                   prt("$msg"."\\"."$fil\n");
               }
           } else {
               prt("$msg\n");
           }
       }
       return;
   }
   $max_dsp = 0;
   $mmax = 0;
   for ($i = 0; $i < $fcs; $i++) {
      $reldir = remdir( ${$rsl}[$i][3] );
      next if (in_user_excluded($reldir));
      ### next if (defined $excluded_dirs{$reldir}); # FIX20110424 - begin using short args = -x <dir?
      if ($skip_frontpage) {
         next if (got_fp_dir($reldir));
      }
      if ($skip_cvs) {
         next if (got_cvs_dir($reldir));
      }
      if ($skip_git) {
         next if (got_git_dir($reldir));
      }
      if ($skip_svn) {
         next if (got_svn_dir($reldir));
      }
      if ($excldirs) {	# exclude DIRECTORIES from final list
         $flsz = ${$rsl}[$i][2];
         next if ($flsz =~ /<DIR>/i);
      }
      $nm = ${$rsl}[$i][1];
      next if (has_user_excluded_ext_i($nm));
      # EXCLUDE msvc extensions - controlled by $exclude_msvc_ext
      if ($exclude_msvc_ext) {
         next if (has_excluded_ext_i($nm));
      }
      $max_dsp++;
      $nlen = length($nm);
      $mmax = $nlen if ($nlen > $mmax);
   }
   $diff = 0;
   $begin = 0;
   if ($tail_cnt > 0) {
       if ($tail_both) {
           if (($tail_cnt * 2) < $max_dsp) {
               $begin = $max_dsp - $tail_cnt;
               $diff = $max_dsp - ($tail_cnt * 2);
           }
           prt("Tail count is $tail_cnt of $max_dsp, and tail both on, so begin 0, then at $begin...\n") if (VERB9());
       } else {
           if ($tail_cnt < $max_dsp) {
               $begin = $max_dsp - $tail_cnt;
           }
           prt("Tail count is $tail_cnt of $max_dsp, so begin listing at $begin...\n") if (VERB9());
       }
   } else {
       prt("Tail count is ZERO, so listing them ALL...\n") if (VERB9());
   }
   if ($limit_max_name && $evenspace && ($tail_cnt > 0)) {
       $mmax = 0;
       if ( ($begin > 0) && ($tail_both) ) {
           for ($i = 0; $i < $tail_cnt; $i++) {
              $reldir = remdir( ${$rsl}[$i][3] );
              next if (in_user_excluded($reldir));
              if ($skip_frontpage) {
                 next if (got_fp_dir($reldir));
              }
              if ($skip_cvs) {
                 next if (got_cvs_dir($reldir));
              }
              if ($skip_git) {
                 next if (got_git_dir($reldir));
              }
              if ($skip_svn) {
                 next if (got_svn_dir($reldir));
              }
              if ($excldirs) {	# exclude DIRECTORIES from final list
                 $flsz = ${$rsl}[$i][2];
                 next if ($flsz =~ /<DIR>/i);
              }
              $nm = ${$rsl}[$i][1];
              next if (has_user_excluded_ext_i($nm));
              # EXCLUDE msvc extensions - controlled by $exclude_msvc_ext
              if ($exclude_msvc_ext) {
                 next if (has_excluded_ext_i($nm));
              }
              $nlen = length($nm);
              $mmax = $nlen if ($nlen > $mmax);
           }
       }
       for ($i = $begin; $i < $fcs; $i++) {
          $reldir = remdir( ${$rsl}[$i][3] );
          next if (in_user_excluded($reldir));
          if ($skip_frontpage) {
             next if (got_fp_dir($reldir));
          }
          if ($skip_cvs) {
             next if (got_cvs_dir($reldir));
          }
          if ($skip_git) {
             next if (got_git_dir($reldir));
          }
          if ($skip_svn) {
             next if (got_svn_dir($reldir));
          }
          if ($excldirs) {	# exclude DIRECTORIES from final list
             $flsz = ${$rsl}[$i][2];
             next if ($flsz =~ /<DIR>/i);
          }
          $nm = ${$rsl}[$i][1];
          next if (has_user_excluded_ext_i($nm));
          # EXCLUDE msvc extensions - controlled by $exclude_msvc_ext
          if ($exclude_msvc_ext) {
             next if (has_excluded_ext_i($nm));
          }
          $nlen = length($nm);
          $mmax = $nlen if ($nlen > $mmax);
       }
   }
   if ($limit_max_name) {
       $mmax = $max_name if ($mmax > $max_name);
   }
   # finally, do output...
   if ($tail_both && ($begin > 0) && ($tail_cnt > 0)) {
       #for ($i = 0; $i < $tail_cnt; $i++) {
       $dspcnt = 0;
       for ($i = 0; $i < $fcs; $i++) {
          $reldir = remdir( ${$rsl}[$i][3] );
          next if (in_user_excluded($reldir));
          if ($skip_frontpage) {
             next if (got_fp_dir($reldir));
          }
          if ($skip_cvs) {
             next if (got_cvs_dir($reldir));
          }
          if ($skip_git) {
             next if (got_git_dir($reldir));
          }
          if ($skip_svn) {
             next if (got_svn_dir($reldir));
          }
          if ($excldirs) {	# exclude DIRECTORIES from final list
             $flsz = ${$rsl}[$i][2];
             next if ($flsz =~ /<DIR>/i);
          }
          $nm = ${$rsl}[$i][1];
          next if (has_user_excluded_ext_i($nm));
          # EXCLUDE msvc extensions - controlled by $exclude_msvc_ext
          if ($exclude_msvc_ext) {
             next if (has_excluded_ext_i($nm));
          }
          $dspcnt++;
          last if ($dspcnt > $tail_cnt);
          if ($evenspace) {
             $sz = ${$rsl}[$i][2];
             while (length($sz) < $maxsize) {
                $sz = ' ' . $sz;
             }
             $nm = ${$rsl}[$i][1];
             while (length($nm) < $mmax) {
                $nm = ' ' . $nm;
             }
             $msg = ${$rsl}[$i][4] . ' ' . ${$rsl}[$i][5] . ' ' . $sz . ' ' . $nm . ' ' . $reldir;
          } else {
             $msg = ${$rsl}[$i][4] . ' ' . ${$rsl}[$i][5] . ' ' . ${$rsl}[$i][1] . ' ' . $reldir;
          }
          prt( "$msg\n" );
          $outcnt++;
          push(@outlist,$i);
       }
       if ($outcnt) {
           prt("... skipping $diff entries ...\n");
       }
   }
   prt( "Begin at $begin, or $fcs items...\n" ) if (VERB9());
   $dspcnt = 0;
   #for ($i = $begin; $i < $fcs; $i++) {
   for ($i = 0; $i < $fcs; $i++) {
      $reldir = remdir( ${$rsl}[$i][3] );
      next if (in_user_excluded($reldir));
      if ($skip_frontpage) {
         next if (got_fp_dir($reldir));
      }
      if ($skip_cvs) {
         next if (got_cvs_dir($reldir));
      }
      if ($skip_git) {
         next if (got_git_dir($reldir));
      }
      if ($skip_svn) {
         next if (got_svn_dir($reldir));
      }
      if ($excldirs) {	# exclude DIRECTORIES from final list
         $flsz = ${$rsl}[$i][2];
         next if ($flsz =~ /<DIR>/i);
      }
      $nm = ${$rsl}[$i][1];
      next if (has_user_excluded_ext_i($nm));
      # EXCLUDE msvc extensions - controlled by $exclude_msvc_ext
      if ($exclude_msvc_ext) {
         next if (has_excluded_ext_i($nm));
      }
      $dspcnt++;
      if ($dspcnt > $begin) {
          if ($evenspace) {
             $sz = ${$rsl}[$i][2];
             while (length($sz) < $maxsize) {
                $sz = ' ' . $sz;
             }
             $nm = ${$rsl}[$i][1];
             while (length($nm) < $mmax) {
                $nm = ' ' . $nm;
             }
             $msg = ${$rsl}[$i][4] . ' ' . ${$rsl}[$i][5] . ' ' . $sz . ' ' . $nm . ' ' . $reldir;
          } else {
             $msg = ${$rsl}[$i][4] . ' ' . ${$rsl}[$i][5] . ' ' . ${$rsl}[$i][1] . ' ' . $reldir;
          }
          prt( "$msg\n" );
          $outcnt++;
          push(@outlist,$i);
      }
   }

   $msg = "Listed $outcnt, in DATE order...";
   if ($outcnt > 1) {
       $i = $outlist[0];
       $msg .= " Earliest: ".${$rsl}[$i][4];
       $i = $outlist[-1];
       $msg .= " Latest: ".${$rsl}[$i][4];
   }
   prt("$msg\n"); # if (VERB1());
   $loadout = 1 if ($outcnt > $maxlines);	# if greater than ??? lines, $loadout in notepad ...
}

sub process_input_file($) {
   my ($in_file ) = @_;
   open INF, "<$in_file" or mydie("ERROR: Can NOT open [$in_file] ... $! ...\n" );
   my @lines = <INF>;	# slurp it all
   close INF;
   my $lc = scalar @lines;
   prt( "Processing $lc lines from [$in_file] ...\n" ); # if (VERB2());
   $basedir = file_dirname($in_file);
   my $dddmmyy = guess_date_order(@lines);
   my ($csz,$nm,$ac,$pchk,@arr,@ar2,@ar3,$i,$ft,$ra);
   foreach $line (@lines) {
      $tln = trim_all($line);
      next if (length($tln) == 0);
      next if skip_line($tln,1); # skipped, but added to $act_folder;
      # and added to $h_dir_list{$act_folder} = 1; and push(@dirlist,$act_folder);
      @arr = split(/\s/, $tln);
      $ac = scalar @arr;
      $pchk = 0;
      #prt( $line );
      if ($ac > 3) {
         if (($arr[2] eq '<DIR>')||($arr[3] eq '<DIR>')) {
            # ignore
         } else {
            # file names of interest
            @ar2 = split('/', $arr[0]); # get day/month/year
            @ar3 = split(':', $arr[1]); # get hour:minutes
            $csz = $arr[2];
            $nm = $arr[3];
            #if ($fixtm && (($sz eq 'AM')||($sz eq 'PM'))) {
            if (($csz eq 'AM')||($csz eq 'PM')) {
               # 12 hour clock - have AM or PM
               if ($csz eq 'PM') {
                  $ar3[0] += 12;	# bump hour by 12
                  $arr[1] = $ar3[0].':'.$ar3[1];
               }
               $csz = $arr[3];
               $nm = $arr[4]; # get the FILE NAME
               if ($ac > 5) { # even if contains SPACES
                  $i = 5;
                  while($i < $ac) {
                     $nm .= ' '.$arr[$i];
                     $i++;
                  }
               }

            } else {
               # 24 hour clock (no AM/PM)
               if ($ac > 4) {
                  $i = 4;
                  while($i < $ac) {
                     $nm .= ' '.$arr[$i];
                     $i++;
                  }
               }
            }
            if ((scalar @ar2 == 3)&&(scalar @ar3 == 2)) {
               $ft = int($ar2[2].$ar2[1].$ar2[0].$ar3[0].$ar3[1]);
               if ($dddmmyy == 0) {
                  $ft = int($ar2[2].$ar2[0].$ar2[1].$ar3[0].$ar3[1]);
               }
               if ($evenspace) {	# get maximum lengths
                  $maxname = length($nm) if (length($nm) > $maxname);
                  $maxsize = length($csz) if (length($csz) > $maxsize);
               }
               #                 0     1   2    3            4       5         6
               push(@filelist, [$ft, $nm, $csz, $act_folder, $arr[0], $arr[1], 0]);
               $h_file_list{$act_folder} = [] if (! defined $h_file_list{$act_folder});
               $ra = $h_file_list{$act_folder};
               push(@{$ra},$nm);
               #prt( "$ft, $nm, $csz, $act_folder $arr[0], $arr[1]\n") if ($dbg03);
               prt( "$ft, $nm, $csz, $arr[0], $arr[1]\n") if ($dbg03);
            } else {
               $pchk = 1;
            }
         }
      } else {
         $pchk = 1;
      }
      if ($pchk) {
         prt( "CHECK: " );
         for (my $i = 0; $i < $ac; $i++) {
            prt( $arr[$i].' ' );
         }
         prt("\n");
      }
   }

   my $fc = scalar @filelist;
   prt( "Got $fc files ... mxsz=$maxsize mxnm=$maxname ...\n" ) if (VERB9());
   ###@sortlist = sort mycmp_decend @filelist;
   @sortlist = sort mycmp_ascend @filelist;
}

# ##############################################
# MAIN
parse_args(@ARGV);   # 20100102 - add parse...

process_input_file( $inp_file );

out_sorted_list( \@sortlist );

pgm_exit(0,"Normal exit");
# ##############################################

########################################
# rough guess is it DD/MM/YYYY or MM/DD/YYYY?
sub guess_date_order {
	my (@lns) = @_;
	my ($ln, @ar, $c);
	my $badmths = 0;
	my $daysgt12 = 0;
	my $checked = 0;
	foreach $ln (@lns) {
		$ln = trim_all($ln);
		next if (length($ln) == 0);
		next if skip_line($ln,0); # skipped, but added to $act_folder;
        # but NOT added to $h_dir_list{$act_folder} = 1; and push(@dirlist,$act_folder);
		@ar = split(/\s/, $ln);
		$c = scalar @ar;
		#prt( $line );
		if ($c > 3) {
			if ($ar[2] eq '<DIR>') {
				# ignore
			} else {
				# file names of interest
				my @arr2 = split('/', $ar[0]); # get day/month/year OR month/day/year
				if (scalar @arr2 >= 3) {
					$checked++;
					if ($arr2[1] > 12) {
						if ($badmths) {
							$badmths++;
							if ($badmths > 10) {
								prt( "guess_date_order: Got $badmths months GT 12 [$ln]... $arr2[1] ... assume American MM/DD/YEAR ...\n" );
								return 0;
							}
						} else {
							prt( "guess_date_order: Got month GT 12 [$ln]... $arr2[1] ...\n" );
							$badmths++;
						}
					}
					if ($arr2[0] > 12) {
						if ($daysgt12) {
							$daysgt12++;
						} else {
							prt( "guess_date_order: Got day GT 12 [$ln]... $arr2[0] ...\n" ) if (VERB2());
							$daysgt12++;
						}
					}
				}
			}
		}
	}
	if ($badmths > 2) {
		return 0;
	}
	return 1;
}

sub need_arg {
   my ($arg,@av) = @_;
   if (!@av) {
      pgm_exit(1,"ERROR: Argument [$arg] requires following argument!\n");
   }
}

sub give_help {
   my ($arg) = @_;
   prt("Got argument [$arg]\n");
   prt("$pgmname: version $pgm_vers\n");
   prt("Usage: [Options] input_file_name\n");
   prt("The input file name will be read as a directory listing, and will be\n");
   prt("output in date order.\n");
   prt("Options:\n");
   prt(" -h -?        = This help, and exit.\n");
   prt(" -add-fp      = Add the front page directories. Default is OFF\n");
   prt(" -skip-cvs    = Skip 'CVS' directories. Default is OFF\n");   # added 20100625
   prt(" -skip-git    = Skip '.git' directories. Default is OFF\n");   # added 20100625
   prt(" -skip-svn    = Skip '.svn' directories. Default is OFF\n");   # added 20100625
   prt(" -skip-repo   = Skip all the above directories. Default is OFF\n"); # added 20110426
   prt(" -tail=<num>  = Show only this maximum. 0 for all. Default is $tail_cnt.\n"); # added 20100628
   prt("                or -t <num> also accepted.\n"); # FIX20110424 - begin using short args.
   prt(" -tail-both   = Show tail count at beginning, and end.\n"); # added 20100628
   prt(" -dir-list    = Show only a directory list.\n"); # added 20100629
   prt(" -x-msvc      = Exclude MSVC built file extensions. Default is ");
   if ($exclude_msvc_ext) {
       prt("ON\n");
   } else {
       prt("OFF\n");
   }
   prt(" -x-ext=<ext> = Exclude files with this extensions.\n");
   prt(" -x <dir>     = Exclude this directory.\n"); # FIX20110424 - begin using short args
   prt(" -v[num]      = Set verbose. (Def=off)\n"); # added 01/05/2010
   pgm_exit(0,"Help exit.");
}

sub parse_arg_v {
   my (@av) = @_;   # 01/05/2010 - add this pre-parse of -v
   my ($arg,$sarg);
   while (@av) {
      $arg = $av[0];
      if ($arg =~ /^-/) {
         $sarg = substr($arg,1);
         $sarg = substr($sarg,1) while ($sarg =~ /^-/);
         if ($sarg =~ /^v/i) {
             while ($sarg =~ /^v/i) {
                 $sarg = substr($sarg,1);
                 $verbose++; # for each v
             }
             if (length($sarg)) {
                 if ($sarg =~ /^\d+$/) {
                     $verbose = $sarg;
                 } else {
                    pgm_exit(1,"ERROR: Unknown command [$arg]. Can be -v, -vvvv..., or -vNN only.\n");
                 }
             }
             prt("Set verbose ON ($verbose)\n") if (VERB2());
         }
      }
      shift @av;
   }
}

sub parse_args {
   my (@av) = @_;   # 20100102 - add parse...
   my ($arg,$sarg,$cnt,$tmp);
   parse_arg_v(@av);
   while (@av) {
      $arg = $av[0];
      if ($arg =~ /^-/) {
         $sarg = substr($arg,1);
         $sarg = substr($sarg,1) while ($sarg =~ /^-/);
         if (($sarg =~ /^h/)||($sarg =~ /^\?/)) {
            give_help($arg);
         } elsif ($sarg =~ /^l/) {
            $loadout = 1;
            prt("Set to load log at end.\n") if (VERB2());
         } elsif ($sarg =~ /^v/i) {
             # already done $verbose++;
         } elsif ($sarg =~ /^skip-cvs/) {
            $skip_cvs = 1;
            prt("Set to skip 'CVS' directories.\n") if (VERB2());
         } elsif ($sarg =~ /^skip-git/) {
            $skip_git = 1;
            prt("Set to skip '.git' directories.\n") if (VERB2());
         } elsif ($sarg =~ /^skip-svn/) {
            $skip_svn = 1;
            prt("Set to skip '.svn' directories.\n") if (VERB2());
         } elsif ($sarg =~ /^skip-repo/) {
            $skip_cvs = 1;
            $skip_git = 1;
            $skip_svn = 1;
            prt("Set to skip repo directories. (CVS,.svn,.git)\n") if (VERB2());
         } elsif ($sarg =~ /^add-fp/) {
            $skip_frontpage = 0;
            prt("Set to add frontpage directories.\n") if (VERB2());
         } elsif ($sarg =~ /^tail-both$/i) {
             $tail_both = 1;
             prt("Set to show tail count at beggining and end. (def=$tail_cnt)\n") if (VERB2());
         } elsif ($sarg =~ /^tail=(\d+)$/i) {
             $cnt = $1;
             $tail_cnt = $cnt;
             prt("Set to show tail count of $tail_cnt. (0 for all)\n") if (VERB2());
         } elsif ($sarg =~ /^t/) {
             need_arg(@av);
             shift @av;
             $cnt = $av[0];
             $tail_cnt = $cnt;
             prt("Set to show tail count of $tail_cnt. (0 for all)\n") if (VERB2());
         } elsif ($sarg =~ /^tail$/i) {
             need_arg(@av);
             shift @av;
             $cnt = $av[0];
             if ($cnt =~ /^\d+$/) {
                 $tail_cnt = $cnt;
                 prt("Set to show tail count of $tail_cnt. (0 for all)\n") if (VERB2());
             } else {
                pgm_exit(1,"ERROR: Argument [$arg] MUST be followed by a numeric count! Not [$cnt]! Aborting...\n");
             }
         } elsif ($sarg =~ /^dir-list$/) {
             $dir_list = 1;
             prt("Set to show directory list only.\n") if (VERB2());
         } elsif ($sarg =~ /^dir-list2$/) {
             $dir_list = 1;
             $dir_list2 = 1;
             prt("Set to show directory list,plus file only.\n") if (VERB2());
         } elsif ($sarg =~ /^x-msvc/) {
             $exclude_msvc_ext = 1;
             prt("Set to exclude MSVC built files.\n") if (VERB2());
         } elsif ($sarg =~ /^x-ext/) {
             if ($sarg =~ /^x-ext=(.+)/) {
                 $tmp = $1;
             } else {
                 need_arg(@av);
                 shift @av;
                 $tmp = $av[0];
             }
             $tmp = '.'.$tmp if ( !($tmp =~ /^\./) );
             push(@user_exclude_ext,$tmp);
             prt("Added excluded extension [$tmp]\n") if (VERB2());
         } elsif ($sarg =~ /^x/) {
             need_arg(@av);
             shift @av;
             $tmp = $av[0];
             # NO, this is NOT relative ### $tmp = File::Spec->rel2abs($tmp);
             $excluded_dirs{$tmp} = 1;
             prt("Added excluded directory [$tmp]\n") if (VERB2());
         } else {
            pgm_exit(1,"ERROR: Unknown argument [$arg]! aborting...\n");
         }
      } else {
         $inp_file = $arg;
         prt("Set input file to [$inp_file]\n") if (VERB2());
      }
      shift @av;
   }
   if (length($inp_file) == 0) {
        pgm_exit(1,"ERROR: No INPUT file found!\n");
   }
}

# eof - dirbydate.pl
